package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.module.hygf.api.dto.HygfIcbcRecordDTO;
import com.yeejoin.amos.boot.module.hygf.api.dto.IcbcExcelDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.IcbcWithholdRecordDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.IcbcWithhold;
import com.yeejoin.amos.boot.module.hygf.api.entity.IcbcWithholdRecord;
import com.yeejoin.amos.boot.module.hygf.api.util.CommonResponseNewUtil;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import com.yeejoin.amos.boot.module.hygf.biz.service.impl.IcbcWithholdServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.IcbcWithholdDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 *  聚富通代扣信息表
 *
 * @author system_generator
 * @date 2024-12-02
 */
@RestController
@Api(tags = " 聚富通代扣信息表Api")
@RequestMapping(value = "/icbc-withhold")
public class IcbcWithholdController extends BaseController {

    @Autowired
    IcbcWithholdServiceImpl icbcWithholdServiceImpl;

    /**
     * 新增 聚富通代扣信息表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增 聚富通代扣信息表", notes = "新增 聚富通代扣信息表")
	public ResponseModel save(@RequestBody IcbcWithhold model) throws Exception {
	       icbcWithholdServiceImpl.saveRecord(model);
	    return CommonResponseNewUtil.success();
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新 聚富通代扣信息表", notes = "根据sequenceNbr更新 聚富通代扣信息表")
	public ResponseModel<IcbcWithholdDto> updateBySequenceNbrIcbcWithhold(@RequestBody IcbcWithholdDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(icbcWithholdServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/delete/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr删除 聚富通代扣信息表", notes = "根据sequenceNbr删除 聚富通代扣信息表")
    public ResponseModel  deleteBySequenceNbr(@PathVariable(value = "sequenceNbr") Long sequenceNbr, @RequestParam(value = "batchNo") String batchNo){
		icbcWithholdServiceImpl.removeDataById(sequenceNbr,batchNo);
		return CommonResponseNewUtil.success();
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个 聚富通代扣信息表",  notes = "根据sequenceNbr查询单个 聚富通代扣信息表")
	public ResponseModel<IcbcWithholdDto> selectOne(@PathVariable Long sequenceNbr) {
		IcbcWithholdDto icbcWithholdDto = icbcWithholdServiceImpl.queryBySeq(sequenceNbr);
		icbcWithholdDto.setRecordDTOS(JSONArray.parseArray(icbcWithholdDto.getIcbcRecordInfos(), HygfIcbcRecordDTO.class));
		return ResponseHelper.buildResponse(icbcWithholdDto);
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = " 聚富通代扣信息表分页查询",  notes = " 聚富通代扣信息表分页查询")
	public ResponseModel<Map<String, Object>> queryForPage(@RequestParam(value = "current") int current,
															 @RequestParam(value = "size") int size,
															 @RequestParam(value = "uploader",required = false) String uploader,
	 														 @RequestParam(value = "uploadStartTime",required = false) String uploadStartTime,
	 														 @RequestParam(value = "uploadEndTime",required = false) String uploadEndTime,
	 														 @RequestParam(value = "uploadStatus",required = false) String uploadStatus,
	 														 @RequestParam(value = "confirmator",required = false) String confirmator,
	 														 @RequestParam(value = "confirmationStartTime",required = false) String confirmationStartTime,
	 														 @RequestParam(value = "confirmationEndTime",required = false) String confirmationEndTime,
	 														 @RequestParam(value = "withholdStatus",required = false) String withholdStatus,
	 														 @RequestParam(value = "desc",required = false) String desc,
	 														 @RequestParam(value = "batchNo",required = false) String batchNo
	) {

	    return ResponseHelper.buildResponse(icbcWithholdServiceImpl.queryForIcbcWithholdPage(current,size,uploader,uploadStartTime,uploadEndTime,uploadStatus,confirmator,confirmationStartTime,confirmationEndTime,desc,withholdStatus,batchNo));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/exportIcbcExcel")
	@ApiOperation(httpMethod = "POST",value = " 导出IcbcExcel",  notes = " 导出IcbcExcel")
	public ResponseModel<?> exportIcbcExcel(@RequestBody IcbcExcelDto icbcExcelDto, HttpServletResponse response) {
		icbcWithholdServiceImpl.exportIcbcExcel(icbcExcelDto,response);
		return ResponseHelper.buildResponse(null);
	}

	/**
     * 列表分页查询
     *

     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/test")
	@ApiOperation(httpMethod = "GET",value = " 聚富通代扣信息表分页查询",  notes = " 聚富通代扣信息表分页查询")
	public ResponseModel<Page<IcbcWithholdDto>> test() {
		icbcWithholdServiceImpl.upIcbcWithholdRecordWithholdStatus();
	    return ResponseHelper.buildResponse(null);
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = " 聚富通代扣信息表列表全部数据查询",   notes = " 聚富通代扣信息表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<IcbcWithholdDto>> selectForList() {
	    return ResponseHelper.buildResponse(icbcWithholdServiceImpl.queryForIcbcWithholdList());
	}


	/**
	 * 列表全部数据查询
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST",value = " 聚富通代扣信息文件生成",   notes = " 聚富通代扣信息文件生成")
	@PostMapping(value = "/fileGeneration")
	@Transactional
	public ResponseModel fileGeneration(@RequestBody IcbcWithhold model) throws Exception {
			icbcWithholdServiceImpl.fileGeneration(model);
		return CommonResponseNewUtil.success();
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST",value = " 聚富通代扣信息文件生成",   notes = " 聚富通代扣信息文件生成")
	@PostMapping(value = "/fileGenerations")
	@Transactional
	public ResponseModel fileGenerationS(@RequestBody IcbcWithholdDto model ) throws Exception {
			icbcWithholdServiceImpl.fileGenerations(model.getIds());
		return CommonResponseNewUtil.success();
	}
	/**
	 * 列表全部数据查询
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = " 聚富通代扣信息文件上传",   notes = " 聚富通代扣信息文件上传")
	@GetMapping(value = "/sftpUploadAndUnzip")
	@Transactional
	public ResponseModel sftpUploadAndUnzip(String fileUrl,String batchNo) throws Exception {
		ReginParams reginParams = getSelectedOrgInfo();
		icbcWithholdServiceImpl.sftpUploadAndUnzip(fileUrl,batchNo);
		return CommonResponseNewUtil.success();
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = " 聚富通代扣信息文件批量上传",   notes = " 聚富通代扣信息文件批量上传")
	@GetMapping(value = "/sftpUploadAndUnzipFiles")
	@Transactional
	public ResponseModel sftpUploadAndUnzipFiles(IcbcWithholdDto model) throws Exception {
		ReginParams reginParams = getSelectedOrgInfo();
		icbcWithholdServiceImpl.sftpUploadAndUnzipFiles(model.getIds(),reginParams.getUserModel().getRealName());
		return CommonResponseNewUtil.success();
	}
	/**
	 * 列表全部数据查询
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = " 聚富通代扣信息回盘文件获取",   notes = " 聚富通代扣信息回盘文件获取")
	@GetMapping(value = "/downLoadicbcFile")
	public ResponseModel  downLoadicbcFile( Long sequenceNbr,String batchNo,HttpServletResponse response ) throws Exception {
		icbcWithholdServiceImpl.downLoadicbcFile(batchNo,sequenceNbr,response);
		return ResponseHelper.buildResponse(null);
	}
	/**
	 * 列表全部数据查询
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = " 聚富通代扣信息回盘文件获取",   notes = " 聚富通代扣信息回盘文件获取")
	@GetMapping(value = "/updateWithholdStatus")
	public ResponseModel  updateWithholdStatus( ) throws Exception {
		icbcWithholdServiceImpl.updateWithholdStatus();
		return CommonResponseNewUtil.success();
	}

	/**
	 * 列表全部数据查询
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST",value = "批次明细信息下载",   notes = "批次明细信息下载")
	@PostMapping(value = "/export")
	public void downTemplate(HttpServletResponse response, @RequestBody IcbcWithholdDto model ) {

		icbcWithholdServiceImpl.exportData(response,model);
	}
	/**
	 * 文件下载
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "文件下载",   notes = "文件下载")
	@GetMapping(value = "/downloadFile")
	public void downTemplate(HttpServletResponse response, String fileUrl, String batchNo,String type  ) throws Exception {

		icbcWithholdServiceImpl.downloadAndSaveZipFile(fileUrl,batchNo,type,response);
	}
}
