package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.hygf.api.dto.PersonnelQualificationsDto;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.PersonnelQualificationsServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 证书
 *
 * @author system_generator
 * @date 2023-09-01
 */
@RestController
@Api(tags = "证书Api")
@RequestMapping(value = "/personnel-qualifications")
public class PersonnelQualificationsController extends BaseController {

    @Autowired
    PersonnelQualificationsServiceImpl personnelQualificationsServiceImpl;

    /**
     * 新增证书
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增证书", notes = "新增证书")
	public ResponseModel<PersonnelQualificationsDto> save(@RequestBody PersonnelQualificationsDto model) {
	    model = personnelQualificationsServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新证书", notes = "根据sequenceNbr更新证书")
	public ResponseModel<PersonnelQualificationsDto> updateBySequenceNbrPersonnelQualifications(@RequestBody PersonnelQualificationsDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(personnelQualificationsServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除证书", notes = "根据sequenceNbr删除证书")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(personnelQualificationsServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个证书",  notes = "根据sequenceNbr查询单个证书")
	public ResponseModel<PersonnelQualificationsDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(personnelQualificationsServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "证书分页查询",  notes = "证书分页查询")
	public ResponseModel<Page<PersonnelQualificationsDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<PersonnelQualificationsDto> page = new Page<PersonnelQualificationsDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(personnelQualificationsServiceImpl.queryForPersonnelQualificationsPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "证书列表全部数据查询",   notes = "证书列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<PersonnelQualificationsDto>> selectForList() {
	    return ResponseHelper.buildResponse(personnelQualificationsServiceImpl.queryForPersonnelQualificationsList());
	}
}
