package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.hygf.api.dto.YearPowerDto;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.YearPowerServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 按年统计
 *
 * @author system_generator
 * @date 2023-09-20
 */
@RestController
@Api(tags = "按年统计Api")
@RequestMapping(value = "/year-power")
public class YearPowerController extends BaseController {

    @Autowired
    YearPowerServiceImpl yearPowerServiceImpl;

    /**
     * 新增按年统计
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增按年统计", notes = "新增按年统计")
	public ResponseModel<YearPowerDto> save(@RequestBody YearPowerDto model) {
	    model = yearPowerServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新按年统计", notes = "根据sequenceNbr更新按年统计")
	public ResponseModel<YearPowerDto> updateBySequenceNbrYearPower(@RequestBody YearPowerDto model,@ApiParam(name = "sequenceNbr",value = "主键", example = "158888889425888") @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    return ResponseHelper.buildResponse(yearPowerServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除按年统计", notes = "根据sequenceNbr删除按年统计")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @ApiParam(name = "sequenceNbr",value = "主键", example = "158888889425888")@PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(yearPowerServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个按年统计",  notes = "根据sequenceNbr查询单个按年统计")
	public ResponseModel<YearPowerDto> selectOne(@ApiParam(name = "sequenceNbr",value = "主键", example = "158888889425888")@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(yearPowerServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "按年统计分页查询",  notes = "按年统计分页查询")
	public ResponseModel<Page<YearPowerDto>> queryForPage(@RequestParam(value = "current")@ApiParam(name = "current",example = "1") int current, @RequestParam
                    (value = "size") @ApiParam(name = "size",example = "20")int size) {
	    Page<YearPowerDto> page = new Page<YearPowerDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(yearPowerServiceImpl.queryForYearPowerPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "按年统计列表全部数据查询",   notes = "按年统计列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<YearPowerDto>> selectForList() {
	    return ResponseHelper.buildResponse(yearPowerServiceImpl.queryForYearPowerList());
	}
}
