package com.yeejoin.amos.boot.module.hygf.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.biz.common.excel.ExcelUtil;
import com.yeejoin.amos.boot.module.hygf.api.entity.FinancingInfoHistory;
import com.yeejoin.amos.boot.module.hygf.api.entity.HistoryPeasantHousehold;
import com.yeejoin.amos.boot.module.hygf.api.entity.SurveyInformation;
import com.yeejoin.amos.boot.module.hygf.api.mapper.HistoryPeasantHouseholdMapper;
import com.yeejoin.amos.boot.module.hygf.api.service.IHistoryPeasantHouseholdService;
import com.yeejoin.amos.boot.module.hygf.api.dto.HistoryPeasantHouseholdDto;
import com.yeejoin.amos.boot.module.hygf.api.util.BeanDtoUtils;
import com.yeejoin.amos.component.robot.BadRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.rdbms.annotation.Condition;
import org.typroject.tyboot.core.rdbms.annotation.Operator;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 存量合同电站服务实现类
 *
 * @author system_generator
 * @date 2024-10-18
 */
@Service
public class HistoryPeasantHouseholdServiceImpl extends BaseService<HistoryPeasantHouseholdDto,HistoryPeasantHousehold,HistoryPeasantHouseholdMapper> implements IHistoryPeasantHouseholdService {

   @Autowired
   FinancingInfoHistoryServiceImpl financingInfoHistoryService;
    /**
     * 分页查询
     */
    public Page<HistoryPeasantHouseholdDto> queryForHistoryPeasantHouseholdPage(Page<HistoryPeasantHouseholdDto> page, @Condition(Operator.in) List<String> sequenceNbr,@Condition(Operator.like) String ownersName ,@Condition(Operator.like) String province,@Condition(Operator.eq) String status)   {

        PageHelper.startPage((int) page.getCurrent(), (int) page.getSize());
        List<HistoryPeasantHouseholdDto> historyPeasantHouseholdDtos = this.getBaseMapper().queryForPage(sequenceNbr, ownersName, province, status);
        historyPeasantHouseholdDtos.forEach(e->{
            e.setFileUrl(JSONArray.parseArray(e.getFiles()));
        });
        PageInfo<HistoryPeasantHouseholdDto> infos = new PageInfo<>(historyPeasantHouseholdDtos);
        page.setRecords(historyPeasantHouseholdDtos);
        page.setTotal(infos.getTotal());
        return page;
    }

    /**
     * 列表查询 示例
     */
    public List<HistoryPeasantHouseholdDto> queryForHistoryPeasantHouseholdList()   {
        return this.queryForList("" , false);
    }

    public void   uploadData(MultipartFile multipartFile) throws Exception {

        List<HistoryPeasantHouseholdDto> excelDtoList = ExcelUtil.readFirstSheetExcel(multipartFile, HistoryPeasantHouseholdDto.class, 1);
        List<HistoryPeasantHousehold> list = new ArrayList<>();
        for (HistoryPeasantHouseholdDto dto : excelDtoList) {
            HistoryPeasantHousehold convert = BeanDtoUtils.convert(dto, HistoryPeasantHousehold.class);
            convert.setStatus("待上传");

            LambdaQueryWrapper<HistoryPeasantHousehold> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(HistoryPeasantHousehold::getPeasantHouseholdNo,convert.getPeasantHouseholdNo());
            List<HistoryPeasantHousehold> list1 = this.getBaseMapper().selectList(wrapper);

            if (CollectionUtil.isNotEmpty(list1)){

                throw new BadRequest(convert.getPeasantHouseholdNo()+ "编号重复");
            }

            list.add(convert);
        }
        this.saveBatch(list);
    }


    public void exportData(HttpServletResponse response, List<String> ids ){
        LambdaQueryWrapper<HistoryPeasantHousehold> wrapper = new LambdaQueryWrapper<>();
        List<HistoryPeasantHousehold> list = new ArrayList<>();
        if (CollectionUtil.isNotEmpty(ids)){
            wrapper.in(BaseEntity::getSequenceNbr,ids);
            list = this.getBaseMapper().selectBatchIds(ids);
        }else {
            list =  this.getBaseMapper().selectList(wrapper);
        }
        if (CollectionUtil.isNotEmpty(list)){

         ExcelUtil.createTemplate(response,"存量合同电站","存量合同电站",list,HistoryPeasantHouseholdDto.class,null,false);
        }
    }

    public HistoryPeasantHouseholdDto  updateStation(HistoryPeasantHouseholdDto model){
        LambdaQueryWrapper<HistoryPeasantHousehold> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(HistoryPeasantHousehold::getPeasantHouseholdNo,model.getPeasantHouseholdNo());
        wrapper.ne(BaseEntity::getSequenceNbr,model.getSequenceNbr());
        List<HistoryPeasantHousehold> list = this.getBaseMapper().selectList(wrapper);
        if (CollectionUtil.isNotEmpty(list)){
            throw new BadRequest("农户编号重复");
        }

        if (model.getStatus().equals("已提交")){
            FinancingInfoHistory financingInfoHistory = new FinancingInfoHistory();
            financingInfoHistory.setPeasantHouseholdId(model.getSequenceNbr());
            financingInfoHistory.setStatus("待放款");
            financingInfoHistoryService.save(financingInfoHistory);
        }
        if (null != model.getFileUrl() && model.getStatus().equals("待上传")){
            model.setStatus("待提交");
        }
        HistoryPeasantHousehold convert = BeanDtoUtils.convert(model,
                HistoryPeasantHousehold.class);
        this.saveOrUpdate(convert);
        return model;
        }

}