package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.IdxBizFanHealthIndexDto;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.*;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.*;
import com.yeejoin.amos.boot.module.jxiop.biz.service.IIdxBizFanHealthIndexService;
import com.yeejoin.amos.boot.module.jxiop.biz.tdmapper.IndicatorDataMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.*;



/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2023-08-15
 */
@Service
public class IdxBizFanHealthIndexServiceImpl extends BaseService<IdxBizFanHealthIndexDto,IdxBizFanHealthIndex,IdxBizFanHealthIndexMapper> implements IIdxBizFanHealthIndexService {


   @Autowired
   IdxBizPvPointProcessVariableClassificationMapper idxBizPvPointProcessVariableClassificationMapper;

    @Autowired
    IdxBizFanPointProcessVariableClassificationMapper idxBizFanPointProcessVariableClassificationMapper;
    @Autowired
    IndicatorDataMapper indicatorDataMapper;

    @Autowired
    IdxBizFanPointTagMapper idxBizFanPointTagMapper;
    @Autowired
    IdxBizPvPointTagMapper idxBizPvPointTagMapper;


    /**
     * 分页查询
     */
    public Page<IdxBizFanHealthIndexDto> queryForIdxBizFanHealthIndexPage(Page<IdxBizFanHealthIndexDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<IdxBizFanHealthIndexDto> queryForIdxBizFanHealthIndexList()   {
        return this.queryForList("" , false);
    }

    public List<Map<String,Object>> queryForLeftTableList(String STATION, String HEALTHLEVEL, String EQUIPMENTNAME, Integer current, Integer size){
    return  this.getBaseMapper().queryForLeftTableList(STATION,HEALTHLEVEL,EQUIPMENTNAME,current,size);
    }

    public int queryForLeftTableListCount(String STATION, String HEALTHLEVEL, String EQUIPMENTNAME){
        return  this.getBaseMapper().queryForLeftTableListCount(STATION,HEALTHLEVEL,EQUIPMENTNAME);
    }

    public Map<String,Object> queryForLeftTableListNum(String STATION, String HEALTHLEVEL, String EQUIPMENTNAME){
        return  this.getBaseMapper().queryForLeftTableListNum(STATION,HEALTHLEVEL,EQUIPMENTNAME);
    }


    public final DecimalFormat dfSS = new DecimalFormat("0.00");

    public  Object getqyt(String type,String address,String statioName,String equipmentName, String  arae,String startTime,String endTime,List<String> gatewayIds){
        Map<String, Object> map = new HashMap<>();
        try {
           //获取场站网关
        String tdid=null;
     if(type.equals("1")){
         IdxBizPvPointProcessVariableClassification      idxBizPvPointProcessVariableClassification=  idxBizPvPointProcessVariableClassificationMapper.selectOne(
                 new QueryWrapper<IdxBizPvPointProcessVariableClassification>()
                         .eq("INDEX_ADDRESS", address)
                         .eq("STATION", statioName)
                         .eq("EQUIPMENT_NAME", equipmentName)
                         .eq("ARAE", arae)
                         .last("limit 1")
         );
         tdid=address+"_"+idxBizPvPointProcessVariableClassification.getGatewayId();
     }else{
         IdxBizFanPointProcessVariableClassification idxBizFanPointProcessVariableClassification=   idxBizFanPointProcessVariableClassificationMapper.selectOne(
                 new QueryWrapper<IdxBizFanPointProcessVariableClassification>()
                         .eq("INDEX_ADDRESS", address)
                         .eq("STATION", statioName)
                         .eq("EQUIPMENT_NAME", equipmentName)
                         .eq("ARAE", arae)
                         .last("limit 1")
         );
         tdid=address+"_"+idxBizFanPointProcessVariableClassification.getGatewayId();
     }
        SimpleDateFormat sdf = new SimpleDateFormat(DateUtils.DATE_TIME_PATTERN);
    //限制必须是区间时间段
    if(startTime==null||endTime==null){
         Date currentDayStartTime = DateUtils.getCurrentDayStartTime(new Date());
         Date currentDayEndTime = DateUtils.getCurrentDayEndTime(new Date());
         startTime = sdf.format(currentDayStartTime);
         endTime= sdf.format(currentDayEndTime);
    }else{
        if (startTime.length() == 10) {
            startTime = startTime.concat(" 00:00:00");
            endTime = endTime.concat(" 23:59:59");
        } else if (startTime.length() == 13) {
            startTime = startTime.concat(":00:00");
            endTime = endTime.concat(":50:59");
        } else if (startTime.length() == 16) {
            startTime = startTime.concat(":00");
            endTime = endTime.concat(":59");
        } else {
            startTime = startTime.concat(" 00:00:00");
            endTime = endTime.concat(" 23:59:59");
        }
        Date currentDayStartTime = DateUtils.dateAddHours(DateUtils.dateParse(startTime), -8);
        Date currentDayEndTime = DateUtils.dateAddHours(DateUtils.dateParse(endTime), -8);
        startTime = sdf.format(currentDayStartTime);
        endTime= sdf.format(currentDayEndTime);
    }
        List<IndicatorData> indicatorDataListActivePowers = new ArrayList<>();
        indicatorDataListActivePowers= indicatorDataMapper.selectDataByequipmentIndexNameAndtimeAndEquipmentNumber(tdid,startTime,endTime,gatewayIds);
        List<String> axisData = new ArrayList<>();
        List<String> activePowers = new ArrayList<>();
        for (int i = 0; i < indicatorDataListActivePowers.size(); i++) {
            activePowers.add(dfSS.format(indicatorDataListActivePowers.get(i).getValueF()));
            axisData.add(DateUtil.format(indicatorDataListActivePowers.get(i).getCreatedTime(), "yyyy-MM-dd HH:mm:ss"));
        }
       // List<Map<String, Object>> seriesData = new ArrayList<>();

//        Map<String, Object> map2 = new HashMap<>();
//        map2.put("data", activePowers);
//        seriesData.add(map2);
        map.put("seriesData", activePowers);
        map.put("axisData", axisData);
     }catch (Exception e){
         e.printStackTrace();
         throw new RuntimeException();
     }
    return map;
    }

    public void updatezd( String type,
                          String  id,
                          String pointDirection,
                          String  tagCode){

        if(type.equals("1")){
            IdxBizPvPointTag object= idxBizPvPointTagMapper.selectById(id);
            LambdaUpdateWrapper<IdxBizPvPointTag> UpdateWrapper =new LambdaUpdateWrapper();
            UpdateWrapper.eq(object.getArae()!=null,IdxBizPvPointTag::getArae,object.getArae());
            UpdateWrapper.eq(object.getStation()!=null,IdxBizPvPointTag::getStation,object.getStation());
            UpdateWrapper.eq(object.getDeviceType()!=null,IdxBizPvPointTag::getDeviceType,object.getDeviceType());
            UpdateWrapper.eq(object.getManufacturer()!=null,IdxBizPvPointTag::getManufacturer,object.getManufacturer());
            UpdateWrapper.eq(object.getPointName()!=null,IdxBizPvPointTag::getPointName,object.getPointName());
            UpdateWrapper.set(pointDirection!=null,IdxBizPvPointTag::getPointDirection,pointDirection);
            UpdateWrapper.set(tagCode!=null,IdxBizPvPointTag::getTagCode,tagCode);
            idxBizPvPointTagMapper.update(null,UpdateWrapper);
        }else{

            IdxBizFanPointTag  object= idxBizFanPointTagMapper.selectById(id);
            LambdaUpdateWrapper<IdxBizFanPointTag> UpdateWrapper =new LambdaUpdateWrapper();
            UpdateWrapper.eq(object.getArae()!=null,IdxBizFanPointTag::getArae,object.getArae());
            UpdateWrapper.eq(object.getStation()!=null,IdxBizFanPointTag::getStation,object.getStation());
            UpdateWrapper.eq(object.getNumber()!=null,IdxBizFanPointTag::getNumber,object.getNumber());
            UpdateWrapper.eq(object.getPointName()!=null,IdxBizFanPointTag::getPointName,object.getPointName());
            UpdateWrapper.set(pointDirection!=null,IdxBizFanPointTag::getPointDirection,pointDirection);
            UpdateWrapper.set(tagCode!=null,IdxBizFanPointTag::getTagCode,tagCode);
            idxBizFanPointTagMapper.update(null,UpdateWrapper);
        }





    }






    public List<Map<String,Object>> queryForLeftTableListByPoint(String STATION, String HEALTHLEVEL, String EQUIPMENTNAME,  String POINTNAME,Integer current, Integer size){
        return  this.getBaseMapper().queryForLeftTableListByPoint(STATION,HEALTHLEVEL,EQUIPMENTNAME,POINTNAME,current,size);
    }

    public  List<Map<String,Object>>  selectPointByANALYSISTYPE(String STATION, String HEALTHLEVEL,String EQUIPMENTNAME,String POINTNAME,String startTime,String endTime){
        return  this.getBaseMapper().selectPointByANALYSISTYPE(STATION,HEALTHLEVEL,EQUIPMENTNAME,POINTNAME,startTime,endTime);

    };

    public  Map<String,Object> getFanEquipStatusByStation(String STATION){
        return  this.getBaseMapper().getFanEquipStatusByStation(STATION);

    }
    public  Map<String,Object> getPvEquipStatusByStation(String STATION){
        return  this.getBaseMapper().getPvEquipStatusByStation(STATION);

    }

    public int queryForLeftTableListByPointCount(String STATION, String HEALTHLEVEL, String EQUIPMENTNAME,String POINTNAME){
        return  this.getBaseMapper().queryForLeftTableListByPointCount(STATION,HEALTHLEVEL,EQUIPMENTNAME,POINTNAME);
    }

    public Map<String,Object> queryForLeftTableListByPointNum(String STATION, String HEALTHLEVEL, String EQUIPMENTNAME,String POINTNAME){
        return  this.getBaseMapper().queryForLeftTableListByPointNum(STATION,HEALTHLEVEL,EQUIPMENTNAME,POINTNAME);
    }

    public int pointNum(String STATION, String SUBSYSTEM,String EQUIPMENTNAME) {
        return this.getBaseMapper().pointNum(STATION, SUBSYSTEM,EQUIPMENTNAME);
    }

    public  List<IdxBizFanWarningRecord> warningData(String STATION, String SUBARRAY , String EQUIPMENTNAME) {
        return this.getBaseMapper().warningData(STATION, SUBARRAY, EQUIPMENTNAME);
    }



}