package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapBuilder;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.IdxBizFanPointVarCorrelationDto;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IdxBizFanPointVarCorrelation;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IdxBizFanWeight;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IdxBizPvPointVarCorrelation;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.IdxBizFanPointVarCorrelationMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.service.IIdxBizFanPointVarCorrelationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2023-08-15
 */
@Service
public class IdxBizFanPointVarCorrelationServiceImpl extends BaseService<IdxBizFanPointVarCorrelationDto, IdxBizFanPointVarCorrelation, IdxBizFanPointVarCorrelationMapper> implements IIdxBizFanPointVarCorrelationService {

    @Autowired
    private IdxBizFanPointVarCorrelationMapper idxBizFanPointVarCorrelationMapper;
    /**
     * 分页查询
     */
    public Page<IdxBizFanPointVarCorrelationDto> queryForIdxBizFanPointVarCorrelationPage(Page<IdxBizFanPointVarCorrelationDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<IdxBizFanPointVarCorrelationDto> queryForIdxBizFanPointVarCorrelationList()   {
        return this.queryForList("" , false);
    }

    public Map<String,Object> getCurrentChoosePoint(String gatewayId, String analysePointId) {
        List<IdxBizFanPointVarCorrelation> gongkuangList;
          gongkuangList = idxBizFanPointVarCorrelationMapper
                  .selectList(new QueryWrapper<IdxBizFanPointVarCorrelation>()
                          .eq("ANALYSIS_GATEWAY_ID",
                                  gatewayId)
                          .eq("ANALYSIS_POINT_ID",
                                  analysePointId)
                          .eq("MATCH_PROCESS_PONIT","匹配"));
          if (CollectionUtil.isEmpty(gongkuangList) || gongkuangList.size() !=3 ){
              gongkuangList = idxBizFanPointVarCorrelationMapper
                      .selectList(new QueryWrapper<IdxBizFanPointVarCorrelation>()
                              .eq("ANALYSIS_GATEWAY_ID",
                                      gatewayId)
                              .eq("ANALYSIS_POINT_ID",
                                      analysePointId)
                              .orderByDesc("CORRELATION_COEFFICIENT").last("limit 0,3"));
          }

        List<Long> collect = gongkuangList.stream().map(IdxBizFanPointVarCorrelation::getProcessPointId).collect(Collectors.toList());
        return    MapBuilder.<String,Object>create().put("processPointIds",collect).build();
    }

    public void updatePointChoose(String gatewayId, Long analysePointId, List<String> processPointIds) {
        this.getBaseMapper().updatePointChoose(gatewayId,analysePointId,null);


        this.getBaseMapper().updatePointChoose(gatewayId,analysePointId,processPointIds);


    }

    public  Map<String,Object> getPointProcess(String gatewayId, String analysePointId) {

        List<IdxBizFanPointVarCorrelation> gongkuangList = idxBizFanPointVarCorrelationMapper
                .selectList(new QueryWrapper<IdxBizFanPointVarCorrelation>()
                        .eq("ANALYSIS_GATEWAY_ID",
                                gatewayId)
                        .eq("ANALYSIS_POINT_ID",
                                analysePointId));
        return    MapBuilder.<String,Object>create().put("processPointIds",gongkuangList).build();
    }

    public List<IdxBizFanPointVarCorrelation> getDetailBySequenceNbr(String sequenceNbr) {
        IdxBizFanPointVarCorrelation fanPointVarCorrelation = getById(sequenceNbr);
        if(Objects.isNull(fanPointVarCorrelation)){
            return new ArrayList<>();
        }
        LambdaQueryWrapper<IdxBizFanPointVarCorrelation> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(IdxBizFanPointVarCorrelation::getArae, fanPointVarCorrelation.getArae());
        wrapper.eq(IdxBizFanPointVarCorrelation::getAnalysisGatewayId,fanPointVarCorrelation.getAnalysisGatewayId());
        wrapper.eq(IdxBizFanPointVarCorrelation::getStation, fanPointVarCorrelation.getStation());
        wrapper.eq(IdxBizFanPointVarCorrelation::getNumber, fanPointVarCorrelation.getNumber());
        wrapper.eq(IdxBizFanPointVarCorrelation::getEquipmentName, fanPointVarCorrelation.getEquipmentName());
        wrapper.eq(IdxBizFanPointVarCorrelation::getSubSystem, fanPointVarCorrelation.getSubSystem());
        wrapper.eq(IdxBizFanPointVarCorrelation::getAnalysisPointId, fanPointVarCorrelation.getAnalysisPointId());
        wrapper.orderByDesc(IdxBizFanPointVarCorrelation::getMatchProcessPoint).orderByAsc(IdxBizFanPointVarCorrelation::getProcessPointName);
        List<IdxBizFanPointVarCorrelation> fanPointVarCorrelationList = list(wrapper);
        return fanPointVarCorrelationList;
    }

    public void updatePointChooseBySequenceNbrList(List<String> sequenceNbrList) {
        if(CollectionUtil.isNotEmpty(sequenceNbrList) ){
            if(sequenceNbrList.size()>3){
                throw new BadRequest("最多选择3个");
            }
            LambdaQueryWrapper<IdxBizFanPointVarCorrelation> wrapper = new LambdaQueryWrapper<>();
            wrapper.in(IdxBizFanPointVarCorrelation::getSequenceNbr, sequenceNbrList);
            List<IdxBizFanPointVarCorrelation> fanPointVarCorrelations = list(wrapper);
            if(CollectionUtil.isNotEmpty(fanPointVarCorrelations)){
                IdxBizFanPointVarCorrelation firstData = fanPointVarCorrelations.get(0);
                String analysisGatewayId = firstData.getAnalysisGatewayId();
                Long analysisPointId = firstData.getAnalysisPointId();
                List<String> processPointIds = new ArrayList<>();
                for (IdxBizFanPointVarCorrelation fanPointVarCorrelation : fanPointVarCorrelations) {
                    if(!analysisGatewayId.equals(fanPointVarCorrelation.getAnalysisGatewayId())|| !analysisPointId.equals(fanPointVarCorrelation.getAnalysisPointId())){
                        throw new BadRequest("不是同一批分析测点无法操作");
                    }
                    processPointIds.add(String.valueOf(fanPointVarCorrelation.getProcessPointId()));
                }
                updatePointChoose(analysisGatewayId,Long.valueOf(analysisPointId),processPointIds);
            }
        }
    }
}