package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jxiop.api.feign.IdxFeign;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.IdxBizTableMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.service.IIdxBizTableService;
import com.yeejoin.amos.boot.module.jxiop.biz.service.IPermissionService;
import com.yeejoin.amos.component.feign.model.FeignClientResult;

import lombok.extern.slf4j.Slf4j;

@Service
@Slf4j
public class IdxBizTableServiceImpl implements IIdxBizTableService {

	@Autowired
	private IPermissionService permissionService;

	@Autowired
	private IdxBizTableMapper idxBizTableMapper;

	@Autowired
	private IdxFeign idxFeign;

	private static Map<String, String> cmap = new HashMap<>();
	
	private static String[] tableNames = {"idx_biz_fan_point_process_variable_classification","idx_biz_pv_point_process_variable_classification"};

	//初始化表列对应map
	static {
		cmap.put("area", "ARAE");
		cmap.put("station", "STATION");
		cmap.put("number", "NUMBER");
		cmap.put("equipmentName", "EQUIPMENT_NAME");
		cmap.put("subSystem", "SUB_SYSTEM");
		cmap.put("pointName", "ANALYSIS_POINT_NAME");
		cmap.put("subarray", "SUBARRAY");
	}

	/**
	 * 分页查询业务事实表的数据-IDX(/idx/table/getPage)前置接口, 增加权限控制
	 *
	 * @param map 查询参数
	 */
	public Page<Map<String, Object>> getPage(Map<String, Object> map) {
		List<String> currentUserPermissions = permissionService.getCurrentUserPermissions();
		if (Objects.isNull(currentUserPermissions)) {
			currentUserPermissions = new ArrayList<>();
		}
		String gatewayIds = String.join(",", currentUserPermissions);
		if (!gatewayIds.isEmpty()) {
			map.put("GATEWAY_ID", String.format("[%s]", gatewayIds));
		} else {
			map.put("GATEWAY_ID", "[NULL]");
		}
		FeignClientResult<Page<Map<String, Object>>> page = idxFeign.getPage(map);
		return page.getResult();
	}

	/**
	 * 分页查询业务事实表的数据-IDX(/idx/table/getPage)前置接口, 增加权限控制
	 *
	 * @param map 查询参数
	 */
	public Page<Map<String, Object>> getPageO(Map<String, Object> map) {
		List<String> currentUserPermissions = permissionService.getCurrentUserProjectOrgCodes();
		if (Objects.isNull(currentUserPermissions)) {
			currentUserPermissions = new ArrayList<>();
		}
		String orgcodes = String.join(",", currentUserPermissions);
		if (!orgcodes.isEmpty()) {
			map.put("ORG_CODE", String.format("[%s]", orgcodes));
		} else {
			map.put("ORG_CODE", "[NULL]");
		}
		FeignClientResult<Page<Map<String, Object>>> page = idxFeign.getPage(map);
		return page.getResult();
	}

	/**
	 * 获取下拉列表参数
	 *
	 * @param tableName       表名
	 * @param column          列名
	 * @param valueColumn     数据值列
	 * @param conditionColumn 条件列名
	 * @param conditionValue  条件值
	 * @param isFx            是否是"分析变量"
	 */
	@Override
	public List<Map<String, Object>> getSelectOptions(Map<String, String> map) {
		// List<String> permissions = permissionService.getCurrentUserPermissions();
		String tableName = map.get("tableName");
		map.remove("tableName");
		String column = map.get("column");
		map.remove("column");
		String valueColumn = map.get("valueColumn");
		map.remove("valueColumn");
		String conditionColumn = map.get("conditionColumn");
		map.remove("conditionColumn");
		String conditionValue = map.get("conditionValue");
		map.remove("conditionValue");
		String isFx = map.get("isFx");
		map.remove("isFx");
		String fx = map.get("fx");
		map.remove("fx");
		List<String> permissions = permissionService.getCurrentUserProjectOrgCodes();
		List<Map<String, String>> filters = new ArrayList<>();
		map.forEach((key, value) -> {
			Map<String, String> smap = new HashMap<>();
			if (Arrays.asList(tableNames).contains(tableName)&&cmap.containsKey(key)) {
				key = cmap.get(key);
			}
			smap.put("column", key);
			smap.put("value", value);
			filters.add(smap);
		});
		if (Objects.isNull(permissions)) {
			permissions = new ArrayList<>();
			permissions.add("NULL");
		}
		return idxBizTableMapper.getSelectOptions(tableName, column, valueColumn, conditionColumn, conditionValue, isFx,
				permissions, filters);
	}
}
