package com.yeejoin.amos.boot.module.jxiop.api.service;


import java.util.List;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.amos.boot.module.jxiop.api.dto.*;
import com.yeejoin.amos.boot.module.jxiop.api.entity.HouseholdPv;
import com.yeejoin.amos.boot.module.jxiop.api.util.CommonResponse;
import com.yeejoin.amos.feign.privilege.model.UserOrgTreeModel;

/**
 * 户用光伏表接口类
 *
 * @author system_generator
 * @date 2023-03-17
 */
public interface IHouseholdPvService extends IService<HouseholdPv>{

    CommonResponse importData(List<HouseholdPvImport> list);

    List<HouseholdPvExport> selectExportList(HouseholdPvDto dto, List<Long> ids);

    void deleteBatch(List<Long> ids);
    
    HouseholdPvDto save(HouseholdPvDto householdPvDto);
    
    HouseholdPvDto update(HouseholdPvDto householdPvDto);
    
    HouseholdPvDto getBySeq(Long id);

    Integer countRepeat(HouseholdPvDto householdPvDto, String type);

    /**
     * 导出-户用光伏运维表-设备信息
     * @param dto
     * @param ids
     * @return
     */
    List<EquipMessageExport> selectExportEquipMessage(HouseholdPvDto dto, List<Long> ids);


}
