package com.yeejoin.amos.boot.module.jxiop.api.util;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Component
public class HttpRequestUtil {
    public String sendRequest(String requestMethod, String url, String params, HashMap<String, String> headMap) {
        String respone = "";
        if (requestMethod.equals("POST")) {
            respone = HttpUtil.createPost(url).headerMap(headMap, false).
                    body(params).execute().body();
        }
        if (requestMethod.equals("GET")) {
            respone = HttpUtil.createGet(url).headerMap(headMap, true).
                    body(params).execute().body();
        }
        return respone;
    }

    public JSONArray handlerResponseByResultResolverule(String resultResovle, String response) {
        JSONObject jsonObject = JSONObject.parseObject(response);
        JSONArray jsonArray = new JSONArray();
        if (ObjectUtil.isNotEmpty(resultResovle)) {
            String[] rules = resultResovle.split(",");
            if (rules.length > 0) {
                for (int i = 0; i < rules.length; i++) {
                    try {
                        jsonObject = (JSONObject) jsonObject.get(rules[i]);
                        if (jsonObject == null) {
                            jsonArray = (JSONArray) jsonObject.get(rules[i]);
                        }
                    } catch (Exception exception) {
                        jsonArray = (JSONArray) jsonObject.get(rules[i]);
                    }
                }
            }
            if (jsonArray.size() == 0) {
                jsonArray.add(jsonObject);
            }
        }
        return jsonArray;
    }

    public <T> List<T> getResPonse(String apiurl, String requestMethod, String requestParmInfo, String ResultResolveRule, Class<T> tClass) {
        String respone = "";
        String params = "";
        JSONArray jsonArray = null;
        List<T> result = new ArrayList<>();
        try {
            respone = sendRequest(requestMethod, apiurl, requestParmInfo, null);
            jsonArray = handlerResponseByResultResolverule(ResultResolveRule, respone);
            if (!ObjectUtils.isEmpty(jsonArray)) {
                result = JSONArray.parseArray(jsonArray.toJSONString(), tClass);
            }
        } catch (Exception exception) {
            return result;
        }
        return result;
    }
    
    public JSONObject getResPonse(String apiurl, String requestMethod, String requestParmInfo, String ResultResolveRule) {
        String response = "";
        String params = "";
        JSONObject jsonObject = null;
        try {
            response = sendRequest(requestMethod, apiurl, requestParmInfo, null);
            jsonObject = JSONObject.parseObject(response);
            jsonObject = jsonObject.getJSONObject(ResultResolveRule);
        } catch (Exception exception) {
            return jsonObject;
        }
        return jsonObject;
    }
}
