package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jxiop.api.dto.StationBasicDto;
import com.yeejoin.amos.boot.module.jxiop.api.dto.StationInfoDto;
import com.yeejoin.amos.boot.module.jxiop.api.dto.StationRecordInfo;
import com.yeejoin.amos.boot.module.jxiop.api.dto.StationTaksDto;
import com.yeejoin.amos.boot.module.jxiop.api.entity.*;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.StationBasicMapper;
import com.yeejoin.amos.boot.module.jxiop.api.service.IStationBasicService;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/**
 * 场站基础信息表服务实现类
 *
 * @author system_generator
 * @date 2023-04-20
 */
@Service
public class StationBasicServiceImpl extends BaseService<StationBasicDto, StationBasic, StationBasicMapper> implements IStationBasicService {



    @Autowired
    StationBasicMapper stationBasicMapper;

    private final String CZLX = "CZLX";

    /**
     * 分页查询
     */
    public Page<StationBasicDto> queryForStationBasicPage(Page<StationBasicDto> page) {
        return this.queryForPage(page, null, false);
    }


    /**
     * 分页查询
     */
    public Page<StationBasicDto> queryPage(Page<StationBasicDto> page,
                                           String stationMasterName,
                                           String stationName,
                                           String stationType,
                                           String orgCode
    ) {
        List<StationBasicDto> list = stationBasicMapper.queryPage((page.getCurrent() - 1) * page.getSize(), page.getSize(), stationMasterName,
                stationName,
                stationType, orgCode);
        List<StationBasicDto> listcount = stationBasicMapper.queryPagecount(stationMasterName,
                stationName,
                stationType,
                orgCode);
        page.setTotal(listcount.size());
        page.setRecords(list);
        return page;
    }


    private CompanyModel addCompanyModel(CompanyModel companyModel) {
        FeignClientResult<CompanyModel> Model = Privilege.companyClient.create(companyModel);
        CompanyModel user = new CompanyModel();

        if (!ObjectUtils.isEmpty(Model)) {
            if (Model.getStatus() == 200) {
                user = Model.getResult();
            } else {
                throw new RuntimeException(Model.getMessage());
            }
        }
        return user;
    }

    private void deleteCompany(String ids) {
        FeignClientResult Model = Privilege.companyClient.deleteCompany(ids);

        CompanyModel user = new CompanyModel();

        if (!ObjectUtils.isEmpty(Model)) {
            if (Model.getStatus() != 200) {
                throw new RuntimeException(Model.getMessage());
            }
        }

    }


    private String queryByCode(String dictCode, String dictDataKey) {
        FeignClientResult<DictionarieValueModel> Model = Systemctl.dictionarieClient.value(dictCode, dictDataKey);
        DictionarieValueModel user = new DictionarieValueModel();

        if (!ObjectUtils.isEmpty(Model)) {
            if (Model.getStatus() == 200) {
                user = Model.getResult();
            } else {
                throw new RuntimeException(Model.getMessage());
            }
        }
        return user.getDictDataValue();
    }


    private CompanyModel updateCompanyModel(CompanyModel companyModel, Long sequenceNbr) {
        FeignClientResult<CompanyModel> Model = Privilege.companyClient.update(companyModel, sequenceNbr);
        CompanyModel user = new CompanyModel();

        if (!ObjectUtils.isEmpty(Model)) {
            if (Model.getStatus() == 200) {
                user = Model.getResult();
            } else {
                throw new RuntimeException(Model.getMessage());
            }
        }
        return user;
    }





    public int deleteList(String ids) {
        QueryWrapper<StationBasic> wrapper = new QueryWrapper();
        wrapper.in("sequence_nbr", ids);
        List<StationBasic> list = this.list(wrapper);
        List<String> idscom = new ArrayList<>();
        for (StationBasic personAccount : list) {
            idscom.add(personAccount.getPlatformStationId());
        }
        //删除平台
        int deleteResult = stationBasicMapper.deleteList(ids);
        this.deleteCompany(String.join(",", idscom));
        return deleteResult;
    }




    public int getStationPersonByStationID(String id) {
        return stationBasicMapper.getStationPersonByStationID(id);
    }


    public List<StationTaksDto> getStationTaksDtoList(){
        return  stationBasicMapper.getStationBasicDtoList();
    }

}