package com.yeejoin.amos.boot.module.jxiop.biz.controller;

import com.yeejoin.amos.boot.module.jxiop.api.dto.MapLegendDto;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.MapLegendServiceImpl;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.util.List;

import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.http.HttpServletRequest;

import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 地图图例
 *
 * @author system_generator
 * @date 2023-06-08
 */
@RestController
@Api(tags = "地图图例Api")
@RequestMapping(value = "/map-legend")
public class MapLegendController extends BaseController {

    @Autowired
    MapLegendServiceImpl mapLegendServiceImpl;

    /**
     * 新增地图图例
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增地图图例", notes = "新增地图图例")
    public ResponseModel<MapLegendDto> save(@RequestBody MapLegendDto model) {
        model = mapLegendServiceImpl.createWithModel(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新地图图例", notes = "根据sequenceNbr更新地图图例")
    public ResponseModel<MapLegendDto> updateBySequenceNbrMapLegend(@RequestBody MapLegendDto model, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(mapLegendServiceImpl.updateWithModel(model));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除地图图例", notes = "根据sequenceNbr删除地图图例")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(mapLegendServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个地图图例", notes = "根据sequenceNbr查询单个地图图例")
    public ResponseModel<MapLegendDto> selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(mapLegendServiceImpl.queryBySeq(sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "地图图例分页查询", notes = "地图图例分页查询")
    public ResponseModel<Page<MapLegendDto>> queryForPage(@RequestParam(value = "current") int current, @RequestParam
            (value = "size") int size) {
        Page<MapLegendDto> page = new Page<MapLegendDto>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(mapLegendServiceImpl.queryForMapLegendPage(page));
    }

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "地图图例列表全部数据查询", notes = "地图图例列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<MapLegendDto>> selectForList() {
        return ResponseHelper.buildResponse(mapLegendServiceImpl.queryForMapLegendList());
    }
}
