package com.yeejoin.amos.boot.module.jxiop.biz.controller;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jxiop.api.entity.PersonAccount;
import com.yeejoin.amos.boot.module.jxiop.api.entity.PersonBasic;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.PersonAccountMapper;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.PersonBasicMapper;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.util.AesUtil;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 农户信息
 *
 * @author system_generator
 * @date 2023-07-07
 */
@RestController
@Api(tags = "农户信息Api")
@RequestMapping(value = "/test")
public class TestController extends BaseController {
	
	@Autowired
	PersonBasicMapper personBasicMapper;
	
	@Autowired
	PersonAccountMapper personAccountMapper;
	

	/**
	 * 新增农户信息
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@GetMapping(value = "/initpw")
	@ApiOperation(httpMethod = "GET", value = "刷新基础管理信息", notes = "刷新基础管理信息")
	public ResponseModel<Object> initpw() {
		// 基础管理员
		List<PersonAccount> list = personAccountMapper.selectList(null);
		int i = 0;
		for (PersonAccount unitInfo : list) {
			System.out.println();
			System.out.println(++i+"/"+list.size());
			try {
				PersonBasic  personBasic =personBasicMapper.selectById(unitInfo.getPersonId());
				int ph = personBasic.getPhone().length();
				String npwd = "Zxnk_" + personBasic.getPhone().substring(ph - 4, ph);
				String npwdm = AesUtil.encode(npwd, "qaz");
				unitInfo.setPassword(npwdm);
				unitInfo.setSecondaryPassword(npwdm);
				FeignClientResult<AgencyUserModel> re = Privilege.agencyUserClient
						.queryByUserId(unitInfo.getPuserId());
				AgencyUserModel ag = re.getResult();
				ag.setPassword(AesUtil.encode(npwd, "qaz"));
				ag.setRePassword(AesUtil.encode(npwd, "qaz"));
				Privilege.agencyUserClient.restorePassword(unitInfo.getPuserId());
				ag.setOriginalPassword(AesUtil.encode("Z2%Op9.q", "qaz"));
				Privilege.agencyUserClient.modifyPassword(unitInfo.getPuserId(), ag);
				personAccountMapper.updateById(unitInfo);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return new ResponseModel<>();
	}
}