package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.joda.time.DateTime;

import java.util.Date;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="HYGFMaintenanceTicketsDto", description="运维工单")
public class HYGFMaintenanceTicketsDto extends BaseDto {
    private static final long serialVersionUID = 1L;
    /**
     * 工单处理状态
     */
    private String handlerStatus;
    /**
     * 场站id
     */
    private String stationId;
    /**
     * 业主姓名
     */
    private String ownerName;
    /**
     * 场站名称
     */
    private String stationName;
    /**
     * 逆变器sn编码
     */
    private String inverterSn;
    /**
     * 告警等级
     */
    private String warningLevel;
    /**
     * 告警内容
     */
    private String warningContent;
    /**
     * 告警开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date warningStartTime;
    /**
     * 告警开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date warningEndTime;
    /**
     * 告警时长
     */
    private String warningDuration;

    /**
     * 告警状态
     */
    private String warningStatus;
    /**
     * 场站联系人
     */
    private String stationContact;
    /**
     * 场站联系人电话
     */

    private String stationContactPhone;
    /**
     * 场站地址
     */

    private String stationAddress;
    /**
     * 处理附件
     */
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> hanlerContentAttachment;
    /**
     * 处理方式
     */
    private String handlerMethod;
    /**
     * 是否替换备件
     */

    private Boolean isReplaceSpareParts =false;
    /**
     * 运维人员附件
     */
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> sparePartsAttchment;
    /**
     * 场站运维人员id
     */
    private String maintenancePersonId;
    /**
     * 场站经度
     */
    private String stationLongitude;
    /**
     * 场站纬度
     */
    private String stationLatitude;
    /**
     * 运维人员名称
     */
    private String maintenancePersonName;
    /**
     * 运维人员手机号
     */
    private String maintenancePersonPhone;
    /**
     * tdengine告警id
     */
    private Long warningId;
    /**
     * 区域公司orgCode
     */
    private String regionalCompaniesCode;

    /**
     * 经销商orgcode
     */
    private String amosCompanyCode;
    /**
     * 工单类型
     */
    private String ticketType;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date taskStartTime;
    /**
     * 告警开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date taskEndTime;
    //创建人id
    private String creatorUserId;
}
