package com.yeejoin.amos.boot.module.hygf.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.AcceptanceRectificationOrderDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.AcceptanceRectificationOrder;
import org.apache.ibatis.annotations.Param;

/**
 * 验收整改单 Mapper 接口
 *
 * @author system_generator
 * @date 2024-01-16
 */
public interface AcceptanceRectificationOrderMapper extends BaseMapper<AcceptanceRectificationOrder> {
    /**
     * 分页查询整改单列表数据
     *
     * @param page             分页对象
     * @param acceptanceSeqNbr 验收单编号
     * @return 分页结果
     */
    Page<AcceptanceRectificationOrderDto> page(
            @Param("page") IPage<AcceptanceRectificationOrderDto> page,
            @Param("acceptanceSeqNbr") Long acceptanceSeqNbr
    );

    /**
     * 根据编号查询
     *
     * @param sequenceNbr 编号
     * @return 结果
     */
    AcceptanceRectificationOrderDto queryBySequenceNbr(@Param("sequenceNbr") Long sequenceNbr);
}
