package com.yeejoin.amos.boot.module.jxiop.api.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.List;
import java.util.Map;

public interface IMcbWarningService {

	/**
	 * 今日预警-预警总数
	 *
	 * @param processingStatus 处理状态
	 * @return 预警总数
	 */
	Map<String, Object> queryTodayCount(Integer processingStatus);

	/**
	 * 近七日预警统计
	 *
	 * @return 预警统计
	 */
	List<Map<String, Object>> queryWeekCount();

	/**
	 * 预警信息列表
	 *
	 * @return 预警信息列表
	 */
	Page<Map<String, Object>> queryWarningPage(Page<Map<String, Object>> page, Integer processingStatus,
			String eventLevel, String createDate,String startTime,String endTime, String warningSourceType,String overView);

	/**
	 * 预警信息总数
	 *
	 * @return 预警信息总数
	 */
	Long queryWarningCount(Integer processingStatus, String eventLevel, String createDate,String startTime,String endTime, String warningSourceType,String overView);

	/**
	 * 问题信息列表
	 *
	 * @return 问题信息列表
	 */
	Page<Map<String, Object>> queryQuestionPage(Page<Map<String, Object>> page, Integer completionStatus, String startTime, String endTime);

	/**
	 * 问题信息列表
	 *
	 * @return 问题信息列表
	 */
	Long queryQuestionCount(Integer completionStatus, String startTime, String endTime);

	/**
	 * 获取地图点位/路线
	 *
	 * @return 地图点位/路线
	 */
	Object queryMapRoutes(String province);

	/**
	 * 任务详情分页列表
	 *
	 * @return 任务详情分页列表
	 */
	Page<Map<String, Object>> getTaskDetailPage(Map<String, Object> map);

	/**
	 * 问题记录分页列表
	 *
	 * @return 任务详情分页列表
	 */
	Page<Map<String, Object>> getQuestionRecordPage(Map<String, Object> map);

	/**
	 * 任务详情、问题记录左侧树
	 */
	Object getWarnTree();

	/**
	 * 任务详情列表统计
	 */
	Object getTaskDetailStatistic(Map<String, Object> map);

	/**
	 * 问题记录列表统计
	 */
	Object getQuestionRecordStatistic(Map<String, Object> map);

	Object getMapRouteInfoByCodes(String province);

	Object getLampListPageByCodes(String questionRectificationStatus, String warningSourceType, String objectName,
			Page page);

	Object getLampListByCodes(String questionRectificationStatus, String warningSourceType, String objectName);

	List<Map<String, Object>> stationOverNum();

	Object stationOverTotal(String province);
}
