package com.yeejoin.amos.boot.module.jxiop.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jxiop.api.service.IMcbWarningService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@RestController
@Api(tags = "McbWarning Controller")
@RequestMapping(value = "/warning")
public class McbWarningController {

	@Autowired
	private IMcbWarningService mcbWarningService;

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "[监测总览]今日预警-预警总数", notes = "[监测总览]今日预警-预警总数")
	@GetMapping(value = "/count/today")
	public ResponseModel<Map<String, Object>> queryTodayCount(
			@RequestParam(value = "processingStatus", required = false) Integer processingStatus) {
		return ResponseHelper.buildResponse(mcbWarningService.queryTodayCount(processingStatus));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "[监测总览]近七日预警统计", notes = "[监测总览]近七日预警统计")
	@GetMapping(value = "/count/week")
	public ResponseModel<Object> queryWeekCount() {
		List<Map<String, Object>> list = mcbWarningService.queryWeekCount();
		Map<String, Object> result = new HashMap<>();
		List<Object> axisData = new ArrayList<>();
		List<Object> seriesData = new ArrayList<>();
		if (!CollectionUtils.isEmpty(list)) {
			axisData = list.stream().map(x -> x.get("axisData")).collect(Collectors.toList());
			seriesData = list.stream().map(y -> y.get("seriesData")).collect(Collectors.toList());
		}
		result.put("axisData", axisData);
		result.put("seriesData", seriesData);
		return ResponseHelper.buildResponse(result);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "[监测总览]预警信息列表", notes = "[监测总览]预警信息列表")
	@GetMapping(value = "/warning/page")
	public ResponseModel<Page<Map<String, Object>>> queryWarningPage(
			@RequestParam(value = "pageNumber", defaultValue = "1") Integer pageNumber,
			@RequestParam(value = "pageSize", defaultValue = "20") Integer pageSize,
			@RequestParam(value = "processingStatus", required = false) Integer processingStatus,
			@RequestParam(value = "eventLevel", required = false) String eventLevel,
			@RequestParam(value = "createDate", required = false) String createDate,
			@RequestParam(value = "startTime", required = false) String startTime,
			@RequestParam(value = "endTime", required = false) String endTime,
			@RequestParam(value = "overView", required = false) String overView,
			@RequestParam(value = "warningSourceType", required = false) String warningSourceType) {
		Page<Map<String, Object>> page = new Page<>(pageNumber, pageSize);
		return ResponseHelper.buildResponse(
				mcbWarningService.queryWarningPage(page, processingStatus, eventLevel, createDate, startTime,endTime,  warningSourceType,overView));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "[监测总览]预警信息总数", notes = "[监测总览]预警信息总数")
	@GetMapping(value = "/warning/count")
	public ResponseModel<Map<String, Object>> queryWarningCount(
			@RequestParam(value = "processingStatus", required = false) Integer processingStatus,
			@RequestParam(value = "eventLevel", required = false) String eventLevel,
			@RequestParam(value = "createDate", required = false) String createDate,
			@RequestParam(value = "startTime", required = false) String startTime,
			@RequestParam(value = "endTime", required = false) String endTime,
			@RequestParam(value = "overView", required = false) String overView,
			@RequestParam(value = "warningSourceType", required = false) String warningSourceType) {
		Long count = mcbWarningService.queryWarningCount(processingStatus, eventLevel,createDate, startTime,endTime, warningSourceType,overView);
		Map<String, Object> result = new HashMap<String, Object>() {
			{
				this.put("count", count);
			}
		};
		return ResponseHelper.buildResponse(result);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "[监测总览]问题列表", notes = "[监测总览]问题列表")
	@GetMapping(value = "/question/page")
	public ResponseModel<Page<Map<String, Object>>> queryQuestionList(
			@RequestParam(value = "pageNumber", defaultValue = "1") Integer pageNumber,
			@RequestParam(value = "pageSize", defaultValue = "20") Integer pageSize,
			@RequestParam(value = "completionStatus", required = false) Integer completionStatus,
			@RequestParam(value = "startTime", required = false) String startTime,
			@RequestParam(value = "endTime", required = false) String endTime
	) {
		Page<Map<String, Object>> page = new Page<>(pageNumber, pageSize);
		return ResponseHelper.buildResponse(mcbWarningService.queryQuestionPage(page, completionStatus,startTime,endTime));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "任务详情、问题记录左侧树", notes = "任务详情、问题记录左侧树")
	@GetMapping(value = "/warning-warning-info/tree")
	public ResponseModel getWarnTree() {
		return ResponseHelper.buildResponse(mcbWarningService.getWarnTree());
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "任务详情分页列表", notes = "任务详情分页列表")
	@GetMapping(value = "/warning-warning-info/page")
	public ResponseModel<Page<Map<String, Object>>> getTaskDetailPage(@RequestParam Map<String, Object> map) {
		return ResponseHelper.buildResponse(mcbWarningService.getTaskDetailPage(map));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "任务详情统计", notes = "任务详情统计")
	@GetMapping(value = "/warning-warning-info/statistics")
	public ResponseModel getTaskDetailStatistic(@RequestParam Map<String, Object> map) {
		return ResponseHelper.buildResponse(mcbWarningService.getTaskDetailStatistic(map));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "问题记录分页列表", notes = "问题记录分页列表")
	@GetMapping(value = "/warning-question-info/questionPage")
	public ResponseModel<Page<Map<String, Object>>> getQuestionRecordPage(@RequestParam Map<String, Object> map) {
		return ResponseHelper.buildResponse(mcbWarningService.getQuestionRecordPage(map));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "问题记录统计", notes = "问题记录统计")
	@GetMapping(value = "/warning-question-info/questionPageTopStatistics")
	public ResponseModel getQuestionRecordStatistic(@RequestParam Map<String, Object> map) {
		return ResponseHelper.buildResponse(mcbWarningService.getQuestionRecordStatistic(map));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "[监测总览]问题总数", notes = "[监测总览]问题总数")
	@GetMapping(value = "/question/count")
	public ResponseModel<Map<String, Object>> queryQuestionCount(
			@RequestParam(value = "completionStatus", required = false) Integer completionStatus,
			@RequestParam(value = "startTime", required = false) String startTime,
			@RequestParam(value = "endTime", required = false) String endTime

	) {
		Long count = mcbWarningService.queryQuestionCount(completionStatus,startTime,endTime);
		Map<String, Object> result = new HashMap<String, Object>() {
			{
				this.put("count", count);
			}
		};
		return ResponseHelper.buildResponse(result);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "[监测总览]地图点位/路线", notes = "[监测总览]地图点位/路线")
	@GetMapping(value = "/map/routes")
	public ResponseModel<Object> queryMapRoutes(@RequestParam(value = "province", required = false) String province) {
		return ResponseHelper.buildResponse(mcbWarningService.queryMapRoutes(province));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "任务总览地图数据", notes = "任务总览地图数据")
	@GetMapping(value = "/getMapRouteInfoByCodes")
	public ResponseModel<Object> getMapRouteInfoByCodes(@RequestParam String province) {
		return ResponseHelper.buildResponse(mcbWarningService.getMapRouteInfoByCodes(province));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "跑马灯列表数据分页查询", notes = "任务总览地图数据")
	@GetMapping(value = "/warning-warning-info/getLampListPageByCodes")
	public ResponseModel<Object> getLampListPageByCodes(
			@RequestParam(value = "questionRectificationStatus", required = false) String questionRectificationStatus,
			@RequestParam(value = "warningSourceType", required = false) String warningSourceType,
			@RequestParam(value = "objectName", required = false) String objectName, Page page) {
		return ResponseHelper
				.buildResponse(mcbWarningService.getLampListPageByCodes(questionRectificationStatus,warningSourceType,objectName, page));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "跑马灯列表数据查询", notes = "任务总览地图数据")
	@GetMapping(value = "/warning-warning-info/getLampListByCodes")
	public ResponseModel<Object> getLampListByCodes(
			@RequestParam(value = "questionRectificationStatus", required = false) String questionRectificationStatus,
			@RequestParam(value = "warningSourceType", required = false) String warningSourceType,
			@RequestParam(value = "objectName", required = false) String objectName) {
		return ResponseHelper.buildResponse(mcbWarningService.getLampListByCodes(questionRectificationStatus,warningSourceType,objectName));
	}


	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "任务总览-地图接口", notes = "任务总览-地图接口")
	@GetMapping(value = "/warning-warning-info/stationOverNum")
	public ResponseModel<Object> stationOverNum() {
		return ResponseHelper.buildResponse(mcbWarningService.stationOverNum());
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "任务总览-地图接口", notes = "任务总览-地图接口")
	@GetMapping(value = "/warning-warning-info/stationOverTotal")
	public ResponseModel<Object> stationOverTotal(String province) {
		return ResponseHelper.buildResponse(mcbWarningService.stationOverTotal(province));
	}
}
