package com.yeejoin.amos.boot.module.jxiop.biz.mcbwarningmapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

public interface McbWarningMapper extends BaseMapper {

    /**
     * 今日预警-预警总数
     *
     * @param processingStatus 处理状态
     * @return 总数信息
     */
    Map<String, Object> queryTodayCount(
            @Param("projectOrgCodes") List<String> projectOrgCodes,
            @Param("processingStatus") Integer processingStatus
    );

    /**
     * 近七日预警统计
     *
     * @return 预警统计
     */
    List<Map<String, Object>> queryWeekCount(
            @Param("projectOrgCodes") List<String> projectOrgCodes
    );

    /**
     * 预警列表
     *
     * @return 预警列表
     */
    List<Map<String, Object>> queryWarningList(
            @Param("start") Long start,
            @Param("offset") Long offset,
            @Param("projectOrgCodes") List<String> projectOrgCodes,
            @Param("processingStatus") Integer processingStatus,
            @Param("eventLevel") String eventLevel,
            @Param("createDate") String createDate,
            @Param("startTime") String startTime,
            @Param("endTime") String endTime,
            @Param("warningSourceType") String warningSourceType,
            @Param("overView") String overView
    );

    /**
     * 预警总数
     *
     * @return 预警总数
     */
    Long queryWarningCount(
            @Param("projectOrgCodes") List<String> projectOrgCodes,
            @Param("processingStatus") Integer processingStatus,
            @Param("eventLevel") String eventLevel,
            @Param("createDate") String createDate,
            @Param("startTime") String startTime,
            @Param("endTime") String endTime,
            @Param("warningSourceType") String warningSourceType,
            @Param("overView") String overView
    );

    /**
     * 问题列表
     *
     * @return 问题列表
     */
    List<Map<String, Object>> queryQuestionList(
            @Param("start") Long start,
            @Param("offset") Long offset,
            @Param("projectOrgCodes") List<String> projectOrgCodes,
            @Param("completionStatus") Integer completionStatus,
            @Param("startTime") String startTime,
            @Param("endTime") String endTime
    );


    List<Map<String, Object>> stationOverNum();

    /**
     * 问题总数
     *
     * @return 问题总数
     */
    Long queryQuestionCount(
            @Param("projectOrgCodes") List<String> projectOrgCodes,
            @Param("completionStatus") Integer completionStatus,
            @Param("startTime") String startTime,
            @Param("endTime") String endTime
    );

    Integer getYearTotal(String province);
    Integer getMonthTotal(String province);
    Integer getDayTotal(String province);
}
