package com.yeejoin.precontrol.common.service.impl;

import java.util.Date;

import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.precontrol.common.dto.CommonPageableDto;
import com.yeejoin.precontrol.common.entity.ProjectClock;
import com.yeejoin.precontrol.common.mapper.ProjectClockMapper;
import com.yeejoin.precontrol.common.service.IProjectClockService;
import com.yeejoin.precontrol.common.vo.ProjectClockVo;

/**
 * 项目入离岗打卡 服务实现类
 *
 * @author duanwei
 * @date 2020-07-22
 */
@Service
public class ProjectClockServiceImpl extends ServiceImpl<ProjectClockMapper, ProjectClock> implements IProjectClockService {

	@Override
	public int count(Long projectId, Long companyId, Date startDate, Date endDate, String contract,Boolean isSign) {
		return this.baseMapper.count(projectId, companyId, startDate, endDate, contract,isSign);
	}

	@Override
	public int dutyCount(String orgcode, Date startDate, Date endDate, boolean isFBS) {
		return this.baseMapper.dutyCount(orgcode,startDate, endDate, isFBS);
	}

	@Override
	public IPage<ProjectClockVo> dutyList(Page<ProjectClockVo> page, ProjectClockVo projectClockVo) {
		return this.baseMapper.dutyList(page,projectClockVo);
	}

}
