package com.yeejoin.equipmanage.common.entity;

import java.math.BigDecimal;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * 
 *
 * @author wujiang
 * @date 2020-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_car_conf")
@ApiModel(value="CarConf对象", description="")
public class CarConf extends BaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "车辆id")
    private Long carId;

    @ApiModelProperty(value = "车载系统编码")
    private String carCode;

    @ApiModelProperty(value = "是否启用")
    private Long enable;

    @ApiModelProperty(value = "参数")
    private String params;

    @ApiModelProperty(value = "系数默认为1")
    private BigDecimal coefficient;

    @ApiModelProperty(value = "创建时间")
    private Date dateCreated;

    @ApiModelProperty(value = "排序字段")
    private Integer orders;

    @ApiModelProperty(value = "类型")
    private String type;

    @ApiModelProperty(value = "描述")
    private String description;

    @ApiModelProperty(value = "编码")
    private String code;

    @ApiModelProperty(value = "别名（对应英文描述）")
    private String alias;

    @ApiModelProperty(value = "单位")
    private String unitName;


}
