package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
/**
 * @author DELL
 */
@Data
@TableName("wl_form_group")
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "wl_form_group对象", description = "分组表")
public class FormGroup extends BaseEntity {
    @ApiModelProperty(value = "分组名称")
    @TableField("group_name")
    private String groupName;

    @ApiModelProperty(value = "分组编号")
    @TableField("group_code")
    private String groupCode;

    @ApiModelProperty(value = "分组类型（点位图过滤用）")
    @TableField("group_type")
    private String groupType;

    @ApiModelProperty(value = "允许的操作（逗号分隔ids）")
    @TableField("allow_operation")
    private String allowOperation;

    @ApiModelProperty(value = "创建者")
    @TableField("creator_id")
    private Long creatorId;
}
