package com.yeejoin.equipmanage.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Properties;

import javax.annotation.PostConstruct;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.support.PropertiesLoaderUtils;

import freemarker.template.Configuration;
import freemarker.template.Template;
import net.bytebuddy.asm.Advice.This;
import sun.misc.BASE64Encoder;

public class WordTemplateUtils {

	
	private static String fileUploadDir;
	
	private Configuration configuration = null;
	
	private static WordTemplateUtils wordTemplateUtils;
	
	private WordTemplateUtils() {
		configuration = new Configuration();
        configuration.setDefaultEncoding("utf-8");
	}

	public static synchronized WordTemplateUtils getInstance(){
        if(wordTemplateUtils == null){
        	//添加你的内容
    		Properties props;
    		try {
    			props = PropertiesLoaderUtils.loadAllProperties("application-dev.properties");
    			fileUploadDir = (String) props.get("file.uploadUrl");
    		} catch (IOException e) {
    			// TODO Auto-generated catch block
    			e.printStackTrace();
    		}
        	wordTemplateUtils = new WordTemplateUtils();
        }
        return wordTemplateUtils;
    }
	

	public void exportMillCertificateWord(HttpServletRequest request, HttpServletResponse response, Map map,
			String title, String ftlFile) throws IOException {
		URL resourcePath = this.getClass().getClassLoader().getResource("ftl");
		configuration.setDirectoryForTemplateLoading(new File(resourcePath.getPath()));
		Template freemarkerTemplate = configuration.getTemplate(ftlFile);
		File file = null;
		InputStream fin = null;
		ServletOutputStream out = null;
		try {
			// 调用工具类的createDoc方法生成Word文档
			file = createDoc(map, freemarkerTemplate);
			fin = new FileInputStream(file);

			response.setCharacterEncoding("utf-8");
			response.setContentType("application/msword");
			// 设置浏览器以下载的方式处理该文件名
			String fileName = (StringUtil.isNotEmpty(title) ? title : FileUtil.getUUID()) + ".doc";
			response.setHeader("Content-Disposition",
					"attachment;filename=".concat(String.valueOf(URLEncoder.encode(fileName, "UTF-8"))));

			out = response.getOutputStream();
			byte[] buffer = new byte[512]; // 缓冲区
			int bytesToRead = -1;
			// 通过循环将读入的Word文件的内容输出到浏览器中
			while ((bytesToRead = fin.read(buffer)) != -1) {
				out.write(buffer, 0, bytesToRead);
			}
		} finally {
			if (fin != null){
				fin.close();}
			if (out != null){
				out.close();}
			if (file != null){
				file.delete(); }// 删除临时文件
		}
	}

	private static File createDoc(Map<?, ?> dataMap, Template template) {
		String name = "sellPlan.doc";
		File f = new File(name);
		Template t = template;
		try {
			// 这个地方不能使用FileWriter因为需要指定编码类型否则生成的Word文档会因为有无法识别的编码而无法打开
			Writer w = new OutputStreamWriter(new FileOutputStream(f), "utf-8");
			t.process(dataMap, w);
			w.close();
		} catch (Exception ex) {
			ex.printStackTrace();
			throw new RuntimeException(ex);
		}
		return f;
	}

	// 获得图片的base64码
	@SuppressWarnings("deprecation")
	public String getImageBase(String src) {
		if (src == null || src == "") {
			return "";
		}
		if (StringUtil.isNotEmpty(src)) {
			src = src.replaceAll("\\.\\.", "");
		}
		String fileName = fileUploadDir + src;
		File file = new File(fileName);
		if (!file.exists()) {
			return "";
		}
		InputStream in = null;
		byte[] data = null;
		try {
			in = new FileInputStream(file);
		} catch (FileNotFoundException e1) {
			e1.printStackTrace();
		}
		try {
			data = new byte[in.available()];
			in.read(data);
			in.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
		BASE64Encoder encoder = new BASE64Encoder();
		return encoder.encode(data);
	}
}
