package com.yeejoin.amos.fas.dao.entity;

import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;


@Entity
@Table(name = "contingency_original_data")
public class ContingencyOriginalData extends BusinessEntity {

    /**
     * id
     */
    @Id
    @GeneratedValue(generator = "uuid")
    @GenericGenerator(name = "uuid", strategy = "uuid2")
    @Column(name = "id", nullable = false, length = 36)
    protected String id;


    @Column(name = "fire_Equipment_Name")
    private String fireEquipmentName;//消防设备名称

    @Column(name = "fire_Equipment_Id")
    private String fireEquipmentId;//消防设备id

    @Column(name = "layer")
    private Integer  layer;//显示图层
    //当前探测器

    @Column(name = "fire_Equipment_Layer")
    private Integer fireEquipmentLayer;//当前探测器图层

    @Column(name = "fire_Equipment_Position")
    private String  fireEquipmentPosition;//消防设备位置

    //重点设备信息
    //负责人名称，手机号
    @Column(name = "equipment_Id")
    private  String  equipmentId;//重点设备id

    @Column(name = "equipment_Name")
    private String   equipmentName;

    @Column(name = "equipment_position3d")
    private String equipmentPosition3d;

    @Column(name = "mobile")
    private String mobile; //负责人手机号

    @Column(name = "admin_Name")
    private String adminName;//负责人名称

    //摄像头
    @Column(name = "camera_Codes")
    private String cameraCodes;//摄像头编号

    @Column(name = "camera_Ids")
    private String cameraIds;//摄像头id

    @Column(name = "fire_Count")
    private Integer fireCount = 1; //火情数量

    @Column(name = "confirm")
    private String confirm ;//是否确认火情，确认 CONFIRM,取消CANCEL,未操作 NONE

    @Column(name = "batch_No")
    private String batchNo;



    @Column(name = "picture1")
    private String picture1;

    @Column(name = "picture2")
    private String picture2;

    @Column(name = "picture3")
    private String picture3;

    @Column(name = "picture4")
    private String picture4;

    @Column(name = "fire_Truck_Route")
    private String fireTruckRoute;

    @Column(name = "runstep")
    private boolean runstep; //是否已经执行流程

    @Column(name = "step")
    private String step;//当前步骤

    @Column(name = "step_state")
    private String stepState;//步骤的操作状态，由所有按钮的步骤状态拼接而成


    public String getEquipmentPosition3d() {
        return equipmentPosition3d;
    }

    public void setEquipmentPosition3d(String equipmentPosition3d) {
        this.equipmentPosition3d = equipmentPosition3d;
    }

    public String getStepState() {
        return stepState;
    }

    public void setStepState(String stepState) {
        this.stepState = stepState;
    }

    public String getStep() {
        return step;
    }

    public void setStep(String step) {
        this.step = step;
    }


    public boolean getRunstep() {
        return runstep;
    }

    public void setRunstep(boolean runstep) {
        this.runstep = runstep;
    }

    public String getFireTruckRoute() {
        return fireTruckRoute;
    }

    public void setFireTruckRoute(String fireTruckRoute) {
        this.fireTruckRoute = fireTruckRoute;
    }

    public String getPicture1() {
        return picture1;
    }

    public void setPicture1(String picture1) {
        this.picture1 = picture1;
    }

    public String getPicture2() {
        return picture2;
    }

    public void setPicture2(String picture2) {
        this.picture2 = picture2;
    }

    public String getPicture3() {
        return picture3;
    }

    public void setPicture3(String picture3) {
        this.picture3 = picture3;
    }

    public String getPicture4() {
        return picture4;
    }

    public void setPicture4(String picture4) {
        this.picture4 = picture4;
    }

    public String getBatchNo() {
        return batchNo;
    }

    public void setBatchNo(String batchNo) {
        this.batchNo = batchNo;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getFireEquipmentName() {
        return fireEquipmentName;
    }

    public void setFireEquipmentName(String fireEquipmentName) {
        this.fireEquipmentName = fireEquipmentName;
    }

    public String getFireEquipmentId() {
        return fireEquipmentId;
    }

    public void setFireEquipmentId(String fireEquipmentId) {
        this.fireEquipmentId = fireEquipmentId;
    }

    public Integer getLayer() {
        return layer;
    }

    public void setLayer(Integer layer) {
        this.layer = layer;
    }

    public Integer getFireEquipmentLayer() {
        return fireEquipmentLayer;
    }

    public void setFireEquipmentLayer(Integer fireEquipmentLayer) {
        this.fireEquipmentLayer = fireEquipmentLayer;
    }

    public String getFireEquipmentPosition() {
        return fireEquipmentPosition;
    }

    public void setFireEquipmentPosition(String fireEquipmentPosition) {
        this.fireEquipmentPosition = fireEquipmentPosition;
    }

    public String getEquipmentId() {
        return equipmentId;
    }

    public void setEquipmentId(String equipmentId) {
        this.equipmentId = equipmentId;
    }

    public String getEquipmentName() {
        return equipmentName;
    }

    public void setEquipmentName(String equipmentName) {
        this.equipmentName = equipmentName;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getAdminName() {
        return adminName;
    }

    public void setAdminName(String adminName) {
        this.adminName = adminName;
    }

    public String getCameraCodes() {
        return cameraCodes;
    }

    public void setCameraCodes(String cameraCodes) {
        this.cameraCodes = cameraCodes;
    }

    public String getCameraIds() {
        return cameraIds;
    }

    public void setCameraIds(String cameraIds) {
        this.cameraIds = cameraIds;
    }

    public Integer getFireCount() {
        return fireCount;
    }

    public void setFireCount(Integer fireCount) {
        this.fireCount = fireCount;
    }

    public String getConfirm() {
        return confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }
}
