package com.yeejoin.amos.fas.dao.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 安全指数日流水
 */
@Entity
@Table(name="f_safety_index_change_log")
@NamedQuery(name="SafetyIndexChangeLog.findAll", query="SELECT s FROM SafetyIndexChangeLog s")
public class SafetyIndexChangeLog extends BasicEntity{

	/**
	 * 安全指数
	 */
	@Column(name="safety_index")
	private BigDecimal safetyIndex;
	/**
	 * 流水日期
	 */
	@Column(name="collect_date")
	private Date collectDate;
	/**
	 * 机构
	 */
	@Column(name="org_code")
	private String orgCode;
	/**
	 * 备注
	 */
	@Column(name="remark")
	private String remark;

	public BigDecimal getSafetyIndex() {
		return safetyIndex;
	}
	public void setSafetyIndex(BigDecimal safetyIndex) {
		this.safetyIndex = safetyIndex;
	}
	public Date getCollectDate() {
		return collectDate;
	}
	public void setCollectDate(Date collectDate) {
		this.collectDate = collectDate;
	}
	public String getOrgCode() {
		return orgCode;
	}
	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}
	public String getRemark() {
		return remark;
	}
	public void setRemark(String remark) {
		this.remark = remark;
	}
}