package com.yeejoin.amos.knowledgebase.face.model;

import org.typroject.tyboot.core.rdbms.model.BaseModel;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 标签库
 * </p>
 *
 * @author 子杨
 * @since 2020-08-05
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class KnowledgeTagModel extends BaseModel {

    /**
     * 标签名称
     */
    private String tagName;
    /**
     * 标签编码
     */
    private String tagCode;
    /**
     * 标签分类：文本标签，值标签，
     */
    private String tagType;
    /**
     * 标签状态：启用，禁用
     */
    private String tagStatus;
    /**
     * 标签备注
     */
    private String tagRemark;
    /**
     * 机构编号
     */
    private String agencyCode;

    /**
     * 被引用数量（所有文档）
     */
    private Integer referenceNumber;

    /**
     * 动态值
     */
    private Map<String, Object> tagValues;

    /**
     * 标签分类
     */
    private List<Long> tagGroup;

    /**
     * 创建人姓名
     */
    private String creator;
}
