package com.yeejoin.amos.boot.module.ccs.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.ccs.api.dto.FireFightingSystemDto;
import com.yeejoin.amos.boot.module.ccs.biz.service.impl.FireFightingSystemServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 消防系统信息
 *
 * @author system_generator
 * @date 2021-11-09
 */
@RestController
@Api(tags = "消防系统信息Api")
@RequestMapping(value = "/fire-fighting-system")
public class FireFightingSystemController extends BaseController {

    @Autowired
    FireFightingSystemServiceImpl fireFightingSystemServiceImpl;

    /**
     * 新增消防系统信息
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增消防系统信息", notes = "新增消防系统信息")
	public ResponseModel<FireFightingSystemDto> save(@RequestBody FireFightingSystemDto model) {
	    model = fireFightingSystemServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除消防系统信息", notes = "根据sequenceNbr删除消防系统信息")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(fireFightingSystemServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个消防系统信息",  notes = "根据sequenceNbr查询单个消防系统信息")
	public ResponseModel<FireFightingSystemDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(fireFightingSystemServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "消防系统信息分页查询",  notes = "消防系统信息分页查询")
	public ResponseModel<Page<FireFightingSystemDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<FireFightingSystemDto> page = new Page<FireFightingSystemDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(fireFightingSystemServiceImpl.queryForFireFightingSystemPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "消防系统信息列表全部数据查询",   notes = "消防系统信息列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<FireFightingSystemDto>> selectForList() {
	    return ResponseHelper.buildResponse(fireFightingSystemServiceImpl.queryForFireFightingSystemList());
	}
}
