package com.yeejoin.equipmanage.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.yeejoin.equipmanage.utils.ExplicitConstraint;
import com.yeejoin.equipmanage.utils.RoleNameExplicitConstraint;

import java.io.Serializable;

/**
 * @author litw
 * @date 2021-10-08.
 */
public class EquipmentDetailExcelTemplateDto implements Serializable {

    @ExcelProperty(value = "器材名称", index = 0)
    // @Excel(name = "器材名称", width = 30, orderNum = "1")
    private String name;

    @ExcelProperty(value = "器材编码（从装备定义中获取）", index = 1)
    //@Excel(name = "器材编码（从装备定义中获取）", width = 30, orderNum = "2")
    private String code;

    @ExcelProperty(value = "规格型号", index = 2)
    //@Excel(name = "规格型号", width = 30, orderNum = "3")
    private String standard;

    @ExcelProperty(value = "品牌", index = 3)
    //@Excel(name = "品牌", width = 30, orderNum = "4")
    private String brand;

    @ExcelProperty(value = "生产厂家名称", index = 4)
    //@Excel(name = "生产厂家名称", width = 30, orderNum = "5")
    private String manufacturerName;

    @ExcelProperty(value = "设备编码", index = 5)
    //@Excel(name = "设备编码", width = 30, orderNum = "6")
    private String systemCode;

    @ExcelProperty(value = "物联编码", index = 6)
    //@Excel(name = "物联编码", width = 30, orderNum = "7")
    private String iotCode;

    @ExcelProperty(value = "存放位置（货位编码）", index = 7)
    //@Excel(name = "存放位置（货位编码）", width = 30, orderNum = "8")
    private String warehouseStructCode;

    @ExcelProperty(value = "位置信息", index = 8)
    //@Excel(name = "位置信息", width = 30, orderNum = "9")
    private String description;

    @ExcelProperty(value = "消防系统编码", index = 9)
    //@Excel(name = "消防系统编码", width = 30, orderNum = "10")
    private String fightingSysCodes;

    @ExplicitConstraint(indexNum = 10, sourceClass = RoleNameExplicitConstraint.class,method="getFireTeam") //动态下拉内容
    @ExcelProperty(value = "所属队伍", index = 10)
    //@Excel(name = "所属队伍",width = 30,orderNum = "11")
    private String fireTeam;

    //动态下拉内容
    @ExplicitConstraint(indexNum = 11, sourceClass = RoleNameExplicitConstraint.class,method="getCompany") //动态下拉内容
    @ExcelProperty(value = "所属单位", index = 11)
    //@Excel(name = "所属单位",width = 30,orderNum = "12")
    private String companyName;
}
