package com.yeejoin.equipmanage.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.equipmanage.common.entity.EquipmentCategory;
import com.yeejoin.equipmanage.common.entity.vo.EquipTypeAmountVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 装备分类 Mapper 接口
 *
 * @author wujiang
 * @date 2020-07-07
 */
public interface EquipmentCategoryMapper extends BaseMapper<EquipmentCategory> {
	
	List<Map<String, Object>> getEquipCategoryListByParentId( @Param("parentId")Long parentId);
	
	/**
	 * 获取层级深度
	 * @param parentId
	 * @return
	 */
	int getEquipCategoryLevelByParentId( @Param("parentId")Long parentId);
	
	/**
	 * 根据父类id获取生成分类的编码
	 * @param parentId
	 * @return
	 */
	List<Map<String, Object>> getEquipCategoryCodeListByParentId( @Param("parentId")Long parentId);
	
	List<Map<String, Object>> getEquipCategoryListcount( @Param("ids") Map<String, Object> ids);
	List<Map<String, Object>> getEquipmentCount( @Param("date") Map<String, Object> date);
	List<Map<String, Object>> getDetailed( @Param("date") Map<String, Object>  date);

	/**
	 * 首页统计9大类数据
	 * @param industryCode 行业编码
	 * @param codeHead 编码第一位
	 * @param orgCode 单位编码
	 * @return
	 */
	int selectCategoryAmount(String industryCode, String codeHead,String orgCode);
	List<EquipTypeAmountVO> CategoryAmountList(IPage<EquipmentCategory> page, int hierarchy, String codeHead, String orgCode, String equipmentName);


	int  checkFather( String id);
	int  islvlOne( String id);
	int checkUsed( String id );

	List<EquipmentCategory> getEquipmentCategoryList(Integer head);
	List<EquipmentCategory> getEquipmentCategoryCarList();
	List<EquipmentCategory> getEquipmentCategoryEquipmentList();

	/**
	 * 根据设备id获取设备对应分类定义
	 *
	 * @param eqpDetailId
	 * @return
	 */
    EquipmentCategory getByEqpDetailId(@Param(value = "eqpDetailId") Long eqpDetailId);

	/**
	 * 根据分类定义id获取对应所有子分类id
	 *
	 * @param categoryId 分类定义id
	 * @return 返回对应所有子分类id
	 */
	List<Long> getAllChildCategoryIdList(@Param(value = "categoryId") Long categoryId);

	List<EquipmentCategory> getColaEquipmentCategoryList(@Param(value = "head") Integer head, @Param(value = "industryCode") String industryCode);
}
