package com.yeejoin.equipmanage.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.equipmanage.common.entity.Equipment;
import com.yeejoin.equipmanage.common.entity.vo.*;
import com.yeejoin.equipmanage.common.vo.EquipmentVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * Mapper 接口
 *
 * @author wujiang
 * @date 2020-07-07
 */
public interface EquipmentMapper extends BaseMapper<Equipment> {

    List<Map<String, Object>> getEquipmentList(@Param("whereConditionStr") String whereConditionStr, @Param("isIot") String isIot, @Param("start") Long start,
                                               @Param("page") Long page);

    int getEquipmentCount(@Param("whereConditionStr") String whereConditionStr);

    EquipmentBaseAppVO getEquipmentAppMessage(String qrCode);

    List<ImportantEquipmentVO> getImportantEquipmentList(@Param("ids") List<Long> ids);

    List<PreplanPictureVO> getPreplanPicture(Long id);

    List<DownloadEquipmentDataVO> getDownloadEquipmentData();

    List<EquipmentVo> getEquipListBySpecific();

    /**
     * 查询指定设备的性能指标
     *
     * @param equipmentSpecificId 设备实例id
     * @return List<EquipmentIndexVO>
     */
    List<EquipmentIndexVO> querySpecificIndexList(Long equipmentSpecificId);

    List<Map<String, Object>> listLikePage(@Param("code") String code);
    /**
     * 
     * <pre>
     * 根据装备id查询所属装备定义
     * </pre>
     *
     * @param equipmentSpecificId
     * @return
     */
    EquipmentVo getEquipBySpecific(@Param("equipmentSpecificId") Long equipmentSpecificId);
}
