package com.yeejoin.equipmanage.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.equipmanage.common.entity.AnalysisReportLog;
import com.yeejoin.equipmanage.common.enums.AnalysisReportEnum;

import java.util.Date;

/**
 * 报告流水表 服务类
 *
 * @author duanwei
 * @date 2021-05-26
 */
public interface IAnalysisReportLogService extends IService<AnalysisReportLog> {

    /**
     * 分页查询
     */
    IPage<AnalysisReportLog>  listPage (Page page, AnalysisReportLog analysisReportLog);

     /** 报表生成
     * @param reportEnum 报告类型
     * @param beginDate 开始日期
     * @param endDate 结束日期
     */
    void generateReport(AnalysisReportEnum reportEnum, Date beginDate, Date endDate);
}
