package com.yeejoin.equipmanage.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.equipmanage.common.dto.AreaDto;
import com.yeejoin.equipmanage.common.entity.Area;
import com.yeejoin.equipmanage.common.vo.AreaResquest;
import com.yeejoin.equipmanage.common.vo.AreaTreeVo;

import java.util.List;
import java.util.Map;

/**
 * 区域 服务类
 *
 * @author duanwei
 * @date 2021-04-27
 */
public interface IAreaService extends IService<Area> {
    /**
     * 获取区域树
     * @return
     */
    List<AreaTreeVo> getAreaTreeVo();

    List<AreaTreeVo> getAreaTreeVoById(long id);
    /**
     * 根据条件分页
     * @param page
     * @param area
     * @return
     */
    IPage<AreaResquest> areaList(Page page, Area area);

    Object saveArea(AreaResquest areaResquest);

    Object updateArea(AreaResquest areaResquest);

    int deleteArea(Long instanceId);

    Map<String,Object> getById(Long instanceId);

    /**
     * 获取指定层级区域树，起步2级树
     * @param tier
     * @return
     */
    List<AreaDto> getAreaTierTree(Integer tier);
}
