package com.yeejoin.equipmanage.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.equipmanage.common.entity.EquipmentCategory;
import com.yeejoin.equipmanage.common.entity.vo.EquipTypeAmountVO;
import com.yeejoin.equipmanage.common.entity.vo.EquipmentCategoryCountVO;
import com.yeejoin.equipmanage.common.entity.vo.EquipmentCategoryTypeTreeVO;
import com.yeejoin.equipmanage.common.vo.IndustryVo;

import java.util.List;

/**
 * 装备分类 服务类
 *
 * @author wujiang
 * @date 2020-07-07
 */
public interface IEquipmentCategoryService extends IService<EquipmentCategory> {
	/**
	 * 新增装备分类
	 * @param equipmentCategory
	 * @return
	 */
	EquipmentCategory saveEquipmentCategory(EquipmentCategory equipmentCategory);

	/**
	 * 获取分类树
	 * @param type
	 * @return
	 */
	List<EquipmentCategory> tree(String type);

	/**
	 * 获取一级父类
	 * @return
	 */
	List<EquipmentCategoryCountVO> typeCount();

	List<EquipmentCategoryTypeTreeVO> getTypeTree(Long id);

	List<EquipTypeAmountVO> CategoryAmountList(IPage<EquipmentCategory> page,int hierarchy, String codeHead, String equipmentName);

	String  checkFather( List<String> ids);

	int checkUsed( List<String> ids);

	List<EquipmentCategory> getEquipmentCategoryList(Integer head);

	/**
	 * 根据分类定义id获取对应所有子分类id
	 *
	 * @param categoryId 分类定义id
	 * @return 返回对应所有子分类id
	 */
	List<Long> getAllChildCategoryIdList(Long categoryId);

	List<EquipmentCategory> getColaEquipmentCategoryList(Integer head, String industryCode);

    List<IndustryVo> getTreeListAll();

	List<EquipmentCategory> getIndustryTreeList(String code);

	List<EquipmentCategory> getEquipmentCategoryEquipmentList();

	List<EquipmentCategory> getEquipmentCategoryCarList();
}
