
package com.yeejoin.equipmanage.service.impl;

import com.google.common.collect.Lists;
import com.yeejoin.equipmanage.common.dto.FireRiskSourceDto;
import com.yeejoin.equipmanage.common.utils.TreeNodeUtil;
import com.yeejoin.equipmanage.mapper.RiskSourceMapper;
import com.yeejoin.equipmanage.service.IRiskSourceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;


@Service("riskSourceService")
public class RiskSourceServiceImpl implements IRiskSourceService {

    @Autowired
    private RiskSourceMapper riskSourceMapper;

    @Override
    @Transactional
    public List<FireRiskSourceDto> getFiskSourceTierTree(Integer tier, Boolean isRegion) {
        List<FireRiskSourceDto> list = null;
        if (isRegion != null) {
            list = riskSourceMapper.findByIsRegion(isRegion);
        } else {
            list = riskSourceMapper.findAll();
        }
        if (!CollectionUtils.isEmpty(list)) {
            if (tier != null) {
                return TreeNodeUtil.assembleTree(list, tier);
            } else {
                return TreeNodeUtil.assembleTree(list);
            }
        }
        return Lists.newArrayList();
    }
}

