package com.yeejoin.equipmanage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.equipmanage.common.entity.VisitorRecording;
import com.yeejoin.equipmanage.mapper.VisitorRecordingMapper;
import com.yeejoin.equipmanage.service.IVisitorRecordingService;
import com.yeejoin.equipmanage.utils.ExcelUtil;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import javax.servlet.http.HttpServletResponse;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;

/**
 * <h1><h1>
 *
 * @author tiantao
 * @date 2021/3/1 11:56
 */
@Service
public class VisitorRecordingServiceImpl extends ServiceImpl<VisitorRecordingMapper, VisitorRecording> implements IVisitorRecordingService {

    @Override
    public Page listByParams(String visitorName, String phoneNumber, String hostName, String visitorCompany,
                             Long targetDepartmentId, Page page) {
        QueryWrapper<VisitorRecording> wrapper = getVisitorRecordingQueryWrapper(visitorName, phoneNumber, hostName, visitorCompany, targetDepartmentId);
        IPage iPage = this.page(page, wrapper);
        return (Page) iPage;
    }

    /**
     * 根据查询条件生成查询QueryWrapper
     *
     * @param visitorName        访客姓名
     * @param phoneNumber        电话号码
     * @param hostName           接待人
     * @param visitorCompany     访客单位
     * @param targetDepartmentId 被防部门id
     * @return
     */
    private QueryWrapper<VisitorRecording> getVisitorRecordingQueryWrapper(String visitorName, String phoneNumber, String hostName, String visitorCompany, Long targetDepartmentId) {
        QueryWrapper<VisitorRecording> wrapper = new QueryWrapper<>();
        if (!ValidationUtil.isEmpty(visitorName)) {
            wrapper.like("visitor_name", visitorName);
        }
        if (!ValidationUtil.isEmpty(phoneNumber)) {
            wrapper.like("phone_number", phoneNumber);
        }
        if (!ValidationUtil.isEmpty(hostName)) {
            wrapper.like("host_name", hostName);
        }
        if (!ValidationUtil.isEmpty(visitorCompany)) {
            wrapper.like("visitor_company", visitorCompany);
        }
        if (!ValidationUtil.isEmpty(targetDepartmentId)) {
            wrapper.eq("target_department_id", targetDepartmentId);
        }
        return wrapper;
    }

    @Override
    public Boolean deleteByIds(String ids) {
        String[] idStr = ids.split(",");
        return this.removeByIds(Arrays.asList(idStr));
    }

    @Override
    public void exportByParams(HttpServletResponse response, List<Long> ids, String visitorName, String phoneNumber, String hostName, String visitorCompany,
                               Long targetDepartmentId) {
        List<VisitorRecording> recordingList;
        if (!ValidationUtil.isEmpty(ids)) {
            recordingList = this.baseMapper.selectBatchIds(ids);
        } else if (ValidationUtil.isEmpty(visitorName) && ValidationUtil.isEmpty(visitorCompany) && ValidationUtil.isEmpty(phoneNumber) && ValidationUtil.isEmpty(hostName
        ) && ValidationUtil.isEmpty(targetDepartmentId)) {
            recordingList = this.list();
        } else {
            recordingList = this.baseMapper.selectList(getVisitorRecordingQueryWrapper(visitorName, phoneNumber,
                    hostName, visitorCompany, targetDepartmentId));
        }
        ExcelUtil.createTemplate(response, "访客记录", "访客记录", recordingList, VisitorRecording.class, null, null, null, false);
    }
}
