package com.yeejoin.equipmanage.utils;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.equipmanage.common.datasync.entity.FireFightingSystem;
import com.yeejoin.equipmanage.common.entity.FireFightingSystemEntity;
import com.yeejoin.equipmanage.common.utils.RedisUtil;
import com.yeejoin.equipmanage.mapper.FireFightingSystemMapper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @ProjectName: EquipManageRoot
 * @Package: com.yeejoin.equipmanage.utils
 * @ClassName: RelationRedisUtil
 * @Author: Jianqiang Gao
 * @Description: 关联Redis工具类
 * @Date: 2021/11/18 17:11
 * @Version: 1.0
 */
@Component
@EnableAsync
public class RelationRedisUtil {

    @Autowired
    private RedisUtil redisUtil;

    @Autowired
    private FireFightingSystemMapper fireFightingSystemMapper;

    @Async
    public Boolean delSysRedisKey(String systemId) {
        if (StringUtils.isNotBlank(systemId)) {
            QueryWrapper<FireFightingSystemEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.in("id", systemId.split(","));
             List<FireFightingSystemEntity> list = fireFightingSystemMapper.selectList(queryWrapper);
             if (CollectionUtils.isNotEmpty(list)) {
                 List<String> collect = list.stream().map(FireFightingSystemEntity::getSystemTypeCode).collect(Collectors.toList());
                 if (CollectionUtils.isNotEmpty(collect)) {
                     for (String key : collect) {
                         redisUtil.del(key);
                     }
                     return Boolean.TRUE;
                 }
             }
        }
        return Boolean.FALSE;
    }
}