package com.yeejoin.amos.fas.business.dao.repository;

import com.yeejoin.amos.fas.dao.entity.PreplanPicture;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Repository("iPreplanPictureDao")
public interface IPreplanPictureDao extends BaseDao<PreplanPicture, Long> {
    @Query(value = "select  * from f_preplan_picture where equipment_id=?1 and type = ?2", nativeQuery = true)
    PreplanPicture selectOne(Long id, int type);

    @Transactional
    @Modifying
    @Query(value = "delete  from f_preplan_picture where equipment_id=?1", nativeQuery = true)
    int deletebyEqId(Long id);

    List<PreplanPicture> findByEquipmentId(Long equipmentId);


}
