package com.yeejoin.amos.supervision.business.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.yeejoin.amos.boot.biz.common.excel.CommonExplicitConstraint;
import com.yeejoin.amos.boot.biz.common.excel.ExplicitConstraint;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author DELL
 */
@Data
public class HiddenDangerTemplateDto implements Serializable {

    /**
     * 隐患名称
     */
    @ExcelProperty(value = "隐患名称", index = 0)
    private String dangerName;

    /**
     * 检查项名称
     */
    @ExcelIgnore
    @ExcelProperty(value = "检查项", index = 1)
    private String inputItemName;

    /**
     * 隐患级别
     */
    @ExcelProperty(value = "隐患级别", index = 1)
    @ExplicitConstraint(indexNum = 1, sourceClass = CommonExplicitConstraint.class, method = "getDangerLevelData")
    private String dangerLevelName;

    /**
     * 治理方式
     */
    @ExcelProperty(value = "治理方式", index = 2)
    @ExplicitConstraint(indexNum = 2, sourceClass = CommonExplicitConstraint.class, method = "getReformTypeData")
    private String reformTypeName;

    /**
     * 整改期限
     */
    @DateTimeFormat(value = "yyyy-MM-dd HH:mm:ss")
    @ExcelProperty(value = "整改期限", index = 3)
    private Date reformLimitDate;

    /**
     * 检查时间
     */
    @ExcelIgnore
    @ExcelProperty(value = "检查时间", index = 5)
    private String checkTime;

    /**
     * 2470	49	2052
     * 检查人员名称
     */
    @ExcelIgnore
    @ExcelProperty(value = "检查人员名称", index = 6)
    private String checkUserName;

    /**
     * 责任单位
     */
    @ExcelProperty(value = "责任单位", index = 4)
    @ExplicitConstraint(indexNum = 4, sourceClass = CommonExplicitConstraint.class, method = "getCompanyData")
    private String pointName;

    /**
     * 状态
     */
    @ExcelIgnore
    @ExcelProperty(value = "状态", index = 8)
    private String dangerStateName;

    /**
     * 隐患来源
     */
    @ExcelIgnore
    @ExcelProperty(value = "隐患来源", index = 9)
    private String dangerTypeName;
}
