# 单元格

## 基本单元格

单元格是Luckysheet中最基本的单位，每个单元格都会保存为一个对象，一个工作表的数据则会保存为一个由单元格对象组成的二维数组，并存入当前工作表的 `luckysheetfile[i].data`中。

单元格对象包含以下单元格属性

<table>
    <tr>
        <td>属性值</td>
        <td>全称</td>
        <td><div style="width:100px">说明</div></td>
        <td>值示例</td>
        <td>Aspose方法或者属性</td>
    </tr>
    <tr>
        <td>ct</td>
        <td>celltype</td>
        <td>单元格值格式：文本、时间等</td>
        <td><code>{
            "fa": "General",
            "t": "g"
        }</code><a href="#cellStyle">单元格值格式</a></td>
        <td></td>
    </tr>
    <tr>
        <td>bg</td>
        <td>background</td>
        <td>背景颜色</td>
        <td>#fff000</td>
        <td>setBackgroundColor</td>
    </tr>
    <tr>
        <td>ff</td>
        <td>fontfamily</td>
        <td>字体</td>
        <td>0 Times New Roman、 1 Arial、2 Tahoma 、3 Verdana、4 微软雅黑、5 宋体（Song）、6 黑体（ST Heiti）、7 楷体（ST Kaiti）、 8 仿宋（ST FangSong）、9 新宋体（ST Song）、10 华文新魏、11 华文行楷、12 华文隶书</td>
        <td>Style.Font object's Name property.</td>
    </tr>
    <tr>
        <td>fc</td>
        <td>fontcolor</td>
        <td>字体颜色</td>
        <td>#fff000</td>
        <td>Style.Font object's Color property</td>
    </tr>
    <tr>
        <td>bl</td>
        <td>bold</td>
        <td>粗体</td>
        <td>0 常规 、 1加粗</td>
        <td>Style.Font object's IsBold property to true.</td>
    </tr>
    <tr>
        <td>it</td>
        <td>italic</td>
        <td>斜体</td>
        <td>0 常规 、 1 斜体</td>
        <td></td>
    </tr>
    <tr>
        <td>fs</td>
        <td>fontsize</td>
        <td>字体大小</td>
        <td>14</td>
        <td>Style.Font object's Size property.</td>
    </tr>
    <tr>
        <td>cl</td>
        <td>cancelline</td>
        <td>删除线</td>
        <td>0 常规 、 1 删除线</td>
        <td>Style.Font object's Underline property</td>
    </tr>
    <tr>
        <td>un</td>
        <td>underline</td>
        <td>下划线</td>
        <td>0 无 、 1 有</td>
        <td></td>
    </tr>
    <tr>
        <td>vt</td>
        <td>verticaltype</td>
        <td>垂直对齐</td>
        <td>0 中间、1 上、2下</td>
        <td>setVerticalAlignment</td>
    </tr>
    <tr>
        <td>ht</td>
        <td>horizontaltype</td>
        <td>水平对齐</td>
        <td>0 居中、1 左、2右</td>
        <td>setHorizontalAlignment</td>
    </tr>
    <tr>
        <td>mc</td>
        <td>mergecell</td>
        <td>合并单元格</td>
        <td>主单元格{ r:0, c:0, rs: 2, cs:2 }，辅单元格{ r:0, c:0 }，<a href="#mergeCell">合并单元格案例</a></td>
        <td>Merge</td>
    </tr>
    <tr>
        <td>tr</td>
        <td>textrotate</td>
        <td>竖排文字</td>
        <td>3</td>
        <td>setRotationAngle</td>
    </tr>
    <tr>
        <td>rt</td>
        <td>rotatetext</td>
        <td>文字旋转角度</td>
        <td>介于0~180之间的整数，包含0和180</td>
        <td>setRotationAngle</td>
    </tr>
    <tr>
        <td>tb</td>
        <td>textbeak</td>
        <td>文本换行</td>
        <td>0 截断、1溢出、2 自动换行</td>
        <td>2：setTextWrapped <br> 0和1：IsTextWrapped =&nbsp;true</td>
    </tr>
    <tr>
        <td>v</td>
        <td>value</td>
        <td>原始值</td>
        <td></td>
        <td></td>
    </tr>
    <tr>
        <td>m</td>
        <td>monitor</td>
        <td>显示值</td>
        <td></td>
        <td></td>
    </tr>
    <tr>
        <td>f</td>
        <td>function</td>
        <td>公式</td>
        <td></td>
        <td>setFormula <br> setArrayFormula <br> workbook.calculateFormula();</td>
    </tr>
    <tr>
        <td>ps</td>
        <td>comment</td>
        <td>批注</td>
        <td>
        <code>
        {<br>
            height: 140,//批注框高度 <br>
            width: 73,//批注框宽度 <br>
            left: 75,//批注框距离左边工作表边缘位置 <br>
            top: 22,//批注框距离上边工作表边缘位置 <br>
            isshow: true,//是否显示批注<br>
            value: "jhbk"//批注内容<br>
        }
        </code>
        </td>
        <td></td>
    </tr>
</table>

一个规范的单元格对象如下：

```json
{
    "ct": { //单元格值格式
        "fa": "General",  //格式名称为自动格式
        "t": "n" //格式类型为数字类型
    },
    "v": 233, //内容的原始值为 233
    "m": 233, //内容的显示值为 233
    "bg": "#f6b26b", //背景为 "#f6b26b"
    "ff": 1, // 字体为 "Arial"
    "fc": "#990000", //字体颜色为 "#990000"
    "bl": 1, //字体加粗
    "it": 1, //字体斜体
    "fs": 9, //字体大小为 9px
    "cl": 1, //启用删除线
    "ht": 0, //水平居中
    "vt": 0, //垂直居中
    "tr": 2, //文字旋转 -45°
    "tb": 2, //文本自动换行
    "ps": { //批注
        "left": 92, //批注框左边距
        "top": 10, //批注框上边距
        "width": 91, //批注框宽度
        "height": 48, //批注框高度
        "value": "I am a comment", //批注内容
        "isshow": true //批注框为显示状态
    },
    "f": "=SUM(233)" //单元格是一个求和公式
}
```

### 为什么会有原始值 `v` 和显示值 `m` 的区分？

Luckysheet在存储数字类型的内容时，支持多种格式转换，所以需要保留原始值来做更多处理，比如同样一个数字`1`，设置成百分比格式就是`"100%"`，设置成两位小数数字就是`"1.00"`，

还有一个原因是日期和时间格式的内容原始值会存储为一个数字，默认情况下，Luckysheet把`1900-1-1 0:00:00`存储为`1`，把`1900-1-1 0:00:00`以后的每一个时刻存储为该时刻与`1900-1-1 0:00:00`这个时刻的差值（以天为单位）。比如`44127`就表示`2020-10-23`这一天。

以下是特殊格式的例子：

百分比 `100%`
```json
{
    "ct": {
        "fa": "0%",
        "t": "n"
    },
    "v": 1,
    "m": "100%"
}
```

小数 `1.00`
```json
{
    "ct": {
        "fa": "##0.00",
        "t": "n"
    },
    "v": 1,
    "m": "1.00"
}
```

日期 `2020-10-23`
```json
{
    "ct": {
        "fa": "yyyy-MM-dd",
        "t": "d"
    },
    "v": 44127,
    "m": "2020-10-23"
}
```

## 合并单元格<div id='mergeCell'></div>

设置一个合并单元格，需要处理两个地方，一是单元格对象中设置`mc`属性，二是在`config`中设置`merge`。

比如，将"A1:B2"单元格合并为一个单元格

- 第一步：先设置四个单元格的参数
    ```json
    [
        [{
            "m": "merge cell",
            "ct": {
                "fa": "General",
                "t": "g"
            },
            "v": "merge cell",
            "mc": { //合并单元格必备属性
                "r": 0, //主单元格的行号
                "c": 0, //主单元格的列号
                "rs": 2, //合并单元格占的行数
                "cs": 2 //合并单元格占的列数
            }
        }, {
            "mc": {
                "r": 0, //主单元格的行号
                "c": 0, //主单元格的列号
            }
        }],
        [{
            "mc": {
                "r": 0, //主单元格的行号
                "c": 0, //主单元格的列号
            }
        }, {
            "mc": {
                "r": 0, //主单元格的行号
                "c": 0, //主单元格的列号
            }
        }]
    ]
    ```

    合并单元格的关键属性是`mc`，主单元格是选区范围中左上角的单元格，包含4个属性 r/c/rs/cs ,分别表示 row/column/rowspan/columnspan，在这里，就表示从主单元格A1（row 0 column 0）开始到右边2行下方2列的单元格进行合并，选区范围中的其他单元格则只需要设置主单元格位置即可。

- 第二步：再设置`config.merge`
    ```json
    {
        "0_0": {
            "r": 0,
            "c": 0,
            "rs": 2,
            "cs": 2
        }
    }
    ```
    对象中的key为 `r + '_' + c` 的拼接值，value同主单元格的`mc`设置: r:行数，c:列数，rs：合并的行数，cs:合并的列数

> merge 详细参考：[表格数据config](/zh/guide/data.html#config)

## 含边框单元格

单元格的边框设置与合并单元格类似，需要在`config`中设置`borderInfo`，区别在于不需要设置单元格对象。
加入

比如，将"A1"单元格设置一个黑色细实线的全部边框

设置`config.borderInfo`为
```json
{
    "rangeType": "range",
    "borderType": "border-all",
    "color": "#000",
    "style": "1",
    "range": [
        {
            "row": [ 0, 0 ],
            "column": [0, 0]
        }
    ]
}
```
而其单元格对象不需要增加设置，如下只是基础的内容和格式设置
```json
[
    [
        {
            "m": "borderCell",
            "ct": {
                "fa": "General",
                "t": "g"
            },
            "v": "borderCell"
        }
    ]
]
```

> borderInfo 详细参考：[config.borderInfo](/zh/guide/sheet.html#config-borderinfo)

## 简化的单元格数据

特别强调的是，表格初始化的时候，采用的是`r/c/v`对象组成的一维数组格式，其中`v`的值一般是设置为单元格对象。为了节约后台的存储空间，`v`的值支持简写格式，直接写为一个字符串即可，渲染进Luckysheet后自动识别为自动格式即，`"ct": { "fa": "General", "t": "n" }`

以下为初始化3个单元格信息，第三个单元格即为简写格式：

```json
[
    {
        "r": 0,
        "c": 0,
        "v": {
            "f": "=MAX(A7:A9)",
            "ct": {
                "fa": "General",
                "t": "n"
            },
            "v": 100,
            "m": "100"
        }
    },
    {
        "r": 0,
        "c": 1,
        "v": {
            "f": "=SUM(A2)",
            "bg": "#fff000",
            "v": 12,
            "m": "12"
        }
    },
    {
        "r": 0,
        "c": 2,
        "v": "value 2"
    }
]
```
> 了解 [celldata的使用](/zh/guide/data.html#celldata)

## 单元格值格式<div id='cellStyle'></div>

值格式即为单元格对象中 `ct` 的设置，

如下为自动格式的单元格

```json
{
    "ct": {
        "fa": "General",
        "t": "g"
    },
    "m": "2424",
    "v": 2424
}
```

|参数|说明|值|
| ------------ | ------------ | ------------ |
|fa|Format格式的定义串| 如"General"|
|t|Type类型|如"g"|


### 可选择的设置如下

| 格式 | ct.fa  |  ct.t   | m 值示例 |备注 |
|----------|----------|-------------------------|------------------------- |------------------------- |
| 自动        | General    |     g/n     | Luckysheet |自动格式，也是默认的格式；单元格内容为数字时，`m`的值为`'n'`|
| 纯文本      | @    | s                         | Luckysheet ||
| <br><br><br>**数字格式** | | | | |
| 整数      | 0 |     n                     | 1235 | 0位小数 ||
| 数字一位小数        | 0.0 | n  | 1234.6 | 点后面0的个数就代表小数位数,如果原始数字位数大,设置位数小时会做四舍五入 |
| 数字两位小数      | 0.00   | n  | 1234.56 ||
| 百分比整数      | 0%    | n          | 123456% |也支持 #0% 的用法|
| 百分比      | 0.00%     | n          | 123456.00% |也支持 #0.00% 的用法,点后面0的个数就代表小数位数|
| 科学计数    | 0.00E+00    | n        | 1.23E+03 ||
| 科学计数    | ##0.0E+0    | n        | 1.2E+3 ||
| 分数    | # ?/?    | n        | 1234 5/9 ||
| 分数    | # ??/??    | n        | 1234 14/25 ||
| 万元        | w   | n                         |12万3456||
| 万元2位小数  | w0.00   | n                    |12万3456.00|| 
| 会计        | ¥(0.00)   | n                   ||
| 更多数字格式    | #,##0   | n  | 1,235 ||
| 更多数字格式    | #,##0.00   | n  | 1,234.56 ||
| 更多数字格式    | `#,##0_);(#,##0)`   | n  | 1,235 ||
| 更多数字格式    | `#,##0_);[Red](#,##0)`   | n  | 1,235 ||
| 更多数字格式    | `#,##0.00_);(#,##0.00)`   | n  | 1,234.56 ||
| 更多数字格式    | `#,##0.00_);[Red](#,##0.00)`   | n  | 1,234.56 ||
| 更多数字格式    | $#,##0_);($#,##0)   | n  | $1,235 ||
| 更多数字格式    | `$#,##0_);[Red]($#,##0)`   | n  | $1,235 ||
| 更多数字格式    | $#,##0.00_);($#,##0.00)   | n  | $1,234.56 ||
| 更多数字格式    | `$#,##0.00_);[Red]($#,##0.00)`   | n  | $1,234.56 ||
| 更多数字格式    | _($* #,##0_);_(...($* "-"_);_(@_)   | n  | $ 1,235 ||
| 更多数字格式    | _(* #,##0_);_(*..._(* "-"_);_(@_)   | n  | 1,235 ||
| 更多数字格式    | _($* #,##0.00_);_(...($* "-"_);_(@_)   | n  | $ 1,234.56 ||
| 更多数字格式    | _(* #,##0.00_);...* "-"??_);_(@_)   | n  | 1,234.56 ||
| <br><br><br>**时间日期格式** | | | | |
| 时间        | hh:mm AM/PM | d                 |10:23 AM||
| 时间24H     | hh:mm | d                       |10:23||
| 日期时间    | yyyy-MM-dd hh:mm AM/PM   | d    |2020-07-29 10:23 AM||
| 日期时间24H | yyyy-MM-dd hh:mm   | d           |2020-07-29 10:23||
| 日期         | yyyy-MM-dd | d                 | 1930-08-05 ||
| 日期         | yyyy/MM/dd | d                 | 1930/8/5 ||
| 日期         | yyyy"年"M"月"d"日" | d                 | 1930年8月5日 ||
| 日期         | MM-dd | d                      | 08-05 ||
| 日期         | M-d | d                        | 8-5 ||
| 日期         | M"月"d"日" | d                 | 8月5日 ||
| 日期         | h:mm:ss | d                    | 13:30:30 ||
| 日期         | h:mm | d                       | 13:30 ||
| 日期         | AM/PM hh:mm | d                | 下午01:30 ||
| 日期         | AM/PM h:mm | d                 | 下午1:30 ||
| 日期         | AM/PM h:mm:ss | d              | 下午1:30:30 ||
| 日期         | MM-dd AM/PM hh:mm | d          | 下08-05 下午01:30 ||
| <br><br><br>**货币格式** | | | | |
| 货币:人民币        | "¥" 0.00 | n           | ¥ 123.00 |也支持 ¥ #.00 或者 ¥0.00|
| 货币:美元        | "$" 0.00 | n           | $ 123.00 ||     
| 货币:欧元        | "€" 0.00 | n           | € 123.00 ||     
| 货币:英镑        | "￡" 0.00 | n           | ￡ 123.00 ||     
| 货币:港元        | "$" 0.00 | n           | $ 123.00 ||     
| 货币:日元        | "￥" 0.00 | n           | ￥ 123.00 ||     
| 货币:阿尔巴尼亚列克        | "Lek" 0.00 | n           | Lek 123.00 ||     
| 货币:阿尔及利亚第纳尔        | "din" 0.00 | n           | din 123.00 ||     
| 货币:阿富汗尼        | "Af" 0.00 | n           | Af 123.00 ||     
| 货币:阿根廷比索        | "$" 0.00 | n           | $ 123.00 ||     
| 货币:阿拉伯联合酋长国迪拉姆        | "dh" 0.00 | n           | dh 123.00 ||     
| 货币:阿鲁巴弗罗林        | "Afl" 0.00 | n           | Afl 123.00 ||     
| 货币:阿曼里亚尔        | "Rial" 0.00 | n           | Rial 123.00 ||     
| 货币:阿塞拜疆马纳特        | "?" 0.00 | n           | ? 123.00 ||     
| 货币:埃及镑        | "￡" 0.00 | n           | ￡ 123.00 ||     
| 货币:埃塞俄比亚比尔        | "Birr" 0.00 | n           | Birr 123.00 ||     
| 货币:安哥拉宽扎        | "Kz" 0.00 | n           | Kz 123.00 ||     
| 货币:澳大利亚元        | "$" 0.00 | n           | $ 123.00 ||     
| 货币:澳门元        | "MOP" 0.00 | n           | MOP 123.00 ||     
| 货币:巴巴多斯元        | "$" 0.00 | n           | $ 123.00 ||     
| 货币:巴布亚新几内亚基那        | "PGK" 0.00 | n           | PGK 123.00 ||     
| 货币:巴哈马元        | "$" 0.00 | n           | $ 123.00 ||     
| 货币:巴基斯坦卢比        | "Rs" 0.00 | n           | Rs 123.00 ||     
| 货币:巴拉圭瓜拉尼        | "Gs" 0.00 | n           | Gs 123.00 ||     
| 货币:巴林第纳尔        | "din" 0.00 | n           | din 123.00 ||     
| 货币:巴拿马巴波亚        | "B/" 0.00 | n           | B/ 123.00 ||     
| 货币:巴西里亚伊        | "R$" 0.00 | n           | R$ 123.00 ||     
| 货币:白俄罗斯卢布        | "р" 0.00 | n           | р 123.00 ||     
| 货币:百慕大元        | "$" 0.00 | n           | $ 123.00 ||     
| 货币:保加利亚列弗        | "lev" 0.00 | n           | lev 123.00 ||    
| 货币:冰岛克朗        | "kr" 0.00 | n           | kr 123.00 ||     
| 货币:波黑可兑换马克        | "KM" 0.00 | n           | KM 123.00 ||     
| 货币:波兰兹罗提        | "z?" 0.00 | n           | z? 123.00 ||     
| 货币:玻利维亚诺        | "Bs" 0.00 | n           | Bs 123.00 ||     
| 货币:伯利兹元        | "$" 0.00 | n           | $ 123.00 ||     
| 货币:博茨瓦纳普拉        | "P" 0.00 | n           | P 123.00 ||     
| 货币:不丹努扎姆        | "Nu" 0.00 | n           | Nu 123.00 ||     
| 货币:布隆迪法郎        | "FBu" 0.00 | n           | FBu 123.00 ||     
| 货币:朝鲜圆        | "?KP" 0.00 | n           | ?KP 123.00 ||     
| 货币:丹麦克朗        | "kr" 0.00 | n           | kr 123.00 ||     
| 货币:东加勒比元        | "$" 0.00 | n           | $ 123.00 ||     
| 货币:多米尼加比索        | "RD$" 0.00 | n           | RD$ 123.00 ||     
| 货币:俄国卢布        | "?" 0.00 | n           | ? 123.00 ||     
| 货币:厄立特里亚纳克法        | "Nfk" 0.00 | n           | Nfk 123.00 ||     
| 货币:非洲金融共同体法郎        | "CFA" 0.00 | n           | CFA 123.00 ||     
| 货币:菲律宾比索        | "?" 0.00 | n           | ? 123.00 ||     
| 货币:斐济元        | "$" 0.00 | n           | $ 123.00 ||     
| 货币:佛得角埃斯库多        | "CVE" 0.00 | n           | CVE 123.00 ||     
| 货币:福克兰群岛镑        | "￡" 0.00 | n           | ￡ 123.00 ||     
| 货币:冈比亚达拉西        | "GMD" 0.00 | n           | GMD 123.00 ||     
| 货币:刚果法郎        | "FrCD" 0.00 | n           | FrCD 123.00 ||     
| 货币:哥伦比亚比索        | "$" 0.00 | n           | $ 123.00 ||     
| 货币:哥斯达黎加科朗        | "?" 0.00 | n           | ? 123.00 ||     
| 货币:古巴比索        | "$" 0.00 | n           | $ 123.00 ||     
| 货币:古巴可兑换比索        | "$" 0.00 | n           | $ 123.00 ||     
| 货币:圭亚那元        | "$" 0.00 | n           | $ 123.00 ||     
| 货币:哈萨克斯坦坚戈        | "?" 0.00 | n           | ? 123.00 ||     
| 货币:海地古德        | "HTG" 0.00 | n           | HTG 123.00 ||     
| 货币:韩元        | "?" 0.00 | n           | ? 123.00 ||     
| 货币:荷属安的列斯盾        | "NAf." 0.00 | n           | NAf. 123.00 ||     
| 货币:洪都拉斯拉伦皮拉        | "L" 0.00 | n           | L 123.00 ||     
| 货币:吉布提法郎        | "Fdj" 0.00 | n           | Fdj 123.00 ||     
| 货币:吉尔吉斯斯坦索姆        | "KGS" 0.00 | n           | KGS 123.00 ||     
| 货币:几内亚法郎        | "FG" 0.00 | n           | FG 123.00 ||     
| 货币:加拿大元        | "$" 0.00 | n           | $ 123.00 ||     
| 货币:加纳塞地        | "GHS" 0.00 | n           | GHS 123.00 ||     
| 货币:柬埔寨瑞尔        | "Riel" 0.00 | n           | Riel 123.00 ||     
| 货币:捷克克朗        | "K?" 0.00 | n           | K? 123.00 ||     
| 货币:津巴布韦元        | "$" 0.00 | n           | $ 123.00 ||     
| 货币:卡塔尔里亚尔        | "Rial" 0.00 | n           | Rial 123.00 ||     
| 货币:开曼群岛元        | "$" 0.00 | n           | $ 123.00 ||     
| 货币:科摩罗法郎        | "CF" 0.00 | n           | CF 123.00 ||     
| 货币:科威特第纳尔        | "din" 0.00 | n           | din 123.00 ||     
| 货币:克罗地亚库纳        | "kn" 0.00 | n           | kn 123.00 ||     
| 货币:肯尼亚先令        | "Ksh" 0.00 | n           | Ksh 123.00 ||     
| 货币:莱索托洛蒂        | "LSL" 0.00 | n           | LSL 123.00 ||     
| 货币:老挝基普        | "?" 0.00 | n           | ? 123.00 ||     
| 货币:黎巴嫩镑        | "L￡" 0.00 | n           | L￡ 123.00 ||     
| 货币:立陶宛立特        | "Lt" 0.00 | n           | Lt 123.00 ||     
| 货币:利比亚第纳尔        | "din" 0.00 | n           | din 123.00 ||     
| 货币:利比亚元        | "$" 0.00 | n           | $ 123.00 ||     
| 货币:卢旺达法郎        | "RF" 0.00 | n           | RF 123.00 ||     
| 货币:罗马尼亚列伊        | "RON" 0.00 | n           | RON 123.00 ||     
| 货币:马达加斯加阿里亚里        | "Ar" 0.00 | n           | Ar 123.00 ||     
| 货币:马尔代夫拉菲亚        | "Rf" 0.00 | n           | Rf 123.00 ||     
| 货币:马拉维克瓦查        | "MWK" 0.00 | n           | MWK 123.00 ||     
| 货币:马来西亚林吉特        | "RM" 0.00 | n           | RM 123.00 ||     
| 货币:马其顿戴第纳尔        | "din" 0.00 | n           | din 123.00 ||     
| 货币:毛里求斯卢比        | "MURs" 0.00 | n           | MURs 123.00 ||     
| 货币:毛里塔尼亚乌吉亚        | "MRO" 0.00 | n           | MRO 123.00 ||     
| 货币:蒙古图格里克        | "?" 0.00 | n           | ? 123.00 ||     
| 货币:孟加拉塔卡        | "?" 0.00 | n           | ? 123.00 ||     
| 货币:秘鲁新索尔        | "S/" 0.00 | n           | S/ 123.00 ||     
| 货币:缅甸开亚特        | "K" 0.00 | n           | K 123.00 ||     
| 货币:摩尔多瓦列伊        | "MDL" 0.00 | n           | MDL 123.00 ||     
| 货币:摩洛哥迪拉姆        | "dh" 0.00 | n           | dh 123.00 ||     
| 货币:莫桑比克梅蒂卡尔        | "MTn" 0.00 | n           | MTn 123.00 ||     
| 货币:墨西哥比索        | "$" 0.00 | n           | $ 123.00 ||     
| 货币:纳米比亚元        | "$" 0.00 | n           | $ 123.00 ||     
| 货币:南非兰特        | "R" 0.00 | n           | R 123.00 ||     
| 货币:南苏丹镑        | "￡" 0.00 | n           | ￡ 123.00 ||     
| 货币:尼加拉瓜科多巴        | "C$" 0.00 | n           | C$ 123.00 ||     
| 货币:尼泊尔卢比        | "Rs" 0.00 | n           | Rs 123.00 ||     
| 货币:尼日利亚奈拉        | "?" 0.00 | n           | ? 123.00 ||     
| 货币:挪威克朗        | "kr" 0.00 | n           | kr 123.00 ||     
| 货币:乔治亚拉瑞        | "GEL" 0.00 | n           | GEL 123.00 ||     
| 货币:人民币（离岸）        | "￥" 0.00 | n           | ￥ 123.00 ||     
| 货币:瑞典克朗        | "kr" 0.00 | n           | kr 123.00 ||     
| 货币:瑞士法郎        | "CHF" 0.00 | n           | CHF 123.00 ||     
| 货币:塞尔维亚第纳尔        | "din" 0.00 | n           | din 123.00 ||     
| 货币:塞拉利昂利昂        | "SLL" 0.00 | n           | SLL 123.00 ||     
| 货币:塞舌尔卢比        | "SCR" 0.00 | n           | SCR 123.00 ||     
| 货币:沙特里亚尔        | "Rial" 0.00 | n           | Rial 123.00 ||     
| 货币:圣多美多布拉        | "Db" 0.00 | n           | Db 123.00 ||     
| 货币:圣赫勒拿群岛磅        | "￡" 0.00 | n           | ￡ 123.00 ||     
| 货币:斯里兰卡卢比        | "Rs" 0.00 | n           | Rs 123.00 ||     
| 货币:斯威士兰里兰吉尼        | "SZL" 0.00 | n           | SZL 123.00 ||     
| 货币:苏丹镑        | "SDG" 0.00 | n           | SDG 123.00 ||     
| 货币:苏里南元        | "$" 0.00 | n           | $ 123.00 ||     
| 货币:所罗门群岛元        | "$" 0.00 | n           | $ 123.00 ||     
| 货币:索马里先令        | "SOS" 0.00 | n           | SOS 123.00 ||     
| 货币:塔吉克斯坦索莫尼        | "Som" 0.00 | n           | Som 123.00 ||     
| 货币:太平洋法郎        | "FCFP" 0.00 | n           | FCFP 123.00 ||     
| 货币:泰国铢        | "?" 0.00 | n           | ? 123.00 ||     
| 货币:坦桑尼亚先令        | "TSh" 0.00 | n           | TSh 123.00 ||     
| 货币:汤加潘加        | "T$" 0.00 | n           | T$ 123.00 ||     
| 货币:特立尼达和多巴哥元        | "$" 0.00 | n           | $ 123.00 ||     
| 货币:突尼斯第纳尔        | "din" 0.00 | n           | din 123.00 ||     
| 货币:土耳其里拉        | "?" 0.00 | n           | ? 123.00 ||     
| 货币:瓦努阿图瓦图        | "VUV" 0.00 | n           | VUV 123.00 ||     
| 货币:危地马拉格查尔        | "Q" 0.00 | n           | Q 123.00 ||     
| 货币:委内瑞拉博利瓦        | "Bs" 0.00 | n           | Bs 123.00 ||     
| 货币:文莱元        | "$" 0.00 | n           | $ 123.00 ||     
| 货币:乌干达先令        | "UGX" 0.00 | n           | UGX 123.00 ||     
| 货币:乌克兰格里夫尼亚        | "грн." 0.00 | n           | грн. 123.00 ||     
| 货币:乌拉圭比索        | "$" 0.00 | n           | $ 123.00 ||     
| 货币:乌兹别克斯坦苏姆        | "so?m" 0.00 | n           | so?m 123.00 ||     
| 货币:西萨摩亚塔拉        | "WST" 0.00 | n           | WST 123.00 ||     
| 货币:新加坡元        | "$" 0.00 | n           | $ 123.00 ||     
| 货币:新台币        | "NT$" 0.00 | n           | NT$ 123.00 ||     
| 货币:新西兰元        | "$" 0.00 | n           | $ 123.00 ||     
| 货币:匈牙利福林        | "Ft" 0.00 | n           | Ft 123.00 ||     
| 货币:叙利亚镑        | "￡" 0.00 | n           | ￡ 123.00 ||     
| 货币:牙买加元        | "$" 0.00 | n           | $ 123.00 ||     
| 货币:亚美尼亚德拉姆        | "Dram" 0.00 | n           | Dram 123.00 ||     
| 货币:也门里亚尔        | "Rial" 0.00 | n           | Rial 123.00 ||     
| 货币:伊拉克第纳尔        | "din" 0.00 | n           | din 123.00 ||     
| 货币:伊朗里亚尔        | "Rial" 0.00 | n           | Rial 123.00 ||     
| 货币:以色列新谢克尔        | "?" 0.00 | n           | ? 123.00 ||     
| 货币:印度卢比        | "?" 0.00 | n           | ? 123.00 ||     
| 货币:印度尼西亚卢比        | "Rp" 0.00 | n           | Rp 123.00 ||     
| 货币:约旦第纳尔        | "din" 0.00 | n           | din 123.00 ||     
| 货币:越南盾        | "?" 0.00 | n           | ? 123.00 ||     
| 货币:赞比亚克瓦查        | "ZMW" 0.00 | n           | ZMW 123.00 ||     
| 货币:直布罗陀镑        | "￡" 0.00 | n           | ￡ 123.00 ||     
| 货币:智利比索        | "$" 0.00 | n           | $ 123.00 ||     
| 货币:中非金融合作法郎        | "FCFA" 0.00 | n           | FCFA 123.00 || 

以上配置参考了[Aspose.Cells](https://docs.aspose.com/display/cellsnet/List+of+Supported+Number+Formats#ListofSupportedNumberFormats-Aspose.Cells)
