// import sheetFormula from './src/demoData/sheetFormula.js'
// import sheetCell from './src/demoData/sheetCell.js'
// import sheetConditionFormat from './src/demoData/sheetConditionFormat.js'
// import sheetTable from './src/demoData/sheetTable.js'
// import sheetComment from './src/demoData/sheetComment.js'
// import sheetPivotTableData from './src/demoData/sheetPivotTableData.js'
// import sheetPivotTable from './src/demoData/sheetPivotTable.js'
// import sheetSparkline from './src/demoData/sheetSparkline.js'
// import sheetChart from './src/demoData/sheetChart.js'
// import sheetPicture from './src/demoData/sheetPicture.js'
// import sheetDataVerification from './src/demoData/sheetDataVerification.js'

import luckysheet from './../src/index.js';


$(function () {
  // According to the browser language
  var lang = luckysheetDemoUtil.language() === "zh" ? "zh" : "en";
  var isShare = luckysheetDemoUtil.getRequest().share; // '?share=1' opens the collaborative editing mode
  var gridKey = luckysheetDemoUtil.getRequest().gridKey; // workbook id for collaborative editing, or directly define here
  var options = null;

  if (isShare || gridKey) {
    // http://localhost:3000/?gridKey=12eyy789-kk45ofid-23737245
    if (!gridKey) {
      alert(
        "If gridKey is not provided in the address bar, please add it in the source code"
      );
    }
    options = {
      container: "luckysheet",
      lang: lang,
      allowUpdate: true,
      updateImageUrl: location.origin + "/luckysheet/api/updateImg",
      updateUrl: "ws://" + location.host + "/luckysheet/websocket/luckysheet",
      gridKey: gridKey,
      loadUrl: location.origin + "/luckysheet/api/load",
      loadSheetUrl: location.origin + "/luckysheet/api/loadsheet",
    };
  } else {
    // http://localhost:3000/
    options = {
      container: "luckysheet",
      lang: lang,
      // pager: {
      // 	pageIndex: 1,
      // 	pageSize: 10,
      // 	total: 50,
      // 	selectOption: [10, 20]
      // },
      forceCalculation: false,
      plugins: ["chart"],
      fontList: [
        {
          fontName: "HanaleiFill",
          url: "./assets/iconfont/HanaleiFill-Regular.ttf",
        },
        {
          fontName: "Anton",
          url: "./assets/iconfont/Anton-Regular.ttf",
        },
        {
          fontName: "Pacifico",
          url: "./assets/iconfont/Pacifico-Regular.ttf",
        },
      ],
      hook: {
        cellDragStop: function (cell, postion, sheetFile, ctx, event) {
          // console.info(cell, postion, sheetFile, ctx, event);
        },
        rowTitleCellRenderBefore: function (rowNum, postion, ctx) {
          // console.log(rowNum);
        },
        rowTitleCellRenderAfter: function (rowNum, postion, ctx) {
          // console.log(ctx);
        },
        columnTitleCellRenderBefore: function (columnAbc, postion, ctx) {
          // console.log(columnAbc);
        },
        columnTitleCellRenderAfter: function (columnAbc, postion, ctx) {
          // console.log(postion);
        },
        cellRenderBefore: function (cell, postion, sheetFile, ctx) {
          // console.log(cell,postion,sheetFile,ctx);
        },
        cellRenderAfter: function (cell, postion, sheetFile, ctx) {
          // console.log(postion);
        },
        cellMousedownBefore: function (cell, postion, sheetFile, ctx) {
          // console.log(postion);
        },
        cellMousedown: function (cell, postion, sheetFile, ctx) {
          // console.log(sheetFile);
        },
        sheetMousemove: function (cell, postion, sheetFile, moveState, ctx) {
          // console.log(cell,postion,sheetFile,moveState,ctx);
        },
        sheetMouseup: function (cell, postion, sheetFile, moveState, ctx) {
          // console.log(cell,postion,sheetFile,moveState,ctx);
        },
        cellAllRenderBefore: function (data, sheetFile, ctx) {
          // console.info(data,sheetFile,ctx)
        },
        updated: function (operate) {
          // console.info(operate)
        },
        cellUpdateBefore: function (r, c, value, isRefresh) {
          // console.info('cellUpdateBefore',r,c,value,isRefresh)
        },
        cellUpdated: function (r, c, oldValue, newValue, isRefresh) {
          // console.info('cellUpdated',r,c,oldValue, newValue, isRefresh)
        },
        sheetActivate: function (index, isPivotInitial, isNewSheet) {
          // console.info(index, isPivotInitial, isNewSheet)
        },
        rangeSelect: function (index, sheet) {
          // console.info(index, sheet)
        },
        commentInsertBefore: function (r, c) {
          // console.info(r, c)
        },
        commentInsertAfter: function (r, c, cell) {
          // console.info(r, c, cell)
        },
        commentDeleteBefore: function (r, c, cell) {
          // console.info(r, c, cell)
        },
        commentDeleteAfter: function (r, c, cell) {
          // console.info(r, c, cell)
        },
        commentUpdateBefore: function (r, c, value) {
          // console.info(r, c, value)
        },
        commentUpdateAfter: function (r, c, oldCell, newCell) {
          // console.info(r, c, oldCell, newCell)
        },
        cellEditBefore: function (range) {
          // console.info(range)
        },
        workbookCreateAfter: function (json) {
          // console.info(json)
        },
        rangePasteBefore: function (range, data) {
          // console.info('rangePasteBefore',range,data)
          // return false; //Can intercept paste
        },
      },
      //data:[{"name":"Sheet1","config":{"columnlen":{"1":88,"2":76,"3":88,"4":69,"5":88,"6":69,"7":83,"8":62,"9":83,"10":55,"11":83,"12":62,"13":88,"14":76,"15":88,"16":69,"17":88,"18":69},"customWidth":{"1":1,"2":1,"3":1,"4":1,"5":1,"6":1,"7":1,"8":1,"9":1,"10":1,"11":1,"12":1,"13":1,"14":1,"15":1,"16":1,"17":1,"18":1},"borderInfo":[{"rangeType":"cell","value":{"row_index":0,"col_index":0,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":0,"col_index":1,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":0,"col_index":2,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":0,"col_index":3,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":0,"col_index":4,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":0,"col_index":5,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":0,"col_index":6,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":0,"col_index":7,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":0,"col_index":8,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":0,"col_index":9,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":0,"col_index":10,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":0,"col_index":11,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":0,"col_index":12,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":0,"col_index":13,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":0,"col_index":14,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":0,"col_index":15,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":0,"col_index":16,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":0,"col_index":17,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":0,"col_index":18,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":1,"col_index":0,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":1,"col_index":1,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":1,"col_index":2,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":1,"col_index":3,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":1,"col_index":4,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":1,"col_index":5,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":1,"col_index":6,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":1,"col_index":7,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":1,"col_index":8,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":1,"col_index":9,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":1,"col_index":10,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":1,"col_index":11,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":1,"col_index":12,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":1,"col_index":13,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":1,"col_index":14,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":1,"col_index":15,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":1,"col_index":16,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":1,"col_index":17,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":1,"col_index":18,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":2,"col_index":0,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":2,"col_index":1,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":2,"col_index":2,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":2,"col_index":3,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":2,"col_index":4,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":2,"col_index":5,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":2,"col_index":6,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":2,"col_index":7,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":2,"col_index":8,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":2,"col_index":9,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":2,"col_index":10,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":2,"col_index":11,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":2,"col_index":12,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":2,"col_index":13,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":2,"col_index":14,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":2,"col_index":15,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":2,"col_index":16,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":2,"col_index":17,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":2,"col_index":18,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":3,"col_index":0,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":3,"col_index":1,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":3,"col_index":2,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":3,"col_index":3,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":3,"col_index":4,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":3,"col_index":5,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":3,"col_index":6,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":3,"col_index":7,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":3,"col_index":8,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":3,"col_index":9,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":3,"col_index":10,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":3,"col_index":11,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":3,"col_index":12,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":3,"col_index":13,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":3,"col_index":14,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":3,"col_index":15,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":3,"col_index":16,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":3,"col_index":17,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":3,"col_index":18,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":4,"col_index":0,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":4,"col_index":1,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":4,"col_index":2,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":4,"col_index":3,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":4,"col_index":4,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":4,"col_index":5,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":4,"col_index":6,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":4,"col_index":7,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":4,"col_index":8,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":4,"col_index":9,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":4,"col_index":10,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":4,"col_index":11,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":4,"col_index":12,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":4,"col_index":13,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":4,"col_index":14,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":4,"col_index":15,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":4,"col_index":16,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":4,"col_index":17,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":4,"col_index":18,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":5,"col_index":0,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":5,"col_index":1,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":5,"col_index":2,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":5,"col_index":3,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":5,"col_index":4,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":5,"col_index":5,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":5,"col_index":6,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":5,"col_index":7,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":5,"col_index":8,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":5,"col_index":9,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":5,"col_index":10,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":5,"col_index":11,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":5,"col_index":12,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":5,"col_index":13,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":5,"col_index":14,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":5,"col_index":15,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":5,"col_index":16,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":5,"col_index":17,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":5,"col_index":18,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":6,"col_index":0,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":6,"col_index":1,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":6,"col_index":2,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":6,"col_index":3,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":6,"col_index":4,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":6,"col_index":5,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":6,"col_index":6,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":6,"col_index":7,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":6,"col_index":8,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":6,"col_index":9,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":6,"col_index":10,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":6,"col_index":11,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":6,"col_index":12,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":6,"col_index":13,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":6,"col_index":14,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":6,"col_index":15,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":6,"col_index":16,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":6,"col_index":17,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":6,"col_index":18,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":7,"col_index":0,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":7,"col_index":1,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":7,"col_index":2,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":7,"col_index":3,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":7,"col_index":4,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":7,"col_index":5,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":7,"col_index":6,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":7,"col_index":7,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":7,"col_index":8,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":7,"col_index":9,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":7,"col_index":10,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":7,"col_index":11,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":7,"col_index":12,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":7,"col_index":13,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":7,"col_index":14,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":7,"col_index":15,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":7,"col_index":16,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":7,"col_index":17,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":7,"col_index":18,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":8,"col_index":0,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":8,"col_index":1,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":8,"col_index":2,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":8,"col_index":3,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":8,"col_index":4,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":8,"col_index":5,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":8,"col_index":6,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":8,"col_index":7,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":8,"col_index":8,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":8,"col_index":9,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":8,"col_index":10,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":8,"col_index":11,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":8,"col_index":12,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":8,"col_index":13,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":8,"col_index":14,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":8,"col_index":15,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":8,"col_index":16,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":8,"col_index":17,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":8,"col_index":18,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":9,"col_index":0,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":9,"col_index":1,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":9,"col_index":2,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":9,"col_index":3,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":9,"col_index":4,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":9,"col_index":5,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":9,"col_index":6,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":9,"col_index":7,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":9,"col_index":8,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":9,"col_index":9,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":9,"col_index":10,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":9,"col_index":11,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":9,"col_index":12,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":9,"col_index":13,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":9,"col_index":14,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":9,"col_index":15,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":9,"col_index":16,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":9,"col_index":17,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":9,"col_index":18,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":10,"col_index":0,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":10,"col_index":1,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":10,"col_index":2,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":10,"col_index":3,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":10,"col_index":4,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":10,"col_index":5,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":10,"col_index":6,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":10,"col_index":7,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":10,"col_index":8,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":10,"col_index":9,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":10,"col_index":10,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":10,"col_index":11,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":10,"col_index":12,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":10,"col_index":13,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":10,"col_index":14,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":10,"col_index":15,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":10,"col_index":16,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":10,"col_index":17,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":10,"col_index":18,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":11,"col_index":0,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":11,"col_index":1,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":11,"col_index":2,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":11,"col_index":3,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":11,"col_index":4,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":11,"col_index":5,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":11,"col_index":6,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":11,"col_index":7,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":11,"col_index":8,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":11,"col_index":9,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":11,"col_index":10,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":11,"col_index":11,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":11,"col_index":12,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":11,"col_index":13,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":11,"col_index":14,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":11,"col_index":15,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":11,"col_index":16,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":11,"col_index":17,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":11,"col_index":18,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":12,"col_index":0,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":12,"col_index":1,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":12,"col_index":2,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":12,"col_index":3,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":12,"col_index":4,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":12,"col_index":5,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":12,"col_index":6,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":12,"col_index":7,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":12,"col_index":8,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":12,"col_index":9,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":12,"col_index":10,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":12,"col_index":11,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":12,"col_index":12,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":12,"col_index":13,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":12,"col_index":14,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":12,"col_index":15,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":12,"col_index":16,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":12,"col_index":17,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":12,"col_index":18,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":13,"col_index":0,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":13,"col_index":1,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":13,"col_index":2,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":13,"col_index":3,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":13,"col_index":4,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":13,"col_index":5,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":13,"col_index":6,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":13,"col_index":7,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":13,"col_index":8,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":13,"col_index":9,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":13,"col_index":10,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":13,"col_index":11,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":13,"col_index":12,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":13,"col_index":13,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":13,"col_index":14,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":13,"col_index":15,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":13,"col_index":16,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":13,"col_index":17,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":13,"col_index":18,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":14,"col_index":0,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":14,"col_index":1,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":14,"col_index":2,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":14,"col_index":3,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":14,"col_index":4,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":14,"col_index":5,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":14,"col_index":6,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":14,"col_index":7,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":14,"col_index":8,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":14,"col_index":9,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":14,"col_index":10,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":14,"col_index":11,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":14,"col_index":12,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":14,"col_index":13,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":14,"col_index":14,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":14,"col_index":15,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":14,"col_index":16,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":14,"col_index":17,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":14,"col_index":18,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":15,"col_index":0,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":15,"col_index":1,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":15,"col_index":2,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":15,"col_index":3,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":15,"col_index":4,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":15,"col_index":5,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":15,"col_index":6,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":15,"col_index":7,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":15,"col_index":8,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":15,"col_index":9,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":15,"col_index":10,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":15,"col_index":11,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":15,"col_index":12,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":15,"col_index":13,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":15,"col_index":14,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":15,"col_index":15,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":15,"col_index":16,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":15,"col_index":17,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":15,"col_index":18,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":16,"col_index":0,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":16,"col_index":1,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":16,"col_index":2,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":16,"col_index":3,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":16,"col_index":4,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":16,"col_index":5,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":16,"col_index":6,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":16,"col_index":7,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":16,"col_index":8,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":16,"col_index":9,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":16,"col_index":10,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":16,"col_index":11,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":16,"col_index":12,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":16,"col_index":13,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":16,"col_index":14,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":16,"col_index":15,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":16,"col_index":16,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":16,"col_index":17,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":16,"col_index":18,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":17,"col_index":0,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":17,"col_index":1,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":17,"col_index":2,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":17,"col_index":3,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":17,"col_index":4,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":17,"col_index":5,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":17,"col_index":6,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":17,"col_index":7,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":17,"col_index":8,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":17,"col_index":9,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":17,"col_index":10,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":17,"col_index":11,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":17,"col_index":12,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":17,"col_index":13,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":17,"col_index":14,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":17,"col_index":15,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":17,"col_index":16,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":17,"col_index":17,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":17,"col_index":18,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":18,"col_index":0,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":18,"col_index":1,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":18,"col_index":2,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":18,"col_index":3,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":18,"col_index":4,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":18,"col_index":5,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":18,"col_index":6,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":18,"col_index":7,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":18,"col_index":8,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":18,"col_index":9,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":18,"col_index":10,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":18,"col_index":11,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":18,"col_index":12,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":18,"col_index":13,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":18,"col_index":14,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":18,"col_index":15,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":18,"col_index":16,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":18,"col_index":17,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":18,"col_index":18,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":19,"col_index":0,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":19,"col_index":1,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":19,"col_index":2,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":19,"col_index":3,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":19,"col_index":4,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":19,"col_index":5,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":19,"col_index":6,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":19,"col_index":7,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":19,"col_index":8,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":19,"col_index":9,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":19,"col_index":10,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":19,"col_index":11,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":19,"col_index":12,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":19,"col_index":13,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":19,"col_index":14,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":19,"col_index":15,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":19,"col_index":16,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":19,"col_index":17,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":19,"col_index":18,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":20,"col_index":0,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":20,"col_index":1,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":20,"col_index":2,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":20,"col_index":3,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":20,"col_index":4,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":20,"col_index":5,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":20,"col_index":6,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":20,"col_index":7,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":20,"col_index":8,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":20,"col_index":9,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":20,"col_index":10,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":20,"col_index":11,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":20,"col_index":12,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":20,"col_index":13,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":20,"col_index":14,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":20,"col_index":15,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":20,"col_index":16,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":20,"col_index":17,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":20,"col_index":18,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":21,"col_index":0,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":21,"col_index":1,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":21,"col_index":2,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":21,"col_index":3,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":21,"col_index":4,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":21,"col_index":5,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":21,"col_index":6,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":21,"col_index":7,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":21,"col_index":8,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":21,"col_index":9,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":21,"col_index":10,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":21,"col_index":11,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":21,"col_index":12,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":21,"col_index":13,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":21,"col_index":14,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":21,"col_index":15,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":21,"col_index":16,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":21,"col_index":17,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":21,"col_index":18,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":22,"col_index":0,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":22,"col_index":1,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":22,"col_index":2,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":22,"col_index":3,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":22,"col_index":4,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":22,"col_index":5,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":22,"col_index":6,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":22,"col_index":7,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":22,"col_index":8,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":22,"col_index":9,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":22,"col_index":10,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":22,"col_index":11,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":22,"col_index":12,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":22,"col_index":13,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":22,"col_index":14,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":22,"col_index":15,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":22,"col_index":16,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":22,"col_index":17,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":22,"col_index":18,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":23,"col_index":0,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":23,"col_index":1,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":23,"col_index":2,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":23,"col_index":3,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":23,"col_index":4,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":23,"col_index":5,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":23,"col_index":6,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":23,"col_index":7,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":23,"col_index":8,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":23,"col_index":9,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":23,"col_index":10,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":23,"col_index":11,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":23,"col_index":12,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":23,"col_index":13,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":23,"col_index":14,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":23,"col_index":15,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":23,"col_index":16,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":23,"col_index":17,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":23,"col_index":18,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":24,"col_index":0,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":24,"col_index":1,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":24,"col_index":2,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":24,"col_index":3,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":24,"col_index":4,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":24,"col_index":5,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":24,"col_index":6,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":24,"col_index":7,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":24,"col_index":8,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":24,"col_index":9,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":24,"col_index":10,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":24,"col_index":11,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":24,"col_index":12,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":24,"col_index":13,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":24,"col_index":14,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":24,"col_index":15,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":24,"col_index":16,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":24,"col_index":17,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":24,"col_index":18,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":25,"col_index":0,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":25,"col_index":1,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":25,"col_index":2,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":25,"col_index":3,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":25,"col_index":4,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":25,"col_index":5,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":25,"col_index":6,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":25,"col_index":7,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":25,"col_index":8,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":25,"col_index":9,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":25,"col_index":10,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":25,"col_index":11,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":25,"col_index":12,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":25,"col_index":13,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":25,"col_index":14,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":25,"col_index":15,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":25,"col_index":16,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":25,"col_index":17,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":25,"col_index":18,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":26,"col_index":0,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":26,"col_index":1,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":26,"col_index":2,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":26,"col_index":3,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":26,"col_index":4,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":26,"col_index":5,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":26,"col_index":6,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":26,"col_index":7,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":26,"col_index":8,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":26,"col_index":9,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":26,"col_index":10,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":26,"col_index":11,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":26,"col_index":12,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":26,"col_index":13,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":26,"col_index":14,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":26,"col_index":15,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":26,"col_index":16,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":26,"col_index":17,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":26,"col_index":18,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":27,"col_index":0,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":27,"col_index":1,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":27,"col_index":2,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":27,"col_index":3,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":27,"col_index":4,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":27,"col_index":5,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":27,"col_index":6,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":27,"col_index":7,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":27,"col_index":8,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":27,"col_index":9,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":27,"col_index":10,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":27,"col_index":11,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":27,"col_index":12,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":27,"col_index":13,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":27,"col_index":14,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":27,"col_index":15,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":27,"col_index":16,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":27,"col_index":17,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":27,"col_index":18,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":28,"col_index":0,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":28,"col_index":1,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":28,"col_index":2,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":28,"col_index":3,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":28,"col_index":4,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":28,"col_index":5,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":28,"col_index":6,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":28,"col_index":7,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":28,"col_index":8,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":28,"col_index":9,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":28,"col_index":10,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":28,"col_index":11,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":28,"col_index":12,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":28,"col_index":13,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":28,"col_index":14,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":28,"col_index":15,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":28,"col_index":16,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":28,"col_index":17,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":28,"col_index":18,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":29,"col_index":0,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":29,"col_index":1,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":29,"col_index":2,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":29,"col_index":3,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":29,"col_index":4,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":29,"col_index":5,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":29,"col_index":6,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":29,"col_index":7,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":29,"col_index":8,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":29,"col_index":9,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":29,"col_index":10,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":29,"col_index":11,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":29,"col_index":12,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":29,"col_index":13,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":29,"col_index":14,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":29,"col_index":15,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":29,"col_index":16,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":29,"col_index":17,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":29,"col_index":18,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":30,"col_index":0,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":30,"col_index":1,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":30,"col_index":2,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":30,"col_index":3,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":30,"col_index":4,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":30,"col_index":5,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":30,"col_index":6,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":30,"col_index":7,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":30,"col_index":8,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":30,"col_index":9,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":30,"col_index":10,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":30,"col_index":11,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":30,"col_index":12,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":30,"col_index":13,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":30,"col_index":14,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":30,"col_index":15,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":30,"col_index":16,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":30,"col_index":17,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":30,"col_index":18,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":31,"col_index":0,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":31,"col_index":1,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":31,"col_index":2,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":31,"col_index":3,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":31,"col_index":4,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":31,"col_index":5,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":31,"col_index":6,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":31,"col_index":7,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":31,"col_index":8,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":31,"col_index":9,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":31,"col_index":10,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":31,"col_index":11,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":31,"col_index":12,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":31,"col_index":13,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":31,"col_index":14,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":31,"col_index":15,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":31,"col_index":16,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":31,"col_index":17,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":31,"col_index":18,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":32,"col_index":0,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":32,"col_index":1,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":32,"col_index":2,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":32,"col_index":3,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":32,"col_index":4,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":32,"col_index":5,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":32,"col_index":6,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":32,"col_index":7,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":32,"col_index":8,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":32,"col_index":9,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":32,"col_index":10,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":32,"col_index":11,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":32,"col_index":12,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":32,"col_index":13,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":32,"col_index":14,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":32,"col_index":15,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":32,"col_index":16,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":32,"col_index":17,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":32,"col_index":18,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":33,"col_index":0,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":33,"col_index":1,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":33,"col_index":2,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":33,"col_index":3,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":33,"col_index":4,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":33,"col_index":5,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":33,"col_index":6,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":33,"col_index":7,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":33,"col_index":8,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":33,"col_index":9,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":33,"col_index":10,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":33,"col_index":11,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":33,"col_index":12,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":33,"col_index":13,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":33,"col_index":14,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":33,"col_index":15,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":33,"col_index":16,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":33,"col_index":17,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":33,"col_index":18,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":34,"col_index":0,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":34,"col_index":1,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":34,"col_index":2,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":34,"col_index":3,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":34,"col_index":4,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":34,"col_index":5,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":34,"col_index":6,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":34,"col_index":7,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":34,"col_index":8,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":34,"col_index":9,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":34,"col_index":10,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":34,"col_index":11,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":34,"col_index":12,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":34,"col_index":13,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":34,"col_index":14,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":34,"col_index":15,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":34,"col_index":16,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":34,"col_index":17,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":34,"col_index":18,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":35,"col_index":0,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":35,"col_index":1,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":35,"col_index":2,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":35,"col_index":3,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":35,"col_index":4,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":35,"col_index":5,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":35,"col_index":6,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":35,"col_index":7,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":35,"col_index":8,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":35,"col_index":9,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":35,"col_index":10,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":35,"col_index":11,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":35,"col_index":12,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":35,"col_index":13,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":35,"col_index":14,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":35,"col_index":15,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":35,"col_index":16,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":35,"col_index":17,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":35,"col_index":18,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":36,"col_index":0,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":36,"col_index":1,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":36,"col_index":2,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":36,"col_index":3,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":36,"col_index":4,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":36,"col_index":5,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":36,"col_index":6,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":36,"col_index":7,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":36,"col_index":8,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":36,"col_index":9,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":36,"col_index":10,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":36,"col_index":11,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":36,"col_index":12,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":36,"col_index":13,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":36,"col_index":14,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":36,"col_index":15,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":36,"col_index":16,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":36,"col_index":17,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":36,"col_index":18,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":37,"col_index":0,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":37,"col_index":1,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":37,"col_index":2,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":37,"col_index":3,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":37,"col_index":4,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":37,"col_index":5,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":37,"col_index":6,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":37,"col_index":7,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":37,"col_index":8,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":37,"col_index":9,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":37,"col_index":10,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":37,"col_index":11,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":37,"col_index":12,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":37,"col_index":13,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":37,"col_index":14,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":37,"col_index":15,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":37,"col_index":16,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":37,"col_index":17,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":37,"col_index":18,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":38,"col_index":0,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":38,"col_index":1,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":38,"col_index":2,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":38,"col_index":3,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":38,"col_index":4,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":38,"col_index":5,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":38,"col_index":6,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":38,"col_index":7,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":38,"col_index":8,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":38,"col_index":9,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":38,"col_index":10,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":38,"col_index":11,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":38,"col_index":12,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":38,"col_index":13,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":38,"col_index":14,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":38,"col_index":15,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":38,"col_index":16,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":38,"col_index":17,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}},{"rangeType":"cell","value":{"row_index":38,"col_index":18,"l":{"style":1,"color":"#302B2F"},"r":{"style":1,"color":"#302B2F"},"t":{"style":1,"color":"#302B2F"},"b":{"style":1,"color":"#302B2F"}}}]},"index":"1","status":"0","order":"0","luckysheet_select_save":[{"row":[9,9],"column":[4,4],"sheetIndex":1}],"zoomRatio":1,"showGridLines":"1","defaultColWidth":72,"defaultRowHeight":18,"celldata":[{"r":0,"c":0,"v":{"ct":{"fa":"General","t":"s"},"bg":"#A9D08E","fs":9,"fc":"#212D2A","ff":"Arial","vt":0,"tb":2,"v":"合计","qp":1}},{"r":0,"c":1,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"2121212"}},{"r":0,"c":2,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"11027033.300000001"}},{"r":0,"c":3,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"33685339116"}},{"r":0,"c":4,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"5060320.4000000004"}},{"r":0,"c":5,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"31551697540.5"}},{"r":0,"c":6,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"5966713"}},{"r":0,"c":7,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"4547347979.1000004"}},{"r":0,"c":8,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"881817.3"}},{"r":0,"c":9,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"232937258.30000001"}},{"r":0,"c":10,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"41419.4"}},{"r":0,"c":11,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"4314410720.8000002"}},{"r":0,"c":12,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"840397.9"}},{"r":0,"c":13,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"60689688677.300003"}},{"r":0,"c":14,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"10145216.1"}},{"r":0,"c":15,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"33452401857.700001"}},{"r":0,"c":16,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"5018901"}},{"r":0,"c":17,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"27237286819.599998"}},{"r":0,"c":18,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"5126315.0999999996"}},{"r":1,"c":0,"v":{"ct":{"fa":"General","t":"s"},"bg":"#A9D08E","fs":9,"fc":"#212D2A","ff":"Arial","vt":0,"tb":2,"v":"区内公司","qp":1}},{"r":1,"c":1,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"19176729211.799999"}},{"r":1,"c":2,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"3309995.6"}},{"r":1,"c":3,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"10232441962.700001"}},{"r":1,"c":4,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1601842.1"}},{"r":1,"c":5,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"8944287249.1000004"}},{"r":1,"c":6,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1708153.5"}},{"r":1,"c":7,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"3741456937.3000002"}},{"r":1,"c":8,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"723406.4"}},{"r":1,"c":9,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"191935455.69999999"}},{"r":1,"c":10,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"32961.1"}},{"r":1,"c":11,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"3549521481.5999999"}},{"r":1,"c":12,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"690445.3"}},{"r":1,"c":13,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"15435272274.5"}},{"r":1,"c":14,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"2586589.2000000002"}},{"r":1,"c":15,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"10040506507.1"}},{"r":1,"c":16,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1568881"}},{"r":1,"c":17,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"5394765767.3999996"}},{"r":1,"c":18,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1017708.2"}},{"r":2,"c":0,"v":{"ct":{"fa":"General","t":"s"},"bg":"#A9D08E","fs":9,"fc":"#212D2A","ff":"Arial","vt":0,"tb":2,"v":"北京","qp":1}},{"r":2,"c":1,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1639327850.0999999"}},{"r":2,"c":2,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"232929.4"}},{"r":2,"c":3,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1639304942.0999999"}},{"r":2,"c":4,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"232926"}},{"r":2,"c":5,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"22908"}},{"r":2,"c":6,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"3.4"}},{"r":2,"c":7,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"10284238.1"}},{"r":2,"c":8,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1602.9"}},{"r":2,"c":9,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"10261330.1"}},{"r":2,"c":10,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1599.5"}},{"r":2,"c":11,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"22908"}},{"r":2,"c":12,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"3.4"}},{"r":2,"c":13,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1629043612"}},{"r":2,"c":14,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"231326.5"}},{"r":2,"c":15,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1629043612"}},{"r":2,"c":16,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"231326.5"}},{"r":2,"c":17,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#323232","ff":"Arial","vt":0,"tb":2}},{"r":2,"c":18,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#323232","ff":"Arial","vt":0,"tb":2}},{"r":3,"c":0,"v":{"ct":{"fa":"General","t":"s"},"bg":"#A9D08E","fs":9,"fc":"#212D2A","ff":"Arial","vt":0,"tb":2,"v":"天津","qp":1}},{"r":3,"c":1,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"197102644"}},{"r":3,"c":2,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"35879.800000000003"}},{"r":3,"c":3,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"101723824.09999999"}},{"r":3,"c":4,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"16908.5"}},{"r":3,"c":5,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"95378819.900000006"}},{"r":3,"c":6,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"18971.3"}},{"r":3,"c":7,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"34415232.600000001"}},{"r":3,"c":8,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"6882.2"}},{"r":3,"c":9,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"4512011.2"}},{"r":3,"c":10,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"812.5"}},{"r":3,"c":11,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"29903221.399999999"}},{"r":3,"c":12,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"6069.6"}},{"r":3,"c":13,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"162687411.40000001"}},{"r":3,"c":14,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"28997.599999999999"}},{"r":3,"c":15,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"97211812.900000006"}},{"r":3,"c":16,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"16096"}},{"r":3,"c":17,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"65475598.5"}},{"r":3,"c":18,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"12901.7"}},{"r":4,"c":0,"v":{"ct":{"fa":"General","t":"s"},"bg":"#A9D08E","fs":9,"fc":"#212D2A","ff":"Arial","vt":0,"tb":2,"v":"河北","qp":1}},{"r":4,"c":1,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"375906003.19999999"}},{"r":4,"c":2,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"72168.800000000003"}},{"r":4,"c":3,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"110165771.5"}},{"r":4,"c":4,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"19157.8"}},{"r":4,"c":5,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"265740231.69999999"}},{"r":4,"c":6,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"53011.1"}},{"r":4,"c":7,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"170439887.19999999"}},{"r":4,"c":8,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"34131.199999999997"}},{"r":4,"c":9,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"3009197.5"}},{"r":4,"c":10,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"531.9"}},{"r":4,"c":11,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"167430689.69999999"}},{"r":4,"c":12,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"33599.4"}},{"r":4,"c":13,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"205466116"}},{"r":4,"c":14,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"38037.599999999999"}},{"r":4,"c":15,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"107156574"}},{"r":4,"c":16,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"18625.900000000001"}},{"r":4,"c":17,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"98309542"}},{"r":4,"c":18,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"19411.7"}},{"r":5,"c":0,"v":{"ct":{"fa":"General","t":"s"},"bg":"#A9D08E","fs":9,"fc":"#212D2A","ff":"Arial","vt":0,"tb":2,"v":"山西","qp":1}},{"r":5,"c":1,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"399821780.5"}},{"r":5,"c":2,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"71645.600000000006"}},{"r":5,"c":3,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"141027648.09999999"}},{"r":5,"c":4,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"22877"}},{"r":5,"c":5,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"258794132.40000001"}},{"r":5,"c":6,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"48768.7"}},{"r":5,"c":7,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"161910575.90000001"}},{"r":5,"c":8,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"30756.7"}},{"r":5,"c":9,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"4719394.5"}},{"r":5,"c":10,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"834"}},{"r":5,"c":11,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"157191181.40000001"}},{"r":5,"c":12,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"29922.7"}},{"r":5,"c":13,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"237911204.59999999"}},{"r":5,"c":14,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"40888.9"}},{"r":5,"c":15,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"136308253.59999999"}},{"r":5,"c":16,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"22042.9"}},{"r":5,"c":17,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"101602951"}},{"r":5,"c":18,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"18845.900000000001"}},{"r":6,"c":0,"v":{"ct":{"fa":"General","t":"s"},"bg":"#A9D08E","fs":9,"fc":"#212D2A","ff":"Arial","vt":0,"tb":2,"v":"河南","qp":1}},{"r":6,"c":1,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"920677504.20000005"}},{"r":6,"c":2,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"167568.5"}},{"r":6,"c":3,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"289753107.89999998"}},{"r":6,"c":4,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"47977.599999999999"}},{"r":6,"c":5,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"630924396.29999995"}},{"r":6,"c":6,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"119590.9"}},{"r":6,"c":7,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"142879264.59999999"}},{"r":6,"c":8,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"26971.3"}},{"r":6,"c":9,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"10949355"}},{"r":6,"c":10,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1889"}},{"r":6,"c":11,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"131929909.59999999"}},{"r":6,"c":12,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"25082.3"}},{"r":6,"c":13,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"777798239.60000002"}},{"r":6,"c":14,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"140597.20000000001"}},{"r":6,"c":15,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"278803752.89999998"}},{"r":6,"c":16,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"46088.6"}},{"r":6,"c":17,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"498994486.69999999"}},{"r":6,"c":18,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"94508.6"}},{"r":7,"c":0,"v":{"ct":{"fa":"General","t":"s"},"bg":"#A9D08E","fs":9,"fc":"#212D2A","ff":"Arial","vt":0,"tb":2,"v":"山东","qp":1}},{"r":7,"c":1,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"921338354"}},{"r":7,"c":2,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"174357.5"}},{"r":7,"c":3,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"379283246.69999999"}},{"r":7,"c":4,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"65057.2"}},{"r":7,"c":5,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"542055107.29999995"}},{"r":7,"c":6,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"109300.4"}},{"r":7,"c":7,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"312142178.30000001"}},{"r":7,"c":8,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"63198.5"}},{"r":7,"c":9,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"25815498.699999999"}},{"r":7,"c":10,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"4692.8999999999996"}},{"r":7,"c":11,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"286326679.60000002"}},{"r":7,"c":12,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"58505.7"}},{"r":7,"c":13,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"609196175.70000005"}},{"r":7,"c":14,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"111159"}},{"r":7,"c":15,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"353467748"}},{"r":7,"c":16,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"60364.3"}},{"r":7,"c":17,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"255728427.69999999"}},{"r":7,"c":18,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"50794.7"}},{"r":8,"c":0,"v":{"ct":{"fa":"General","t":"s"},"bg":"#A9D08E","fs":9,"fc":"#212D2A","ff":"Arial","vt":0,"tb":2,"v":"上海","qp":1}},{"r":8,"c":1,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"700158371.79999995"}},{"r":8,"c":2,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"114934.7"}},{"r":8,"c":3,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"339869447.69999999"}},{"r":8,"c":4,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"47104.800000000003"}},{"r":8,"c":5,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"360288924.10000002"}},{"r":8,"c":6,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"67829.899999999994"}},{"r":8,"c":7,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"113310877.59999999"}},{"r":8,"c":8,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"22652.9"}},{"r":8,"c":9,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"8785937.0999999996"}},{"r":8,"c":10,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1447.7"}},{"r":8,"c":11,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"104524940.5"}},{"r":8,"c":12,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"21205.200000000001"}},{"r":8,"c":13,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"586847494.20000005"}},{"r":8,"c":14,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"92281.8"}},{"r":8,"c":15,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"331083510.60000002"}},{"r":8,"c":16,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"45657.1"}},{"r":8,"c":17,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"255763983.59999999"}},{"r":8,"c":18,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"46624.7"}},{"r":9,"c":0,"v":{"ct":{"fa":"General","t":"s"},"bg":"#A9D08E","fs":9,"fc":"#212D2A","ff":"Arial","vt":0,"tb":2,"v":"江苏","qp":1}},{"r":9,"c":1,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"2328408620.5999999"}},{"r":9,"c":2,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"385231.7"}},{"r":9,"c":3,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1457308176.4000001"}},{"r":9,"c":4,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"218871.5"}},{"r":9,"c":5,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"871100444.20000005"}},{"r":9,"c":6,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"166360.20000000001"}},{"r":9,"c":7,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"321834979.60000002"}},{"r":9,"c":8,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"63399.7"}},{"r":9,"c":9,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"23638030"}},{"r":9,"c":10,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"4164.1000000000004"}},{"r":9,"c":11,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"298196949.60000002"}},{"r":9,"c":12,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"59235.6"}},{"r":9,"c":13,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"2006573641.0999999"}},{"r":9,"c":14,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"321832"}},{"r":9,"c":15,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1433670146.4000001"}},{"r":9,"c":16,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"214707.5"}},{"r":9,"c":17,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"572903494.70000005"}},{"r":9,"c":18,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"107124.5"}},{"r":10,"c":0,"v":{"ct":{"fa":"General","t":"s"},"bg":"#A9D08E","fs":9,"fc":"#212D2A","ff":"Arial","vt":0,"tb":2,"v":"浙江","qp":1}},{"r":10,"c":1,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"3209097346.5999999"}},{"r":10,"c":2,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"555509.9"}},{"r":10,"c":3,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1770617611.3"}},{"r":10,"c":4,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"282921"}},{"r":10,"c":5,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1438479735.3"}},{"r":10,"c":6,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"272588.90000000002"}},{"r":10,"c":7,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"547121572.20000005"}},{"r":10,"c":8,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"105286.6"}},{"r":10,"c":9,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"20516147.600000001"}},{"r":10,"c":10,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"3551.9"}},{"r":10,"c":11,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"526605424.60000002"}},{"r":10,"c":12,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"101734.7"}},{"r":10,"c":13,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"2661975774.4000001"}},{"r":10,"c":14,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"450223.3"}},{"r":10,"c":15,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1750101463.7"}},{"r":10,"c":16,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"279369.09999999998"}},{"r":10,"c":17,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"911874310.70000005"}},{"r":10,"c":18,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"170854.2"}},{"r":11,"c":0,"v":{"ct":{"fa":"General","t":"s"},"bg":"#A9D08E","fs":9,"fc":"#212D2A","ff":"Arial","vt":0,"tb":2,"v":"福建","qp":1}},{"r":11,"c":1,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"821056177.29999995"}},{"r":11,"c":2,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"143190.79999999999"}},{"r":11,"c":3,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"481154195.89999998"}},{"r":11,"c":4,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"77969.899999999994"}},{"r":11,"c":5,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"339901981.39999998"}},{"r":11,"c":6,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"65220.800000000003"}},{"r":11,"c":7,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"114980444.2"}},{"r":11,"c":8,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"22484.6"}},{"r":11,"c":9,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"3744250"}},{"r":11,"c":10,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"654"}},{"r":11,"c":11,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"111236194.2"}},{"r":11,"c":12,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"21830.6"}},{"r":11,"c":13,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"706075733.10000002"}},{"r":11,"c":14,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"120706.1"}},{"r":11,"c":15,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"477409945.89999998"}},{"r":11,"c":16,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"77315.899999999994"}},{"r":11,"c":17,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"228665787.19999999"}},{"r":11,"c":18,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"43390.2"}},{"r":12,"c":0,"v":{"ct":{"fa":"General","t":"s"},"bg":"#A9D08E","fs":9,"fc":"#212D2A","ff":"Arial","vt":0,"tb":2,"v":"安徽","qp":1}},{"r":12,"c":1,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"897439716.89999998"}},{"r":12,"c":2,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"143880.6"}},{"r":12,"c":3,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"479411987.19999999"}},{"r":12,"c":4,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"68040.399999999994"}},{"r":12,"c":5,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"418027729.69999999"}},{"r":12,"c":6,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"75840.2"}},{"r":12,"c":7,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"175178199.40000001"}},{"r":12,"c":8,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"33304.9"}},{"r":12,"c":9,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"11227370"}},{"r":12,"c":10,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1955"}},{"r":12,"c":11,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"163950829.40000001"}},{"r":12,"c":12,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"31349.9"}},{"r":12,"c":13,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"722261517.5"}},{"r":12,"c":14,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"110575.6"}},{"r":12,"c":15,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"468184617.19999999"}},{"r":12,"c":16,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"66085.399999999994"}},{"r":12,"c":17,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"254076900.30000001"}},{"r":12,"c":18,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"44490.3"}},{"r":13,"c":0,"v":{"ct":{"fa":"General","t":"s"},"bg":"#A9D08E","fs":9,"fc":"#212D2A","ff":"Arial","vt":0,"tb":2,"v":"江西","qp":1}},{"r":13,"c":1,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"424480898.10000002"}},{"r":13,"c":2,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"77887"}},{"r":13,"c":3,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"104105580.8"}},{"r":13,"c":4,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"17673.099999999999"}},{"r":13,"c":5,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"320375317.30000001"}},{"r":13,"c":6,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"60213.8"}},{"r":13,"c":7,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"203787204"}},{"r":13,"c":8,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"38057.4"}},{"r":13,"c":9,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"4484151.0999999996"}},{"r":13,"c":10,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"768.4"}},{"r":13,"c":11,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"199303052.90000001"}},{"r":13,"c":12,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"37289"}},{"r":13,"c":13,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"220693694.09999999"}},{"r":13,"c":14,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"39829.599999999999"}},{"r":13,"c":15,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"99621429.700000003"}},{"r":13,"c":16,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"16904.8"}},{"r":13,"c":17,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"121072264.40000001"}},{"r":13,"c":18,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"22924.799999999999"}},{"r":14,"c":0,"v":{"ct":{"fa":"General","t":"s"},"bg":"#A9D08E","fs":9,"fc":"#212D2A","ff":"Arial","vt":0,"tb":2,"v":"湖北","qp":1}},{"r":14,"c":1,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"400208110.19999999"}},{"r":14,"c":2,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"69090.2"}},{"r":14,"c":3,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"183618936.69999999"}},{"r":14,"c":4,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"28662.1"}},{"r":14,"c":5,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"216589173.40000001"}},{"r":14,"c":6,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"40428.1"}},{"r":14,"c":7,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"101799945.8"}},{"r":14,"c":8,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"18829.3"}},{"r":14,"c":9,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"8498576.9000000004"}},{"r":14,"c":10,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1297"}},{"r":14,"c":11,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"93301368.900000006"}},{"r":14,"c":12,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"17532.3"}},{"r":14,"c":13,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"298408164.39999998"}},{"r":14,"c":14,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"50260.800000000003"}},{"r":14,"c":15,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"175120359.80000001"}},{"r":14,"c":16,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"27365.1"}},{"r":14,"c":17,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"123287804.59999999"}},{"r":14,"c":18,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"22895.8"}},{"r":15,"c":0,"v":{"ct":{"fa":"General","t":"s"},"bg":"#A9D08E","fs":9,"fc":"#212D2A","ff":"Arial","vt":0,"tb":2,"v":"湖南","qp":1}},{"r":15,"c":1,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"894856651.70000005"}},{"r":15,"c":2,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"158871.6"}},{"r":15,"c":3,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"526952555"}},{"r":15,"c":4,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"88878.1"}},{"r":15,"c":5,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"367904096.69999999"}},{"r":15,"c":6,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"69993.5"}},{"r":15,"c":7,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"151284562.30000001"}},{"r":15,"c":8,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"28575.3"}},{"r":15,"c":9,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1746400"}},{"r":15,"c":10,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"300"}},{"r":15,"c":11,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"149538162.30000001"}},{"r":15,"c":12,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"28275.3"}},{"r":15,"c":13,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"743572089.39999998"}},{"r":15,"c":14,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"130296.2"}},{"r":15,"c":15,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"525206155"}},{"r":15,"c":16,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"88578.1"}},{"r":15,"c":17,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"218365934.40000001"}},{"r":15,"c":18,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"41718.1"}},{"r":16,"c":0,"v":{"ct":{"fa":"General","t":"s"},"bg":"#A9D08E","fs":9,"fc":"#212D2A","ff":"Arial","vt":0,"tb":2,"v":"广东","qp":1}},{"r":16,"c":1,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"2094063051.3"}},{"r":16,"c":2,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"382884.5"}},{"r":16,"c":3,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1134410441"}},{"r":16,"c":4,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"191533.7"}},{"r":16,"c":5,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"959652610.39999998"}},{"r":16,"c":6,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"191350.9"}},{"r":16,"c":7,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"353601728.39999998"}},{"r":16,"c":8,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"70785.600000000006"}},{"r":16,"c":9,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"18461401.899999999"}},{"r":16,"c":10,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"3207.8"}},{"r":16,"c":11,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"335140326.5"}},{"r":16,"c":12,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"67577.7"}},{"r":16,"c":13,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1740461323"}},{"r":16,"c":14,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"312099"}},{"r":16,"c":15,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1115949039.0999999"}},{"r":16,"c":16,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"188325.8"}},{"r":16,"c":17,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"624512283.89999998"}},{"r":16,"c":18,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"123773.1"}},{"r":17,"c":0,"v":{"ct":{"fa":"General","t":"s"},"bg":"#A9D08E","fs":9,"fc":"#212D2A","ff":"Arial","vt":0,"tb":2,"v":"广西","qp":1}},{"r":17,"c":1,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"881928162.60000002"}},{"r":17,"c":2,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"153065.29999999999"}},{"r":17,"c":3,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"392264700.60000002"}},{"r":17,"c":4,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"60361.4"}},{"r":17,"c":5,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"489663462"}},{"r":17,"c":6,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"92704"}},{"r":17,"c":7,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"319724661.5"}},{"r":17,"c":8,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"61366"}},{"r":17,"c":9,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"15377402.6"}},{"r":17,"c":10,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"2580.1"}},{"r":17,"c":11,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"304347258.89999998"}},{"r":17,"c":12,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"58785.9"}},{"r":17,"c":13,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"562203501.10000002"}},{"r":17,"c":14,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"91699.3"}},{"r":17,"c":15,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"376887298"}},{"r":17,"c":16,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"57781.3"}},{"r":17,"c":17,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"185316203.19999999"}},{"r":17,"c":18,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"33918.1"}},{"r":18,"c":0,"v":{"ct":{"fa":"General","t":"s"},"bg":"#A9D08E","fs":9,"fc":"#212D2A","ff":"Arial","vt":0,"tb":2,"v":"贵州","qp":1}},{"r":18,"c":1,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"761419269.60000002"}},{"r":18,"c":2,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"135602.79999999999"}},{"r":18,"c":3,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"356599638.19999999"}},{"r":18,"c":4,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"59521.5"}},{"r":18,"c":5,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"404819631.39999998"}},{"r":18,"c":6,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"76081.3"}},{"r":18,"c":7,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"169856579.59999999"}},{"r":18,"c":8,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"31752.799999999999"}},{"r":18,"c":9,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"5298353.3"}},{"r":18,"c":10,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"900.4"}},{"r":18,"c":11,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"164558226.30000001"}},{"r":18,"c":12,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"30852.5"}},{"r":18,"c":13,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"591562690"}},{"r":18,"c":14,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"103849.9"}},{"r":18,"c":15,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"351301284.89999998"}},{"r":18,"c":16,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"58621.1"}},{"r":18,"c":17,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"240261405.09999999"}},{"r":18,"c":18,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"45228.800000000003"}},{"r":19,"c":0,"v":{"ct":{"fa":"General","t":"s"},"bg":"#A9D08E","fs":9,"fc":"#212D2A","ff":"Arial","vt":0,"tb":2,"v":"云南","qp":1}},{"r":19,"c":1,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1069523219.5"}},{"r":19,"c":2,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"195511.5"}},{"r":19,"c":3,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"229315506.5"}},{"r":19,"c":4,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"38869"}},{"r":19,"c":5,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"840207713"}},{"r":19,"c":6,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"156642.5"}},{"r":19,"c":7,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"307813804.19999999"}},{"r":19,"c":8,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"57696"}},{"r":19,"c":9,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"8071280"}},{"r":19,"c":10,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1366.2"}},{"r":19,"c":11,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"299742524.19999999"}},{"r":19,"c":12,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"56329.8"}},{"r":19,"c":13,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"761709415.29999995"}},{"r":19,"c":14,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"137815.6"}},{"r":19,"c":15,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"221244226.5"}},{"r":19,"c":16,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"37502.800000000003"}},{"r":19,"c":17,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"540465188.79999995"}},{"r":19,"c":18,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"100312.7"}},{"r":20,"c":0,"v":{"ct":{"fa":"General","t":"s"},"bg":"#A9D08E","fs":9,"fc":"#212D2A","ff":"Arial","vt":0,"tb":2,"v":"海南","qp":1}},{"r":20,"c":1,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"239915479.69999999"}},{"r":20,"c":2,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"39785.5"}},{"r":20,"c":3,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"115554645.09999999"}},{"r":20,"c":4,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"16531.7"}},{"r":20,"c":5,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"124360834.59999999"}},{"r":20,"c":6,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"23253.9"}},{"r":20,"c":7,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"29091002.100000001"}},{"r":20,"c":8,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"5672.4"}},{"r":20,"c":9,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"2819368.3"}},{"r":20,"c":10,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"408.9"}},{"r":20,"c":11,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"26271633.800000001"}},{"r":20,"c":12,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"5263.5"}},{"r":20,"c":13,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"210824477.69999999"}},{"r":20,"c":14,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"34113.1"}},{"r":20,"c":15,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"112735276.90000001"}},{"r":20,"c":16,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"16122.8"}},{"r":20,"c":17,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"98089200.799999997"}},{"r":20,"c":18,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"17990.3"}},{"r":21,"c":0,"v":{"ct":{"fa":"General","t":"s"},"bg":"#A9D08E","fs":9,"fc":"#212D2A","ff":"Arial","vt":0,"tb":2,"v":"区外省市","qp":1}},{"r":21,"c":1,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"10035855546"}},{"r":21,"c":2,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1964509.7"}},{"r":21,"c":3,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"2197155097.3000002"}},{"r":21,"c":4,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"390293.7"}},{"r":21,"c":5,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"7838700448.6999998"}},{"r":21,"c":6,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1574216"}},{"r":21,"c":7,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"434791957.19999999"}},{"r":21,"c":8,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"82580"}},{"r":21,"c":9,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"9754767.6999999993"}},{"r":21,"c":10,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1684.4"}},{"r":21,"c":11,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"425037189.5"}},{"r":21,"c":12,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"80895.600000000006"}},{"r":21,"c":13,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"9601063588.7999992"}},{"r":21,"c":14,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1881929.7"}},{"r":21,"c":15,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"2187400329.5999999"}},{"r":21,"c":16,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"388609.3"}},{"r":21,"c":17,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"7413663259.1999998"}},{"r":21,"c":18,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1493320.5"}},{"r":22,"c":0,"v":{"ct":{"fa":"General","t":"s"},"bg":"#A9D08E","fs":9,"fc":"#212D2A","ff":"Arial","vt":0,"tb":2,"v":"黑龙江","qp":1}},{"r":22,"c":1,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"129541171.09999999"}},{"r":22,"c":2,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"24391.3"}},{"r":22,"c":3,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"62821830.299999997"}},{"r":22,"c":4,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"11458.3"}},{"r":22,"c":5,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"66719340.799999997"}},{"r":22,"c":6,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"12933"}},{"r":22,"c":7,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"351794.8"}},{"r":22,"c":8,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"68.400000000000006"}},{"r":22,"c":9,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#323232","ff":"Arial","vt":0,"tb":2}},{"r":22,"c":10,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#323232","ff":"Arial","vt":0,"tb":2}},{"r":22,"c":11,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"351794.8"}},{"r":22,"c":12,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"68.400000000000006"}},{"r":22,"c":13,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"129189376.3"}},{"r":22,"c":14,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"24322.9"}},{"r":22,"c":15,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"62821830.299999997"}},{"r":22,"c":16,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"11458.3"}},{"r":22,"c":17,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"66367546"}},{"r":22,"c":18,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"12864.5"}},{"r":23,"c":0,"v":{"ct":{"fa":"General","t":"s"},"bg":"#A9D08E","fs":9,"fc":"#212D2A","ff":"Arial","vt":0,"tb":2,"v":"吉林","qp":1}},{"r":23,"c":1,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"78698824.599999994"}},{"r":23,"c":2,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"15613.4"}},{"r":23,"c":3,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"32110729"}},{"r":23,"c":4,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"5913"}},{"r":23,"c":5,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"46588095.600000001"}},{"r":23,"c":6,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"9700.4"}},{"r":23,"c":7,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"6612155.5"}},{"r":23,"c":8,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1307.9000000000001"}},{"r":23,"c":9,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"45864"}},{"r":23,"c":10,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"6"}},{"r":23,"c":11,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"6566291.5"}},{"r":23,"c":12,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1301.9000000000001"}},{"r":23,"c":13,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"72086669.099999994"}},{"r":23,"c":14,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"14305.6"}},{"r":23,"c":15,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"32064865"}},{"r":23,"c":16,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"5907"}},{"r":23,"c":17,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"40021804.100000001"}},{"r":23,"c":18,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"8398.6"}},{"r":24,"c":0,"v":{"ct":{"fa":"General","t":"s"},"bg":"#A9D08E","fs":9,"fc":"#212D2A","ff":"Arial","vt":0,"tb":2,"v":"辽宁","qp":1}},{"r":24,"c":1,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"7733295016.6000004"}},{"r":24,"c":2,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1547329.3"}},{"r":24,"c":3,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1522587629.4000001"}},{"r":24,"c":4,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"278027.5"}},{"r":24,"c":5,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"6210707387.1000004"}},{"r":24,"c":6,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1269301.8999999999"}},{"r":24,"c":7,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"60966225.399999999"}},{"r":24,"c":8,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"12480.2"}},{"r":24,"c":9,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"884918"}},{"r":24,"c":10,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"144"}},{"r":24,"c":11,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"60081307.399999999"}},{"r":24,"c":12,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"12336.2"}},{"r":24,"c":13,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"7672328791.1999998"}},{"r":24,"c":14,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1534849.1"}},{"r":24,"c":15,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1521702711.4000001"}},{"r":24,"c":16,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"277883.5"}},{"r":24,"c":17,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"6150626079.6999998"}},{"r":24,"c":18,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1256965.6000000001"}},{"r":25,"c":0,"v":{"ct":{"fa":"General","t":"s"},"bg":"#A9D08E","fs":9,"fc":"#212D2A","ff":"Arial","vt":0,"tb":2,"v":"陕西","qp":1}},{"r":25,"c":1,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"216046916.09999999"}},{"r":25,"c":2,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"42153.7"}},{"r":25,"c":3,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"65047944"}},{"r":25,"c":4,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"11657.8"}},{"r":25,"c":5,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"150998972.09999999"}},{"r":25,"c":6,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"30496"}},{"r":25,"c":7,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"35712772.200000003"}},{"r":25,"c":8,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"6986"}},{"r":25,"c":9,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"4241540.8"}},{"r":25,"c":10,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"756.3"}},{"r":25,"c":11,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"31471231.399999999"}},{"r":25,"c":12,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"6229.7"}},{"r":25,"c":13,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"180334143.90000001"}},{"r":25,"c":14,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"35167.699999999997"}},{"r":25,"c":15,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"60806403.200000003"}},{"r":25,"c":16,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"10901.5"}},{"r":25,"c":17,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"119527740.7"}},{"r":25,"c":18,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"24266.2"}},{"r":26,"c":0,"v":{"ct":{"fa":"General","t":"s"},"bg":"#A9D08E","fs":9,"fc":"#212D2A","ff":"Arial","vt":0,"tb":2,"v":"新疆","qp":1}},{"r":26,"c":1,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"834583660.60000002"}},{"r":26,"c":2,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"144791.4"}},{"r":26,"c":3,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"184835666.80000001"}},{"r":26,"c":4,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"27384.1"}},{"r":26,"c":5,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"649747993.89999998"}},{"r":26,"c":6,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"117407.2"}},{"r":26,"c":7,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"73977926"}},{"r":26,"c":8,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"13424.5"}},{"r":26,"c":9,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"647113.80000000005"}},{"r":26,"c":10,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"93"}},{"r":26,"c":11,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"73330812.099999994"}},{"r":26,"c":12,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"13331.5"}},{"r":26,"c":13,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"760605734.60000002"}},{"r":26,"c":14,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"131366.9"}},{"r":26,"c":15,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"184188552.90000001"}},{"r":26,"c":16,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"27291.200000000001"}},{"r":26,"c":17,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"576417181.70000005"}},{"r":26,"c":18,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"104075.7"}},{"r":27,"c":0,"v":{"ct":{"fa":"General","t":"s"},"bg":"#A9D08E","fs":9,"fc":"#212D2A","ff":"Arial","vt":0,"tb":2,"v":"内蒙古","qp":1}},{"r":27,"c":1,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"145212039.59999999"}},{"r":27,"c":2,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"27917.599999999999"}},{"r":27,"c":3,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"39988602.899999999"}},{"r":27,"c":4,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"7276.2"}},{"r":27,"c":5,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"105223436.7"}},{"r":27,"c":6,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"20641.400000000001"}},{"r":27,"c":7,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"67942427.200000003"}},{"r":27,"c":8,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"13237.9"}},{"r":27,"c":9,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"100262.9"}},{"r":27,"c":10,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"14.7"}},{"r":27,"c":11,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"67842164.299999997"}},{"r":27,"c":12,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"13223.2"}},{"r":27,"c":13,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"77269612.400000006"}},{"r":27,"c":14,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"14679.7"}},{"r":27,"c":15,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"39888340"}},{"r":27,"c":16,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"7261.5"}},{"r":27,"c":17,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"37381272.399999999"}},{"r":27,"c":18,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"7418.2"}},{"r":28,"c":0,"v":{"ct":{"fa":"General","t":"s"},"bg":"#A9D08E","fs":9,"fc":"#212D2A","ff":"Arial","vt":0,"tb":2,"v":"青海","qp":1}},{"r":28,"c":1,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"21566200.199999999"}},{"r":28,"c":2,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"3999.8"}},{"r":28,"c":3,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1237480"}},{"r":28,"c":4,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"201"}},{"r":28,"c":5,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"20328720.199999999"}},{"r":28,"c":6,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"3798.8"}},{"r":28,"c":7,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"8181122.2999999998"}},{"r":28,"c":8,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1522.1"}},{"r":28,"c":9,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"127500"}},{"r":28,"c":10,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"21"}},{"r":28,"c":11,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"8053622.2999999998"}},{"r":28,"c":12,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1501.1"}},{"r":28,"c":13,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"13385077.9"}},{"r":28,"c":14,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"2477.6999999999998"}},{"r":28,"c":15,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1109980"}},{"r":28,"c":16,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"180"}},{"r":28,"c":17,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"12275097.9"}},{"r":28,"c":18,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"2297.6999999999998"}},{"r":29,"c":0,"v":{"ct":{"fa":"General","t":"s"},"bg":"#A9D08E","fs":9,"fc":"#212D2A","ff":"Arial","vt":0,"tb":2,"v":"甘肃","qp":1}},{"r":29,"c":1,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"32689330.300000001"}},{"r":29,"c":2,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"5767.2"}},{"r":29,"c":3,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"5726954.4000000004"}},{"r":29,"c":4,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"831.6"}},{"r":29,"c":5,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"26962375.899999999"}},{"r":29,"c":6,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"4935.7"}},{"r":29,"c":7,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"12420033.6"}},{"r":29,"c":8,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"2265.6999999999998"}},{"r":29,"c":9,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"193500"}},{"r":29,"c":10,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"30"}},{"r":29,"c":11,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"12226533.6"}},{"r":29,"c":12,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"2235.6999999999998"}},{"r":29,"c":13,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"20269296.699999999"}},{"r":29,"c":14,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"3501.5"}},{"r":29,"c":15,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"5533454.4000000004"}},{"r":29,"c":16,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"801.6"}},{"r":29,"c":17,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"14735842.300000001"}},{"r":29,"c":18,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"2700"}},{"r":30,"c":0,"v":{"ct":{"fa":"General","t":"s"},"bg":"#A9D08E","fs":9,"fc":"#212D2A","ff":"Arial","vt":0,"tb":2,"v":"四川","qp":1}},{"r":30,"c":1,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"342838681.19999999"}},{"r":30,"c":2,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"62286.2"}},{"r":30,"c":3,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"82197971.099999994"}},{"r":30,"c":4,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"13580.9"}},{"r":30,"c":5,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"260640710.19999999"}},{"r":30,"c":6,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"48705.2"}},{"r":30,"c":7,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"91659839.200000003"}},{"r":30,"c":8,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"16902.599999999999"}},{"r":30,"c":9,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#323232","ff":"Arial","vt":0,"tb":2}},{"r":30,"c":10,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#323232","ff":"Arial","vt":0,"tb":2}},{"r":30,"c":11,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"91659839.200000003"}},{"r":30,"c":12,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"16902.599999999999"}},{"r":30,"c":13,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"251178842.09999999"}},{"r":30,"c":14,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"45383.6"}},{"r":30,"c":15,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"82197971.099999994"}},{"r":30,"c":16,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"13580.9"}},{"r":30,"c":17,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"168980871"}},{"r":30,"c":18,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"31802.7"}},{"r":31,"c":0,"v":{"ct":{"fa":"General","t":"s"},"bg":"#A9D08E","fs":9,"fc":"#212D2A","ff":"Arial","vt":0,"tb":2,"v":"重庆","qp":1}},{"r":31,"c":1,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"484643083.69999999"}},{"r":31,"c":2,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"87310"}},{"r":31,"c":3,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"196324840.40000001"}},{"r":31,"c":4,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"33260.699999999997"}},{"r":31,"c":5,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"288318243.30000001"}},{"r":31,"c":6,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"54049.3"}},{"r":31,"c":7,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"75011847.299999997"}},{"r":31,"c":8,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"14061.5"}},{"r":31,"c":9,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"3514068.1"}},{"r":31,"c":10,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"619.5"}},{"r":31,"c":11,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"71497779.200000003"}},{"r":31,"c":12,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"13442"}},{"r":31,"c":13,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"409631236.39999998"}},{"r":31,"c":14,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"73248.5"}},{"r":31,"c":15,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"192810772.40000001"}},{"r":31,"c":16,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"32641.200000000001"}},{"r":31,"c":17,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"216820464"}},{"r":31,"c":18,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"40607.300000000003"}},{"r":32,"c":0,"v":{"ct":{"fa":"General","t":"s"},"bg":"#A9D08E","fs":9,"fc":"#212D2A","ff":"Arial","vt":0,"tb":2,"v":"西藏","qp":1}},{"r":32,"c":1,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"16740621.9"}},{"r":32,"c":2,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"2949.8"}},{"r":32,"c":3,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"4275449"}},{"r":32,"c":4,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"702.6"}},{"r":32,"c":5,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"12465172.9"}},{"r":32,"c":6,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"2247.1999999999998"}},{"r":32,"c":7,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1955813.7"}},{"r":32,"c":8,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"323.3"}},{"r":32,"c":9,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#323232","ff":"Arial","vt":0,"tb":2}},{"r":32,"c":10,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#323232","ff":"Arial","vt":0,"tb":2}},{"r":32,"c":11,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1955813.7"}},{"r":32,"c":12,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"323.3"}},{"r":32,"c":13,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"14784808.199999999"}},{"r":32,"c":14,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"2626.5"}},{"r":32,"c":15,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"4275449"}},{"r":32,"c":16,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"702.6"}},{"r":32,"c":17,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"10509359.199999999"}},{"r":32,"c":18,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1923.9"}},{"r":33,"c":0,"v":{"ct":{"fa":"General","t":"s"},"bg":"#A9D08E","fs":9,"fc":"#212D2A","ff":"Arial","vt":0,"tb":2,"v":"大区小计","qp":1}},{"r":33,"c":1,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"36024451898.699997"}},{"r":33,"c":2,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"5752528"}},{"r":33,"c":3,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"21255742056"}},{"r":33,"c":4,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"3068184.5"}},{"r":33,"c":5,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"14768709842.700001"}},{"r":33,"c":6,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"2684343.5"}},{"r":33,"c":7,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"371099084.69999999"}},{"r":33,"c":8,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"75830.899999999994"}},{"r":33,"c":9,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"31247035"}},{"r":33,"c":10,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"6773.8"}},{"r":33,"c":11,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"339852049.69999999"}},{"r":33,"c":12,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"69057.100000000006"}},{"r":33,"c":13,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"35653352814"}},{"r":33,"c":14,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"5676697.0999999996"}},{"r":33,"c":15,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"21224495021"}},{"r":33,"c":16,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"3061410.7"}},{"r":33,"c":17,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"14428857793"}},{"r":33,"c":18,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"2615286.4"}},{"r":34,"c":0,"v":{"ct":{"fa":"General","t":"s"},"bg":"#A9D08E","fs":9,"fc":"#212D2A","ff":"Arial","vt":0,"tb":2,"v":"华北","qp":1}},{"r":34,"c":1,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"8979562707.2999992"}},{"r":34,"c":2,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1430431.3"}},{"r":34,"c":3,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"5769830804.1000004"}},{"r":34,"c":4,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"851308"}},{"r":34,"c":5,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"3209731903.1999998"}},{"r":34,"c":6,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"579123.30000000005"}},{"r":34,"c":7,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"80191139.5"}},{"r":34,"c":8,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"16249.4"}},{"r":34,"c":9,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#323232","ff":"Arial","vt":0,"tb":2}},{"r":34,"c":10,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#323232","ff":"Arial","vt":0,"tb":2}},{"r":34,"c":11,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"80191139.5"}},{"r":34,"c":12,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"16249.4"}},{"r":34,"c":13,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"8899371567.8999996"}},{"r":34,"c":14,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1414181.9"}},{"r":34,"c":15,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"5769830804.1000004"}},{"r":34,"c":16,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"851308"}},{"r":34,"c":17,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"3129540763.8000002"}},{"r":34,"c":18,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"562874"}},{"r":35,"c":0,"v":{"ct":{"fa":"General","t":"s"},"bg":"#A9D08E","fs":9,"fc":"#212D2A","ff":"Arial","vt":0,"tb":2,"v":"华东","qp":1}},{"r":35,"c":1,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"7743100122.6000004"}},{"r":35,"c":2,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1238875.3999999999"}},{"r":35,"c":3,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"4813028321"}},{"r":35,"c":4,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"696549.2"}},{"r":35,"c":5,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"2930071801.5999999"}},{"r":35,"c":6,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"542326.19999999995"}},{"r":35,"c":7,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"72956393.599999994"}},{"r":35,"c":8,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"15326.1"}},{"r":35,"c":9,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"8332411"}},{"r":35,"c":10,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"2000"}},{"r":35,"c":11,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"64623982.600000001"}},{"r":35,"c":12,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"13326.2"}},{"r":35,"c":13,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"7670143729"}},{"r":35,"c":14,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1223549.3"}},{"r":35,"c":15,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"4804695910"}},{"r":35,"c":16,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"694549.2"}},{"r":35,"c":17,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"2865447819"}},{"r":35,"c":18,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"529000.1"}},{"r":36,"c":0,"v":{"ct":{"fa":"General","t":"s"},"bg":"#A9D08E","fs":9,"fc":"#212D2A","ff":"Arial","vt":0,"tb":2,"v":"华中","qp":1}},{"r":36,"c":1,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"6445973642.6999998"}},{"r":36,"c":2,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1002082.6"}},{"r":36,"c":3,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"3738291609.9000001"}},{"r":36,"c":4,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"524638.9"}},{"r":36,"c":5,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"2707682032.9000001"}},{"r":36,"c":6,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"477443.7"}},{"r":36,"c":7,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"154601705.40000001"}},{"r":36,"c":8,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"32604.9"}},{"r":36,"c":9,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"22914624"}},{"r":36,"c":10,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"4773.8"}},{"r":36,"c":11,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"131687081.40000001"}},{"r":36,"c":12,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"27831"}},{"r":36,"c":13,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"6291371937.3000002"}},{"r":36,"c":14,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"969477.8"}},{"r":36,"c":15,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"3715376985.9000001"}},{"r":36,"c":16,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"519865.1"}},{"r":36,"c":17,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"2575994951.4000001"}},{"r":36,"c":18,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"449612.7"}},{"r":37,"c":0,"v":{"ct":{"fa":"General","t":"s"},"bg":"#A9D08E","fs":9,"fc":"#212D2A","ff":"Arial","vt":0,"tb":2,"v":"华南","qp":1}},{"r":37,"c":1,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"11537868598.799999"}},{"r":37,"c":2,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1836507.6"}},{"r":37,"c":3,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"6442924168.1000004"}},{"r":37,"c":4,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"914431.9"}},{"r":37,"c":5,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"5094944430.6999998"}},{"r":37,"c":6,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"922075.7"}},{"r":37,"c":7,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"34995802.399999999"}},{"r":37,"c":8,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"7091.3"}},{"r":37,"c":9,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#323232","ff":"Arial","vt":0,"tb":2}},{"r":37,"c":10,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#323232","ff":"Arial","vt":0,"tb":2}},{"r":37,"c":11,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"34995802.399999999"}},{"r":37,"c":12,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"7091.3"}},{"r":37,"c":13,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"11502872796.4"}},{"r":37,"c":14,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1829416.4"}},{"r":37,"c":15,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"6442924168.1000004"}},{"r":37,"c":16,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"914431.9"}},{"r":37,"c":17,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"5059948628.3000002"}},{"r":37,"c":18,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"914984.4"}},{"r":38,"c":0,"v":{"ct":{"fa":"General","t":"s"},"bg":"#A9D08E","fs":9,"fc":"#212D2A","ff":"Arial","vt":0,"tb":2,"v":"西北","qp":1}},{"r":38,"c":1,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1317946827.2"}},{"r":38,"c":2,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"244631"}},{"r":38,"c":3,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"491667152.89999998"}},{"r":38,"c":4,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"81256.5"}},{"r":38,"c":5,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"826279674.29999995"}},{"r":38,"c":6,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"163374.5"}},{"r":38,"c":7,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"28354043.800000001"}},{"r":38,"c":8,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"4559.2"}},{"r":38,"c":9,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#323232","ff":"Arial","vt":0,"tb":2}},{"r":38,"c":10,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#323232","ff":"Arial","vt":0,"tb":2}},{"r":38,"c":11,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"28354043.800000001"}},{"r":38,"c":12,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"4559.2"}},{"r":38,"c":13,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"1289592783.4000001"}},{"r":38,"c":14,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"240071.8"}},{"r":38,"c":15,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"491667152.89999998"}},{"r":38,"c":16,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"81256.5"}},{"r":38,"c":17,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"797925630.5"}},{"r":38,"c":18,"v":{"ct":{"fa":"General"},"bg":"#FFFFFF","fs":9,"fc":"#302C2A","ff":"Arial","vt":0,"tb":2,"v":"158815.29999999999"}}],"calcChain":[]},{"name":"Sheet2","config":{"columnlen":{"3":100},"customWidth":{"3":1}},"index":"2","status":"1","order":"1","luckysheet_select_save":[{"row":[19,19],"column":[6,6],"sheetIndex":2}],"zoomRatio":1,"showGridLines":"1","defaultColWidth":72,"defaultRowHeight":18,"celldata":[{"r":1,"c":3,"v":{"tb":1,"v":"2"}},{"r":1,"c":4,"v":{"tb":1,"v":"3"}},{"r":1,"c":5,"v":{"tb":1,"v":"4"}},{"r":1,"c":6,"v":{"tb":1,"v":"5"}},{"r":1,"c":7,"v":{"tb":1,"v":"6"}},{"r":1,"c":8,"v":{"tb":1,"v":"7"}},{"r":1,"c":9,"v":{"tb":1,"v":"8"}},{"r":1,"c":10,"v":{"tb":1,"v":"9"}},{"r":1,"c":11,"v":{"tb":1,"v":"10"}},{"r":1,"c":12,"v":{"tb":1,"v":"11"}},{"r":1,"c":13,"v":{"tb":1,"v":"12"}},{"r":1,"c":14,"v":{"tb":1,"v":"13"}},{"r":1,"c":15,"v":{"tb":1,"v":"14"}},{"r":1,"c":16,"v":{"tb":1,"v":"15"}},{"r":1,"c":17,"v":{"tb":1,"v":"16"}},{"r":1,"c":18,"v":{"tb":1,"v":"17"}},{"r":3,"c":2,"v":{"f":"=Sheet1!A1","tb":1,"v":"合计"}},{"r":3,"c":3,"v":{"f":"=VLOOKUP($C4,Sheet1!$A$1:$S$39,Sheet2!D$2,FALSE())","tb":1,"v":"2121212"}},{"r":3,"c":4,"v":{"f":"=VLOOKUP($C4,Sheet1!$A$1:$S$39,Sheet2!E$2,FALSE())","tb":1,"v":"11027033.300000001"}},{"r":3,"c":5,"v":{"f":"=VLOOKUP($C4,Sheet1!$A$1:$S$39,Sheet2!F$2,FALSE())","tb":1,"v":"33685339116"}},{"r":3,"c":6,"v":{"f":"=VLOOKUP($C4,Sheet1!$A$1:$S$39,Sheet2!G$2,FALSE())","tb":1,"v":"5060320.4000000004"}},{"r":3,"c":7,"v":{"f":"=VLOOKUP($C4,Sheet1!$A$1:$S$39,Sheet2!H$2,FALSE())","tb":1,"v":"31551697540.5"}},{"r":3,"c":8,"v":{"f":"=VLOOKUP($C4,Sheet1!$A$1:$S$39,Sheet2!I$2,FALSE())","tb":1,"v":"5966713"}},{"r":3,"c":9,"v":{"f":"=VLOOKUP($C4,Sheet1!$A$1:$S$39,Sheet2!J$2,FALSE())","tb":1,"v":"4547347979.1000004"}},{"r":3,"c":10,"v":{"f":"=VLOOKUP($C4,Sheet1!$A$1:$S$39,Sheet2!K$2,FALSE())","tb":1,"v":"881817.3"}},{"r":3,"c":11,"v":{"f":"=VLOOKUP($C4,Sheet1!$A$1:$S$39,Sheet2!L$2,FALSE())","tb":1,"v":"232937258.30000001"}},{"r":3,"c":12,"v":{"f":"=VLOOKUP($C4,Sheet1!$A$1:$S$39,Sheet2!M$2,FALSE())","tb":1,"v":"41419.4"}},{"r":3,"c":13,"v":{"f":"=VLOOKUP($C4,Sheet1!$A$1:$S$39,Sheet2!N$2,FALSE())","tb":1,"v":"4314410720.8000002"}},{"r":3,"c":14,"v":{"f":"=VLOOKUP($C4,Sheet1!$A$1:$S$39,Sheet2!O$2,FALSE())","tb":1,"v":"840397.9"}},{"r":3,"c":15,"v":{"f":"=VLOOKUP($C4,Sheet1!$A$1:$S$39,Sheet2!P$2,FALSE())","tb":1,"v":"60689688677.300003"}},{"r":3,"c":16,"v":{"f":"=VLOOKUP($C4,Sheet1!$A$1:$S$39,Sheet2!Q$2,FALSE())","tb":1,"v":"10145216.1"}},{"r":3,"c":17,"v":{"f":"=VLOOKUP($C4,Sheet1!$A$1:$S$39,Sheet2!R$2,FALSE())","tb":1,"v":"33452401857.700001"}},{"r":3,"c":18,"v":{"f":"=VLOOKUP($C4,Sheet1!$A$1:$S$39,Sheet2!S$2,FALSE())","tb":1,"v":"5018901"}},{"r":4,"c":2,"v":{"f":"=Sheet1!A2","tb":1,"v":"区内公司"}},{"r":4,"c":3,"v":{"f":"=VLOOKUP($C5,Sheet1!$A$1:$S$39,Sheet2!D$2,FALSE())","tb":1,"v":"19176729211.799999"}},{"r":4,"c":4,"v":{"f":"=VLOOKUP($C5,Sheet1!$A$1:$S$39,Sheet2!E$2,FALSE())","tb":1,"v":"3309995.6"}},{"r":4,"c":5,"v":{"f":"=VLOOKUP($C5,Sheet1!$A$1:$S$39,Sheet2!F$2,FALSE())","tb":1,"v":"10232441962.700001"}},{"r":4,"c":6,"v":{"f":"=VLOOKUP($C5,Sheet1!$A$1:$S$39,Sheet2!G$2,FALSE())","tb":1,"v":"1601842.1"}},{"r":4,"c":7,"v":{"f":"=VLOOKUP($C5,Sheet1!$A$1:$S$39,Sheet2!H$2,FALSE())","tb":1,"v":"8944287249.1000004"}},{"r":4,"c":8,"v":{"f":"=VLOOKUP($C5,Sheet1!$A$1:$S$39,Sheet2!I$2,FALSE())","tb":1,"v":"1708153.5"}},{"r":4,"c":9,"v":{"f":"=VLOOKUP($C5,Sheet1!$A$1:$S$39,Sheet2!J$2,FALSE())","tb":1,"v":"3741456937.3000002"}},{"r":4,"c":10,"v":{"f":"=VLOOKUP($C5,Sheet1!$A$1:$S$39,Sheet2!K$2,FALSE())","tb":1,"v":"723406.4"}},{"r":4,"c":11,"v":{"f":"=VLOOKUP($C5,Sheet1!$A$1:$S$39,Sheet2!L$2,FALSE())","tb":1,"v":"191935455.69999999"}},{"r":4,"c":12,"v":{"f":"=VLOOKUP($C5,Sheet1!$A$1:$S$39,Sheet2!M$2,FALSE())","tb":1,"v":"32961.1"}},{"r":4,"c":13,"v":{"f":"=VLOOKUP($C5,Sheet1!$A$1:$S$39,Sheet2!N$2,FALSE())","tb":1,"v":"3549521481.5999999"}},{"r":4,"c":14,"v":{"f":"=VLOOKUP($C5,Sheet1!$A$1:$S$39,Sheet2!O$2,FALSE())","tb":1,"v":"690445.3"}},{"r":4,"c":15,"v":{"f":"=VLOOKUP($C5,Sheet1!$A$1:$S$39,Sheet2!P$2,FALSE())","tb":1,"v":"15435272274.5"}},{"r":4,"c":16,"v":{"f":"=VLOOKUP($C5,Sheet1!$A$1:$S$39,Sheet2!Q$2,FALSE())","tb":1,"v":"2586589.2000000002"}},{"r":4,"c":17,"v":{"f":"=VLOOKUP($C5,Sheet1!$A$1:$S$39,Sheet2!R$2,FALSE())","tb":1,"v":"10040506507.1"}},{"r":4,"c":18,"v":{"f":"=VLOOKUP($C5,Sheet1!$A$1:$S$39,Sheet2!S$2,FALSE())","tb":1,"v":"1568881"}},{"r":5,"c":2,"v":{"f":"=Sheet1!A3","tb":1,"v":"北京"}},{"r":5,"c":3,"v":{"f":"=VLOOKUP($C6,Sheet1!$A$1:$S$39,Sheet2!D$2,FALSE())","tb":1,"v":"1639327850.0999999"}},{"r":5,"c":4,"v":{"f":"=VLOOKUP($C6,Sheet1!$A$1:$S$39,Sheet2!E$2,FALSE())","tb":1,"v":"232929.4"}},{"r":5,"c":5,"v":{"f":"=VLOOKUP($C6,Sheet1!$A$1:$S$39,Sheet2!F$2,FALSE())","tb":1,"v":"1639304942.0999999"}},{"r":5,"c":6,"v":{"f":"=VLOOKUP($C6,Sheet1!$A$1:$S$39,Sheet2!G$2,FALSE())","tb":1,"v":"232926"}},{"r":5,"c":7,"v":{"f":"=VLOOKUP($C6,Sheet1!$A$1:$S$39,Sheet2!H$2,FALSE())","tb":1,"v":"22908"}},{"r":5,"c":8,"v":{"f":"=VLOOKUP($C6,Sheet1!$A$1:$S$39,Sheet2!I$2,FALSE())","tb":1,"v":"3.4"}},{"r":5,"c":9,"v":{"f":"=VLOOKUP($C6,Sheet1!$A$1:$S$39,Sheet2!J$2,FALSE())","tb":1,"v":"10284238.1"}},{"r":5,"c":10,"v":{"f":"=VLOOKUP($C6,Sheet1!$A$1:$S$39,Sheet2!K$2,FALSE())","tb":1,"v":"1602.9"}},{"r":5,"c":11,"v":{"f":"=VLOOKUP($C6,Sheet1!$A$1:$S$39,Sheet2!L$2,FALSE())","tb":1,"v":"10261330.1"}},{"r":5,"c":12,"v":{"f":"=VLOOKUP($C6,Sheet1!$A$1:$S$39,Sheet2!M$2,FALSE())","tb":1,"v":"1599.5"}},{"r":5,"c":13,"v":{"f":"=VLOOKUP($C6,Sheet1!$A$1:$S$39,Sheet2!N$2,FALSE())","tb":1,"v":"22908"}},{"r":5,"c":14,"v":{"f":"=VLOOKUP($C6,Sheet1!$A$1:$S$39,Sheet2!O$2,FALSE())","tb":1,"v":"3.4"}},{"r":5,"c":15,"v":{"f":"=VLOOKUP($C6,Sheet1!$A$1:$S$39,Sheet2!P$2,FALSE())","tb":1,"v":"1629043612"}},{"r":5,"c":16,"v":{"f":"=VLOOKUP($C6,Sheet1!$A$1:$S$39,Sheet2!Q$2,FALSE())","tb":1,"v":"231326.5"}},{"r":5,"c":17,"v":{"f":"=VLOOKUP($C6,Sheet1!$A$1:$S$39,Sheet2!R$2,FALSE())","tb":1,"v":"1629043612"}},{"r":5,"c":18,"v":{"f":"=VLOOKUP($C6,Sheet1!$A$1:$S$39,Sheet2!S$2,FALSE())","tb":1,"v":"231326.5"}},{"r":6,"c":2,"v":{"f":"=Sheet1!A4","tb":1,"v":"天津"}},{"r":6,"c":3,"v":{"f":"=VLOOKUP($C7,Sheet1!$A$1:$S$39,Sheet2!D$2,FALSE())","tb":1,"v":"197102644"}},{"r":6,"c":4,"v":{"f":"=VLOOKUP($C7,Sheet1!$A$1:$S$39,Sheet2!E$2,FALSE())","tb":1,"v":"35879.800000000003"}},{"r":6,"c":5,"v":{"f":"=VLOOKUP($C7,Sheet1!$A$1:$S$39,Sheet2!F$2,FALSE())","tb":1,"v":"101723824.09999999"}},{"r":6,"c":6,"v":{"f":"=VLOOKUP($C7,Sheet1!$A$1:$S$39,Sheet2!G$2,FALSE())","tb":1,"v":"16908.5"}},{"r":6,"c":7,"v":{"f":"=VLOOKUP($C7,Sheet1!$A$1:$S$39,Sheet2!H$2,FALSE())","tb":1,"v":"95378819.900000006"}},{"r":6,"c":8,"v":{"f":"=VLOOKUP($C7,Sheet1!$A$1:$S$39,Sheet2!I$2,FALSE())","tb":1,"v":"18971.3"}},{"r":6,"c":9,"v":{"f":"=VLOOKUP($C7,Sheet1!$A$1:$S$39,Sheet2!J$2,FALSE())","tb":1,"v":"34415232.600000001"}},{"r":6,"c":10,"v":{"f":"=VLOOKUP($C7,Sheet1!$A$1:$S$39,Sheet2!K$2,FALSE())","tb":1,"v":"6882.2"}},{"r":6,"c":11,"v":{"f":"=VLOOKUP($C7,Sheet1!$A$1:$S$39,Sheet2!L$2,FALSE())","tb":1,"v":"4512011.2"}},{"r":6,"c":12,"v":{"f":"=VLOOKUP($C7,Sheet1!$A$1:$S$39,Sheet2!M$2,FALSE())","tb":1,"v":"812.5"}},{"r":6,"c":13,"v":{"f":"=VLOOKUP($C7,Sheet1!$A$1:$S$39,Sheet2!N$2,FALSE())","tb":1,"v":"29903221.399999999"}},{"r":6,"c":14,"v":{"f":"=VLOOKUP($C7,Sheet1!$A$1:$S$39,Sheet2!O$2,FALSE())","tb":1,"v":"6069.6"}},{"r":6,"c":15,"v":{"f":"=VLOOKUP($C7,Sheet1!$A$1:$S$39,Sheet2!P$2,FALSE())","tb":1,"v":"162687411.40000001"}},{"r":6,"c":16,"v":{"f":"=VLOOKUP($C7,Sheet1!$A$1:$S$39,Sheet2!Q$2,FALSE())","tb":1,"v":"28997.599999999999"}},{"r":6,"c":17,"v":{"f":"=VLOOKUP($C7,Sheet1!$A$1:$S$39,Sheet2!R$2,FALSE())","tb":1,"v":"97211812.900000006"}},{"r":6,"c":18,"v":{"f":"=VLOOKUP($C7,Sheet1!$A$1:$S$39,Sheet2!S$2,FALSE())","tb":1,"v":"16096"}},{"r":7,"c":2,"v":{"f":"=Sheet1!A5","tb":1,"v":"河北"}},{"r":7,"c":3,"v":{"f":"=VLOOKUP($C8,Sheet1!$A$1:$S$39,Sheet2!D$2,FALSE())","tb":1,"v":"375906003.19999999"}},{"r":7,"c":4,"v":{"f":"=VLOOKUP($C8,Sheet1!$A$1:$S$39,Sheet2!E$2,FALSE())","tb":1,"v":"72168.800000000003"}},{"r":7,"c":5,"v":{"f":"=VLOOKUP($C8,Sheet1!$A$1:$S$39,Sheet2!F$2,FALSE())","tb":1,"v":"110165771.5"}},{"r":7,"c":6,"v":{"f":"=VLOOKUP($C8,Sheet1!$A$1:$S$39,Sheet2!G$2,FALSE())","tb":1,"v":"19157.8"}},{"r":7,"c":7,"v":{"f":"=VLOOKUP($C8,Sheet1!$A$1:$S$39,Sheet2!H$2,FALSE())","tb":1,"v":"265740231.69999999"}},{"r":7,"c":8,"v":{"f":"=VLOOKUP($C8,Sheet1!$A$1:$S$39,Sheet2!I$2,FALSE())","tb":1,"v":"53011.1"}},{"r":7,"c":9,"v":{"f":"=VLOOKUP($C8,Sheet1!$A$1:$S$39,Sheet2!J$2,FALSE())","tb":1,"v":"170439887.19999999"}},{"r":7,"c":10,"v":{"f":"=VLOOKUP($C8,Sheet1!$A$1:$S$39,Sheet2!K$2,FALSE())","tb":1,"v":"34131.199999999997"}},{"r":7,"c":11,"v":{"f":"=VLOOKUP($C8,Sheet1!$A$1:$S$39,Sheet2!L$2,FALSE())","tb":1,"v":"3009197.5"}},{"r":7,"c":12,"v":{"f":"=VLOOKUP($C8,Sheet1!$A$1:$S$39,Sheet2!M$2,FALSE())","tb":1,"v":"531.9"}},{"r":7,"c":13,"v":{"f":"=VLOOKUP($C8,Sheet1!$A$1:$S$39,Sheet2!N$2,FALSE())","tb":1,"v":"167430689.69999999"}},{"r":7,"c":14,"v":{"f":"=VLOOKUP($C8,Sheet1!$A$1:$S$39,Sheet2!O$2,FALSE())","tb":1,"v":"33599.4"}},{"r":7,"c":15,"v":{"f":"=VLOOKUP($C8,Sheet1!$A$1:$S$39,Sheet2!P$2,FALSE())","tb":1,"v":"205466116"}},{"r":7,"c":16,"v":{"f":"=VLOOKUP($C8,Sheet1!$A$1:$S$39,Sheet2!Q$2,FALSE())","tb":1,"v":"38037.599999999999"}},{"r":7,"c":17,"v":{"f":"=VLOOKUP($C8,Sheet1!$A$1:$S$39,Sheet2!R$2,FALSE())","tb":1,"v":"107156574"}},{"r":7,"c":18,"v":{"f":"=VLOOKUP($C8,Sheet1!$A$1:$S$39,Sheet2!S$2,FALSE())","tb":1,"v":"18625.900000000001"}},{"r":8,"c":2,"v":{"f":"=Sheet1!A6","tb":1,"v":"山西"}},{"r":8,"c":3,"v":{"f":"=VLOOKUP($C9,Sheet1!$A$1:$S$39,Sheet2!D$2,FALSE())","tb":1,"v":"399821780.5"}},{"r":8,"c":4,"v":{"f":"=VLOOKUP($C9,Sheet1!$A$1:$S$39,Sheet2!E$2,FALSE())","tb":1,"v":"71645.600000000006"}},{"r":8,"c":5,"v":{"f":"=VLOOKUP($C9,Sheet1!$A$1:$S$39,Sheet2!F$2,FALSE())","tb":1,"v":"141027648.09999999"}},{"r":8,"c":6,"v":{"f":"=VLOOKUP($C9,Sheet1!$A$1:$S$39,Sheet2!G$2,FALSE())","tb":1,"v":"22877"}},{"r":8,"c":7,"v":{"f":"=VLOOKUP($C9,Sheet1!$A$1:$S$39,Sheet2!H$2,FALSE())","tb":1,"v":"258794132.40000001"}},{"r":8,"c":8,"v":{"f":"=VLOOKUP($C9,Sheet1!$A$1:$S$39,Sheet2!I$2,FALSE())","tb":1,"v":"48768.7"}},{"r":8,"c":9,"v":{"f":"=VLOOKUP($C9,Sheet1!$A$1:$S$39,Sheet2!J$2,FALSE())","tb":1,"v":"161910575.90000001"}},{"r":8,"c":10,"v":{"f":"=VLOOKUP($C9,Sheet1!$A$1:$S$39,Sheet2!K$2,FALSE())","tb":1,"v":"30756.7"}},{"r":8,"c":11,"v":{"f":"=VLOOKUP($C9,Sheet1!$A$1:$S$39,Sheet2!L$2,FALSE())","tb":1,"v":"4719394.5"}},{"r":8,"c":12,"v":{"f":"=VLOOKUP($C9,Sheet1!$A$1:$S$39,Sheet2!M$2,FALSE())","tb":1,"v":"834"}},{"r":8,"c":13,"v":{"f":"=VLOOKUP($C9,Sheet1!$A$1:$S$39,Sheet2!N$2,FALSE())","tb":1,"v":"157191181.40000001"}},{"r":8,"c":14,"v":{"f":"=VLOOKUP($C9,Sheet1!$A$1:$S$39,Sheet2!O$2,FALSE())","tb":1,"v":"29922.7"}},{"r":8,"c":15,"v":{"f":"=VLOOKUP($C9,Sheet1!$A$1:$S$39,Sheet2!P$2,FALSE())","tb":1,"v":"237911204.59999999"}},{"r":8,"c":16,"v":{"f":"=VLOOKUP($C9,Sheet1!$A$1:$S$39,Sheet2!Q$2,FALSE())","tb":1,"v":"40888.9"}},{"r":8,"c":17,"v":{"f":"=VLOOKUP($C9,Sheet1!$A$1:$S$39,Sheet2!R$2,FALSE())","tb":1,"v":"136308253.59999999"}},{"r":8,"c":18,"v":{"f":"=VLOOKUP($C9,Sheet1!$A$1:$S$39,Sheet2!S$2,FALSE())","tb":1,"v":"22042.9"}},{"r":9,"c":2,"v":{"f":"=Sheet1!A7","tb":1,"v":"河南"}},{"r":9,"c":3,"v":{"f":"=VLOOKUP($C10,Sheet1!$A$1:$S$39,Sheet2!D$2,FALSE())","tb":1,"v":"920677504.20000005"}},{"r":9,"c":4,"v":{"f":"=VLOOKUP($C10,Sheet1!$A$1:$S$39,Sheet2!E$2,FALSE())","tb":1,"v":"167568.5"}},{"r":9,"c":5,"v":{"f":"=VLOOKUP($C10,Sheet1!$A$1:$S$39,Sheet2!F$2,FALSE())","tb":1,"v":"289753107.89999998"}},{"r":9,"c":6,"v":{"f":"=VLOOKUP($C10,Sheet1!$A$1:$S$39,Sheet2!G$2,FALSE())","tb":1,"v":"47977.599999999999"}},{"r":9,"c":7,"v":{"f":"=VLOOKUP($C10,Sheet1!$A$1:$S$39,Sheet2!H$2,FALSE())","tb":1,"v":"630924396.29999995"}},{"r":9,"c":8,"v":{"f":"=VLOOKUP($C10,Sheet1!$A$1:$S$39,Sheet2!I$2,FALSE())","tb":1,"v":"119590.9"}},{"r":9,"c":9,"v":{"f":"=VLOOKUP($C10,Sheet1!$A$1:$S$39,Sheet2!J$2,FALSE())","tb":1,"v":"142879264.59999999"}},{"r":9,"c":10,"v":{"f":"=VLOOKUP($C10,Sheet1!$A$1:$S$39,Sheet2!K$2,FALSE())","tb":1,"v":"26971.3"}},{"r":9,"c":11,"v":{"f":"=VLOOKUP($C10,Sheet1!$A$1:$S$39,Sheet2!L$2,FALSE())","tb":1,"v":"10949355"}},{"r":9,"c":12,"v":{"f":"=VLOOKUP($C10,Sheet1!$A$1:$S$39,Sheet2!M$2,FALSE())","tb":1,"v":"1889"}},{"r":9,"c":13,"v":{"f":"=VLOOKUP($C10,Sheet1!$A$1:$S$39,Sheet2!N$2,FALSE())","tb":1,"v":"131929909.59999999"}},{"r":9,"c":14,"v":{"f":"=VLOOKUP($C10,Sheet1!$A$1:$S$39,Sheet2!O$2,FALSE())","tb":1,"v":"25082.3"}},{"r":9,"c":15,"v":{"f":"=VLOOKUP($C10,Sheet1!$A$1:$S$39,Sheet2!P$2,FALSE())","tb":1,"v":"777798239.60000002"}},{"r":9,"c":16,"v":{"f":"=VLOOKUP($C10,Sheet1!$A$1:$S$39,Sheet2!Q$2,FALSE())","tb":1,"v":"140597.20000000001"}},{"r":9,"c":17,"v":{"f":"=VLOOKUP($C10,Sheet1!$A$1:$S$39,Sheet2!R$2,FALSE())","tb":1,"v":"278803752.89999998"}},{"r":9,"c":18,"v":{"f":"=VLOOKUP($C10,Sheet1!$A$1:$S$39,Sheet2!S$2,FALSE())","tb":1,"v":"46088.6"}},{"r":10,"c":2,"v":{"f":"=Sheet1!A8","tb":1,"v":"山东"}},{"r":10,"c":3,"v":{"f":"=VLOOKUP($C11,Sheet1!$A$1:$S$39,Sheet2!D$2,FALSE())","tb":1,"v":"921338354"}},{"r":10,"c":4,"v":{"f":"=VLOOKUP($C11,Sheet1!$A$1:$S$39,Sheet2!E$2,FALSE())","tb":1,"v":"174357.5"}},{"r":10,"c":5,"v":{"f":"=VLOOKUP($C11,Sheet1!$A$1:$S$39,Sheet2!F$2,FALSE())","tb":1,"v":"379283246.69999999"}},{"r":10,"c":6,"v":{"f":"=VLOOKUP($C11,Sheet1!$A$1:$S$39,Sheet2!G$2,FALSE())","tb":1,"v":"65057.2"}},{"r":10,"c":7,"v":{"f":"=VLOOKUP($C11,Sheet1!$A$1:$S$39,Sheet2!H$2,FALSE())","tb":1,"v":"542055107.29999995"}},{"r":10,"c":8,"v":{"f":"=VLOOKUP($C11,Sheet1!$A$1:$S$39,Sheet2!I$2,FALSE())","tb":1,"v":"109300.4"}},{"r":10,"c":9,"v":{"f":"=VLOOKUP($C11,Sheet1!$A$1:$S$39,Sheet2!J$2,FALSE())","tb":1,"v":"312142178.30000001"}},{"r":10,"c":10,"v":{"f":"=VLOOKUP($C11,Sheet1!$A$1:$S$39,Sheet2!K$2,FALSE())","tb":1,"v":"63198.5"}},{"r":10,"c":11,"v":{"f":"=VLOOKUP($C11,Sheet1!$A$1:$S$39,Sheet2!L$2,FALSE())","tb":1,"v":"25815498.699999999"}},{"r":10,"c":12,"v":{"f":"=VLOOKUP($C11,Sheet1!$A$1:$S$39,Sheet2!M$2,FALSE())","tb":1,"v":"4692.8999999999996"}},{"r":10,"c":13,"v":{"f":"=VLOOKUP($C11,Sheet1!$A$1:$S$39,Sheet2!N$2,FALSE())","tb":1,"v":"286326679.60000002"}},{"r":10,"c":14,"v":{"f":"=VLOOKUP($C11,Sheet1!$A$1:$S$39,Sheet2!O$2,FALSE())","tb":1,"v":"58505.7"}},{"r":10,"c":15,"v":{"f":"=VLOOKUP($C11,Sheet1!$A$1:$S$39,Sheet2!P$2,FALSE())","tb":1,"v":"609196175.70000005"}},{"r":10,"c":16,"v":{"f":"=VLOOKUP($C11,Sheet1!$A$1:$S$39,Sheet2!Q$2,FALSE())","tb":1,"v":"111159"}},{"r":10,"c":17,"v":{"f":"=VLOOKUP($C11,Sheet1!$A$1:$S$39,Sheet2!R$2,FALSE())","tb":1,"v":"353467748"}},{"r":10,"c":18,"v":{"f":"=VLOOKUP($C11,Sheet1!$A$1:$S$39,Sheet2!S$2,FALSE())","tb":1,"v":"60364.3"}},{"r":11,"c":2,"v":{"f":"=Sheet1!A9","tb":1,"v":"上海"}},{"r":11,"c":3,"v":{"f":"=VLOOKUP($C12,Sheet1!$A$1:$S$39,Sheet2!D$2,FALSE())","tb":1,"v":"700158371.79999995"}},{"r":11,"c":4,"v":{"f":"=VLOOKUP($C12,Sheet1!$A$1:$S$39,Sheet2!E$2,FALSE())","tb":1,"v":"114934.7"}},{"r":11,"c":5,"v":{"f":"=VLOOKUP($C12,Sheet1!$A$1:$S$39,Sheet2!F$2,FALSE())","tb":1,"v":"339869447.69999999"}},{"r":11,"c":6,"v":{"f":"=VLOOKUP($C12,Sheet1!$A$1:$S$39,Sheet2!G$2,FALSE())","tb":1,"v":"47104.800000000003"}},{"r":11,"c":7,"v":{"f":"=VLOOKUP($C12,Sheet1!$A$1:$S$39,Sheet2!H$2,FALSE())","tb":1,"v":"360288924.10000002"}},{"r":11,"c":8,"v":{"f":"=VLOOKUP($C12,Sheet1!$A$1:$S$39,Sheet2!I$2,FALSE())","tb":1,"v":"67829.899999999994"}},{"r":11,"c":9,"v":{"f":"=VLOOKUP($C12,Sheet1!$A$1:$S$39,Sheet2!J$2,FALSE())","tb":1,"v":"113310877.59999999"}},{"r":11,"c":10,"v":{"f":"=VLOOKUP($C12,Sheet1!$A$1:$S$39,Sheet2!K$2,FALSE())","tb":1,"v":"22652.9"}},{"r":11,"c":11,"v":{"f":"=VLOOKUP($C12,Sheet1!$A$1:$S$39,Sheet2!L$2,FALSE())","tb":1,"v":"8785937.0999999996"}},{"r":11,"c":12,"v":{"f":"=VLOOKUP($C12,Sheet1!$A$1:$S$39,Sheet2!M$2,FALSE())","tb":1,"v":"1447.7"}},{"r":11,"c":13,"v":{"f":"=VLOOKUP($C12,Sheet1!$A$1:$S$39,Sheet2!N$2,FALSE())","tb":1,"v":"104524940.5"}},{"r":11,"c":14,"v":{"f":"=VLOOKUP($C12,Sheet1!$A$1:$S$39,Sheet2!O$2,FALSE())","tb":1,"v":"21205.200000000001"}},{"r":11,"c":15,"v":{"f":"=VLOOKUP($C12,Sheet1!$A$1:$S$39,Sheet2!P$2,FALSE())","tb":1,"v":"586847494.20000005"}},{"r":11,"c":16,"v":{"f":"=VLOOKUP($C12,Sheet1!$A$1:$S$39,Sheet2!Q$2,FALSE())","tb":1,"v":"92281.8"}},{"r":11,"c":17,"v":{"f":"=VLOOKUP($C12,Sheet1!$A$1:$S$39,Sheet2!R$2,FALSE())","tb":1,"v":"331083510.60000002"}},{"r":11,"c":18,"v":{"f":"=VLOOKUP($C12,Sheet1!$A$1:$S$39,Sheet2!S$2,FALSE())","tb":1,"v":"45657.1"}},{"r":12,"c":2,"v":{"f":"=Sheet1!A10","tb":1,"v":"江苏"}},{"r":12,"c":3,"v":{"f":"=VLOOKUP($C13,Sheet1!$A$1:$S$39,Sheet2!D$2,FALSE())","tb":1,"v":"2328408620.5999999"}},{"r":12,"c":4,"v":{"f":"=VLOOKUP($C13,Sheet1!$A$1:$S$39,Sheet2!E$2,FALSE())","tb":1,"v":"385231.7"}},{"r":12,"c":5,"v":{"f":"=VLOOKUP($C13,Sheet1!$A$1:$S$39,Sheet2!F$2,FALSE())","tb":1,"v":"1457308176.4000001"}},{"r":12,"c":6,"v":{"f":"=VLOOKUP($C13,Sheet1!$A$1:$S$39,Sheet2!G$2,FALSE())","tb":1,"v":"218871.5"}},{"r":12,"c":7,"v":{"f":"=VLOOKUP($C13,Sheet1!$A$1:$S$39,Sheet2!H$2,FALSE())","tb":1,"v":"871100444.20000005"}},{"r":12,"c":8,"v":{"f":"=VLOOKUP($C13,Sheet1!$A$1:$S$39,Sheet2!I$2,FALSE())","tb":1,"v":"166360.20000000001"}},{"r":12,"c":9,"v":{"f":"=VLOOKUP($C13,Sheet1!$A$1:$S$39,Sheet2!J$2,FALSE())","tb":1,"v":"321834979.60000002"}},{"r":12,"c":10,"v":{"f":"=VLOOKUP($C13,Sheet1!$A$1:$S$39,Sheet2!K$2,FALSE())","tb":1,"v":"63399.7"}},{"r":12,"c":11,"v":{"f":"=VLOOKUP($C13,Sheet1!$A$1:$S$39,Sheet2!L$2,FALSE())","tb":1,"v":"23638030"}},{"r":12,"c":12,"v":{"f":"=VLOOKUP($C13,Sheet1!$A$1:$S$39,Sheet2!M$2,FALSE())","tb":1,"v":"4164.1000000000004"}},{"r":12,"c":13,"v":{"f":"=VLOOKUP($C13,Sheet1!$A$1:$S$39,Sheet2!N$2,FALSE())","tb":1,"v":"298196949.60000002"}},{"r":12,"c":14,"v":{"f":"=VLOOKUP($C13,Sheet1!$A$1:$S$39,Sheet2!O$2,FALSE())","tb":1,"v":"59235.6"}},{"r":12,"c":15,"v":{"f":"=VLOOKUP($C13,Sheet1!$A$1:$S$39,Sheet2!P$2,FALSE())","tb":1,"v":"2006573641.0999999"}},{"r":12,"c":16,"v":{"f":"=VLOOKUP($C13,Sheet1!$A$1:$S$39,Sheet2!Q$2,FALSE())","tb":1,"v":"321832"}},{"r":12,"c":17,"v":{"f":"=VLOOKUP($C13,Sheet1!$A$1:$S$39,Sheet2!R$2,FALSE())","tb":1,"v":"1433670146.4000001"}},{"r":12,"c":18,"v":{"f":"=VLOOKUP($C13,Sheet1!$A$1:$S$39,Sheet2!S$2,FALSE())","tb":1,"v":"214707.5"}},{"r":13,"c":2,"v":{"f":"=Sheet1!A11","tb":1,"v":"浙江"}},{"r":13,"c":3,"v":{"f":"=VLOOKUP($C14,Sheet1!$A$1:$S$39,Sheet2!D$2,FALSE())","tb":1,"v":"3209097346.5999999"}},{"r":13,"c":4,"v":{"f":"=VLOOKUP($C14,Sheet1!$A$1:$S$39,Sheet2!E$2,FALSE())","tb":1,"v":"555509.9"}},{"r":13,"c":5,"v":{"f":"=VLOOKUP($C14,Sheet1!$A$1:$S$39,Sheet2!F$2,FALSE())","tb":1,"v":"1770617611.3"}},{"r":13,"c":6,"v":{"f":"=VLOOKUP($C14,Sheet1!$A$1:$S$39,Sheet2!G$2,FALSE())","tb":1,"v":"282921"}},{"r":13,"c":7,"v":{"f":"=VLOOKUP($C14,Sheet1!$A$1:$S$39,Sheet2!H$2,FALSE())","tb":1,"v":"1438479735.3"}},{"r":13,"c":8,"v":{"f":"=VLOOKUP($C14,Sheet1!$A$1:$S$39,Sheet2!I$2,FALSE())","tb":1,"v":"272588.90000000002"}},{"r":13,"c":9,"v":{"f":"=VLOOKUP($C14,Sheet1!$A$1:$S$39,Sheet2!J$2,FALSE())","tb":1,"v":"547121572.20000005"}},{"r":13,"c":10,"v":{"f":"=VLOOKUP($C14,Sheet1!$A$1:$S$39,Sheet2!K$2,FALSE())","tb":1,"v":"105286.6"}},{"r":13,"c":11,"v":{"f":"=VLOOKUP($C14,Sheet1!$A$1:$S$39,Sheet2!L$2,FALSE())","tb":1,"v":"20516147.600000001"}},{"r":13,"c":12,"v":{"f":"=VLOOKUP($C14,Sheet1!$A$1:$S$39,Sheet2!M$2,FALSE())","tb":1,"v":"3551.9"}},{"r":13,"c":13,"v":{"f":"=VLOOKUP($C14,Sheet1!$A$1:$S$39,Sheet2!N$2,FALSE())","tb":1,"v":"526605424.60000002"}},{"r":13,"c":14,"v":{"f":"=VLOOKUP($C14,Sheet1!$A$1:$S$39,Sheet2!O$2,FALSE())","tb":1,"v":"101734.7"}},{"r":13,"c":15,"v":{"f":"=VLOOKUP($C14,Sheet1!$A$1:$S$39,Sheet2!P$2,FALSE())","tb":1,"v":"2661975774.4000001"}},{"r":13,"c":16,"v":{"f":"=VLOOKUP($C14,Sheet1!$A$1:$S$39,Sheet2!Q$2,FALSE())","tb":1,"v":"450223.3"}},{"r":13,"c":17,"v":{"f":"=VLOOKUP($C14,Sheet1!$A$1:$S$39,Sheet2!R$2,FALSE())","tb":1,"v":"1750101463.7"}},{"r":13,"c":18,"v":{"f":"=VLOOKUP($C14,Sheet1!$A$1:$S$39,Sheet2!S$2,FALSE())","tb":1,"v":"279369.09999999998"}},{"r":14,"c":2,"v":{"f":"=Sheet1!A12","tb":1,"v":"福建"}},{"r":14,"c":3,"v":{"f":"=VLOOKUP($C15,Sheet1!$A$1:$S$39,Sheet2!D$2,FALSE())","tb":1,"v":"821056177.29999995"}},{"r":14,"c":4,"v":{"f":"=VLOOKUP($C15,Sheet1!$A$1:$S$39,Sheet2!E$2,FALSE())","tb":1,"v":"143190.79999999999"}},{"r":14,"c":5,"v":{"f":"=VLOOKUP($C15,Sheet1!$A$1:$S$39,Sheet2!F$2,FALSE())","tb":1,"v":"481154195.89999998"}},{"r":14,"c":6,"v":{"f":"=VLOOKUP($C15,Sheet1!$A$1:$S$39,Sheet2!G$2,FALSE())","tb":1,"v":"77969.899999999994"}},{"r":14,"c":7,"v":{"f":"=VLOOKUP($C15,Sheet1!$A$1:$S$39,Sheet2!H$2,FALSE())","tb":1,"v":"339901981.39999998"}},{"r":14,"c":8,"v":{"f":"=VLOOKUP($C15,Sheet1!$A$1:$S$39,Sheet2!I$2,FALSE())","tb":1,"v":"65220.800000000003"}},{"r":14,"c":9,"v":{"f":"=VLOOKUP($C15,Sheet1!$A$1:$S$39,Sheet2!J$2,FALSE())","tb":1,"v":"114980444.2"}},{"r":14,"c":10,"v":{"f":"=VLOOKUP($C15,Sheet1!$A$1:$S$39,Sheet2!K$2,FALSE())","tb":1,"v":"22484.6"}},{"r":14,"c":11,"v":{"f":"=VLOOKUP($C15,Sheet1!$A$1:$S$39,Sheet2!L$2,FALSE())","tb":1,"v":"3744250"}},{"r":14,"c":12,"v":{"f":"=VLOOKUP($C15,Sheet1!$A$1:$S$39,Sheet2!M$2,FALSE())","tb":1,"v":"654"}},{"r":14,"c":13,"v":{"f":"=VLOOKUP($C15,Sheet1!$A$1:$S$39,Sheet2!N$2,FALSE())","tb":1,"v":"111236194.2"}},{"r":14,"c":14,"v":{"f":"=VLOOKUP($C15,Sheet1!$A$1:$S$39,Sheet2!O$2,FALSE())","tb":1,"v":"21830.6"}},{"r":14,"c":15,"v":{"f":"=VLOOKUP($C15,Sheet1!$A$1:$S$39,Sheet2!P$2,FALSE())","tb":1,"v":"706075733.10000002"}},{"r":14,"c":16,"v":{"f":"=VLOOKUP($C15,Sheet1!$A$1:$S$39,Sheet2!Q$2,FALSE())","tb":1,"v":"120706.1"}},{"r":14,"c":17,"v":{"f":"=VLOOKUP($C15,Sheet1!$A$1:$S$39,Sheet2!R$2,FALSE())","tb":1,"v":"477409945.89999998"}},{"r":14,"c":18,"v":{"f":"=VLOOKUP($C15,Sheet1!$A$1:$S$39,Sheet2!S$2,FALSE())","tb":1,"v":"77315.899999999994"}},{"r":15,"c":2,"v":{"f":"=Sheet1!A13","tb":1,"v":"安徽"}},{"r":15,"c":3,"v":{"f":"=VLOOKUP($C16,Sheet1!$A$1:$S$39,Sheet2!D$2,FALSE())","tb":1,"v":"897439716.89999998"}},{"r":15,"c":4,"v":{"f":"=VLOOKUP($C16,Sheet1!$A$1:$S$39,Sheet2!E$2,FALSE())","tb":1,"v":"143880.6"}},{"r":15,"c":5,"v":{"f":"=VLOOKUP($C16,Sheet1!$A$1:$S$39,Sheet2!F$2,FALSE())","tb":1,"v":"479411987.19999999"}},{"r":15,"c":6,"v":{"f":"=VLOOKUP($C16,Sheet1!$A$1:$S$39,Sheet2!G$2,FALSE())","tb":1,"v":"68040.399999999994"}},{"r":15,"c":7,"v":{"f":"=VLOOKUP($C16,Sheet1!$A$1:$S$39,Sheet2!H$2,FALSE())","tb":1,"v":"418027729.69999999"}},{"r":15,"c":8,"v":{"f":"=VLOOKUP($C16,Sheet1!$A$1:$S$39,Sheet2!I$2,FALSE())","tb":1,"v":"75840.2"}},{"r":15,"c":9,"v":{"f":"=VLOOKUP($C16,Sheet1!$A$1:$S$39,Sheet2!J$2,FALSE())","tb":1,"v":"175178199.40000001"}},{"r":15,"c":10,"v":{"f":"=VLOOKUP($C16,Sheet1!$A$1:$S$39,Sheet2!K$2,FALSE())","tb":1,"v":"33304.9"}},{"r":15,"c":11,"v":{"f":"=VLOOKUP($C16,Sheet1!$A$1:$S$39,Sheet2!L$2,FALSE())","tb":1,"v":"11227370"}},{"r":15,"c":12,"v":{"f":"=VLOOKUP($C16,Sheet1!$A$1:$S$39,Sheet2!M$2,FALSE())","tb":1,"v":"1955"}},{"r":15,"c":13,"v":{"f":"=VLOOKUP($C16,Sheet1!$A$1:$S$39,Sheet2!N$2,FALSE())","tb":1,"v":"163950829.40000001"}},{"r":15,"c":14,"v":{"f":"=VLOOKUP($C16,Sheet1!$A$1:$S$39,Sheet2!O$2,FALSE())","tb":1,"v":"31349.9"}},{"r":15,"c":15,"v":{"f":"=VLOOKUP($C16,Sheet1!$A$1:$S$39,Sheet2!P$2,FALSE())","tb":1,"v":"722261517.5"}},{"r":15,"c":16,"v":{"f":"=VLOOKUP($C16,Sheet1!$A$1:$S$39,Sheet2!Q$2,FALSE())","tb":1,"v":"110575.6"}},{"r":15,"c":17,"v":{"f":"=VLOOKUP($C16,Sheet1!$A$1:$S$39,Sheet2!R$2,FALSE())","tb":1,"v":"468184617.19999999"}},{"r":15,"c":18,"v":{"f":"=VLOOKUP($C16,Sheet1!$A$1:$S$39,Sheet2!S$2,FALSE())","tb":1,"v":"66085.399999999994"}},{"r":16,"c":2,"v":{"f":"=Sheet1!A14","tb":1,"v":"江西"}},{"r":16,"c":3,"v":{"f":"=VLOOKUP($C17,Sheet1!$A$1:$S$39,Sheet2!D$2,FALSE())","tb":1,"v":"424480898.10000002"}},{"r":16,"c":4,"v":{"f":"=VLOOKUP($C17,Sheet1!$A$1:$S$39,Sheet2!E$2,FALSE())","tb":1,"v":"77887"}},{"r":16,"c":5,"v":{"f":"=VLOOKUP($C17,Sheet1!$A$1:$S$39,Sheet2!F$2,FALSE())","tb":1,"v":"104105580.8"}},{"r":16,"c":6,"v":{"f":"=VLOOKUP($C17,Sheet1!$A$1:$S$39,Sheet2!G$2,FALSE())","tb":1,"v":"17673.099999999999"}},{"r":16,"c":7,"v":{"f":"=VLOOKUP($C17,Sheet1!$A$1:$S$39,Sheet2!H$2,FALSE())","tb":1,"v":"320375317.30000001"}},{"r":16,"c":8,"v":{"f":"=VLOOKUP($C17,Sheet1!$A$1:$S$39,Sheet2!I$2,FALSE())","tb":1,"v":"60213.8"}},{"r":16,"c":9,"v":{"f":"=VLOOKUP($C17,Sheet1!$A$1:$S$39,Sheet2!J$2,FALSE())","tb":1,"v":"203787204"}},{"r":16,"c":10,"v":{"f":"=VLOOKUP($C17,Sheet1!$A$1:$S$39,Sheet2!K$2,FALSE())","tb":1,"v":"38057.4"}},{"r":16,"c":11,"v":{"f":"=VLOOKUP($C17,Sheet1!$A$1:$S$39,Sheet2!L$2,FALSE())","tb":1,"v":"4484151.0999999996"}},{"r":16,"c":12,"v":{"f":"=VLOOKUP($C17,Sheet1!$A$1:$S$39,Sheet2!M$2,FALSE())","tb":1,"v":"768.4"}},{"r":16,"c":13,"v":{"f":"=VLOOKUP($C17,Sheet1!$A$1:$S$39,Sheet2!N$2,FALSE())","tb":1,"v":"199303052.90000001"}},{"r":16,"c":14,"v":{"f":"=VLOOKUP($C17,Sheet1!$A$1:$S$39,Sheet2!O$2,FALSE())","tb":1,"v":"37289"}},{"r":16,"c":15,"v":{"f":"=VLOOKUP($C17,Sheet1!$A$1:$S$39,Sheet2!P$2,FALSE())","tb":1,"v":"220693694.09999999"}},{"r":16,"c":16,"v":{"f":"=VLOOKUP($C17,Sheet1!$A$1:$S$39,Sheet2!Q$2,FALSE())","tb":1,"v":"39829.599999999999"}},{"r":16,"c":17,"v":{"f":"=VLOOKUP($C17,Sheet1!$A$1:$S$39,Sheet2!R$2,FALSE())","tb":1,"v":"99621429.700000003"}},{"r":16,"c":18,"v":{"f":"=VLOOKUP($C17,Sheet1!$A$1:$S$39,Sheet2!S$2,FALSE())","tb":1,"v":"16904.8"}},{"r":17,"c":2,"v":{"f":"=Sheet1!A15","tb":1,"v":"湖北"}},{"r":17,"c":3,"v":{"f":"=VLOOKUP($C18,Sheet1!$A$1:$S$39,Sheet2!D$2,FALSE())","tb":1,"v":"400208110.19999999"}},{"r":17,"c":4,"v":{"f":"=VLOOKUP($C18,Sheet1!$A$1:$S$39,Sheet2!E$2,FALSE())","tb":1,"v":"69090.2"}},{"r":17,"c":5,"v":{"f":"=VLOOKUP($C18,Sheet1!$A$1:$S$39,Sheet2!F$2,FALSE())","tb":1,"v":"183618936.69999999"}},{"r":17,"c":6,"v":{"f":"=VLOOKUP($C18,Sheet1!$A$1:$S$39,Sheet2!G$2,FALSE())","tb":1,"v":"28662.1"}},{"r":17,"c":7,"v":{"f":"=VLOOKUP($C18,Sheet1!$A$1:$S$39,Sheet2!H$2,FALSE())","tb":1,"v":"216589173.40000001"}},{"r":17,"c":8,"v":{"f":"=VLOOKUP($C18,Sheet1!$A$1:$S$39,Sheet2!I$2,FALSE())","tb":1,"v":"40428.1"}},{"r":17,"c":9,"v":{"f":"=VLOOKUP($C18,Sheet1!$A$1:$S$39,Sheet2!J$2,FALSE())","tb":1,"v":"101799945.8"}},{"r":17,"c":10,"v":{"f":"=VLOOKUP($C18,Sheet1!$A$1:$S$39,Sheet2!K$2,FALSE())","tb":1,"v":"18829.3"}},{"r":17,"c":11,"v":{"f":"=VLOOKUP($C18,Sheet1!$A$1:$S$39,Sheet2!L$2,FALSE())","tb":1,"v":"8498576.9000000004"}},{"r":17,"c":12,"v":{"f":"=VLOOKUP($C18,Sheet1!$A$1:$S$39,Sheet2!M$2,FALSE())","tb":1,"v":"1297"}},{"r":17,"c":13,"v":{"f":"=VLOOKUP($C18,Sheet1!$A$1:$S$39,Sheet2!N$2,FALSE())","tb":1,"v":"93301368.900000006"}},{"r":17,"c":14,"v":{"f":"=VLOOKUP($C18,Sheet1!$A$1:$S$39,Sheet2!O$2,FALSE())","tb":1,"v":"17532.3"}},{"r":17,"c":15,"v":{"f":"=VLOOKUP($C18,Sheet1!$A$1:$S$39,Sheet2!P$2,FALSE())","tb":1,"v":"298408164.39999998"}},{"r":17,"c":16,"v":{"f":"=VLOOKUP($C18,Sheet1!$A$1:$S$39,Sheet2!Q$2,FALSE())","tb":1,"v":"50260.800000000003"}},{"r":17,"c":17,"v":{"f":"=VLOOKUP($C18,Sheet1!$A$1:$S$39,Sheet2!R$2,FALSE())","tb":1,"v":"175120359.80000001"}},{"r":17,"c":18,"v":{"f":"=VLOOKUP($C18,Sheet1!$A$1:$S$39,Sheet2!S$2,FALSE())","tb":1,"v":"27365.1"}},{"r":18,"c":2,"v":{"f":"=Sheet1!A16","tb":1,"v":"湖南"}},{"r":18,"c":3,"v":{"f":"=VLOOKUP($C19,Sheet1!$A$1:$S$39,Sheet2!D$2,FALSE())","tb":1,"v":"894856651.70000005"}},{"r":18,"c":4,"v":{"f":"=VLOOKUP($C19,Sheet1!$A$1:$S$39,Sheet2!E$2,FALSE())","tb":1,"v":"158871.6"}},{"r":18,"c":5,"v":{"f":"=VLOOKUP($C19,Sheet1!$A$1:$S$39,Sheet2!F$2,FALSE())","tb":1,"v":"526952555"}},{"r":18,"c":6,"v":{"f":"=VLOOKUP($C19,Sheet1!$A$1:$S$39,Sheet2!G$2,FALSE())","tb":1,"v":"88878.1"}},{"r":18,"c":7,"v":{"f":"=VLOOKUP($C19,Sheet1!$A$1:$S$39,Sheet2!H$2,FALSE())","tb":1,"v":"367904096.69999999"}},{"r":18,"c":8,"v":{"f":"=VLOOKUP($C19,Sheet1!$A$1:$S$39,Sheet2!I$2,FALSE())","tb":1,"v":"69993.5"}},{"r":18,"c":9,"v":{"f":"=VLOOKUP($C19,Sheet1!$A$1:$S$39,Sheet2!J$2,FALSE())","tb":1,"v":"151284562.30000001"}},{"r":18,"c":10,"v":{"f":"=VLOOKUP($C19,Sheet1!$A$1:$S$39,Sheet2!K$2,FALSE())","tb":1,"v":"28575.3"}},{"r":18,"c":11,"v":{"f":"=VLOOKUP($C19,Sheet1!$A$1:$S$39,Sheet2!L$2,FALSE())","tb":1,"v":"1746400"}},{"r":18,"c":12,"v":{"f":"=VLOOKUP($C19,Sheet1!$A$1:$S$39,Sheet2!M$2,FALSE())","tb":1,"v":"300"}},{"r":18,"c":13,"v":{"f":"=VLOOKUP($C19,Sheet1!$A$1:$S$39,Sheet2!N$2,FALSE())","tb":1,"v":"149538162.30000001"}},{"r":18,"c":14,"v":{"f":"=VLOOKUP($C19,Sheet1!$A$1:$S$39,Sheet2!O$2,FALSE())","tb":1,"v":"28275.3"}},{"r":18,"c":15,"v":{"f":"=VLOOKUP($C19,Sheet1!$A$1:$S$39,Sheet2!P$2,FALSE())","tb":1,"v":"743572089.39999998"}},{"r":18,"c":16,"v":{"f":"=VLOOKUP($C19,Sheet1!$A$1:$S$39,Sheet2!Q$2,FALSE())","tb":1,"v":"130296.2"}},{"r":18,"c":17,"v":{"f":"=VLOOKUP($C19,Sheet1!$A$1:$S$39,Sheet2!R$2,FALSE())","tb":1,"v":"525206155"}},{"r":18,"c":18,"v":{"f":"=VLOOKUP($C19,Sheet1!$A$1:$S$39,Sheet2!S$2,FALSE())","tb":1,"v":"88578.1"}},{"r":19,"c":2,"v":{"f":"=Sheet1!A17","tb":1,"v":"广东"}},{"r":19,"c":3,"v":{"f":"=VLOOKUP($C20,Sheet1!$A$1:$S$39,Sheet2!D$2,FALSE())","tb":1,"v":"2094063051.3"}},{"r":19,"c":4,"v":{"f":"=VLOOKUP($C20,Sheet1!$A$1:$S$39,Sheet2!E$2,FALSE())","tb":1,"v":"382884.5"}},{"r":19,"c":5,"v":{"f":"=VLOOKUP($C20,Sheet1!$A$1:$S$39,Sheet2!F$2,FALSE())","tb":1,"v":"1134410441"}},{"r":19,"c":6,"v":{"f":"=VLOOKUP($C20,Sheet1!$A$1:$S$39,Sheet2!G$2,FALSE())","tb":1,"v":"191533.7"}},{"r":19,"c":7,"v":{"f":"=VLOOKUP($C20,Sheet1!$A$1:$S$39,Sheet2!H$2,FALSE())","tb":1,"v":"959652610.39999998"}},{"r":19,"c":8,"v":{"f":"=VLOOKUP($C20,Sheet1!$A$1:$S$39,Sheet2!I$2,FALSE())","tb":1,"v":"191350.9"}},{"r":19,"c":9,"v":{"f":"=VLOOKUP($C20,Sheet1!$A$1:$S$39,Sheet2!J$2,FALSE())","tb":1,"v":"353601728.39999998"}},{"r":19,"c":10,"v":{"f":"=VLOOKUP($C20,Sheet1!$A$1:$S$39,Sheet2!K$2,FALSE())","tb":1,"v":"70785.600000000006"}},{"r":19,"c":11,"v":{"f":"=VLOOKUP($C20,Sheet1!$A$1:$S$39,Sheet2!L$2,FALSE())","tb":1,"v":"18461401.899999999"}},{"r":19,"c":12,"v":{"f":"=VLOOKUP($C20,Sheet1!$A$1:$S$39,Sheet2!M$2,FALSE())","tb":1,"v":"3207.8"}},{"r":19,"c":13,"v":{"f":"=VLOOKUP($C20,Sheet1!$A$1:$S$39,Sheet2!N$2,FALSE())","tb":1,"v":"335140326.5"}},{"r":19,"c":14,"v":{"f":"=VLOOKUP($C20,Sheet1!$A$1:$S$39,Sheet2!O$2,FALSE())","tb":1,"v":"67577.7"}},{"r":19,"c":15,"v":{"f":"=VLOOKUP($C20,Sheet1!$A$1:$S$39,Sheet2!P$2,FALSE())","tb":1,"v":"1740461323"}},{"r":19,"c":16,"v":{"f":"=VLOOKUP($C20,Sheet1!$A$1:$S$39,Sheet2!Q$2,FALSE())","tb":1,"v":"312099"}},{"r":19,"c":17,"v":{"f":"=VLOOKUP($C20,Sheet1!$A$1:$S$39,Sheet2!R$2,FALSE())","tb":1,"v":"1115949039.0999999"}},{"r":19,"c":18,"v":{"f":"=VLOOKUP($C20,Sheet1!$A$1:$S$39,Sheet2!S$2,FALSE())","tb":1,"v":"188325.8"}},{"r":20,"c":2,"v":{"f":"=Sheet1!A18","tb":1,"v":"广西"}},{"r":20,"c":3,"v":{"f":"=VLOOKUP($C21,Sheet1!$A$1:$S$39,Sheet2!D$2,FALSE())","tb":1,"v":"881928162.60000002"}},{"r":20,"c":4,"v":{"f":"=VLOOKUP($C21,Sheet1!$A$1:$S$39,Sheet2!E$2,FALSE())","tb":1,"v":"153065.29999999999"}},{"r":20,"c":5,"v":{"f":"=VLOOKUP($C21,Sheet1!$A$1:$S$39,Sheet2!F$2,FALSE())","tb":1,"v":"392264700.60000002"}},{"r":20,"c":6,"v":{"f":"=VLOOKUP($C21,Sheet1!$A$1:$S$39,Sheet2!G$2,FALSE())","tb":1,"v":"60361.4"}},{"r":20,"c":7,"v":{"f":"=VLOOKUP($C21,Sheet1!$A$1:$S$39,Sheet2!H$2,FALSE())","tb":1,"v":"489663462"}},{"r":20,"c":8,"v":{"f":"=VLOOKUP($C21,Sheet1!$A$1:$S$39,Sheet2!I$2,FALSE())","tb":1,"v":"92704"}},{"r":20,"c":9,"v":{"f":"=VLOOKUP($C21,Sheet1!$A$1:$S$39,Sheet2!J$2,FALSE())","tb":1,"v":"319724661.5"}},{"r":20,"c":10,"v":{"f":"=VLOOKUP($C21,Sheet1!$A$1:$S$39,Sheet2!K$2,FALSE())","tb":1,"v":"61366"}},{"r":20,"c":11,"v":{"f":"=VLOOKUP($C21,Sheet1!$A$1:$S$39,Sheet2!L$2,FALSE())","tb":1,"v":"15377402.6"}},{"r":20,"c":12,"v":{"f":"=VLOOKUP($C21,Sheet1!$A$1:$S$39,Sheet2!M$2,FALSE())","tb":1,"v":"2580.1"}},{"r":20,"c":13,"v":{"f":"=VLOOKUP($C21,Sheet1!$A$1:$S$39,Sheet2!N$2,FALSE())","tb":1,"v":"304347258.89999998"}},{"r":20,"c":14,"v":{"f":"=VLOOKUP($C21,Sheet1!$A$1:$S$39,Sheet2!O$2,FALSE())","tb":1,"v":"58785.9"}},{"r":20,"c":15,"v":{"f":"=VLOOKUP($C21,Sheet1!$A$1:$S$39,Sheet2!P$2,FALSE())","tb":1,"v":"562203501.10000002"}},{"r":20,"c":16,"v":{"f":"=VLOOKUP($C21,Sheet1!$A$1:$S$39,Sheet2!Q$2,FALSE())","tb":1,"v":"91699.3"}},{"r":20,"c":17,"v":{"f":"=VLOOKUP($C21,Sheet1!$A$1:$S$39,Sheet2!R$2,FALSE())","tb":1,"v":"376887298"}},{"r":20,"c":18,"v":{"f":"=VLOOKUP($C21,Sheet1!$A$1:$S$39,Sheet2!S$2,FALSE())","tb":1,"v":"57781.3"}},{"r":21,"c":2,"v":{"f":"=Sheet1!A19","tb":1,"v":"贵州"}},{"r":21,"c":3,"v":{"f":"=VLOOKUP($C22,Sheet1!$A$1:$S$39,Sheet2!D$2,FALSE())","tb":1,"v":"761419269.60000002"}},{"r":21,"c":4,"v":{"f":"=VLOOKUP($C22,Sheet1!$A$1:$S$39,Sheet2!E$2,FALSE())","tb":1,"v":"135602.79999999999"}},{"r":21,"c":5,"v":{"f":"=VLOOKUP($C22,Sheet1!$A$1:$S$39,Sheet2!F$2,FALSE())","tb":1,"v":"356599638.19999999"}},{"r":21,"c":6,"v":{"f":"=VLOOKUP($C22,Sheet1!$A$1:$S$39,Sheet2!G$2,FALSE())","tb":1,"v":"59521.5"}},{"r":21,"c":7,"v":{"f":"=VLOOKUP($C22,Sheet1!$A$1:$S$39,Sheet2!H$2,FALSE())","tb":1,"v":"404819631.39999998"}},{"r":21,"c":8,"v":{"f":"=VLOOKUP($C22,Sheet1!$A$1:$S$39,Sheet2!I$2,FALSE())","tb":1,"v":"76081.3"}},{"r":21,"c":9,"v":{"f":"=VLOOKUP($C22,Sheet1!$A$1:$S$39,Sheet2!J$2,FALSE())","tb":1,"v":"169856579.59999999"}},{"r":21,"c":10,"v":{"f":"=VLOOKUP($C22,Sheet1!$A$1:$S$39,Sheet2!K$2,FALSE())","tb":1,"v":"31752.799999999999"}},{"r":21,"c":11,"v":{"f":"=VLOOKUP($C22,Sheet1!$A$1:$S$39,Sheet2!L$2,FALSE())","tb":1,"v":"5298353.3"}},{"r":21,"c":12,"v":{"f":"=VLOOKUP($C22,Sheet1!$A$1:$S$39,Sheet2!M$2,FALSE())","tb":1,"v":"900.4"}},{"r":21,"c":13,"v":{"f":"=VLOOKUP($C22,Sheet1!$A$1:$S$39,Sheet2!N$2,FALSE())","tb":1,"v":"164558226.30000001"}},{"r":21,"c":14,"v":{"f":"=VLOOKUP($C22,Sheet1!$A$1:$S$39,Sheet2!O$2,FALSE())","tb":1,"v":"30852.5"}},{"r":21,"c":15,"v":{"f":"=VLOOKUP($C22,Sheet1!$A$1:$S$39,Sheet2!P$2,FALSE())","tb":1,"v":"591562690"}},{"r":21,"c":16,"v":{"f":"=VLOOKUP($C22,Sheet1!$A$1:$S$39,Sheet2!Q$2,FALSE())","tb":1,"v":"103849.9"}},{"r":21,"c":17,"v":{"f":"=VLOOKUP($C22,Sheet1!$A$1:$S$39,Sheet2!R$2,FALSE())","tb":1,"v":"351301284.89999998"}},{"r":21,"c":18,"v":{"f":"=VLOOKUP($C22,Sheet1!$A$1:$S$39,Sheet2!S$2,FALSE())","tb":1,"v":"58621.1"}},{"r":22,"c":2,"v":{"f":"=Sheet1!A20","tb":1,"v":"云南"}},{"r":22,"c":3,"v":{"f":"=VLOOKUP($C23,Sheet1!$A$1:$S$39,Sheet2!D$2,FALSE())","tb":1,"v":"1069523219.5"}},{"r":22,"c":4,"v":{"f":"=VLOOKUP($C23,Sheet1!$A$1:$S$39,Sheet2!E$2,FALSE())","tb":1,"v":"195511.5"}},{"r":22,"c":5,"v":{"f":"=VLOOKUP($C23,Sheet1!$A$1:$S$39,Sheet2!F$2,FALSE())","tb":1,"v":"229315506.5"}},{"r":22,"c":6,"v":{"f":"=VLOOKUP($C23,Sheet1!$A$1:$S$39,Sheet2!G$2,FALSE())","tb":1,"v":"38869"}},{"r":22,"c":7,"v":{"f":"=VLOOKUP($C23,Sheet1!$A$1:$S$39,Sheet2!H$2,FALSE())","tb":1,"v":"840207713"}},{"r":22,"c":8,"v":{"f":"=VLOOKUP($C23,Sheet1!$A$1:$S$39,Sheet2!I$2,FALSE())","tb":1,"v":"156642.5"}},{"r":22,"c":9,"v":{"f":"=VLOOKUP($C23,Sheet1!$A$1:$S$39,Sheet2!J$2,FALSE())","tb":1,"v":"307813804.19999999"}},{"r":22,"c":10,"v":{"f":"=VLOOKUP($C23,Sheet1!$A$1:$S$39,Sheet2!K$2,FALSE())","tb":1,"v":"57696"}},{"r":22,"c":11,"v":{"f":"=VLOOKUP($C23,Sheet1!$A$1:$S$39,Sheet2!L$2,FALSE())","tb":1,"v":"8071280"}},{"r":22,"c":12,"v":{"f":"=VLOOKUP($C23,Sheet1!$A$1:$S$39,Sheet2!M$2,FALSE())","tb":1,"v":"1366.2"}},{"r":22,"c":13,"v":{"f":"=VLOOKUP($C23,Sheet1!$A$1:$S$39,Sheet2!N$2,FALSE())","tb":1,"v":"299742524.19999999"}},{"r":22,"c":14,"v":{"f":"=VLOOKUP($C23,Sheet1!$A$1:$S$39,Sheet2!O$2,FALSE())","tb":1,"v":"56329.8"}},{"r":22,"c":15,"v":{"f":"=VLOOKUP($C23,Sheet1!$A$1:$S$39,Sheet2!P$2,FALSE())","tb":1,"v":"761709415.29999995"}},{"r":22,"c":16,"v":{"f":"=VLOOKUP($C23,Sheet1!$A$1:$S$39,Sheet2!Q$2,FALSE())","tb":1,"v":"137815.6"}},{"r":22,"c":17,"v":{"f":"=VLOOKUP($C23,Sheet1!$A$1:$S$39,Sheet2!R$2,FALSE())","tb":1,"v":"221244226.5"}},{"r":22,"c":18,"v":{"f":"=VLOOKUP($C23,Sheet1!$A$1:$S$39,Sheet2!S$2,FALSE())","tb":1,"v":"37502.800000000003"}},{"r":23,"c":2,"v":{"f":"=Sheet1!A21","tb":1,"v":"海南"}},{"r":23,"c":3,"v":{"f":"=VLOOKUP($C24,Sheet1!$A$1:$S$39,Sheet2!D$2,FALSE())","tb":1,"v":"239915479.69999999"}},{"r":23,"c":4,"v":{"f":"=VLOOKUP($C24,Sheet1!$A$1:$S$39,Sheet2!E$2,FALSE())","tb":1,"v":"39785.5"}},{"r":23,"c":5,"v":{"f":"=VLOOKUP($C24,Sheet1!$A$1:$S$39,Sheet2!F$2,FALSE())","tb":1,"v":"115554645.09999999"}},{"r":23,"c":6,"v":{"f":"=VLOOKUP($C24,Sheet1!$A$1:$S$39,Sheet2!G$2,FALSE())","tb":1,"v":"16531.7"}},{"r":23,"c":7,"v":{"f":"=VLOOKUP($C24,Sheet1!$A$1:$S$39,Sheet2!H$2,FALSE())","tb":1,"v":"124360834.59999999"}},{"r":23,"c":8,"v":{"f":"=VLOOKUP($C24,Sheet1!$A$1:$S$39,Sheet2!I$2,FALSE())","tb":1,"v":"23253.9"}},{"r":23,"c":9,"v":{"f":"=VLOOKUP($C24,Sheet1!$A$1:$S$39,Sheet2!J$2,FALSE())","tb":1,"v":"29091002.100000001"}},{"r":23,"c":10,"v":{"f":"=VLOOKUP($C24,Sheet1!$A$1:$S$39,Sheet2!K$2,FALSE())","tb":1,"v":"5672.4"}},{"r":23,"c":11,"v":{"f":"=VLOOKUP($C24,Sheet1!$A$1:$S$39,Sheet2!L$2,FALSE())","tb":1,"v":"2819368.3"}},{"r":23,"c":12,"v":{"f":"=VLOOKUP($C24,Sheet1!$A$1:$S$39,Sheet2!M$2,FALSE())","tb":1,"v":"408.9"}},{"r":23,"c":13,"v":{"f":"=VLOOKUP($C24,Sheet1!$A$1:$S$39,Sheet2!N$2,FALSE())","tb":1,"v":"26271633.800000001"}},{"r":23,"c":14,"v":{"f":"=VLOOKUP($C24,Sheet1!$A$1:$S$39,Sheet2!O$2,FALSE())","tb":1,"v":"5263.5"}},{"r":23,"c":15,"v":{"f":"=VLOOKUP($C24,Sheet1!$A$1:$S$39,Sheet2!P$2,FALSE())","tb":1,"v":"210824477.69999999"}},{"r":23,"c":16,"v":{"f":"=VLOOKUP($C24,Sheet1!$A$1:$S$39,Sheet2!Q$2,FALSE())","tb":1,"v":"34113.1"}},{"r":23,"c":17,"v":{"f":"=VLOOKUP($C24,Sheet1!$A$1:$S$39,Sheet2!R$2,FALSE())","tb":1,"v":"112735276.90000001"}},{"r":23,"c":18,"v":{"f":"=VLOOKUP($C24,Sheet1!$A$1:$S$39,Sheet2!S$2,FALSE())","tb":1,"v":"16122.8"}},{"r":24,"c":2,"v":{"f":"=Sheet1!A22","tb":1,"v":"区外省市"}},{"r":24,"c":3,"v":{"f":"=VLOOKUP($C25,Sheet1!$A$1:$S$39,Sheet2!D$2,FALSE())","tb":1,"v":"10035855546"}},{"r":24,"c":4,"v":{"f":"=VLOOKUP($C25,Sheet1!$A$1:$S$39,Sheet2!E$2,FALSE())","tb":1,"v":"1964509.7"}},{"r":24,"c":5,"v":{"f":"=VLOOKUP($C25,Sheet1!$A$1:$S$39,Sheet2!F$2,FALSE())","tb":1,"v":"2197155097.3000002"}},{"r":24,"c":6,"v":{"f":"=VLOOKUP($C25,Sheet1!$A$1:$S$39,Sheet2!G$2,FALSE())","tb":1,"v":"390293.7"}},{"r":24,"c":7,"v":{"f":"=VLOOKUP($C25,Sheet1!$A$1:$S$39,Sheet2!H$2,FALSE())","tb":1,"v":"7838700448.6999998"}},{"r":24,"c":8,"v":{"f":"=VLOOKUP($C25,Sheet1!$A$1:$S$39,Sheet2!I$2,FALSE())","tb":1,"v":"1574216"}},{"r":24,"c":9,"v":{"f":"=VLOOKUP($C25,Sheet1!$A$1:$S$39,Sheet2!J$2,FALSE())","tb":1,"v":"434791957.19999999"}},{"r":24,"c":10,"v":{"f":"=VLOOKUP($C25,Sheet1!$A$1:$S$39,Sheet2!K$2,FALSE())","tb":1,"v":"82580"}},{"r":24,"c":11,"v":{"f":"=VLOOKUP($C25,Sheet1!$A$1:$S$39,Sheet2!L$2,FALSE())","tb":1,"v":"9754767.6999999993"}},{"r":24,"c":12,"v":{"f":"=VLOOKUP($C25,Sheet1!$A$1:$S$39,Sheet2!M$2,FALSE())","tb":1,"v":"1684.4"}},{"r":24,"c":13,"v":{"f":"=VLOOKUP($C25,Sheet1!$A$1:$S$39,Sheet2!N$2,FALSE())","tb":1,"v":"425037189.5"}},{"r":24,"c":14,"v":{"f":"=VLOOKUP($C25,Sheet1!$A$1:$S$39,Sheet2!O$2,FALSE())","tb":1,"v":"80895.600000000006"}},{"r":24,"c":15,"v":{"f":"=VLOOKUP($C25,Sheet1!$A$1:$S$39,Sheet2!P$2,FALSE())","tb":1,"v":"9601063588.7999992"}},{"r":24,"c":16,"v":{"f":"=VLOOKUP($C25,Sheet1!$A$1:$S$39,Sheet2!Q$2,FALSE())","tb":1,"v":"1881929.7"}},{"r":24,"c":17,"v":{"f":"=VLOOKUP($C25,Sheet1!$A$1:$S$39,Sheet2!R$2,FALSE())","tb":1,"v":"2187400329.5999999"}},{"r":24,"c":18,"v":{"f":"=VLOOKUP($C25,Sheet1!$A$1:$S$39,Sheet2!S$2,FALSE())","tb":1,"v":"388609.3"}},{"r":25,"c":2,"v":{"f":"=Sheet1!A23","tb":1,"v":"黑龙江"}},{"r":25,"c":3,"v":{"f":"=VLOOKUP($C26,Sheet1!$A$1:$S$39,Sheet2!D$2,FALSE())","tb":1,"v":"129541171.09999999"}},{"r":25,"c":4,"v":{"f":"=VLOOKUP($C26,Sheet1!$A$1:$S$39,Sheet2!E$2,FALSE())","tb":1,"v":"24391.3"}},{"r":25,"c":5,"v":{"f":"=VLOOKUP($C26,Sheet1!$A$1:$S$39,Sheet2!F$2,FALSE())","tb":1,"v":"62821830.299999997"}},{"r":25,"c":6,"v":{"f":"=VLOOKUP($C26,Sheet1!$A$1:$S$39,Sheet2!G$2,FALSE())","tb":1,"v":"11458.3"}},{"r":25,"c":7,"v":{"f":"=VLOOKUP($C26,Sheet1!$A$1:$S$39,Sheet2!H$2,FALSE())","tb":1,"v":"66719340.799999997"}},{"r":25,"c":8,"v":{"f":"=VLOOKUP($C26,Sheet1!$A$1:$S$39,Sheet2!I$2,FALSE())","tb":1,"v":"12933"}},{"r":25,"c":9,"v":{"f":"=VLOOKUP($C26,Sheet1!$A$1:$S$39,Sheet2!J$2,FALSE())","tb":1,"v":"351794.8"}},{"r":25,"c":10,"v":{"f":"=VLOOKUP($C26,Sheet1!$A$1:$S$39,Sheet2!K$2,FALSE())","tb":1,"v":"68.400000000000006"}},{"r":25,"c":11,"v":{"f":"=VLOOKUP($C26,Sheet1!$A$1:$S$39,Sheet2!L$2,FALSE())","tb":1,"v":"0"}},{"r":25,"c":12,"v":{"f":"=VLOOKUP($C26,Sheet1!$A$1:$S$39,Sheet2!M$2,FALSE())","tb":1,"v":"0"}},{"r":25,"c":13,"v":{"f":"=VLOOKUP($C26,Sheet1!$A$1:$S$39,Sheet2!N$2,FALSE())","tb":1,"v":"351794.8"}},{"r":25,"c":14,"v":{"f":"=VLOOKUP($C26,Sheet1!$A$1:$S$39,Sheet2!O$2,FALSE())","tb":1,"v":"68.400000000000006"}},{"r":25,"c":15,"v":{"f":"=VLOOKUP($C26,Sheet1!$A$1:$S$39,Sheet2!P$2,FALSE())","tb":1,"v":"129189376.3"}},{"r":25,"c":16,"v":{"f":"=VLOOKUP($C26,Sheet1!$A$1:$S$39,Sheet2!Q$2,FALSE())","tb":1,"v":"24322.9"}},{"r":25,"c":17,"v":{"f":"=VLOOKUP($C26,Sheet1!$A$1:$S$39,Sheet2!R$2,FALSE())","tb":1,"v":"62821830.299999997"}},{"r":25,"c":18,"v":{"f":"=VLOOKUP($C26,Sheet1!$A$1:$S$39,Sheet2!S$2,FALSE())","tb":1,"v":"11458.3"}},{"r":26,"c":2,"v":{"f":"=Sheet1!A24","tb":1,"v":"吉林"}},{"r":26,"c":3,"v":{"f":"=VLOOKUP($C27,Sheet1!$A$1:$S$39,Sheet2!D$2,FALSE())","tb":1,"v":"78698824.599999994"}},{"r":26,"c":4,"v":{"f":"=VLOOKUP($C27,Sheet1!$A$1:$S$39,Sheet2!E$2,FALSE())","tb":1,"v":"15613.4"}},{"r":26,"c":5,"v":{"f":"=VLOOKUP($C27,Sheet1!$A$1:$S$39,Sheet2!F$2,FALSE())","tb":1,"v":"32110729"}},{"r":26,"c":6,"v":{"f":"=VLOOKUP($C27,Sheet1!$A$1:$S$39,Sheet2!G$2,FALSE())","tb":1,"v":"5913"}},{"r":26,"c":7,"v":{"f":"=VLOOKUP($C27,Sheet1!$A$1:$S$39,Sheet2!H$2,FALSE())","tb":1,"v":"46588095.600000001"}},{"r":26,"c":8,"v":{"f":"=VLOOKUP($C27,Sheet1!$A$1:$S$39,Sheet2!I$2,FALSE())","tb":1,"v":"9700.4"}},{"r":26,"c":9,"v":{"f":"=VLOOKUP($C27,Sheet1!$A$1:$S$39,Sheet2!J$2,FALSE())","tb":1,"v":"6612155.5"}},{"r":26,"c":10,"v":{"f":"=VLOOKUP($C27,Sheet1!$A$1:$S$39,Sheet2!K$2,FALSE())","tb":1,"v":"1307.9000000000001"}},{"r":26,"c":11,"v":{"f":"=VLOOKUP($C27,Sheet1!$A$1:$S$39,Sheet2!L$2,FALSE())","tb":1,"v":"45864"}},{"r":26,"c":12,"v":{"f":"=VLOOKUP($C27,Sheet1!$A$1:$S$39,Sheet2!M$2,FALSE())","tb":1,"v":"6"}},{"r":26,"c":13,"v":{"f":"=VLOOKUP($C27,Sheet1!$A$1:$S$39,Sheet2!N$2,FALSE())","tb":1,"v":"6566291.5"}},{"r":26,"c":14,"v":{"f":"=VLOOKUP($C27,Sheet1!$A$1:$S$39,Sheet2!O$2,FALSE())","tb":1,"v":"1301.9000000000001"}},{"r":26,"c":15,"v":{"f":"=VLOOKUP($C27,Sheet1!$A$1:$S$39,Sheet2!P$2,FALSE())","tb":1,"v":"72086669.099999994"}},{"r":26,"c":16,"v":{"f":"=VLOOKUP($C27,Sheet1!$A$1:$S$39,Sheet2!Q$2,FALSE())","tb":1,"v":"14305.6"}},{"r":26,"c":17,"v":{"f":"=VLOOKUP($C27,Sheet1!$A$1:$S$39,Sheet2!R$2,FALSE())","tb":1,"v":"32064865"}},{"r":26,"c":18,"v":{"f":"=VLOOKUP($C27,Sheet1!$A$1:$S$39,Sheet2!S$2,FALSE())","tb":1,"v":"5907"}},{"r":27,"c":2,"v":{"f":"=Sheet1!A25","tb":1,"v":"辽宁"}},{"r":27,"c":3,"v":{"f":"=VLOOKUP($C28,Sheet1!$A$1:$S$39,Sheet2!D$2,FALSE())","tb":1,"v":"7733295016.6000004"}},{"r":27,"c":4,"v":{"f":"=VLOOKUP($C28,Sheet1!$A$1:$S$39,Sheet2!E$2,FALSE())","tb":1,"v":"1547329.3"}},{"r":27,"c":5,"v":{"f":"=VLOOKUP($C28,Sheet1!$A$1:$S$39,Sheet2!F$2,FALSE())","tb":1,"v":"1522587629.4000001"}},{"r":27,"c":6,"v":{"f":"=VLOOKUP($C28,Sheet1!$A$1:$S$39,Sheet2!G$2,FALSE())","tb":1,"v":"278027.5"}},{"r":27,"c":7,"v":{"f":"=VLOOKUP($C28,Sheet1!$A$1:$S$39,Sheet2!H$2,FALSE())","tb":1,"v":"6210707387.1000004"}},{"r":27,"c":8,"v":{"f":"=VLOOKUP($C28,Sheet1!$A$1:$S$39,Sheet2!I$2,FALSE())","tb":1,"v":"1269301.8999999999"}},{"r":27,"c":9,"v":{"f":"=VLOOKUP($C28,Sheet1!$A$1:$S$39,Sheet2!J$2,FALSE())","tb":1,"v":"60966225.399999999"}},{"r":27,"c":10,"v":{"f":"=VLOOKUP($C28,Sheet1!$A$1:$S$39,Sheet2!K$2,FALSE())","tb":1,"v":"12480.2"}},{"r":27,"c":11,"v":{"f":"=VLOOKUP($C28,Sheet1!$A$1:$S$39,Sheet2!L$2,FALSE())","tb":1,"v":"884918"}},{"r":27,"c":12,"v":{"f":"=VLOOKUP($C28,Sheet1!$A$1:$S$39,Sheet2!M$2,FALSE())","tb":1,"v":"144"}},{"r":27,"c":13,"v":{"f":"=VLOOKUP($C28,Sheet1!$A$1:$S$39,Sheet2!N$2,FALSE())","tb":1,"v":"60081307.399999999"}},{"r":27,"c":14,"v":{"f":"=VLOOKUP($C28,Sheet1!$A$1:$S$39,Sheet2!O$2,FALSE())","tb":1,"v":"12336.2"}},{"r":27,"c":15,"v":{"f":"=VLOOKUP($C28,Sheet1!$A$1:$S$39,Sheet2!P$2,FALSE())","tb":1,"v":"7672328791.1999998"}},{"r":27,"c":16,"v":{"f":"=VLOOKUP($C28,Sheet1!$A$1:$S$39,Sheet2!Q$2,FALSE())","tb":1,"v":"1534849.1"}},{"r":27,"c":17,"v":{"f":"=VLOOKUP($C28,Sheet1!$A$1:$S$39,Sheet2!R$2,FALSE())","tb":1,"v":"1521702711.4000001"}},{"r":27,"c":18,"v":{"f":"=VLOOKUP($C28,Sheet1!$A$1:$S$39,Sheet2!S$2,FALSE())","tb":1,"v":"277883.5"}},{"r":28,"c":2,"v":{"f":"=Sheet1!A26","tb":1,"v":"陕西"}},{"r":28,"c":3,"v":{"f":"=VLOOKUP($C29,Sheet1!$A$1:$S$39,Sheet2!D$2,FALSE())","tb":1,"v":"216046916.09999999"}},{"r":28,"c":4,"v":{"f":"=VLOOKUP($C29,Sheet1!$A$1:$S$39,Sheet2!E$2,FALSE())","tb":1,"v":"42153.7"}},{"r":28,"c":5,"v":{"f":"=VLOOKUP($C29,Sheet1!$A$1:$S$39,Sheet2!F$2,FALSE())","tb":1,"v":"65047944"}},{"r":28,"c":6,"v":{"f":"=VLOOKUP($C29,Sheet1!$A$1:$S$39,Sheet2!G$2,FALSE())","tb":1,"v":"11657.8"}},{"r":28,"c":7,"v":{"f":"=VLOOKUP($C29,Sheet1!$A$1:$S$39,Sheet2!H$2,FALSE())","tb":1,"v":"150998972.09999999"}},{"r":28,"c":8,"v":{"f":"=VLOOKUP($C29,Sheet1!$A$1:$S$39,Sheet2!I$2,FALSE())","tb":1,"v":"30496"}},{"r":28,"c":9,"v":{"f":"=VLOOKUP($C29,Sheet1!$A$1:$S$39,Sheet2!J$2,FALSE())","tb":1,"v":"35712772.200000003"}},{"r":28,"c":10,"v":{"f":"=VLOOKUP($C29,Sheet1!$A$1:$S$39,Sheet2!K$2,FALSE())","tb":1,"v":"6986"}},{"r":28,"c":11,"v":{"f":"=VLOOKUP($C29,Sheet1!$A$1:$S$39,Sheet2!L$2,FALSE())","tb":1,"v":"4241540.8"}},{"r":28,"c":12,"v":{"f":"=VLOOKUP($C29,Sheet1!$A$1:$S$39,Sheet2!M$2,FALSE())","tb":1,"v":"756.3"}},{"r":28,"c":13,"v":{"f":"=VLOOKUP($C29,Sheet1!$A$1:$S$39,Sheet2!N$2,FALSE())","tb":1,"v":"31471231.399999999"}},{"r":28,"c":14,"v":{"f":"=VLOOKUP($C29,Sheet1!$A$1:$S$39,Sheet2!O$2,FALSE())","tb":1,"v":"6229.7"}},{"r":28,"c":15,"v":{"f":"=VLOOKUP($C29,Sheet1!$A$1:$S$39,Sheet2!P$2,FALSE())","tb":1,"v":"180334143.90000001"}},{"r":28,"c":16,"v":{"f":"=VLOOKUP($C29,Sheet1!$A$1:$S$39,Sheet2!Q$2,FALSE())","tb":1,"v":"35167.699999999997"}},{"r":28,"c":17,"v":{"f":"=VLOOKUP($C29,Sheet1!$A$1:$S$39,Sheet2!R$2,FALSE())","tb":1,"v":"60806403.200000003"}},{"r":28,"c":18,"v":{"f":"=VLOOKUP($C29,Sheet1!$A$1:$S$39,Sheet2!S$2,FALSE())","tb":1,"v":"10901.5"}},{"r":29,"c":2,"v":{"f":"=Sheet1!A27","tb":1,"v":"新疆"}},{"r":29,"c":3,"v":{"f":"=VLOOKUP($C30,Sheet1!$A$1:$S$39,Sheet2!D$2,FALSE())","tb":1,"v":"834583660.60000002"}},{"r":29,"c":4,"v":{"f":"=VLOOKUP($C30,Sheet1!$A$1:$S$39,Sheet2!E$2,FALSE())","tb":1,"v":"144791.4"}},{"r":29,"c":5,"v":{"f":"=VLOOKUP($C30,Sheet1!$A$1:$S$39,Sheet2!F$2,FALSE())","tb":1,"v":"184835666.80000001"}},{"r":29,"c":6,"v":{"f":"=VLOOKUP($C30,Sheet1!$A$1:$S$39,Sheet2!G$2,FALSE())","tb":1,"v":"27384.1"}},{"r":29,"c":7,"v":{"f":"=VLOOKUP($C30,Sheet1!$A$1:$S$39,Sheet2!H$2,FALSE())","tb":1,"v":"649747993.89999998"}},{"r":29,"c":8,"v":{"f":"=VLOOKUP($C30,Sheet1!$A$1:$S$39,Sheet2!I$2,FALSE())","tb":1,"v":"117407.2"}},{"r":29,"c":9,"v":{"f":"=VLOOKUP($C30,Sheet1!$A$1:$S$39,Sheet2!J$2,FALSE())","tb":1,"v":"73977926"}},{"r":29,"c":10,"v":{"f":"=VLOOKUP($C30,Sheet1!$A$1:$S$39,Sheet2!K$2,FALSE())","tb":1,"v":"13424.5"}},{"r":29,"c":11,"v":{"f":"=VLOOKUP($C30,Sheet1!$A$1:$S$39,Sheet2!L$2,FALSE())","tb":1,"v":"647113.80000000005"}},{"r":29,"c":12,"v":{"f":"=VLOOKUP($C30,Sheet1!$A$1:$S$39,Sheet2!M$2,FALSE())","tb":1,"v":"93"}},{"r":29,"c":13,"v":{"f":"=VLOOKUP($C30,Sheet1!$A$1:$S$39,Sheet2!N$2,FALSE())","tb":1,"v":"73330812.099999994"}},{"r":29,"c":14,"v":{"f":"=VLOOKUP($C30,Sheet1!$A$1:$S$39,Sheet2!O$2,FALSE())","tb":1,"v":"13331.5"}},{"r":29,"c":15,"v":{"f":"=VLOOKUP($C30,Sheet1!$A$1:$S$39,Sheet2!P$2,FALSE())","tb":1,"v":"760605734.60000002"}},{"r":29,"c":16,"v":{"f":"=VLOOKUP($C30,Sheet1!$A$1:$S$39,Sheet2!Q$2,FALSE())","tb":1,"v":"131366.9"}},{"r":29,"c":17,"v":{"f":"=VLOOKUP($C30,Sheet1!$A$1:$S$39,Sheet2!R$2,FALSE())","tb":1,"v":"184188552.90000001"}},{"r":29,"c":18,"v":{"f":"=VLOOKUP($C30,Sheet1!$A$1:$S$39,Sheet2!S$2,FALSE())","tb":1,"v":"27291.200000000001"}},{"r":30,"c":2,"v":{"f":"=Sheet1!A28","tb":1,"v":"内蒙古"}},{"r":30,"c":3,"v":{"f":"=VLOOKUP($C31,Sheet1!$A$1:$S$39,Sheet2!D$2,FALSE())","tb":1,"v":"145212039.59999999"}},{"r":30,"c":4,"v":{"f":"=VLOOKUP($C31,Sheet1!$A$1:$S$39,Sheet2!E$2,FALSE())","tb":1,"v":"27917.599999999999"}},{"r":30,"c":5,"v":{"f":"=VLOOKUP($C31,Sheet1!$A$1:$S$39,Sheet2!F$2,FALSE())","tb":1,"v":"39988602.899999999"}},{"r":30,"c":6,"v":{"f":"=VLOOKUP($C31,Sheet1!$A$1:$S$39,Sheet2!G$2,FALSE())","tb":1,"v":"7276.2"}},{"r":30,"c":7,"v":{"f":"=VLOOKUP($C31,Sheet1!$A$1:$S$39,Sheet2!H$2,FALSE())","tb":1,"v":"105223436.7"}},{"r":30,"c":8,"v":{"f":"=VLOOKUP($C31,Sheet1!$A$1:$S$39,Sheet2!I$2,FALSE())","tb":1,"v":"20641.400000000001"}},{"r":30,"c":9,"v":{"f":"=VLOOKUP($C31,Sheet1!$A$1:$S$39,Sheet2!J$2,FALSE())","tb":1,"v":"67942427.200000003"}},{"r":30,"c":10,"v":{"f":"=VLOOKUP($C31,Sheet1!$A$1:$S$39,Sheet2!K$2,FALSE())","tb":1,"v":"13237.9"}},{"r":30,"c":11,"v":{"f":"=VLOOKUP($C31,Sheet1!$A$1:$S$39,Sheet2!L$2,FALSE())","tb":1,"v":"100262.9"}},{"r":30,"c":12,"v":{"f":"=VLOOKUP($C31,Sheet1!$A$1:$S$39,Sheet2!M$2,FALSE())","tb":1,"v":"14.7"}},{"r":30,"c":13,"v":{"f":"=VLOOKUP($C31,Sheet1!$A$1:$S$39,Sheet2!N$2,FALSE())","tb":1,"v":"67842164.299999997"}},{"r":30,"c":14,"v":{"f":"=VLOOKUP($C31,Sheet1!$A$1:$S$39,Sheet2!O$2,FALSE())","tb":1,"v":"13223.2"}},{"r":30,"c":15,"v":{"f":"=VLOOKUP($C31,Sheet1!$A$1:$S$39,Sheet2!P$2,FALSE())","tb":1,"v":"77269612.400000006"}},{"r":30,"c":16,"v":{"f":"=VLOOKUP($C31,Sheet1!$A$1:$S$39,Sheet2!Q$2,FALSE())","tb":1,"v":"14679.7"}},{"r":30,"c":17,"v":{"f":"=VLOOKUP($C31,Sheet1!$A$1:$S$39,Sheet2!R$2,FALSE())","tb":1,"v":"39888340"}},{"r":30,"c":18,"v":{"f":"=VLOOKUP($C31,Sheet1!$A$1:$S$39,Sheet2!S$2,FALSE())","tb":1,"v":"7261.5"}},{"r":31,"c":2,"v":{"f":"=Sheet1!A29","tb":1,"v":"青海"}},{"r":31,"c":3,"v":{"f":"=VLOOKUP($C32,Sheet1!$A$1:$S$39,Sheet2!D$2,FALSE())","tb":1,"v":"21566200.199999999"}},{"r":31,"c":4,"v":{"f":"=VLOOKUP($C32,Sheet1!$A$1:$S$39,Sheet2!E$2,FALSE())","tb":1,"v":"3999.8"}},{"r":31,"c":5,"v":{"f":"=VLOOKUP($C32,Sheet1!$A$1:$S$39,Sheet2!F$2,FALSE())","tb":1,"v":"1237480"}},{"r":31,"c":6,"v":{"f":"=VLOOKUP($C32,Sheet1!$A$1:$S$39,Sheet2!G$2,FALSE())","tb":1,"v":"201"}},{"r":31,"c":7,"v":{"f":"=VLOOKUP($C32,Sheet1!$A$1:$S$39,Sheet2!H$2,FALSE())","tb":1,"v":"20328720.199999999"}},{"r":31,"c":8,"v":{"f":"=VLOOKUP($C32,Sheet1!$A$1:$S$39,Sheet2!I$2,FALSE())","tb":1,"v":"3798.8"}},{"r":31,"c":9,"v":{"f":"=VLOOKUP($C32,Sheet1!$A$1:$S$39,Sheet2!J$2,FALSE())","tb":1,"v":"8181122.2999999998"}},{"r":31,"c":10,"v":{"f":"=VLOOKUP($C32,Sheet1!$A$1:$S$39,Sheet2!K$2,FALSE())","tb":1,"v":"1522.1"}},{"r":31,"c":11,"v":{"f":"=VLOOKUP($C32,Sheet1!$A$1:$S$39,Sheet2!L$2,FALSE())","tb":1,"v":"127500"}},{"r":31,"c":12,"v":{"f":"=VLOOKUP($C32,Sheet1!$A$1:$S$39,Sheet2!M$2,FALSE())","tb":1,"v":"21"}},{"r":31,"c":13,"v":{"f":"=VLOOKUP($C32,Sheet1!$A$1:$S$39,Sheet2!N$2,FALSE())","tb":1,"v":"8053622.2999999998"}},{"r":31,"c":14,"v":{"f":"=VLOOKUP($C32,Sheet1!$A$1:$S$39,Sheet2!O$2,FALSE())","tb":1,"v":"1501.1"}},{"r":31,"c":15,"v":{"f":"=VLOOKUP($C32,Sheet1!$A$1:$S$39,Sheet2!P$2,FALSE())","tb":1,"v":"13385077.9"}},{"r":31,"c":16,"v":{"f":"=VLOOKUP($C32,Sheet1!$A$1:$S$39,Sheet2!Q$2,FALSE())","tb":1,"v":"2477.6999999999998"}},{"r":31,"c":17,"v":{"f":"=VLOOKUP($C32,Sheet1!$A$1:$S$39,Sheet2!R$2,FALSE())","tb":1,"v":"1109980"}},{"r":31,"c":18,"v":{"f":"=VLOOKUP($C32,Sheet1!$A$1:$S$39,Sheet2!S$2,FALSE())","tb":1,"v":"180"}},{"r":32,"c":2,"v":{"f":"=Sheet1!A30","tb":1,"v":"甘肃"}},{"r":32,"c":3,"v":{"f":"=VLOOKUP($C33,Sheet1!$A$1:$S$39,Sheet2!D$2,FALSE())","tb":1,"v":"32689330.300000001"}},{"r":32,"c":4,"v":{"f":"=VLOOKUP($C33,Sheet1!$A$1:$S$39,Sheet2!E$2,FALSE())","tb":1,"v":"5767.2"}},{"r":32,"c":5,"v":{"f":"=VLOOKUP($C33,Sheet1!$A$1:$S$39,Sheet2!F$2,FALSE())","tb":1,"v":"5726954.4000000004"}},{"r":32,"c":6,"v":{"f":"=VLOOKUP($C33,Sheet1!$A$1:$S$39,Sheet2!G$2,FALSE())","tb":1,"v":"831.6"}},{"r":32,"c":7,"v":{"f":"=VLOOKUP($C33,Sheet1!$A$1:$S$39,Sheet2!H$2,FALSE())","tb":1,"v":"26962375.899999999"}},{"r":32,"c":8,"v":{"f":"=VLOOKUP($C33,Sheet1!$A$1:$S$39,Sheet2!I$2,FALSE())","tb":1,"v":"4935.7"}},{"r":32,"c":9,"v":{"f":"=VLOOKUP($C33,Sheet1!$A$1:$S$39,Sheet2!J$2,FALSE())","tb":1,"v":"12420033.6"}},{"r":32,"c":10,"v":{"f":"=VLOOKUP($C33,Sheet1!$A$1:$S$39,Sheet2!K$2,FALSE())","tb":1,"v":"2265.6999999999998"}},{"r":32,"c":11,"v":{"f":"=VLOOKUP($C33,Sheet1!$A$1:$S$39,Sheet2!L$2,FALSE())","tb":1,"v":"193500"}},{"r":32,"c":12,"v":{"f":"=VLOOKUP($C33,Sheet1!$A$1:$S$39,Sheet2!M$2,FALSE())","tb":1,"v":"30"}},{"r":32,"c":13,"v":{"f":"=VLOOKUP($C33,Sheet1!$A$1:$S$39,Sheet2!N$2,FALSE())","tb":1,"v":"12226533.6"}},{"r":32,"c":14,"v":{"f":"=VLOOKUP($C33,Sheet1!$A$1:$S$39,Sheet2!O$2,FALSE())","tb":1,"v":"2235.6999999999998"}},{"r":32,"c":15,"v":{"f":"=VLOOKUP($C33,Sheet1!$A$1:$S$39,Sheet2!P$2,FALSE())","tb":1,"v":"20269296.699999999"}},{"r":32,"c":16,"v":{"f":"=VLOOKUP($C33,Sheet1!$A$1:$S$39,Sheet2!Q$2,FALSE())","tb":1,"v":"3501.5"}},{"r":32,"c":17,"v":{"f":"=VLOOKUP($C33,Sheet1!$A$1:$S$39,Sheet2!R$2,FALSE())","tb":1,"v":"5533454.4000000004"}},{"r":32,"c":18,"v":{"f":"=VLOOKUP($C33,Sheet1!$A$1:$S$39,Sheet2!S$2,FALSE())","tb":1,"v":"801.6"}},{"r":33,"c":2,"v":{"f":"=Sheet1!A31","tb":1,"v":"四川"}},{"r":33,"c":3,"v":{"f":"=VLOOKUP($C34,Sheet1!$A$1:$S$39,Sheet2!D$2,FALSE())","tb":1,"v":"342838681.19999999"}},{"r":33,"c":4,"v":{"f":"=VLOOKUP($C34,Sheet1!$A$1:$S$39,Sheet2!E$2,FALSE())","tb":1,"v":"62286.2"}},{"r":33,"c":5,"v":{"f":"=VLOOKUP($C34,Sheet1!$A$1:$S$39,Sheet2!F$2,FALSE())","tb":1,"v":"82197971.099999994"}},{"r":33,"c":6,"v":{"f":"=VLOOKUP($C34,Sheet1!$A$1:$S$39,Sheet2!G$2,FALSE())","tb":1,"v":"13580.9"}},{"r":33,"c":7,"v":{"f":"=VLOOKUP($C34,Sheet1!$A$1:$S$39,Sheet2!H$2,FALSE())","tb":1,"v":"260640710.19999999"}},{"r":33,"c":8,"v":{"f":"=VLOOKUP($C34,Sheet1!$A$1:$S$39,Sheet2!I$2,FALSE())","tb":1,"v":"48705.2"}},{"r":33,"c":9,"v":{"f":"=VLOOKUP($C34,Sheet1!$A$1:$S$39,Sheet2!J$2,FALSE())","tb":1,"v":"91659839.200000003"}},{"r":33,"c":10,"v":{"f":"=VLOOKUP($C34,Sheet1!$A$1:$S$39,Sheet2!K$2,FALSE())","tb":1,"v":"16902.599999999999"}},{"r":33,"c":11,"v":{"f":"=VLOOKUP($C34,Sheet1!$A$1:$S$39,Sheet2!L$2,FALSE())","tb":1,"v":"0"}},{"r":33,"c":12,"v":{"f":"=VLOOKUP($C34,Sheet1!$A$1:$S$39,Sheet2!M$2,FALSE())","tb":1,"v":"0"}},{"r":33,"c":13,"v":{"f":"=VLOOKUP($C34,Sheet1!$A$1:$S$39,Sheet2!N$2,FALSE())","tb":1,"v":"91659839.200000003"}},{"r":33,"c":14,"v":{"f":"=VLOOKUP($C34,Sheet1!$A$1:$S$39,Sheet2!O$2,FALSE())","tb":1,"v":"16902.599999999999"}},{"r":33,"c":15,"v":{"f":"=VLOOKUP($C34,Sheet1!$A$1:$S$39,Sheet2!P$2,FALSE())","tb":1,"v":"251178842.09999999"}},{"r":33,"c":16,"v":{"f":"=VLOOKUP($C34,Sheet1!$A$1:$S$39,Sheet2!Q$2,FALSE())","tb":1,"v":"45383.6"}},{"r":33,"c":17,"v":{"f":"=VLOOKUP($C34,Sheet1!$A$1:$S$39,Sheet2!R$2,FALSE())","tb":1,"v":"82197971.099999994"}},{"r":33,"c":18,"v":{"f":"=VLOOKUP($C34,Sheet1!$A$1:$S$39,Sheet2!S$2,FALSE())","tb":1,"v":"13580.9"}},{"r":34,"c":2,"v":{"f":"=Sheet1!A32","tb":1,"v":"重庆"}},{"r":34,"c":3,"v":{"f":"=VLOOKUP($C35,Sheet1!$A$1:$S$39,Sheet2!D$2,FALSE())","tb":1,"v":"484643083.69999999"}},{"r":34,"c":4,"v":{"f":"=VLOOKUP($C35,Sheet1!$A$1:$S$39,Sheet2!E$2,FALSE())","tb":1,"v":"87310"}},{"r":34,"c":5,"v":{"f":"=VLOOKUP($C35,Sheet1!$A$1:$S$39,Sheet2!F$2,FALSE())","tb":1,"v":"196324840.40000001"}},{"r":34,"c":6,"v":{"f":"=VLOOKUP($C35,Sheet1!$A$1:$S$39,Sheet2!G$2,FALSE())","tb":1,"v":"33260.699999999997"}},{"r":34,"c":7,"v":{"f":"=VLOOKUP($C35,Sheet1!$A$1:$S$39,Sheet2!H$2,FALSE())","tb":1,"v":"288318243.30000001"}},{"r":34,"c":8,"v":{"f":"=VLOOKUP($C35,Sheet1!$A$1:$S$39,Sheet2!I$2,FALSE())","tb":1,"v":"54049.3"}},{"r":34,"c":9,"v":{"f":"=VLOOKUP($C35,Sheet1!$A$1:$S$39,Sheet2!J$2,FALSE())","tb":1,"v":"75011847.299999997"}},{"r":34,"c":10,"v":{"f":"=VLOOKUP($C35,Sheet1!$A$1:$S$39,Sheet2!K$2,FALSE())","tb":1,"v":"14061.5"}},{"r":34,"c":11,"v":{"f":"=VLOOKUP($C35,Sheet1!$A$1:$S$39,Sheet2!L$2,FALSE())","tb":1,"v":"3514068.1"}},{"r":34,"c":12,"v":{"f":"=VLOOKUP($C35,Sheet1!$A$1:$S$39,Sheet2!M$2,FALSE())","tb":1,"v":"619.5"}},{"r":34,"c":13,"v":{"f":"=VLOOKUP($C35,Sheet1!$A$1:$S$39,Sheet2!N$2,FALSE())","tb":1,"v":"71497779.200000003"}},{"r":34,"c":14,"v":{"f":"=VLOOKUP($C35,Sheet1!$A$1:$S$39,Sheet2!O$2,FALSE())","tb":1,"v":"13442"}},{"r":34,"c":15,"v":{"f":"=VLOOKUP($C35,Sheet1!$A$1:$S$39,Sheet2!P$2,FALSE())","tb":1,"v":"409631236.39999998"}},{"r":34,"c":16,"v":{"f":"=VLOOKUP($C35,Sheet1!$A$1:$S$39,Sheet2!Q$2,FALSE())","tb":1,"v":"73248.5"}},{"r":34,"c":17,"v":{"f":"=VLOOKUP($C35,Sheet1!$A$1:$S$39,Sheet2!R$2,FALSE())","tb":1,"v":"192810772.40000001"}},{"r":34,"c":18,"v":{"f":"=VLOOKUP($C35,Sheet1!$A$1:$S$39,Sheet2!S$2,FALSE())","tb":1,"v":"32641.200000000001"}},{"r":35,"c":2,"v":{"f":"=Sheet1!A33","tb":1,"v":"西藏"}},{"r":35,"c":3,"v":{"f":"=VLOOKUP($C36,Sheet1!$A$1:$S$39,Sheet2!D$2,FALSE())","tb":1,"v":"16740621.9"}},{"r":35,"c":4,"v":{"f":"=VLOOKUP($C36,Sheet1!$A$1:$S$39,Sheet2!E$2,FALSE())","tb":1,"v":"2949.8"}},{"r":35,"c":5,"v":{"f":"=VLOOKUP($C36,Sheet1!$A$1:$S$39,Sheet2!F$2,FALSE())","tb":1,"v":"4275449"}},{"r":35,"c":6,"v":{"f":"=VLOOKUP($C36,Sheet1!$A$1:$S$39,Sheet2!G$2,FALSE())","tb":1,"v":"702.6"}},{"r":35,"c":7,"v":{"f":"=VLOOKUP($C36,Sheet1!$A$1:$S$39,Sheet2!H$2,FALSE())","tb":1,"v":"12465172.9"}},{"r":35,"c":8,"v":{"f":"=VLOOKUP($C36,Sheet1!$A$1:$S$39,Sheet2!I$2,FALSE())","tb":1,"v":"2247.1999999999998"}},{"r":35,"c":9,"v":{"f":"=VLOOKUP($C36,Sheet1!$A$1:$S$39,Sheet2!J$2,FALSE())","tb":1,"v":"1955813.7"}},{"r":35,"c":10,"v":{"f":"=VLOOKUP($C36,Sheet1!$A$1:$S$39,Sheet2!K$2,FALSE())","tb":1,"v":"323.3"}},{"r":35,"c":11,"v":{"f":"=VLOOKUP($C36,Sheet1!$A$1:$S$39,Sheet2!L$2,FALSE())","tb":1,"v":"0"}},{"r":35,"c":12,"v":{"f":"=VLOOKUP($C36,Sheet1!$A$1:$S$39,Sheet2!M$2,FALSE())","tb":1,"v":"0"}},{"r":35,"c":13,"v":{"f":"=VLOOKUP($C36,Sheet1!$A$1:$S$39,Sheet2!N$2,FALSE())","tb":1,"v":"1955813.7"}},{"r":35,"c":14,"v":{"f":"=VLOOKUP($C36,Sheet1!$A$1:$S$39,Sheet2!O$2,FALSE())","tb":1,"v":"323.3"}},{"r":35,"c":15,"v":{"f":"=VLOOKUP($C36,Sheet1!$A$1:$S$39,Sheet2!P$2,FALSE())","tb":1,"v":"14784808.199999999"}},{"r":35,"c":16,"v":{"f":"=VLOOKUP($C36,Sheet1!$A$1:$S$39,Sheet2!Q$2,FALSE())","tb":1,"v":"2626.5"}},{"r":35,"c":17,"v":{"f":"=VLOOKUP($C36,Sheet1!$A$1:$S$39,Sheet2!R$2,FALSE())","tb":1,"v":"4275449"}},{"r":35,"c":18,"v":{"f":"=VLOOKUP($C36,Sheet1!$A$1:$S$39,Sheet2!S$2,FALSE())","tb":1,"v":"702.6"}},{"r":36,"c":2,"v":{"f":"=Sheet1!A34","tb":1,"v":"大区小计"}},{"r":36,"c":3,"v":{"f":"=VLOOKUP($C37,Sheet1!$A$1:$S$39,Sheet2!D$2,FALSE())","tb":1,"v":"36024451898.699997"}},{"r":36,"c":4,"v":{"f":"=VLOOKUP($C37,Sheet1!$A$1:$S$39,Sheet2!E$2,FALSE())","tb":1,"v":"5752528"}},{"r":36,"c":5,"v":{"f":"=VLOOKUP($C37,Sheet1!$A$1:$S$39,Sheet2!F$2,FALSE())","tb":1,"v":"21255742056"}},{"r":36,"c":6,"v":{"f":"=VLOOKUP($C37,Sheet1!$A$1:$S$39,Sheet2!G$2,FALSE())","tb":1,"v":"3068184.5"}},{"r":36,"c":7,"v":{"f":"=VLOOKUP($C37,Sheet1!$A$1:$S$39,Sheet2!H$2,FALSE())","tb":1,"v":"14768709842.700001"}},{"r":36,"c":8,"v":{"f":"=VLOOKUP($C37,Sheet1!$A$1:$S$39,Sheet2!I$2,FALSE())","tb":1,"v":"2684343.5"}},{"r":36,"c":9,"v":{"f":"=VLOOKUP($C37,Sheet1!$A$1:$S$39,Sheet2!J$2,FALSE())","tb":1,"v":"371099084.69999999"}},{"r":36,"c":10,"v":{"f":"=VLOOKUP($C37,Sheet1!$A$1:$S$39,Sheet2!K$2,FALSE())","tb":1,"v":"75830.899999999994"}},{"r":36,"c":11,"v":{"f":"=VLOOKUP($C37,Sheet1!$A$1:$S$39,Sheet2!L$2,FALSE())","tb":1,"v":"31247035"}},{"r":36,"c":12,"v":{"f":"=VLOOKUP($C37,Sheet1!$A$1:$S$39,Sheet2!M$2,FALSE())","tb":1,"v":"6773.8"}},{"r":36,"c":13,"v":{"f":"=VLOOKUP($C37,Sheet1!$A$1:$S$39,Sheet2!N$2,FALSE())","tb":1,"v":"339852049.69999999"}},{"r":36,"c":14,"v":{"f":"=VLOOKUP($C37,Sheet1!$A$1:$S$39,Sheet2!O$2,FALSE())","tb":1,"v":"69057.100000000006"}},{"r":36,"c":15,"v":{"f":"=VLOOKUP($C37,Sheet1!$A$1:$S$39,Sheet2!P$2,FALSE())","tb":1,"v":"35653352814"}},{"r":36,"c":16,"v":{"f":"=VLOOKUP($C37,Sheet1!$A$1:$S$39,Sheet2!Q$2,FALSE())","tb":1,"v":"5676697.0999999996"}},{"r":36,"c":17,"v":{"f":"=VLOOKUP($C37,Sheet1!$A$1:$S$39,Sheet2!R$2,FALSE())","tb":1,"v":"21224495021"}},{"r":36,"c":18,"v":{"f":"=VLOOKUP($C37,Sheet1!$A$1:$S$39,Sheet2!S$2,FALSE())","tb":1,"v":"3061410.7"}},{"r":37,"c":2,"v":{"f":"=Sheet1!A35","tb":1,"v":"华北"}},{"r":37,"c":3,"v":{"f":"=VLOOKUP($C38,Sheet1!$A$1:$S$39,Sheet2!D$2,FALSE())","tb":1,"v":"8979562707.2999992"}},{"r":37,"c":4,"v":{"f":"=VLOOKUP($C38,Sheet1!$A$1:$S$39,Sheet2!E$2,FALSE())","tb":1,"v":"1430431.3"}},{"r":37,"c":5,"v":{"f":"=VLOOKUP($C38,Sheet1!$A$1:$S$39,Sheet2!F$2,FALSE())","tb":1,"v":"5769830804.1000004"}},{"r":37,"c":6,"v":{"f":"=VLOOKUP($C38,Sheet1!$A$1:$S$39,Sheet2!G$2,FALSE())","tb":1,"v":"851308"}},{"r":37,"c":7,"v":{"f":"=VLOOKUP($C38,Sheet1!$A$1:$S$39,Sheet2!H$2,FALSE())","tb":1,"v":"3209731903.1999998"}},{"r":37,"c":8,"v":{"f":"=VLOOKUP($C38,Sheet1!$A$1:$S$39,Sheet2!I$2,FALSE())","tb":1,"v":"579123.30000000005"}},{"r":37,"c":9,"v":{"f":"=VLOOKUP($C38,Sheet1!$A$1:$S$39,Sheet2!J$2,FALSE())","tb":1,"v":"80191139.5"}},{"r":37,"c":10,"v":{"f":"=VLOOKUP($C38,Sheet1!$A$1:$S$39,Sheet2!K$2,FALSE())","tb":1,"v":"16249.4"}},{"r":37,"c":11,"v":{"f":"=VLOOKUP($C38,Sheet1!$A$1:$S$39,Sheet2!L$2,FALSE())","tb":1,"v":"0"}},{"r":37,"c":12,"v":{"f":"=VLOOKUP($C38,Sheet1!$A$1:$S$39,Sheet2!M$2,FALSE())","tb":1,"v":"0"}},{"r":37,"c":13,"v":{"f":"=VLOOKUP($C38,Sheet1!$A$1:$S$39,Sheet2!N$2,FALSE())","tb":1,"v":"80191139.5"}},{"r":37,"c":14,"v":{"f":"=VLOOKUP($C38,Sheet1!$A$1:$S$39,Sheet2!O$2,FALSE())","tb":1,"v":"16249.4"}},{"r":37,"c":15,"v":{"f":"=VLOOKUP($C38,Sheet1!$A$1:$S$39,Sheet2!P$2,FALSE())","tb":1,"v":"8899371567.8999996"}},{"r":37,"c":16,"v":{"f":"=VLOOKUP($C38,Sheet1!$A$1:$S$39,Sheet2!Q$2,FALSE())","tb":1,"v":"1414181.9"}},{"r":37,"c":17,"v":{"f":"=VLOOKUP($C38,Sheet1!$A$1:$S$39,Sheet2!R$2,FALSE())","tb":1,"v":"5769830804.1000004"}},{"r":37,"c":18,"v":{"f":"=VLOOKUP($C38,Sheet1!$A$1:$S$39,Sheet2!S$2,FALSE())","tb":1,"v":"851308"}},{"r":38,"c":2,"v":{"f":"=Sheet1!A36","tb":1,"v":"华东"}},{"r":38,"c":3,"v":{"f":"=VLOOKUP($C39,Sheet1!$A$1:$S$39,Sheet2!D$2,FALSE())","tb":1,"v":"7743100122.6000004"}},{"r":38,"c":4,"v":{"f":"=VLOOKUP($C39,Sheet1!$A$1:$S$39,Sheet2!E$2,FALSE())","tb":1,"v":"1238875.3999999999"}},{"r":38,"c":5,"v":{"f":"=VLOOKUP($C39,Sheet1!$A$1:$S$39,Sheet2!F$2,FALSE())","tb":1,"v":"4813028321"}},{"r":38,"c":6,"v":{"f":"=VLOOKUP($C39,Sheet1!$A$1:$S$39,Sheet2!G$2,FALSE())","tb":1,"v":"696549.2"}},{"r":38,"c":7,"v":{"f":"=VLOOKUP($C39,Sheet1!$A$1:$S$39,Sheet2!H$2,FALSE())","tb":1,"v":"2930071801.5999999"}},{"r":38,"c":8,"v":{"f":"=VLOOKUP($C39,Sheet1!$A$1:$S$39,Sheet2!I$2,FALSE())","tb":1,"v":"542326.19999999995"}},{"r":38,"c":9,"v":{"f":"=VLOOKUP($C39,Sheet1!$A$1:$S$39,Sheet2!J$2,FALSE())","tb":1,"v":"72956393.599999994"}},{"r":38,"c":10,"v":{"f":"=VLOOKUP($C39,Sheet1!$A$1:$S$39,Sheet2!K$2,FALSE())","tb":1,"v":"15326.1"}},{"r":38,"c":11,"v":{"f":"=VLOOKUP($C39,Sheet1!$A$1:$S$39,Sheet2!L$2,FALSE())","tb":1,"v":"8332411"}},{"r":38,"c":12,"v":{"f":"=VLOOKUP($C39,Sheet1!$A$1:$S$39,Sheet2!M$2,FALSE())","tb":1,"v":"2000"}},{"r":38,"c":13,"v":{"f":"=VLOOKUP($C39,Sheet1!$A$1:$S$39,Sheet2!N$2,FALSE())","tb":1,"v":"64623982.600000001"}},{"r":38,"c":14,"v":{"f":"=VLOOKUP($C39,Sheet1!$A$1:$S$39,Sheet2!O$2,FALSE())","tb":1,"v":"13326.2"}},{"r":38,"c":15,"v":{"f":"=VLOOKUP($C39,Sheet1!$A$1:$S$39,Sheet2!P$2,FALSE())","tb":1,"v":"7670143729"}},{"r":38,"c":16,"v":{"f":"=VLOOKUP($C39,Sheet1!$A$1:$S$39,Sheet2!Q$2,FALSE())","tb":1,"v":"1223549.3"}},{"r":38,"c":17,"v":{"f":"=VLOOKUP($C39,Sheet1!$A$1:$S$39,Sheet2!R$2,FALSE())","tb":1,"v":"4804695910"}},{"r":38,"c":18,"v":{"f":"=VLOOKUP($C39,Sheet1!$A$1:$S$39,Sheet2!S$2,FALSE())","tb":1,"v":"694549.2"}},{"r":39,"c":2,"v":{"f":"=Sheet1!A37","tb":1,"v":"华中"}},{"r":39,"c":3,"v":{"f":"=VLOOKUP($C40,Sheet1!$A$1:$S$39,Sheet2!D$2,FALSE())","tb":1,"v":"6445973642.6999998"}},{"r":39,"c":4,"v":{"f":"=VLOOKUP($C40,Sheet1!$A$1:$S$39,Sheet2!E$2,FALSE())","tb":1,"v":"1002082.6"}},{"r":39,"c":5,"v":{"f":"=VLOOKUP($C40,Sheet1!$A$1:$S$39,Sheet2!F$2,FALSE())","tb":1,"v":"3738291609.9000001"}},{"r":39,"c":6,"v":{"f":"=VLOOKUP($C40,Sheet1!$A$1:$S$39,Sheet2!G$2,FALSE())","tb":1,"v":"524638.9"}},{"r":39,"c":7,"v":{"f":"=VLOOKUP($C40,Sheet1!$A$1:$S$39,Sheet2!H$2,FALSE())","tb":1,"v":"2707682032.9000001"}},{"r":39,"c":8,"v":{"f":"=VLOOKUP($C40,Sheet1!$A$1:$S$39,Sheet2!I$2,FALSE())","tb":1,"v":"477443.7"}},{"r":39,"c":9,"v":{"f":"=VLOOKUP($C40,Sheet1!$A$1:$S$39,Sheet2!J$2,FALSE())","tb":1,"v":"154601705.40000001"}},{"r":39,"c":10,"v":{"f":"=VLOOKUP($C40,Sheet1!$A$1:$S$39,Sheet2!K$2,FALSE())","tb":1,"v":"32604.9"}},{"r":39,"c":11,"v":{"f":"=VLOOKUP($C40,Sheet1!$A$1:$S$39,Sheet2!L$2,FALSE())","tb":1,"v":"22914624"}},{"r":39,"c":12,"v":{"f":"=VLOOKUP($C40,Sheet1!$A$1:$S$39,Sheet2!M$2,FALSE())","tb":1,"v":"4773.8"}},{"r":39,"c":13,"v":{"f":"=VLOOKUP($C40,Sheet1!$A$1:$S$39,Sheet2!N$2,FALSE())","tb":1,"v":"131687081.40000001"}},{"r":39,"c":14,"v":{"f":"=VLOOKUP($C40,Sheet1!$A$1:$S$39,Sheet2!O$2,FALSE())","tb":1,"v":"27831"}},{"r":39,"c":15,"v":{"f":"=VLOOKUP($C40,Sheet1!$A$1:$S$39,Sheet2!P$2,FALSE())","tb":1,"v":"6291371937.3000002"}},{"r":39,"c":16,"v":{"f":"=VLOOKUP($C40,Sheet1!$A$1:$S$39,Sheet2!Q$2,FALSE())","tb":1,"v":"969477.8"}},{"r":39,"c":17,"v":{"f":"=VLOOKUP($C40,Sheet1!$A$1:$S$39,Sheet2!R$2,FALSE())","tb":1,"v":"3715376985.9000001"}},{"r":39,"c":18,"v":{"f":"=VLOOKUP($C40,Sheet1!$A$1:$S$39,Sheet2!S$2,FALSE())","tb":1,"v":"519865.1"}},{"r":40,"c":2,"v":{"f":"=Sheet1!A38","tb":1,"v":"华南"}},{"r":40,"c":3,"v":{"f":"=VLOOKUP($C41,Sheet1!$A$1:$S$39,Sheet2!D$2,FALSE())","tb":1,"v":"11537868598.799999"}},{"r":40,"c":4,"v":{"f":"=VLOOKUP($C41,Sheet1!$A$1:$S$39,Sheet2!E$2,FALSE())","tb":1,"v":"1836507.6"}},{"r":40,"c":5,"v":{"f":"=VLOOKUP($C41,Sheet1!$A$1:$S$39,Sheet2!F$2,FALSE())","tb":1,"v":"6442924168.1000004"}},{"r":40,"c":6,"v":{"f":"=VLOOKUP($C41,Sheet1!$A$1:$S$39,Sheet2!G$2,FALSE())","tb":1,"v":"914431.9"}},{"r":40,"c":7,"v":{"f":"=VLOOKUP($C41,Sheet1!$A$1:$S$39,Sheet2!H$2,FALSE())","tb":1,"v":"5094944430.6999998"}},{"r":40,"c":8,"v":{"f":"=VLOOKUP($C41,Sheet1!$A$1:$S$39,Sheet2!I$2,FALSE())","tb":1,"v":"922075.7"}},{"r":40,"c":9,"v":{"f":"=VLOOKUP($C41,Sheet1!$A$1:$S$39,Sheet2!J$2,FALSE())","tb":1,"v":"34995802.399999999"}},{"r":40,"c":10,"v":{"f":"=VLOOKUP($C41,Sheet1!$A$1:$S$39,Sheet2!K$2,FALSE())","tb":1,"v":"7091.3"}},{"r":40,"c":11,"v":{"f":"=VLOOKUP($C41,Sheet1!$A$1:$S$39,Sheet2!L$2,FALSE())","tb":1,"v":"0"}},{"r":40,"c":12,"v":{"f":"=VLOOKUP($C41,Sheet1!$A$1:$S$39,Sheet2!M$2,FALSE())","tb":1,"v":"0"}},{"r":40,"c":13,"v":{"f":"=VLOOKUP($C41,Sheet1!$A$1:$S$39,Sheet2!N$2,FALSE())","tb":1,"v":"34995802.399999999"}},{"r":40,"c":14,"v":{"f":"=VLOOKUP($C41,Sheet1!$A$1:$S$39,Sheet2!O$2,FALSE())","tb":1,"v":"7091.3"}},{"r":40,"c":15,"v":{"f":"=VLOOKUP($C41,Sheet1!$A$1:$S$39,Sheet2!P$2,FALSE())","tb":1,"v":"11502872796.4"}},{"r":40,"c":16,"v":{"f":"=VLOOKUP($C41,Sheet1!$A$1:$S$39,Sheet2!Q$2,FALSE())","tb":1,"v":"1829416.4"}},{"r":40,"c":17,"v":{"f":"=VLOOKUP($C41,Sheet1!$A$1:$S$39,Sheet2!R$2,FALSE())","tb":1,"v":"6442924168.1000004"}},{"r":40,"c":18,"v":{"f":"=VLOOKUP($C41,Sheet1!$A$1:$S$39,Sheet2!S$2,FALSE())","tb":1,"v":"914431.9"}},{"r":41,"c":2,"v":{"f":"=Sheet1!A39","tb":1,"v":"西北"}},{"r":41,"c":3,"v":{"f":"=VLOOKUP($C42,Sheet1!$A$1:$S$39,Sheet2!D$2,FALSE())","tb":1,"v":"1317946827.2"}},{"r":41,"c":4,"v":{"f":"=VLOOKUP($C42,Sheet1!$A$1:$S$39,Sheet2!E$2,FALSE())","tb":1,"v":"244631"}},{"r":41,"c":5,"v":{"f":"=VLOOKUP($C42,Sheet1!$A$1:$S$39,Sheet2!F$2,FALSE())","tb":1,"v":"491667152.89999998"}},{"r":41,"c":6,"v":{"f":"=VLOOKUP($C42,Sheet1!$A$1:$S$39,Sheet2!G$2,FALSE())","tb":1,"v":"81256.5"}},{"r":41,"c":7,"v":{"f":"=VLOOKUP($C42,Sheet1!$A$1:$S$39,Sheet2!H$2,FALSE())","tb":1,"v":"826279674.29999995"}},{"r":41,"c":8,"v":{"f":"=VLOOKUP($C42,Sheet1!$A$1:$S$39,Sheet2!I$2,FALSE())","tb":1,"v":"163374.5"}},{"r":41,"c":9,"v":{"f":"=VLOOKUP($C42,Sheet1!$A$1:$S$39,Sheet2!J$2,FALSE())","tb":1,"v":"28354043.800000001"}},{"r":41,"c":10,"v":{"f":"=VLOOKUP($C42,Sheet1!$A$1:$S$39,Sheet2!K$2,FALSE())","tb":1,"v":"4559.2"}},{"r":41,"c":11,"v":{"f":"=VLOOKUP($C42,Sheet1!$A$1:$S$39,Sheet2!L$2,FALSE())","tb":1,"v":"0"}},{"r":41,"c":12,"v":{"f":"=VLOOKUP($C42,Sheet1!$A$1:$S$39,Sheet2!M$2,FALSE())","tb":1,"v":"0"}},{"r":41,"c":13,"v":{"f":"=VLOOKUP($C42,Sheet1!$A$1:$S$39,Sheet2!N$2,FALSE())","tb":1,"v":"28354043.800000001"}},{"r":41,"c":14,"v":{"f":"=VLOOKUP($C42,Sheet1!$A$1:$S$39,Sheet2!O$2,FALSE())","tb":1,"v":"4559.2"}},{"r":41,"c":15,"v":{"f":"=VLOOKUP($C42,Sheet1!$A$1:$S$39,Sheet2!P$2,FALSE())","tb":1,"v":"1289592783.4000001"}},{"r":41,"c":16,"v":{"f":"=VLOOKUP($C42,Sheet1!$A$1:$S$39,Sheet2!Q$2,FALSE())","tb":1,"v":"240071.8"}},{"r":41,"c":17,"v":{"f":"=VLOOKUP($C42,Sheet1!$A$1:$S$39,Sheet2!R$2,FALSE())","tb":1,"v":"491667152.89999998"}},{"r":41,"c":18,"v":{"f":"=VLOOKUP($C42,Sheet1!$A$1:$S$39,Sheet2!S$2,FALSE())","tb":1,"v":"81256.5"}}],"calcChain":[{"r":41,"c":2,"index":"2"},{"r":41,"c":3,"index":"2"},{"r":4,"c":2,"index":"2"},{"r":4,"c":3,"index":"2"},{"r":5,"c":2,"index":"2"},{"r":5,"c":3,"index":"2"},{"r":6,"c":2,"index":"2"},{"r":6,"c":3,"index":"2"},{"r":7,"c":2,"index":"2"},{"r":7,"c":3,"index":"2"},{"r":8,"c":2,"index":"2"},{"r":8,"c":3,"index":"2"},{"r":9,"c":2,"index":"2"},{"r":9,"c":3,"index":"2"},{"r":10,"c":2,"index":"2"},{"r":10,"c":3,"index":"2"},{"r":11,"c":2,"index":"2"},{"r":11,"c":3,"index":"2"},{"r":12,"c":2,"index":"2"},{"r":12,"c":3,"index":"2"},{"r":13,"c":2,"index":"2"},{"r":13,"c":3,"index":"2"},{"r":14,"c":2,"index":"2"},{"r":14,"c":3,"index":"2"},{"r":15,"c":2,"index":"2"},{"r":15,"c":3,"index":"2"},{"r":16,"c":2,"index":"2"},{"r":16,"c":3,"index":"2"},{"r":17,"c":2,"index":"2"},{"r":17,"c":3,"index":"2"},{"r":18,"c":2,"index":"2"},{"r":18,"c":3,"index":"2"},{"r":19,"c":2,"index":"2"},{"r":19,"c":3,"index":"2"},{"r":20,"c":2,"index":"2"},{"r":20,"c":3,"index":"2"},{"r":21,"c":2,"index":"2"},{"r":21,"c":3,"index":"2"},{"r":22,"c":2,"index":"2"},{"r":22,"c":3,"index":"2"},{"r":23,"c":2,"index":"2"},{"r":23,"c":3,"index":"2"},{"r":24,"c":2,"index":"2"},{"r":24,"c":3,"index":"2"},{"r":25,"c":2,"index":"2"},{"r":25,"c":3,"index":"2"},{"r":26,"c":2,"index":"2"},{"r":26,"c":3,"index":"2"},{"r":27,"c":2,"index":"2"},{"r":27,"c":3,"index":"2"},{"r":28,"c":2,"index":"2"},{"r":28,"c":3,"index":"2"},{"r":29,"c":2,"index":"2"},{"r":29,"c":3,"index":"2"},{"r":30,"c":2,"index":"2"},{"r":30,"c":3,"index":"2"},{"r":31,"c":2,"index":"2"},{"r":31,"c":3,"index":"2"},{"r":32,"c":2,"index":"2"},{"r":32,"c":3,"index":"2"},{"r":33,"c":2,"index":"2"},{"r":33,"c":3,"index":"2"},{"r":34,"c":2,"index":"2"},{"r":34,"c":3,"index":"2"},{"r":35,"c":2,"index":"2"},{"r":35,"c":3,"index":"2"},{"r":36,"c":2,"index":"2"},{"r":36,"c":3,"index":"2"},{"r":37,"c":2,"index":"2"},{"r":37,"c":3,"index":"2"},{"r":38,"c":2,"index":"2"},{"r":38,"c":3,"index":"2"},{"r":39,"c":2,"index":"2"},{"r":39,"c":3,"index":"2"},{"r":40,"c":2,"index":"2"},{"r":40,"c":3,"index":"2"},{"r":3,"c":2,"index":"2"},{"r":3,"c":4,"index":"2"},{"r":3,"c":3,"index":"2"},{"r":3,"c":11,"index":"2"},{"r":40,"c":18,"index":"2"},{"r":40,"c":10,"index":"2"},{"r":39,"c":18,"index":"2"},{"r":39,"c":10,"index":"2"},{"r":38,"c":18,"index":"2"},{"r":38,"c":10,"index":"2"},{"r":37,"c":18,"index":"2"},{"r":37,"c":10,"index":"2"},{"r":36,"c":18,"index":"2"},{"r":36,"c":10,"index":"2"},{"r":35,"c":18,"index":"2"},{"r":35,"c":10,"index":"2"},{"r":34,"c":18,"index":"2"},{"r":34,"c":10,"index":"2"},{"r":33,"c":18,"index":"2"},{"r":33,"c":10,"index":"2"},{"r":32,"c":18,"index":"2"},{"r":32,"c":10,"index":"2"},{"r":31,"c":18,"index":"2"},{"r":31,"c":10,"index":"2"},{"r":30,"c":18,"index":"2"},{"r":30,"c":10,"index":"2"},{"r":29,"c":18,"index":"2"},{"r":29,"c":10,"index":"2"},{"r":28,"c":18,"index":"2"},{"r":28,"c":10,"index":"2"},{"r":27,"c":18,"index":"2"},{"r":27,"c":10,"index":"2"},{"r":26,"c":18,"index":"2"},{"r":26,"c":10,"index":"2"},{"r":25,"c":18,"index":"2"},{"r":25,"c":10,"index":"2"},{"r":24,"c":18,"index":"2"},{"r":24,"c":10,"index":"2"},{"r":23,"c":18,"index":"2"},{"r":23,"c":10,"index":"2"},{"r":22,"c":18,"index":"2"},{"r":22,"c":10,"index":"2"},{"r":21,"c":18,"index":"2"},{"r":21,"c":10,"index":"2"},{"r":20,"c":18,"index":"2"},{"r":20,"c":10,"index":"2"},{"r":19,"c":18,"index":"2"},{"r":19,"c":10,"index":"2"},{"r":18,"c":18,"index":"2"},{"r":18,"c":10,"index":"2"},{"r":17,"c":18,"index":"2"},{"r":17,"c":10,"index":"2"},{"r":16,"c":18,"index":"2"},{"r":16,"c":10,"index":"2"},{"r":15,"c":18,"index":"2"},{"r":15,"c":10,"index":"2"},{"r":14,"c":18,"index":"2"},{"r":14,"c":10,"index":"2"},{"r":13,"c":18,"index":"2"},{"r":13,"c":10,"index":"2"},{"r":12,"c":18,"index":"2"},{"r":12,"c":10,"index":"2"},{"r":11,"c":18,"index":"2"},{"r":11,"c":10,"index":"2"},{"r":10,"c":18,"index":"2"},{"r":10,"c":10,"index":"2"},{"r":9,"c":18,"index":"2"},{"r":9,"c":10,"index":"2"},{"r":8,"c":18,"index":"2"},{"r":8,"c":10,"index":"2"},{"r":7,"c":18,"index":"2"},{"r":7,"c":10,"index":"2"},{"r":6,"c":18,"index":"2"},{"r":6,"c":10,"index":"2"},{"r":5,"c":18,"index":"2"},{"r":5,"c":10,"index":"2"},{"r":4,"c":18,"index":"2"},{"r":4,"c":10,"index":"2"},{"r":41,"c":18,"index":"2"},{"r":41,"c":10,"index":"2"},{"r":3,"c":18,"index":"2"},{"r":3,"c":10,"index":"2"},{"r":40,"c":17,"index":"2"},{"r":40,"c":9,"index":"2"},{"r":39,"c":17,"index":"2"},{"r":39,"c":9,"index":"2"},{"r":38,"c":17,"index":"2"},{"r":38,"c":9,"index":"2"},{"r":37,"c":17,"index":"2"},{"r":37,"c":9,"index":"2"},{"r":36,"c":17,"index":"2"},{"r":36,"c":9,"index":"2"},{"r":35,"c":17,"index":"2"},{"r":35,"c":9,"index":"2"},{"r":34,"c":17,"index":"2"},{"r":34,"c":9,"index":"2"},{"r":33,"c":17,"index":"2"},{"r":33,"c":9,"index":"2"},{"r":32,"c":17,"index":"2"},{"r":32,"c":9,"index":"2"},{"r":31,"c":17,"index":"2"},{"r":31,"c":9,"index":"2"},{"r":30,"c":17,"index":"2"},{"r":30,"c":9,"index":"2"},{"r":29,"c":17,"index":"2"},{"r":29,"c":9,"index":"2"},{"r":28,"c":17,"index":"2"},{"r":28,"c":9,"index":"2"},{"r":27,"c":17,"index":"2"},{"r":27,"c":9,"index":"2"},{"r":26,"c":17,"index":"2"},{"r":26,"c":9,"index":"2"},{"r":25,"c":17,"index":"2"},{"r":25,"c":9,"index":"2"},{"r":24,"c":17,"index":"2"},{"r":24,"c":9,"index":"2"},{"r":23,"c":17,"index":"2"},{"r":23,"c":9,"index":"2"},{"r":22,"c":17,"index":"2"},{"r":22,"c":9,"index":"2"},{"r":21,"c":17,"index":"2"},{"r":21,"c":9,"index":"2"},{"r":20,"c":17,"index":"2"},{"r":20,"c":9,"index":"2"},{"r":19,"c":17,"index":"2"},{"r":19,"c":9,"index":"2"},{"r":18,"c":17,"index":"2"},{"r":18,"c":9,"index":"2"},{"r":17,"c":17,"index":"2"},{"r":17,"c":9,"index":"2"},{"r":16,"c":17,"index":"2"},{"r":16,"c":9,"index":"2"},{"r":15,"c":17,"index":"2"},{"r":15,"c":9,"index":"2"},{"r":14,"c":17,"index":"2"},{"r":14,"c":9,"index":"2"},{"r":13,"c":17,"index":"2"},{"r":13,"c":9,"index":"2"},{"r":12,"c":17,"index":"2"},{"r":12,"c":9,"index":"2"},{"r":11,"c":17,"index":"2"},{"r":11,"c":9,"index":"2"},{"r":10,"c":17,"index":"2"},{"r":10,"c":9,"index":"2"},{"r":9,"c":17,"index":"2"},{"r":9,"c":9,"index":"2"},{"r":8,"c":17,"index":"2"},{"r":8,"c":9,"index":"2"},{"r":7,"c":17,"index":"2"},{"r":7,"c":9,"index":"2"},{"r":6,"c":17,"index":"2"},{"r":6,"c":9,"index":"2"},{"r":5,"c":17,"index":"2"},{"r":5,"c":9,"index":"2"},{"r":4,"c":17,"index":"2"},{"r":4,"c":9,"index":"2"},{"r":41,"c":17,"index":"2"},{"r":41,"c":9,"index":"2"},{"r":3,"c":17,"index":"2"},{"r":3,"c":9,"index":"2"},{"r":40,"c":16,"index":"2"},{"r":40,"c":8,"index":"2"},{"r":39,"c":16,"index":"2"},{"r":39,"c":8,"index":"2"},{"r":38,"c":16,"index":"2"},{"r":38,"c":8,"index":"2"},{"r":37,"c":16,"index":"2"},{"r":37,"c":8,"index":"2"},{"r":36,"c":16,"index":"2"},{"r":36,"c":8,"index":"2"},{"r":35,"c":16,"index":"2"},{"r":35,"c":8,"index":"2"},{"r":34,"c":16,"index":"2"},{"r":34,"c":8,"index":"2"},{"r":33,"c":16,"index":"2"},{"r":33,"c":8,"index":"2"},{"r":32,"c":16,"index":"2"},{"r":32,"c":8,"index":"2"},{"r":31,"c":16,"index":"2"},{"r":31,"c":8,"index":"2"},{"r":30,"c":16,"index":"2"},{"r":30,"c":8,"index":"2"},{"r":29,"c":16,"index":"2"},{"r":29,"c":8,"index":"2"},{"r":28,"c":16,"index":"2"},{"r":28,"c":8,"index":"2"},{"r":27,"c":16,"index":"2"},{"r":27,"c":8,"index":"2"},{"r":26,"c":16,"index":"2"},{"r":26,"c":8,"index":"2"},{"r":25,"c":16,"index":"2"},{"r":25,"c":8,"index":"2"},{"r":24,"c":16,"index":"2"},{"r":24,"c":8,"index":"2"},{"r":23,"c":16,"index":"2"},{"r":23,"c":8,"index":"2"},{"r":22,"c":16,"index":"2"},{"r":22,"c":8,"index":"2"},{"r":21,"c":16,"index":"2"},{"r":21,"c":8,"index":"2"},{"r":20,"c":16,"index":"2"},{"r":20,"c":8,"index":"2"},{"r":19,"c":16,"index":"2"},{"r":19,"c":8,"index":"2"},{"r":18,"c":16,"index":"2"},{"r":18,"c":8,"index":"2"},{"r":17,"c":16,"index":"2"},{"r":17,"c":8,"index":"2"},{"r":16,"c":16,"index":"2"},{"r":16,"c":8,"index":"2"},{"r":15,"c":16,"index":"2"},{"r":15,"c":8,"index":"2"},{"r":14,"c":16,"index":"2"},{"r":14,"c":8,"index":"2"},{"r":13,"c":16,"index":"2"},{"r":13,"c":8,"index":"2"},{"r":12,"c":16,"index":"2"},{"r":12,"c":8,"index":"2"},{"r":11,"c":16,"index":"2"},{"r":11,"c":8,"index":"2"},{"r":10,"c":16,"index":"2"},{"r":10,"c":8,"index":"2"},{"r":9,"c":16,"index":"2"},{"r":9,"c":8,"index":"2"},{"r":8,"c":16,"index":"2"},{"r":8,"c":8,"index":"2"},{"r":7,"c":16,"index":"2"},{"r":7,"c":8,"index":"2"},{"r":6,"c":16,"index":"2"},{"r":6,"c":8,"index":"2"},{"r":5,"c":16,"index":"2"},{"r":5,"c":8,"index":"2"},{"r":4,"c":16,"index":"2"},{"r":4,"c":8,"index":"2"},{"r":41,"c":16,"index":"2"},{"r":41,"c":8,"index":"2"},{"r":3,"c":16,"index":"2"},{"r":3,"c":8,"index":"2"},{"r":40,"c":15,"index":"2"},{"r":40,"c":7,"index":"2"},{"r":39,"c":15,"index":"2"},{"r":39,"c":7,"index":"2"},{"r":38,"c":15,"index":"2"},{"r":38,"c":7,"index":"2"},{"r":37,"c":15,"index":"2"},{"r":37,"c":7,"index":"2"},{"r":36,"c":15,"index":"2"},{"r":36,"c":7,"index":"2"},{"r":35,"c":15,"index":"2"},{"r":35,"c":7,"index":"2"},{"r":34,"c":15,"index":"2"},{"r":34,"c":7,"index":"2"},{"r":33,"c":15,"index":"2"},{"r":33,"c":7,"index":"2"},{"r":32,"c":15,"index":"2"},{"r":32,"c":7,"index":"2"},{"r":31,"c":15,"index":"2"},{"r":31,"c":7,"index":"2"},{"r":30,"c":15,"index":"2"},{"r":30,"c":7,"index":"2"},{"r":29,"c":15,"index":"2"},{"r":29,"c":7,"index":"2"},{"r":28,"c":15,"index":"2"},{"r":28,"c":7,"index":"2"},{"r":27,"c":15,"index":"2"},{"r":27,"c":7,"index":"2"},{"r":26,"c":15,"index":"2"},{"r":26,"c":7,"index":"2"},{"r":25,"c":15,"index":"2"},{"r":25,"c":7,"index":"2"},{"r":24,"c":15,"index":"2"},{"r":24,"c":7,"index":"2"},{"r":23,"c":15,"index":"2"},{"r":23,"c":7,"index":"2"},{"r":22,"c":15,"index":"2"},{"r":22,"c":7,"index":"2"},{"r":21,"c":15,"index":"2"},{"r":21,"c":7,"index":"2"},{"r":20,"c":15,"index":"2"},{"r":20,"c":7,"index":"2"},{"r":19,"c":15,"index":"2"},{"r":19,"c":7,"index":"2"},{"r":18,"c":15,"index":"2"},{"r":18,"c":7,"index":"2"},{"r":17,"c":15,"index":"2"},{"r":17,"c":7,"index":"2"},{"r":16,"c":15,"index":"2"},{"r":16,"c":7,"index":"2"},{"r":15,"c":15,"index":"2"},{"r":15,"c":7,"index":"2"},{"r":14,"c":15,"index":"2"},{"r":14,"c":7,"index":"2"},{"r":13,"c":15,"index":"2"},{"r":13,"c":7,"index":"2"},{"r":12,"c":15,"index":"2"},{"r":12,"c":7,"index":"2"},{"r":11,"c":15,"index":"2"},{"r":11,"c":7,"index":"2"},{"r":10,"c":15,"index":"2"},{"r":10,"c":7,"index":"2"},{"r":9,"c":15,"index":"2"},{"r":9,"c":7,"index":"2"},{"r":8,"c":15,"index":"2"},{"r":8,"c":7,"index":"2"},{"r":7,"c":15,"index":"2"},{"r":7,"c":7,"index":"2"},{"r":6,"c":15,"index":"2"},{"r":6,"c":7,"index":"2"},{"r":5,"c":15,"index":"2"},{"r":5,"c":7,"index":"2"},{"r":4,"c":15,"index":"2"},{"r":4,"c":7,"index":"2"},{"r":41,"c":15,"index":"2"},{"r":41,"c":7,"index":"2"},{"r":3,"c":15,"index":"2"},{"r":3,"c":7,"index":"2"},{"r":40,"c":14,"index":"2"},{"r":40,"c":6,"index":"2"},{"r":39,"c":14,"index":"2"},{"r":39,"c":6,"index":"2"},{"r":38,"c":14,"index":"2"},{"r":38,"c":6,"index":"2"},{"r":37,"c":14,"index":"2"},{"r":37,"c":6,"index":"2"},{"r":36,"c":14,"index":"2"},{"r":36,"c":6,"index":"2"},{"r":35,"c":14,"index":"2"},{"r":35,"c":6,"index":"2"},{"r":34,"c":14,"index":"2"},{"r":34,"c":6,"index":"2"},{"r":33,"c":14,"index":"2"},{"r":33,"c":6,"index":"2"},{"r":32,"c":14,"index":"2"},{"r":32,"c":6,"index":"2"},{"r":31,"c":14,"index":"2"},{"r":31,"c":6,"index":"2"},{"r":30,"c":14,"index":"2"},{"r":30,"c":6,"index":"2"},{"r":29,"c":14,"index":"2"},{"r":29,"c":6,"index":"2"},{"r":28,"c":14,"index":"2"},{"r":28,"c":6,"index":"2"},{"r":27,"c":14,"index":"2"},{"r":27,"c":6,"index":"2"},{"r":26,"c":14,"index":"2"},{"r":26,"c":6,"index":"2"},{"r":25,"c":14,"index":"2"},{"r":25,"c":6,"index":"2"},{"r":24,"c":14,"index":"2"},{"r":24,"c":6,"index":"2"},{"r":23,"c":14,"index":"2"},{"r":23,"c":6,"index":"2"},{"r":22,"c":14,"index":"2"},{"r":22,"c":6,"index":"2"},{"r":21,"c":14,"index":"2"},{"r":21,"c":6,"index":"2"},{"r":20,"c":14,"index":"2"},{"r":20,"c":6,"index":"2"},{"r":19,"c":14,"index":"2"},{"r":19,"c":6,"index":"2"},{"r":18,"c":14,"index":"2"},{"r":18,"c":6,"index":"2"},{"r":17,"c":14,"index":"2"},{"r":17,"c":6,"index":"2"},{"r":16,"c":14,"index":"2"},{"r":16,"c":6,"index":"2"},{"r":15,"c":14,"index":"2"},{"r":15,"c":6,"index":"2"},{"r":14,"c":14,"index":"2"},{"r":14,"c":6,"index":"2"},{"r":13,"c":14,"index":"2"},{"r":13,"c":6,"index":"2"},{"r":12,"c":14,"index":"2"},{"r":12,"c":6,"index":"2"},{"r":11,"c":14,"index":"2"},{"r":11,"c":6,"index":"2"},{"r":10,"c":14,"index":"2"},{"r":10,"c":6,"index":"2"},{"r":9,"c":14,"index":"2"},{"r":9,"c":6,"index":"2"},{"r":8,"c":14,"index":"2"},{"r":8,"c":6,"index":"2"},{"r":7,"c":14,"index":"2"},{"r":7,"c":6,"index":"2"},{"r":6,"c":14,"index":"2"},{"r":6,"c":6,"index":"2"},{"r":5,"c":14,"index":"2"},{"r":5,"c":6,"index":"2"},{"r":4,"c":14,"index":"2"},{"r":4,"c":6,"index":"2"},{"r":41,"c":14,"index":"2"},{"r":41,"c":6,"index":"2"},{"r":3,"c":14,"index":"2"},{"r":3,"c":6,"index":"2"},{"r":40,"c":13,"index":"2"},{"r":40,"c":5,"index":"2"},{"r":39,"c":13,"index":"2"},{"r":39,"c":5,"index":"2"},{"r":38,"c":13,"index":"2"},{"r":38,"c":5,"index":"2"},{"r":37,"c":13,"index":"2"},{"r":37,"c":5,"index":"2"},{"r":36,"c":13,"index":"2"},{"r":36,"c":5,"index":"2"},{"r":35,"c":13,"index":"2"},{"r":35,"c":5,"index":"2"},{"r":34,"c":13,"index":"2"},{"r":34,"c":5,"index":"2"},{"r":33,"c":13,"index":"2"},{"r":33,"c":5,"index":"2"},{"r":32,"c":13,"index":"2"},{"r":32,"c":5,"index":"2"},{"r":31,"c":13,"index":"2"},{"r":31,"c":5,"index":"2"},{"r":30,"c":13,"index":"2"},{"r":30,"c":5,"index":"2"},{"r":29,"c":13,"index":"2"},{"r":29,"c":5,"index":"2"},{"r":28,"c":13,"index":"2"},{"r":28,"c":5,"index":"2"},{"r":27,"c":13,"index":"2"},{"r":27,"c":5,"index":"2"},{"r":26,"c":13,"index":"2"},{"r":26,"c":5,"index":"2"},{"r":25,"c":13,"index":"2"},{"r":25,"c":5,"index":"2"},{"r":24,"c":13,"index":"2"},{"r":24,"c":5,"index":"2"},{"r":23,"c":13,"index":"2"},{"r":23,"c":5,"index":"2"},{"r":22,"c":13,"index":"2"},{"r":22,"c":5,"index":"2"},{"r":21,"c":13,"index":"2"},{"r":21,"c":5,"index":"2"},{"r":20,"c":13,"index":"2"},{"r":20,"c":5,"index":"2"},{"r":19,"c":13,"index":"2"},{"r":19,"c":5,"index":"2"},{"r":18,"c":13,"index":"2"},{"r":18,"c":5,"index":"2"},{"r":17,"c":13,"index":"2"},{"r":17,"c":5,"index":"2"},{"r":16,"c":13,"index":"2"},{"r":16,"c":5,"index":"2"},{"r":15,"c":13,"index":"2"},{"r":15,"c":5,"index":"2"},{"r":14,"c":13,"index":"2"},{"r":14,"c":5,"index":"2"},{"r":13,"c":13,"index":"2"},{"r":13,"c":5,"index":"2"},{"r":12,"c":13,"index":"2"},{"r":12,"c":5,"index":"2"},{"r":11,"c":13,"index":"2"},{"r":11,"c":5,"index":"2"},{"r":10,"c":13,"index":"2"},{"r":10,"c":5,"index":"2"},{"r":9,"c":13,"index":"2"},{"r":9,"c":5,"index":"2"},{"r":8,"c":13,"index":"2"},{"r":8,"c":5,"index":"2"},{"r":7,"c":13,"index":"2"},{"r":7,"c":5,"index":"2"},{"r":6,"c":13,"index":"2"},{"r":6,"c":5,"index":"2"},{"r":5,"c":13,"index":"2"},{"r":5,"c":5,"index":"2"},{"r":4,"c":13,"index":"2"},{"r":4,"c":5,"index":"2"},{"r":41,"c":13,"index":"2"},{"r":41,"c":5,"index":"2"},{"r":3,"c":13,"index":"2"},{"r":3,"c":5,"index":"2"},{"r":40,"c":12,"index":"2"},{"r":40,"c":4,"index":"2"},{"r":39,"c":12,"index":"2"},{"r":39,"c":4,"index":"2"},{"r":38,"c":12,"index":"2"},{"r":38,"c":4,"index":"2"},{"r":37,"c":12,"index":"2"},{"r":37,"c":4,"index":"2"},{"r":36,"c":12,"index":"2"},{"r":36,"c":4,"index":"2"},{"r":35,"c":12,"index":"2"},{"r":35,"c":4,"index":"2"},{"r":34,"c":12,"index":"2"},{"r":34,"c":4,"index":"2"},{"r":33,"c":12,"index":"2"},{"r":33,"c":4,"index":"2"},{"r":32,"c":12,"index":"2"},{"r":32,"c":4,"index":"2"},{"r":31,"c":12,"index":"2"},{"r":31,"c":4,"index":"2"},{"r":30,"c":12,"index":"2"},{"r":30,"c":4,"index":"2"},{"r":29,"c":12,"index":"2"},{"r":29,"c":4,"index":"2"},{"r":28,"c":12,"index":"2"},{"r":28,"c":4,"index":"2"},{"r":27,"c":12,"index":"2"},{"r":27,"c":4,"index":"2"},{"r":26,"c":12,"index":"2"},{"r":26,"c":4,"index":"2"},{"r":25,"c":12,"index":"2"},{"r":25,"c":4,"index":"2"},{"r":24,"c":12,"index":"2"},{"r":24,"c":4,"index":"2"},{"r":23,"c":12,"index":"2"},{"r":23,"c":4,"index":"2"},{"r":22,"c":12,"index":"2"},{"r":22,"c":4,"index":"2"},{"r":21,"c":12,"index":"2"},{"r":21,"c":4,"index":"2"},{"r":20,"c":12,"index":"2"},{"r":20,"c":4,"index":"2"},{"r":19,"c":12,"index":"2"},{"r":19,"c":4,"index":"2"},{"r":18,"c":12,"index":"2"},{"r":18,"c":4,"index":"2"},{"r":17,"c":12,"index":"2"},{"r":17,"c":4,"index":"2"},{"r":16,"c":12,"index":"2"},{"r":16,"c":4,"index":"2"},{"r":15,"c":12,"index":"2"},{"r":15,"c":4,"index":"2"},{"r":14,"c":12,"index":"2"},{"r":14,"c":4,"index":"2"},{"r":13,"c":12,"index":"2"},{"r":13,"c":4,"index":"2"},{"r":12,"c":12,"index":"2"},{"r":12,"c":4,"index":"2"},{"r":11,"c":12,"index":"2"},{"r":11,"c":4,"index":"2"},{"r":10,"c":12,"index":"2"},{"r":10,"c":4,"index":"2"},{"r":9,"c":12,"index":"2"},{"r":9,"c":4,"index":"2"},{"r":8,"c":12,"index":"2"},{"r":8,"c":4,"index":"2"},{"r":7,"c":12,"index":"2"},{"r":7,"c":4,"index":"2"},{"r":6,"c":12,"index":"2"},{"r":6,"c":4,"index":"2"},{"r":5,"c":12,"index":"2"},{"r":5,"c":4,"index":"2"},{"r":4,"c":12,"index":"2"},{"r":4,"c":4,"index":"2"},{"r":41,"c":12,"index":"2"},{"r":41,"c":4,"index":"2"},{"r":3,"c":12,"index":"2"},{"r":40,"c":11,"index":"2"},{"r":39,"c":11,"index":"2"},{"r":38,"c":11,"index":"2"},{"r":37,"c":11,"index":"2"},{"r":36,"c":11,"index":"2"},{"r":35,"c":11,"index":"2"},{"r":34,"c":11,"index":"2"},{"r":33,"c":11,"index":"2"},{"r":32,"c":11,"index":"2"},{"r":31,"c":11,"index":"2"},{"r":30,"c":11,"index":"2"},{"r":29,"c":11,"index":"2"},{"r":28,"c":11,"index":"2"},{"r":27,"c":11,"index":"2"},{"r":26,"c":11,"index":"2"},{"r":25,"c":11,"index":"2"},{"r":24,"c":11,"index":"2"},{"r":23,"c":11,"index":"2"},{"r":22,"c":11,"index":"2"},{"r":21,"c":11,"index":"2"},{"r":20,"c":11,"index":"2"},{"r":19,"c":11,"index":"2"},{"r":18,"c":11,"index":"2"},{"r":17,"c":11,"index":"2"},{"r":16,"c":11,"index":"2"},{"r":15,"c":11,"index":"2"},{"r":14,"c":11,"index":"2"},{"r":13,"c":11,"index":"2"},{"r":12,"c":11,"index":"2"},{"r":11,"c":11,"index":"2"},{"r":10,"c":11,"index":"2"},{"r":9,"c":11,"index":"2"},{"r":8,"c":11,"index":"2"},{"r":7,"c":11,"index":"2"},{"r":6,"c":11,"index":"2"},{"r":5,"c":11,"index":"2"},{"r":4,"c":11,"index":"2"},{"r":41,"c":11,"index":"2"}]},{"name":"Sheet3","config":{},"index":"3","status":"0","order":"2","zoomRatio":1,"showGridLines":"1","defaultColWidth":72,"defaultRowHeight":18,"celldata":[],"calcChain":[]}]
      data: [
        sheetCell,
        sheetFormula,
        sheetConditionFormat,
        sheetSparkline,
        sheetTable,
        sheetComment,
        sheetPivotTableData,
        sheetPivotTable,
        sheetChart,
        sheetPicture,
        sheetDataVerification,
      ],
      /*data:[{
					"name": "Cell",
					"config": {
						"curentsheetView":"viewNormal",//viewNormal, viewLayout, viewPage
						"sheetViewZoom":{
							"viewNormalZoomScale": 1 ,
							"viewLayoutZoomScale":1 ,
							"viewPageZoomScale":0.6,
						},
						"printoptions":{
							unit:"mm",//mm(default), in, pt, cm, m, 
							PrintArea:"$A$1:$S$31",//print range
							PrintTitles:{//row column
								row:"Sheet1!$1:$1",
								column:"Sheet1!$C:$C"
							}, 
							printOptions:{
								horizontalCentered:0,//align
								verticalCentered:0,//valign
								headings:0,//show row and column 
								gridLines:0,//show gridlines
							},
							pageMargins:{
								left:0.7,//Left Page Margin, inch
								right:0.7,//Right page margin, inch
								top:0.75,//Top Page Margin, inch
								bottom:0.75,//Bottom Page Margin, inch
								header:0.3,//Header Page Margin, date,sheet name, page , custom etc, inch.
								footer:0.3,//Footer Page Margin, date,sheet name, page , custom etc, inch.
							},
							pageSetup:{
								copies:1,//Number of copies to print.
								draft:0,//Print without graphics about image and chart
								paperSize:9,//1Letter ,3Tabloid, 5Legal ,6Statement ,7Executive ,8A3 ,9A4 ,11A5 ,12B4 ,13B5 
								paperHeight:null,//Height of custom paper as a number followed by a unit identifier. [Example: 297mm, 11inend example],When paperHeight and paperWidth are specified, paperSize shall be ignored.
								paperWidth:null,//Width of custom paper as a number followed by a unit identifier. [Example: 21cm, 8.5inend example]
								fitToWidth:0,//Number of horizontal pages to fit on.
								fitToHeight:0,//Number of vertical pages to fit on.
								scale:100,//Print scaling. This attribute is restricted to values ranging from 10 to 400.
								orientation:0,//0defualt,1landscape,2portrait
								blackAndWhite:0,
								cellComments:0,//This attribute specifies how to print cell comments, 2 asDisplayed, 1 atEnd, 0 none
								errors:0,//Specifies how to print cell values for cells with errors, 0 blank(Show Cell Errors As Blank),1 dash(Dash Cell Errors),2 displayed(Display Cell Errors),3 NA
								horizontalDpi:null,//Vertical print resolution of the device.
								verticalDpi:null,//Vertical print resolution of the device.
								pageOrder:0, //0 downThenOver ,1 overThenDown
								firstPageNumber:null,//Page number for first printed page. If no value is specified, then 'automatic' is assumed.
								useFirstPageNumber:0,//Use firstPageNumber value for first page number, and do not auto number the pages.
								usePrinterDefaults:1,//applay default when config is null,
							},
							headerFooter:{
								firstFooter:{
									left:[//&L
										{
											"ff":"Arial", //font family &"-,Regular" or &"font name,font type"
											"fc":"#fff000",//font color &K
											"fs":12,//font size &font-size
											"cl":0,//strike
											"un":0,//underline &E double,  &U single
											"bl":0,//blod &B
											"it":0,//italic &I
											"ss":0,//0 none 1sup &X,  2sub &Y
											v:"我在马路\r\n边捡到\r\n\r\n一分钱"
										}
									],
									center:[],//&C
									right:[],//&R
								}, //First Page Footer
								firstHeader:null, //First Page Header
								oddFooter:"&C第 &P 页&R&G", //Odd Page Footer
								oddHeader:"&L&G&C&A&F",//Odd Header
								evenFooter:null,//Even Page Footer
								evenHeader:null,//Even Page Header
								drawingHF:{//Drawing Reference in Header Footer
									LF:{//left footer
										type:"#_x0000_t75",
										imagedata:"",
										style:"",
									},
									RF:{},//right footer
									CF:{},//center footer
									LH:{},//left header
									RH:{},//right header
									CH:{},//center header
								},
							},
							rowBreaks:{
								"rowBreaks_1":{
									rowIndex:68,
									man:1,
								},
							},
							colBreaks:{
								"colBreaks_1":{
									colIndex:5,
									man:1,
									max:16383,
								},
								"colBreaks_2":{
									colIndex:11,
									man:1,
									max:1048575,
								},
								"colBreaks_3":{
									colIndex:17,
									man:1,
									max:1048575
								},
							}
						},
						"merge": {
							"13_5": {
								"r": 13,
								"c": 5,
								"rs": 3,
								"cs": 1
							},
							"13_7": {
								"r": 13,
								"c": 7,
								"rs": 3,
								"cs": 2
							},
							"14_2": {
								"r": 14,
								"c": 2,
								"rs": 1,
								"cs": 2
							},
							"15_10": {
								"r": 15,
								"c": 10,
								"rs": 4,
								"cs": 3
							}
						},
						"borderInfo": [
							{
								"rangeType": "cell",
								"value": {
									"row_index": 3,
									"col_index": 3,
									"l": {
										"style": 10,
										"color": "rgb(255, 0, 0)"
									},
									"r": {
										"style": 10,
										"color": "rgb(255, 0, 0)"
									},
									"t": {
										"style": 10,
										"color": "rgb(255, 0, 0)"
									},
									"b": {
										"style": 10,
										"color": "rgb(255, 0, 0)"
									}
								}
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 3,
									"col_index": 4,
									"l": {
										"style": 10,
										"color": "rgb(255, 0, 0)"
									},
									"r": {
										"style": 10,
										"color": "rgb(255, 0, 0)"
									},
									"t": {
										"style": 10,
										"color": "rgb(255, 0, 0)"
									},
									"b": {
										"style": 10,
										"color": "rgb(255, 0, 0)"
									}
								}
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 3,
									"col_index": 5,
									"l": {
										"style": 9,
										"color": "rgb(255, 0, 0)"
									},
									"r": {
										"style": 9,
										"color": "rgb(255, 0, 0)"
									},
									"t": {
										"style": 9,
										"color": "rgb(255, 0, 0)"
									},
									"b": {
										"style": 9,
										"color": "rgb(255, 0, 0)"
									}
								}
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 3,
									"col_index": 6,
									"l": {
										"style": 9,
										"color": "rgb(255, 0, 0)"
									},
									"r": {
										"style": 9,
										"color": "rgb(255, 0, 0)"
									},
									"t": {
										"style": 9,
										"color": "rgb(255, 0, 0)"
									},
									"b": {
										"style": 9,
										"color": "rgb(255, 0, 0)"
									}
								}
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 3,
									"col_index": 7,
									"l": {
										"style": 9,
										"color": "rgb(255, 0, 0)"
									},
									"r": {
										"style": 9,
										"color": "rgb(255, 0, 0)"
									},
									"t": {
										"style": 9,
										"color": "rgb(255, 0, 0)"
									},
									"b": {
										"style": 9,
										"color": "rgb(255, 0, 0)"
									}
								}
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 3,
									"col_index": 8,
									"l": {
										"style": 1,
										"color": "rgb(255, 0, 0)"
									},
									"r": {
										"style": 1,
										"color": "rgb(255, 0, 0)"
									},
									"t": {
										"style": 1,
										"color": "rgb(255, 0, 0)"
									},
									"b": {
										"style": 1,
										"color": "rgb(255, 0, 0)"
									}
								}
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 5,
									"col_index": 2,
									"l": {
										"style": 9,
										"color": "rgb(255, 0, 0)"
									},
									"r": {
										"style": 9,
										"color": "rgb(255, 0, 0)"
									},
									"t": {
										"style": 9,
										"color": "rgb(255, 0, 0)"
									},
									"b": {
										"style": 9,
										"color": "rgb(255, 0, 0)"
									}
								}
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 5,
									"col_index": 3,
									"l": {
										"style": 9,
										"color": "rgb(255, 0, 0)"
									},
									"r": {
										"style": 9,
										"color": "rgb(255, 0, 0)"
									},
									"t": {
										"style": 9,
										"color": "rgb(255, 0, 0)"
									},
									"b": {
										"style": 9,
										"color": "rgb(255, 0, 0)"
									}
								}
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 5,
									"col_index": 4,
									"l": {
										"style": 9,
										"color": "rgb(255, 0, 0)"
									},
									"r": {
										"style": 9,
										"color": "rgb(255, 0, 0)"
									},
									"t": {
										"style": 9,
										"color": "rgb(255, 0, 0)"
									},
									"b": {
										"style": 9,
										"color": "rgb(255, 0, 0)"
									}
								}
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 5,
									"col_index": 5,
									"l": {
										"style": 9,
										"color": "rgb(255, 0, 0)"
									},
									"r": {
										"style": 9,
										"color": "rgb(255, 0, 0)"
									},
									"t": {
										"style": 9,
										"color": "rgb(255, 0, 0)"
									},
									"b": {
										"style": 9,
										"color": "rgb(255, 0, 0)"
									}
								}
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 5,
									"col_index": 6,
									"l": {
										"style": 1,
										"color": "rgb(255, 0, 0)"
									},
									"r": {
										"style": 1,
										"color": "rgb(255, 0, 0)"
									},
									"t": {
										"style": 1,
										"color": "rgb(255, 0, 0)"
									},
									"b": {
										"style": 1,
										"color": "rgb(255, 0, 0)"
									}
								}
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 5,
									"col_index": 7,
									"l": {
										"style": 1,
										"color": "rgb(255, 0, 0)"
									},
									"r": {
										"style": 1,
										"color": "rgb(255, 0, 0)"
									},
									"t": {
										"style": 1,
										"color": "rgb(255, 0, 0)"
									},
									"b": {
										"style": 1,
										"color": "rgb(255, 0, 0)"
									}
								}
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 5,
									"col_index": 8,
									"l": {
										"style": 2,
										"color": "rgb(255, 0, 0)"
									},
									"r": {
										"style": 2,
										"color": "rgb(255, 0, 0)"
									},
									"t": {
										"style": 2,
										"color": "rgb(255, 0, 0)"
									},
									"b": {
										"style": 2,
										"color": "rgb(255, 0, 0)"
									}
								}
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 7,
									"col_index": 2,
									"l": {
										"style": 9,
										"color": "rgb(0, 0, 255)"
									},
									"r": {
										"style": 9,
										"color": "rgb(0, 0, 255)"
									},
									"t": {
										"style": 9,
										"color": "rgb(0, 0, 255)"
									},
									"b": {
										"style": 9,
										"color": "rgb(0, 0, 255)"
									}
								}
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 7,
									"col_index": 3,
									"l": {
										"style": 9,
										"color": "rgb(0, 0, 255)"
									},
									"r": {
										"style": 9,
										"color": "rgb(0, 0, 255)"
									},
									"t": {
										"style": 9,
										"color": "rgb(0, 0, 255)"
									},
									"b": {
										"style": 9,
										"color": "rgb(0, 0, 255)"
									}
								}
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 7,
									"col_index": 5,
									"l": {
										"style": 2,
										"color": "rgb(154, 205, 50)"
									},
									"t": {
										"style": 2,
										"color": "rgb(154, 205, 50)"
									}
								}
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 7,
									"col_index": 6,
									"r": {
										"style": 2,
										"color": "rgb(154, 205, 50)"
									},
									"t": {
										"style": 2,
										"color": "rgb(154, 205, 50)"
									}
								}
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 7,
									"col_index": 8,
									"r": {
										"style": 9,
										"color": "rgb(0, 0, 0)"
									},
									"b": {
										"style": 9,
										"color": "rgb(0, 0, 0)"
									}
								}
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 7,
									"col_index": 9,
									"l": {
										"style": 9,
										"color": "rgb(0, 0, 0)"
									},
									"b": {
										"style": 9,
										"color": "rgb(0, 0, 0)"
									}
								}
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 8,
									"col_index": 2,
									"l": {
										"style": 9,
										"color": "rgb(0, 0, 255)"
									},
									"r": {
										"style": 9,
										"color": "rgb(0, 0, 255)"
									},
									"t": {
										"style": 9,
										"color": "rgb(0, 0, 255)"
									},
									"b": {
										"style": 9,
										"color": "rgb(0, 0, 255)"
									}
								}
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 8,
									"col_index": 3,
									"l": {
										"style": 9,
										"color": "rgb(0, 0, 255)"
									},
									"r": {
										"style": 9,
										"color": "rgb(0, 0, 255)"
									},
									"t": {
										"style": 9,
										"color": "rgb(0, 0, 255)"
									},
									"b": {
										"style": 9,
										"color": "rgb(0, 0, 255)"
									}
								}
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 8,
									"col_index": 5,
									"l": {
										"style": 2,
										"color": "rgb(154, 205, 50)"
									},
									"b": {
										"style": 2,
										"color": "rgb(154, 205, 50)"
									}
								}
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 8,
									"col_index": 6,
									"r": {
										"style": 2,
										"color": "rgb(154, 205, 50)"
									},
									"b": {
										"style": 2,
										"color": "rgb(154, 205, 50)"
									}
								}
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 8,
									"col_index": 8,
									"r": {
										"style": 9,
										"color": "rgb(0, 0, 0)"
									},
									"t": {
										"style": 9,
										"color": "rgb(0, 0, 0)"
									}
								}
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 8,
									"col_index": 9,
									"l": {
										"style": 9,
										"color": "rgb(0, 0, 0)"
									},
									"t": {
										"style": 9,
										"color": "rgb(0, 0, 0)"
									}
								}
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 10,
									"col_index": 2,
									"l": {
										"style": 1,
										"color": "rgb(144, 238, 144)"
									},
									"t": {
										"style": 1,
										"color": "rgb(144, 238, 144)"
									},
									"b": {
										"style": 1,
										"color": "rgb(144, 238, 144)"
									}
								}
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 10,
									"col_index": 3,
									"r": {
										"style": 1,
										"color": "rgb(144, 238, 144)"
									},
									"t": {
										"style": 1,
										"color": "rgb(144, 238, 144)"
									},
									"b": {
										"style": 1,
										"color": "rgb(144, 238, 144)"
									}
								}
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 10,
									"col_index": 5,
									"l": {
										"style": 1,
										"color": "rgb(205, 205, 0)"
									},
									"r": {
										"style": 1,
										"color": "rgb(205, 205, 0)"
									},
									"t": {
										"style": 1,
										"color": "rgb(205, 205, 0)"
									}
								}
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 10,
									"col_index": 6,
									"l": {
										"style": 1,
										"color": "rgb(205, 205, 0)"
									},
									"r": {
										"style": 1,
										"color": "rgb(205, 205, 0)"
									},
									"t": {
										"style": 1,
										"color": "rgb(205, 205, 0)"
									}
								}
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 10,
									"col_index": 7,
									"l": {
										"style": 1,
										"color": "rgb(205, 205, 0)"
									},
									"r": {
										"style": 1,
										"color": "rgb(205, 205, 0)"
									},
									"t": {
										"style": 1,
										"color": "rgb(205, 205, 0)"
									}
								}
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 11,
									"col_index": 2,
									"l": {
										"style": 1,
										"color": "rgb(144, 238, 144)"
									},
									"t": {
										"style": 1,
										"color": "rgb(144, 238, 144)"
									},
									"b": {
										"style": 1,
										"color": "rgb(144, 238, 144)"
									}
								}
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 11,
									"col_index": 3,
									"r": {
										"style": 1,
										"color": "rgb(144, 238, 144)"
									},
									"t": {
										"style": 1,
										"color": "rgb(144, 238, 144)"
									},
									"b": {
										"style": 1,
										"color": "rgb(144, 238, 144)"
									}
								}
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 11,
									"col_index": 5,
									"l": {
										"style": 1,
										"color": "rgb(205, 205, 0)"
									},
									"r": {
										"style": 1,
										"color": "rgb(205, 205, 0)"
									}
								}
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 11,
									"col_index": 6,
									"l": {
										"style": 1,
										"color": "rgb(205, 205, 0)"
									},
									"r": {
										"style": 1,
										"color": "rgb(205, 205, 0)"
									}
								}
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 11,
									"col_index": 7,
									"l": {
										"style": 1,
										"color": "rgb(205, 205, 0)"
									},
									"r": {
										"style": 1,
										"color": "rgb(205, 205, 0)"
									}
								}
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 12,
									"col_index": 2,
									"l": {
										"style": 1,
										"color": "rgb(144, 238, 144)"
									},
									"t": {
										"style": 1,
										"color": "rgb(144, 238, 144)"
									},
									"b": {
										"style": 1,
										"color": "rgb(144, 238, 144)"
									}
								}
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 12,
									"col_index": 3,
									"r": {
										"style": 1,
										"color": "rgb(144, 238, 144)"
									},
									"t": {
										"style": 1,
										"color": "rgb(144, 238, 144)"
									},
									"b": {
										"style": 1,
										"color": "rgb(144, 238, 144)"
									}
								}
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 12,
									"col_index": 5,
									"l": {
										"style": 1,
										"color": "rgb(205, 205, 0)"
									},
									"r": {
										"style": 1,
										"color": "rgb(205, 205, 0)"
									},
									"b": {
										"style": 1,
										"color": "rgb(205, 205, 0)"
									}
								}
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 12,
									"col_index": 6,
									"l": {
										"style": 1,
										"color": "rgb(205, 205, 0)"
									},
									"r": {
										"style": 1,
										"color": "rgb(205, 205, 0)"
									},
									"b": {
										"style": 1,
										"color": "rgb(205, 205, 0)"
									}
								}
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 12,
									"col_index": 7,
									"l": {
										"style": 1,
										"color": "rgb(205, 205, 0)"
									},
									"r": {
										"style": 1,
										"color": "rgb(205, 205, 0)"
									},
									"b": {
										"style": 1,
										"color": "rgb(205, 205, 0)"
									}
								}
							},
							{
								"rangeType": "range",
								"borderType": "border-none",
								"style": "2",
								"color": "#000",
								"range": [
									{
										"row": [
											3,
											3
										],
										"column": [
											3,
											4
										]
									}
								]
							},
							{
								"rangeType": "range",
								"borderType": "border-all",
								"style": "2",
								"color": "#ff0000",
								"range": [
									{
										"row": [
											3,
											3
										],
										"column": [
											3,
											4
										]
									}
								]
							},
							{
								"rangeType": "range",
								"borderType": "border-none",
								"style": "4",
								"color": "#ff0000",
								"range": [
									{
										"row": [
											3,
											3
										],
										"column": [
											4,
											4
										]
									}
								]
							},
							{
								"rangeType": "range",
								"borderType": "border-all",
								"style": "3",
								"color": "#ff0000",
								"range": [
									{
										"row": [
											3,
											3
										],
										"column": [
											4,
											4
										]
									}
								]
							},
							{
								"rangeType": "range",
								"borderType": "border-none",
								"style": "3",
								"color": "#ff0000",
								"range": [
									{
										"row": [
											3,
											3
										],
										"column": [
											3,
											3
										]
									}
								]
							},
							{
								"rangeType": "range",
								"borderType": "border-all",
								"style": "2",
								"color": "#ff0000",
								"range": [
									{
										"row": [
											3,
											3
										],
										"column": [
											3,
											3
										]
									}
								]
							},
							{
								"rangeType": "range",
								"borderType": "border-none",
								"style": "2",
								"color": "#ff0000",
								"range": [
									{
										"row": [
											3,
											3
										],
										"column": [
											5,
											5
										]
									}
								]
							},
							{
								"rangeType": "range",
								"borderType": "border-none",
								"style": "2",
								"color": "#ff0000",
								"range": [
									{
										"row": [
											3,
											3
										],
										"column": [
											8,
											8
										]
									}
								]
							},
							{
								"rangeType": "range",
								"borderType": "border-none",
								"style": "2",
								"color": "#ff0000",
								"range": [
									{
										"row": [
											3,
											3
										],
										"column": [
											3,
											8
										]
									}
								]
							},
							{
								"rangeType": "range",
								"borderType": "border-all",
								"style": "4",
								"color": "#ff0000",
								"range": [
									{
										"row": [
											3,
											3
										],
										"column": [
											7,
											7
										]
									}
								]
							},
							{
								"rangeType": "range",
								"borderType": "border-all",
								"style": "1",
								"color": "#ff0000",
								"range": [
									{
										"row": [
											3,
											3
										],
										"column": [
											8,
											8
										]
									}
								]
							},
							{
								"rangeType": "range",
								"borderType": "border-all",
								"style": "5",
								"color": "#ff0000",
								"range": [
									{
										"row": [
											3,
											3
										],
										"column": [
											6,
											6
										]
									}
								]
							},
							{
								"rangeType": "range",
								"borderType": "border-all",
								"style": "6",
								"color": "#ff0000",
								"range": [
									{
										"row": [
											3,
											3
										],
										"column": [
											5,
											5
										]
									}
								]
							},
							{
								"rangeType": "range",
								"borderType": "border-none",
								"style": "3",
								"color": "#ff0000",
								"range": [
									{
										"row": [
											3,
											3
										],
										"column": [
											4,
											4
										]
									}
								]
							},
							{
								"rangeType": "range",
								"borderType": "border-all",
								"style": "3",
								"color": "#ff0000",
								"range": [
									{
										"row": [
											3,
											3
										],
										"column": [
											4,
											4
										]
									}
								]
							},
							{
								"rangeType": "range",
								"borderType": "border-all",
								"style": "2",
								"color": "#ff0000",
								"range": [
									{
										"row": [
											3,
											3
										],
										"column": [
											3,
											3
										]
									}
								]
							},
							{
								"rangeType": "range",
								"borderType": "border-none",
								"style": "2",
								"color": "#ff0000",
								"range": [
									{
										"row": [
											5,
											5
										],
										"column": [
											2,
											9
										]
									}
								]
							},
							{
								"rangeType": "range",
								"borderType": "border-all",
								"style": "9",
								"color": "#ff0000",
								"range": [
									{
										"row": [
											5,
											5
										],
										"column": [
											5,
											5
										]
									}
								]
							},
							{
								"rangeType": "range",
								"borderType": "border-all",
								"style": "8",
								"color": "#ff0000",
								"range": [
									{
										"row": [
											5,
											5
										],
										"column": [
											6,
											6
										]
									}
								]
							},
							{
								"rangeType": "range",
								"borderType": "border-all",
								"style": "13",
								"color": "#ff0000",
								"range": [
									{
										"row": [
											5,
											5
										],
										"column": [
											7,
											7
										]
									}
								]
							},
							{
								"rangeType": "range",
								"borderType": "border-all",
								"style": "13",
								"color": "#ff0000",
								"range": [
									{
										"row": [
											6,
											6
										],
										"column": [
											11,
											11
										]
									}
								]
							},
							{
								"rangeType": "range",
								"borderType": "border-all",
								"style": "10",
								"color": "#ff0000",
								"range": [
									{
										"row": [
											5,
											5
										],
										"column": [
											4,
											4
										]
									}
								]
							},
							{
								"rangeType": "range",
								"borderType": "border-all",
								"style": "11",
								"color": "#ff0000",
								"range": [
									{
										"row": [
											5,
											5
										],
										"column": [
											3,
											3
										]
									}
								]
							},
							{
								"rangeType": "range",
								"borderType": "border-none",
								"style": "11",
								"color": "#ff0000",
								"range": [
									{
										"row": [
											7,
											8
										],
										"column": [
											2,
											3
										]
									}
								]
							},
							{
								"rangeType": "range",
								"borderType": "border-all",
								"style": "3",
								"color": "#0000ff",
								"range": [
									{
										"row": [
											7,
											8
										],
										"column": [
											2,
											3
										]
									}
								]
							},
							{
								"rangeType": "range",
								"borderType": "border-inside",
								"style": "3",
								"color": "#0000ff",
								"range": [
									{
										"row": [
											7,
											8
										],
										"column": [
											8,
											9
										]
									}
								]
							},
							{
								"rangeType": "range",
								"borderType": "border-inside",
								"style": "9",
								"color": "#0000ff",
								"range": [
									{
										"row": [
											7,
											8
										],
										"column": [
											8,
											9
										]
									}
								]
							},
							{
								"rangeType": "range",
								"borderType": "border-inside",
								"style": "2",
								"color": "#0000ff",
								"range": [
									{
										"row": [
											7,
											8
										],
										"column": [
											8,
											9
										]
									}
								]
							},
							{
								"rangeType": "range",
								"borderType": "border-inside",
								"style": "9",
								"color": "#0000ff",
								"range": [
									{
										"row": [
											7,
											8
										],
										"column": [
											8,
											9
										]
									}
								]
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 10,
									"col_index": 10,
									"l": {
										"color": "#ff0000",
										"style": "13"
									},
									"r": {
										"color": "#ff0000",
										"style": "13"
									},
									"t": {
										"color": "#ff0000",
										"style": "13"
									},
									"b": {
										"color": "#ff0000",
										"style": "13"
									}
								}
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 6,
									"col_index": 11,
									"l": null,
									"r": null,
									"t": null,
									"b": null
								}
							},
							{
								"rangeType": "cell",
								"value": {
									"row_index": 10,
									"col_index": 10,
									"l": null,
									"r": null,
									"t": null,
									"b": null
								}
							},
							{
								"rangeType": "range",
								"borderType": "border-outside",
								"style": "13",
								"color": "#00ff00",
								"range": [
									{
										"row": [
											10,
											12
										],
										"column": [
											2,
											3
										]
									}
								]
							},
							{
								"rangeType": "range",
								"borderType": "border-horizontal",
								"style": "13",
								"color": "#00ff00",
								"range": [
									{
										"row": [
											10,
											12
										],
										"column": [
											2,
											3
										]
									}
								]
							},
							{
								"rangeType": "range",
								"borderType": "border-vertical",
								"style": "13",
								"color": "#ff9900",
								"range": [
									{
										"row": [
											10,
											12
										],
										"column": [
											5,
											7
										]
									}
								]
							},
							{
								"rangeType": "range",
								"borderType": "border-outside",
								"style": "13",
								"color": "#ff9900",
								"range": [
									{
										"row": [
											10,
											12
										],
										"column": [
											5,
											7
										]
									}
								]
							},
							{
								"rangeType": "range",
								"borderType": "border-none",
								"style": "1",
								"color": "#ff9900",
								"range": [
									{
										"row": [
											19,
											19
										],
										"column": [
											6,
											6
										]
									}
								]
							}
						],
						"rowlen": {
							"0": 20,
							"1": 20,
							"2": 20,
							"3": 20,
							"4": 20,
							"5": 20,
							"6": 20,
							"7": 20,
							"8": 20,
							"9": 20,
							"10": 20,
							"11": 20,
							"12": 20,
							"13": 20,
							"14": 20,
							"15": 20,
							"16": 20,
							"17": 31,
							"18": 20,
							"19": 20,
							"20": 20,
							"21": 20,
							"22": 20,
							"23": 20,
							"24": 20,
							"25": 79,
							"26": 20,
							"27": 20,
							"28": 80,
							"29": 36
						},
						"columnlen": {
							"0": 131,
							"2": 153,
							"3": 128,
							"4": 136,
							"5": 122,
							"6": 138,
							"7": 131,
							"8": 128,
							"9": 140,
							"10": 144
						},
						"rowhidden": {
							"30": 0,
							"31": 0
						},
						"customHeight": {
							"29": 1
						},
						"customWidth": {
							"2": 1
						}
					},
					"index": "0",
					"zoomRatio": 1,
					"order": "0",
					"column": 18,
					"row": 36,
					"status": 1,
					"celldata": [{"r":0,"c":0,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1,"v":"1","ct":{"fa":"General","t":"n"},"m":"1"}},{"r":0,"c":1,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1,"v":2,"ct":{"fa":"General","t":"n"},"m":"2"}},{"r":0,"c":2,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1,"v":3,"ct":{"fa":"General","t":"n"},"m":"3"}},{"r":0,"c":3,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1,"v":0,"ct":{"fa":"###.00","t":"n"},"m":"0","f":"=A1/B1"}},{"r":0,"c":4,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":0,"c":5,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":0,"c":6,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":0,"c":7,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":0,"c":8,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":0,"c":9,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":0,"c":10,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":1,"c":0,"v":{"v":"Background","ct":{"fa":"General","t":"g"},"m":"Background","bg":null,"bl":1,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":1,"c":1,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":1,"c":2,"v":{"bg":"rgb(30, 144, 255)","bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":1,"c":3,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":1,"c":4,"v":{"bg":"rgb(0, 255, 0)","bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":1,"c":5,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":1,"c":6,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":1,"c":7,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":1,"c":8,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":1,"c":9,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":1,"c":10,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":2,"c":0,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":2,"c":1,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":2,"c":2,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":2,"c":3,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":2,"c":4,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":2,"c":5,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":2,"c":6,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":2,"c":7,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":2,"c":8,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":2,"c":9,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":2,"c":10,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":3,"c":0,"v":{"v":"Border","ct":{"fa":"General","t":"g"},"m":"Border","bg":null,"bl":1,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":3,"c":1,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":3,"c":2,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":3,"c":3,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":3,"c":4,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":3,"c":5,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":3,"c":6,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":3,"c":7,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":3,"c":8,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":3,"c":9,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":3,"c":10,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":4,"c":0,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":4,"c":1,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":4,"c":2,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":4,"c":3,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":4,"c":4,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":4,"c":5,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":4,"c":6,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":4,"c":7,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":4,"c":8,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":4,"c":9,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":4,"c":10,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":5,"c":0,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1,"ct":{"fa":"General","t":"inlineStr","s":[{"ff":"Arial","fc":"rgb(255, 0, 0)","fs":12,"cl":0,"un":0,"bl":0,"it":0,"v":"Inline"},{"ff":"Arial","fc":"#000000","fs":12,"cl":0,"un":0,"bl":0,"it":0,"v":" "},{"ff":"Arial","fc":"#000000","fs":16,"cl":1,"un":0,"bl":0,"it":1,"v":"Style"},{"ff":"Arial","fc":"#000000","fs":12,"cl":0,"un":0,"bl":0,"it":0,"v":" "},{"ff":"Arial","fc":"#000000","fs":12,"cl":0,"un":0,"bl":1,"it":0,"v":"Cell"}]}}},{"r":5,"c":1,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":5,"c":2,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":5,"c":3,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":5,"c":4,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":5,"c":5,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":5,"c":6,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":5,"c":7,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":5,"c":8,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":5,"c":9,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":5,"c":10,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":6,"c":0,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":6,"c":1,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":6,"c":2,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":6,"c":3,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":6,"c":4,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":6,"c":5,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":6,"c":6,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":6,"c":7,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":6,"c":8,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":6,"c":9,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":6,"c":10,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":7,"c":0,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":7,"c":1,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":7,"c":2,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":7,"c":3,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":7,"c":4,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":7,"c":5,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":7,"c":6,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":7,"c":7,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":7,"c":8,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":7,"c":9,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":7,"c":10,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":8,"c":0,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":8,"c":1,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":8,"c":2,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":8,"c":3,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":8,"c":4,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":8,"c":5,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":8,"c":6,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":8,"c":7,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":8,"c":8,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":8,"c":9,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":8,"c":10,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":9,"c":0,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":9,"c":1,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":9,"c":2,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":9,"c":3,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":9,"c":4,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":9,"c":5,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":9,"c":6,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":9,"c":7,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":9,"c":8,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":9,"c":9,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":9,"c":10,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":10,"c":0,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":10,"c":1,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":10,"c":2,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":10,"c":3,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":10,"c":4,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":10,"c":5,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":10,"c":6,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":10,"c":7,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":10,"c":8,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":10,"c":9,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":10,"c":10,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":11,"c":0,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":11,"c":1,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":11,"c":2,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":11,"c":3,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":11,"c":4,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":11,"c":5,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":11,"c":6,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":11,"c":7,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":11,"c":8,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":11,"c":9,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":11,"c":10,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":12,"c":0,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":12,"c":1,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":12,"c":2,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":12,"c":3,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":12,"c":4,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":12,"c":5,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":12,"c":6,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":12,"c":7,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":12,"c":8,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":12,"c":9,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":12,"c":10,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":13,"c":0,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":13,"c":1,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":13,"c":2,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":13,"c":3,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":13,"c":4,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":13,"c":5,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1,"mc":{"r":13,"c":5,"rs":3,"cs":1}}},{"r":13,"c":6,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":13,"c":7,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1,"mc":{"r":13,"c":7,"rs":3,"cs":2}}},{"r":13,"c":8,"v":{"mc":{"r":13,"c":7}}},{"r":13,"c":9,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":13,"c":10,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":14,"c":0,"v":{"v":"Span","ct":{"fa":"General","t":"g"},"m":"Span","bg":null,"bl":1,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":14,"c":1,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":14,"c":2,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1,"mc":{"r":14,"c":2,"rs":1,"cs":2}}},{"r":14,"c":3,"v":{"mc":{"r":14,"c":2}}},{"r":14,"c":4,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":14,"c":5,"v":{"mc":{"r":13,"c":5}}},{"r":14,"c":6,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":14,"c":7,"v":{"mc":{"r":13,"c":7}}},{"r":14,"c":8,"v":{"mc":{"r":13,"c":7}}},{"r":14,"c":9,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":14,"c":10,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":15,"c":0,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":15,"c":1,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":15,"c":2,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":15,"c":3,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":15,"c":4,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":15,"c":5,"v":{"mc":{"r":13,"c":5}}},{"r":15,"c":6,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":15,"c":7,"v":{"mc":{"r":13,"c":7}}},{"r":15,"c":8,"v":{"mc":{"r":13,"c":7}}},{"r":15,"c":9,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":15,"c":10,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1,"mc":{"r":15,"c":10,"rs":4,"cs":3}}},{"r":15,"c":11,"v":{"mc":{"r":15,"c":10}}},{"r":15,"c":12,"v":{"mc":{"r":15,"c":10}}},{"r":16,"c":0,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":16,"c":1,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":16,"c":2,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":16,"c":3,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":16,"c":4,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":16,"c":5,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":16,"c":6,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":16,"c":7,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":16,"c":8,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":16,"c":9,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":16,"c":10,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1,"mc":{"r":15,"c":10}}},{"r":16,"c":11,"v":{"mc":{"r":15,"c":10}}},{"r":16,"c":12,"v":{"mc":{"r":15,"c":10}}},{"r":17,"c":0,"v":{"v":"Font","ct":{"fa":"General","t":"g"},"m":"Font","bg":null,"bl":1,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":17,"c":1,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":17,"c":2,"v":{"v":"Luckysheet","ct":{"fa":"General","t":"g"},"bg":null,"bl":0,"it":0,"ff":0,"fs":"11","fc":"rgb(51, 51, 51)","ht":1,"vt":1,"m":"Luckysheet"}},{"r":17,"c":3,"v":{"v":"Luckysheet","ct":{"fa":"General","t":"g"},"bg":null,"bl":0,"it":0,"ff":0,"fs":13,"fc":"rgb(51, 51, 51)","ht":1,"vt":1,"m":"Luckysheet"}},{"r":17,"c":4,"v":{"v":"Luckysheet","ct":{"fa":"General","t":"g"},"bg":null,"bl":0,"it":0,"ff":9,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1,"m":"Luckysheet"}},{"r":17,"c":5,"v":{"v":"Luckysheet","ct":{"fa":"General","t":"g"},"bg":null,"bl":0,"it":0,"ff":0,"fs":13,"fc":"rgb(51, 51, 51)","ht":1,"vt":1,"m":"Luckysheet"}},{"r":17,"c":6,"v":{"v":"Luckysheet","ct":{"fa":"General","t":"g"},"bg":"rgb(255, 215, 0)","bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1,"m":"Luckysheet"}},{"r":17,"c":7,"v":{"v":"Luckysheet","ct":{"fa":"General","t":"g"},"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(67, 110, 238)","ht":1,"vt":1,"m":"Luckysheet"}},{"r":17,"c":8,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":17,"c":9,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":17,"c":10,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1,"mc":{"r":15,"c":10}}},{"r":17,"c":11,"v":{"mc":{"r":15,"c":10}}},{"r":17,"c":12,"v":{"mc":{"r":15,"c":10}}},{"r":18,"c":0,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":18,"c":1,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":18,"c":2,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":18,"c":3,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":18,"c":4,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":18,"c":5,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":18,"c":6,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":18,"c":7,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":18,"c":8,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":18,"c":9,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":18,"c":10,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1,"mc":{"r":15,"c":10}}},{"r":18,"c":11,"v":{"mc":{"r":15,"c":10}}},{"r":18,"c":12,"v":{"mc":{"r":15,"c":10}}},{"r":19,"c":0,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":19,"c":1,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":19,"c":2,"v":{"v":"Luckysheet","ct":{"fa":"General","t":"g"},"bg":"rgb(67, 110, 238)","bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(255, 215, 0)","ht":1,"vt":1,"m":"Luckysheet"}},{"r":19,"c":3,"v":{"v":"Luckysheet","ct":{"fa":"General","t":"g"},"bg":null,"bl":1,"it":0,"ff":0,"fs":"10","fc":"rgb(51, 51, 51)","ht":1,"vt":1,"m":"Luckysheet"}},{"r":19,"c":4,"v":{"v":"Luckysheet","ct":{"fa":"General","t":"g"},"bg":null,"bl":0,"it":1,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1,"m":"Luckysheet"}},{"r":19,"c":5,"v":{"v":"Luckysheet","ct":{"fa":"General","t":"g"},"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1,"cl":1,"m":"Luckysheet"}},{"r":19,"c":6,"v":{"ct":{"fa":"General","t":"g"},"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":"1","vt":"0","cl":1}},{"r":19,"c":7,"v":{"ct":{"fa":"General","t":"g"},"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":19,"c":8,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":19,"c":9,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":19,"c":10,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":20,"c":0,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":20,"c":1,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":20,"c":2,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":20,"c":3,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":20,"c":4,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":20,"c":5,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":20,"c":6,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":20,"c":7,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":20,"c":8,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":20,"c":9,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":20,"c":10,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":21,"c":0,"v":{"v":"Format","ct":{"fa":"General","t":"g"},"m":"Format","bg":null,"bl":1,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":21,"c":1,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":21,"c":2,"v":{"ct":{"fa":"##0.00","t":"n"},"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1,"m":"0.25","v":0.25}},{"r":21,"c":3,"v":{"ct":{"fa":"$#,##0.00_);($#,##0.00)","t":"n"},"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1,"m":"$0.25 ","v":0.25}},{"r":21,"c":4,"v":{"ct":{"fa":"\"$\" 0.00","t":"n"},"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1,"m":"$ 0.25","v":0.25}},{"r":21,"c":5,"v":{"ct":{"fa":"0%","t":"n"},"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1,"m":"25%","v":0.25}},{"r":21,"c":6,"v":{"ct":{"fa":"# ?/?","t":"n"},"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1,"m":" 1/4","v":0.25}},{"r":21,"c":7,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":21,"c":8,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":21,"c":9,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":21,"c":10,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":22,"c":0,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":22,"c":1,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":22,"c":2,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":22,"c":3,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":22,"c":4,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":22,"c":5,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":22,"c":6,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":22,"c":7,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":22,"c":8,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":22,"c":9,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":22,"c":10,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":23,"c":0,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":23,"c":1,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":23,"c":2,"v":{"ct":{"fa":"0.00E+00","t":"n"},"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1,"m":"2.50E-01","v":0.25}},{"r":23,"c":3,"v":{"v":0.25,"ct":{"fa":"0.00","t":"n"},"m":"0.25","bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":23,"c":4,"v":{"ct":{"fa":"AM/PM h:mm:ss","t":"d"},"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1,"v":44032,"m":"AM 12:00:00"}},{"r":23,"c":5,"v":{"ct":{"fa":"yyyy/MM/dd","t":"d"},"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1,"v":44032,"m":"2020/07/20"}},{"r":23,"c":6,"v":{"ct":{"fa":"yyyy\"年\"M\"月\"d\"日\"","t":"d"},"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1,"v":44032,"m":"2020年7月20日"}},{"r":23,"c":7,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":23,"c":8,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":23,"c":9,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":23,"c":10,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":24,"c":0,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":24,"c":1,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":24,"c":2,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":24,"c":3,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":24,"c":4,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":24,"c":5,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":24,"c":6,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":24,"c":7,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":24,"c":8,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":24,"c":9,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":24,"c":10,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":25,"c":0,"v":{"v":"Alignment","ct":{"fa":"General","t":"g"},"m":"Alignment","bg":null,"bl":1,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":25,"c":1,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":25,"c":2,"v":{"v":"Top Left","ct":{"fa":"General","t":"g"},"m":"Top Left","bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":"1","vt":"1"}},{"r":25,"c":3,"v":{"v":"Top Center","ct":{"fa":"General","t":"g"},"m":"Top Center","bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":"0","vt":"1"}},{"r":25,"c":4,"v":{"v":"Top Right","ct":{"fa":"General","t":"g"},"m":"Top Right","bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":"2","vt":"1"}},{"r":25,"c":5,"v":{"v":"Center Left","ct":{"fa":"General","t":"g"},"m":"Center Left","bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":"1","vt":"0"}},{"r":25,"c":6,"v":{"v":"Center Center","ct":{"fa":"General","t":"g"},"m":"Center Center","bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":"0","vt":"0"}},{"r":25,"c":7,"v":{"v":"Center Right","ct":{"fa":"General","t":"g"},"m":"Center Right","bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":"2","vt":"0"}},{"r":25,"c":8,"v":{"v":"Bottom Left","ct":{"fa":"General","t":"g"},"m":"Bottom Left","bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":"1","vt":"2"}},{"r":25,"c":9,"v":{"v":"Bottom Center","ct":{"fa":"General","t":"g"},"m":"Bottom Center","bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":"0","vt":"2"}},{"r":25,"c":10,"v":{"v":"Bottom Right","ct":{"fa":"General","t":"g"},"m":"Bottom Right","bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":"2","vt":"2"}},{"r":26,"c":0,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":26,"c":1,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":26,"c":2,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":26,"c":3,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":26,"c":4,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":26,"c":5,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":26,"c":6,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":26,"c":7,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":26,"c":8,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":26,"c":9,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":26,"c":10,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":27,"c":0,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":27,"c":1,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":27,"c":2,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":27,"c":3,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":27,"c":4,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":27,"c":5,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":27,"c":6,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":27,"c":7,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":27,"c":8,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":27,"c":9,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":27,"c":10,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":28,"c":0,"v":{"v":"WordWrap","ct":{"fa":"General","t":"g"},"m":"WordWrap","bg":null,"bl":1,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":28,"c":1,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":28,"c":2,"v":{"v":"ABCDEFGHIJKLMNOPQRSTUVWXYZ","ct":{"fa":"General","t":"g"},"m":"ABCDEFGHIJKLMNOPQRSTUVWXYZ","bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1,"tb":"2"}},{"r":28,"c":3,"v":{"ct":{"fa":"General","t":"g"},"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1,"tb":"1"}},{"r":28,"c":4,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":28,"c":5,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":28,"c":6,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":28,"c":7,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":28,"c":8,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":28,"c":9,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":28,"c":10,"v":{"bg":null,"bl":0,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}},{"r":29,"c":0,"v":{"ct":{"fa":"General","t":"inlineStr","s":[{"ff":"\"times new roman\"","fc":"rgb(51, 51, 51)","fs":"12","cl":0,"un":0,"bl":1,"it":0,"v":"TextRotate"}]},"ht":"1","vt":"0"}},{"r":29,"c":2,"v":{"ct":{"fa":"General","t":"g"},"v":"I am Luckysheet text rotate style","m":"I am Luckysheet text rotate style","tr":"1","tb":"2","ht":"1","fs":"12"}},{"r":29,"c":3,"v":{"ct":{"fa":"General","t":"g"},"v":"I am Luckysheet text rotate style","m":"I am Luckysheet text rotate style","tr":"2","tb":"2","ht":"0","fs":"12"}},{"r":29,"c":4,"v":{"ct":{"fa":"General","t":"g"},"v":"I am Luckysheet text rotate style","m":"I am Luckysheet text rotate style","tr":"4","tb":"2","ht":"1","fs":"12","vt":"2"}},{"r":29,"c":5,"v":{"ct":{"fa":"General","t":"g"},"v":"I am Luckysheet text rotate style","m":"I am Luckysheet text rotate style","tr":"5","tb":"2","ht":"1","fs":"12"}},{"r":29,"c":6,"v":{"ct":{"fa":"General","t":"g"},"v":"I am Luckysheet text rotate style","m":"I am Luckysheet text rotate style","tr":"1","tb":"1","ht":"1","fs":"12","vt":"0"}},{"r":30,"c":0,"v":{"ct":{"fa":"General","t":"g"},"v":"hidden1","m":"hidden1"}},{"r":31,"c":0,"v":{"m":"hidden2","ct":{"fa":"General","t":"g"},"v":"hidden2"}},{"r":33,"c":0,"v":{"ct":{"fa":"General","t":"g"},"bg":null,"bl":1,"it":0,"ff":0,"fs":11,"fc":"rgb(51, 51, 51)","ht":1,"vt":1}}],
					"ch_width": 2361,
					"rh_height": 936,
					"luckysheet_select_save": [
						{
							"left": 741,
							"width": 138,
							"top": 796,
							"height": 19,
							"left_move": 741,
							"width_move": 138,
							"top_move": 796,
							"height_move": 19,
							"row": [
								33,
								33
							],
							"column": [
								6,
								6
							],
							"row_focus": 33,
							"column_focus": 6
						}
					],
					"calcChain": [
						{
							"r": 0,
							"c": 3,
							"index": "0",
							"func": [
								true,
								3,
								"=Formula!A1+Formula!B1"
							],
							"color": "w",
							"parent": null,
							"chidren": {},
							"times": 0
						}
					],
					"scrollLeft": 0,
					"scrollTop": 0
				}]*/
    };
  }
  options.loading = {
    image: () => {
      return `<svg viewBox="25 25 50 50" class="circular">
					<circle cx="50" cy="50" r="20" fill="none"></circle>
					</svg>`;
    },
    imageClass: "loadingAnimation",
  };
  options.cellRightClickConfig = {
    customs: [
      {
        title: "test",
        onClick: function (clickEvent, event, params) {
          console.log("function test click", clickEvent, event, params);
        },
      },
    ],
  };
  luckysheet.create(options);
});
