const gulp = require("gulp");
// gulp core function
const { src, dest, series, parallel } = require("gulp");
// gulp compress js
const uglify = require("gulp-uglify");
// gulp judgment
const gulpif = require("gulp-if");
// gulp compress css
const cleanCSS = require("gulp-clean-css");
// Delete Files
const del = require("delete");
// Refresh the browser in real time

const concat = require("gulp-concat");

const __ENV__ = require('amos-build/lib/tools/__ENV__');

const production = __ENV__ === "production" ? true : false;

// uglify js Compression configuration https://github.com/mishoo/UglifyJS#minify-options
const uglifyOptions = {
  compress: {
    drop_console: true,
  },
};

// file handler paths
const paths = {
  // static resources,contains index.html, fonts and images,and extension plugins dependency
  staticHtml: ["src/*.html"],
  staticFonts: ["src/fonts/**"],
  staticAssets: ["src/assets/**"],
  staticImages: ["src/plugins/images/*.png"],
  staticExpendPlugins: [
    "src/expendPlugins/**",
    "!src/expendPlugins/**/plugin.js",
  ],
  staticDemoData: ["src/demoData/*.js"],
  staticCssImages: ["src/css/**", "!src/css/*.css"],

  // static resources dest
  destStaticHtml: ["dist"],
  destStaticFonts: ["dist/fonts"],
  destStaticAssets: ["dist/assets"],
  destStaticImages: ["dist/plugins/images"],
  destStaticExpendPlugins: ["dist/expendPlugins"],
  destStaticDemoData: ["dist/demoData"],
  destStaticCssImages: ["dist/css"],

  //core es module
  core: [
    "src/**/*.js",
    "!src/demoData/*.js",
    "src/expendPlugins/**/plugin.js",
    "!src/plugins/js/*.js",
  ],

  //plugins src
  pluginsCss: ["src/plugins/css/*.css"],
  plugins: ["src/plugins/*.css"],
  css: ["src/css/*.css", "node_modules/flatpickr/dist/themes/light.css"],
  pluginsJs: [
    "node_modules/jquery/dist/jquery.min.js",
    "node_modules/uuid/dist/umd/uuid.min.js",
    "node_modules/exceljs/dist/exceljs.min.js",
    "src/plugins/js/clipboard.min.js",
    "src/plugins/js/spectrum.min.js",
    "src/plugins/js/jquery-ui.min.js",
    "src/plugins/js/jquery.mousewheel.min.js",
    // 'src/plugins/js/numeral.min.js',
    "src/plugins/js/html2canvas.min.js",
    "src/plugins/js/localforage.min.js",
    "src/plugins/js/lodash.min.js",
    "src/plugins/js/jstat.min.js",
    "src/plugins/js/crypto-api.min.js",
    "src/plugins/js/jquery.sPage.min.js",
  ],

  //plugins concat
  concatPluginsCss: "pluginsCss.css",
  concatPlugins: "plugins.css",
  concatCss: "luckysheet.css",
  concatPluginsJs: "plugin.js",

  //plugins dest
  destPluginsCss: ["dist/plugins/css"],
  destPlugins: ["dist/plugins"],
  destCss: ["dist/css"],
  destPluginsJs: ["dist/plugins/js"],

  // Package directory
  dist: "dist",
};

// Clear the dist directory
function clean() {
  return del([paths.dist]);
}

// According to the build tag in html, package js and css
function pluginsCss() {
  return src(paths.pluginsCss)
    .pipe(concat(paths.concatPluginsCss))
    .pipe(gulpif(production, cleanCSS()))
    .pipe(dest(paths.destPluginsCss));
}

function plugins() {
  return src(paths.plugins)
    .pipe(concat(paths.concatPlugins))
    .pipe(gulpif(production, cleanCSS()))
    .pipe(dest(paths.destPlugins));
}

function css() {
  return src(paths.css)
    .pipe(concat(paths.concatCss))
    .pipe(gulpif(production, cleanCSS()))
    .pipe(dest(paths.destCss));
}

function pluginsJs() {
  return src(paths.pluginsJs)
    .pipe(concat(paths.concatPluginsJs))
    .pipe(gulpif(production, uglify(uglifyOptions)))
    .pipe(dest(paths.destPluginsJs));
}

// Copy static resources
function copyStaticHtml() {
  return src(paths.staticHtml).pipe(dest(paths.destStaticHtml));
}
function copyStaticFonts() {
  return src(paths.staticFonts).pipe(dest(paths.destStaticFonts));
}
function copyStaticAssets() {
  return src(paths.staticAssets).pipe(dest(paths.destStaticAssets));
}
function copyStaticImages() {
  return src(paths.staticImages).pipe(dest(paths.destStaticImages));
}
function copyStaticExpendPlugins() {
  return src(paths.staticExpendPlugins).pipe(
    dest(paths.destStaticExpendPlugins)
  );
}
function copyStaticDemoData() {
  return src(paths.staticDemoData).pipe(dest(paths.destStaticDemoData));
  // .pipe(gulpBabel({
  //     presets: ['@babel/env']
  // }))
  // .pipe(gulp.dest('dist'));
}
function copyStaticCssImages() {
  return src(paths.staticCssImages).pipe(dest(paths.destStaticCssImages));
}

const buildAssets = series(
  clean,
  parallel(
    pluginsCss,
    plugins,
    css,
    pluginsJs,
    copyStaticHtml,
    copyStaticFonts,
    copyStaticAssets,
    copyStaticImages,
    copyStaticExpendPlugins,
    copyStaticDemoData,
    copyStaticCssImages
  )
);

gulp.task("assets", buildAssets);
