class HttpConfig {
  /// 平台后端接口 oauth 参数
  static const String product = 'AMOS-APP-ADMIN';
  static const String appKey = 'AMOS_ADMIN';

  ///平台地址（网管地址），如果不写端口，只需要平台配置代理，将80端口映射为具体的端口即可
  /// 注意，改地址必须以 `/` 结尾，其它地方使用时，注意该 `/` 问题
  static const String GateWayURL = 'http://172.16.3.18:8808/';

  /// app 升级地址
  /// json 内容示例
  /// ```json
  /// {
  ///   "version": "1.0.2",
  ///   "apkName": "jcs_airport-V1.0.0-1-20211025_beta1.apk",
  ///   "apkSaveName": "amostmp.apk",
  ///   "apkDownloadUrl": "http://172.16.10.72/app/jcs_airport-V1.0.0-1-20211025_beta1.apk"
  /// }
  /// ```
  ///
  /// 注意，整个升级，仅判断 version 字段
  ///
  static const String UpdateApkUrl =
      'http://172.16.10.72/app/apk/apk-version.json';

  //static const String ImageUrl = 'http://39.98.45.134:9000/';
  static const String ImageUrl = 'http://172.16.11.201:3006/yibin/yeejoin/';

  static const String mqttUrl = 'ws://172.16.11.201:1883/mqtt';

  static const int connTimeout = 60000;
  static const int recTimeout = 10000;
}
