import 'package:fluro/fluro.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:flutter_localizations/flutter_localizations.dart';
import 'package:get/get_navigation/src/root/get_material_app.dart';
import 'package:get/get_navigation/src/routes/get_route.dart';
import 'package:amos_flutter_utils/amos_flutter_utils.dart';
import 'package:amos_iot_login_tpl/amos_iot_login_tpl.dart';
import 'package:base/view/common/not_found_page.dart';
import 'package:jcs_airport/routes/routes.dart';
import 'package:base/consts/global_config.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';
import 'package:equipment_manage/routes/routes.dart' as equipment_manager_routes;
import 'package:jcs_airport/view/sign/routes.dart';
import 'package:jcs_airport/view/sign/application.dart' as application_dl;

import '../consts/http_config.dart';
import '../consts/url_const.dart';
import '../services/application.dart';
import '../utils/app_theme.dart';

void initSysConfig() {
  GlobalConfig.appKey = HttpConfig.appKey;
  GlobalConfig.product = HttpConfig.product;

  /// 设置极光推送 appKey
  LoginGlobalConfig.jpushKey = '4d2a551de5d1878d6509cdda';
  GlobalConfig.gatewayUrl = HttpConfig.GateWayURL;

  /// 配置 login 模块
  LoginGlobalConfig.showSysConfig = true;
  LoginGlobalConfig.gatewayUrl = HttpConfig.GateWayURL;
  LoginGlobalConfig.imageUrl = HttpConfig.ImageUrl;
  LoginGlobalConfig.mqttUrl = HttpConfig.mqttUrl;
  LoginGlobalConfig.updateApkUrl = HttpConfig.UpdateApkUrl;

  /// 内嵌 h5 页面
  LoginGlobalConfig.h5Url = URLConst.MAP_H5_URL;
  LoginGlobalConfig.theme = AppTheme.BUILT_IN_THEME_BLUE;
}

class MyApp extends StatefulWidget {
  MyApp() {
    initSysConfig();
    final router = FluroRouter();
    equipment_manager_routes.Routes.configureRoutes(router);
    Routes.configureRoutes(router);
    Application.router = router;
    // application_dl.Application.router = router;
  }

  @override
  _MyAppState createState() => _MyAppState();
}

class _MyAppState extends State<MyApp> {
  final AppTheme _appTheme = Get.put(AppTheme(), tag: GlobalConst.theme);

  @override
  void initState() {
    super.initState();
    _initTheme();
  }

  Future<void> _initTheme() async {
    String _theme = await ThemeManager.getTheme();
    _appTheme.changeTheme(_theme);
  }

  @override
  Widget build(BuildContext context) {
    SizeFit.initialize();
    return GetMaterialApp(
      localizationsDelegates: const [
        GlobalMaterialLocalizations.delegate,
        GlobalWidgetsLocalizations.delegate,
        RefreshLocalizations.delegate,
      ],
      supportedLocales: const [
        Locale('zh', 'CH'),
        Locale('en', 'US'),
      ],
      locale: const Locale('zh'),
      title: '数字化质量检验系统',
      onGenerateRoute: Application.router.generator,
      theme: _appTheme.getCurrentTheme(),
      debugShowCheckedModeBanner: false,
      getPages: JCSRoutes.getPages(),
      unknownRoute: GetPage(
          name: '404/',
          page: () {
            return const NotFoundPage();
          }),
    );
  }
}
