import 'dart:async';

import 'package:amos_iot_login_tpl/amos_iot_login_tpl.dart';

import 'package:base/model/initialize_providers.dart';
import 'package:flutter/material.dart';
import 'package:provider/provider.dart';

import 'entry/index.dart';

void main() {
  FlutterError.onError = ErrorCrash.instance.onFlutterError;
  /// 错误日志存储到文件
  ErrorCrash.instance.storeToFile = true;

  runZoned<Future<void>>(
    () async {
      runApp(MultiProvider(
        providers: providers,
        child: MyApp(),
      ));
    },
    onError: (dynamic error, StackTrace stackTrace) {
      ErrorCrash.instance.recordError(error, stackTrace);
    },
  );
}
