import 'package:amos_iot_login_tpl/amos_iot_login_tpl.dart';
import 'package:base/view/my/subscribe_page.dart';
import 'package:equipment_manage/routes/routes.dart' as equipment_manage_routes;
import 'package:base/routes/routes.dart' as base_routes;
import 'package:equipment_manage/view/common/create_scrap.dart';
import 'package:equipment_manage/view/equip_warehousing.dart';
import 'package:get/get_navigation/src/routes/get_route.dart';

import 'package:jcs_airport/view/dispatch/bindingCar/binding_car.dart';
import 'package:jcs_airport/view/emergenryPlan/myTask.dart';
import 'package:jcs_airport/view/emergenryPlan/EmergenryLog.dart';
import 'package:jcs_airport/view/dispatch/linkageInformation/linkage_information.dart';
import 'package:jcs_airport/view/workBench/hiddenDanger/HiddenDanger.dart';
import 'package:safe_control/routes/routes.dart' as safe_control_routes;
import 'package:safe_control/view/CheckExecute/checkexec_list_content.dart';
import 'package:safe_control/view/hidedanger_manage/hidden_danger_found.dart';
import 'package:safe_control/view/hidedanger_manage/hidden_danger_processed.dart';
import 'package:safe_control/view/hidedanger_manage/hidedanger_manage.dart';
import 'package:safe_control/view/hidedanger_manage/hidedanger_pending.dart';
import 'package:safe_control/view/hidedanger_manage/task_addition/task_addition_screen.dart';
import 'package:safe_control/view/inspection_record/record_list_screen.dart';
import 'package:safe_control/view/inspection_spot/inspection_spot_screen.dart';
import 'package:safe_control/view/move_inspection/move_spot_list_screen.dart';
import 'package:safe_control/view/no_plan_inspection/no_plan_inspection.dart';
import 'package:safe_control/view/plan_inspection/plan_list_screen.dart';
import 'package:safe_control/view/task_calendar/calendar_main.dart';
import 'package:jcs_airport/view/defect/hidden_defect_found.dart';
import 'package:jcs_airport/view/defect/offline/offline_defect_found.dart';
import 'package:offline/view/plan_inspection/offline_plan_list_screen.dart';
import 'package:offline/view/no_plan_inspection/no_plan_inspection.dart';
import 'package:offline/view/move_inspection/move_spot_list_screen.dart';
import 'package:offline/view/inspection_spot/offline_inspection_spot_screen.dart';
import 'package:jcs_airport/view/sign/sign.dart';
import 'package:jcs_airport/view/sign/offline/offlineSign.dart';
import 'package:safe_control/view/plan_inspection/plan_list_content.dart';


import 'package:jcs_airport/view/workBench/maintenance/maintenanceTask/task_equipment.dart';


import './../consts/iot_page_config.dart';
import './../view/dispatch/calcFormula/index.dart';
import './../view/dispatch/hazardousChemicals/hazardous_chemicals.dart';
import './../view/dispatch/hazardousChemicals/hazardous_chemicals_detail.dart';
import './../view/dispatch/index.dart';
import './../view/dispatch/map/power/power_detail.dart';
import './../view/dispatch/statistics/dispatch_alarm_list.dart';
import './../view/dispatch/statistics/dispatch_task_list.dart';
import './../view/workBench/fireproofSupervision/planCheck/plan_check.dart';
import './../view/workBench/hiddenDanger/hiddenDangerAudit/hidden_danger_audit.dart';
import './../view/workBench/hiddenDanger/hiddenDangerAudit/hidden_danger_audit_detail.dart';
import './../view/workBench/maintenance/maintenanceCalender/calender.dart';
import './../view/workBench/maintenance/maintenanceEquipment/equipment.dart';
import './../view/workBench/maintenance/maintenanceRecord/record.dart';
import './../view/workBench/maintenance/maintenanceTask/task.dart';
import './../view/workBench/malfunctionReport/malfunctionReport/malfunction_report.dart';
import './../view/workBench/malfunctionReport/reportTask/report_task.dart';
import './../view/workBench/realTimeMonitoring/alarmInfo/alarm_info.dart';
import './../view/workBench/realTimeMonitoring/alarmInfo/alarm_info_detail.dart';
import './../view/workBench/realTimeMonitoring/iotFacilities/facility.dart';
import './../view/workBench/realTimeMonitoring/iotFacilities/list_page.dart';
import './../view/workBench/realTimeMonitoring/monitorEvent/monitor_event.dart';
import './../view/workBench/realTimeMonitoring/monitorEvent/monitor_event_detail.dart';
import './../view/workBench/realTimeMonitoring/monitorVideo/monitor_video_detail.dart';
import './../view/workBench/realTimeMonitoring/monitorVideo/monitor_video_list.dart';
import '../view/workBench/maintenance/maintenanceTask/task_detail.dart';
import '../view/maintenance/index.dart';

import '../view/scanOnce/NewQrPage.dart';
import '../view/scanOnce/DeviceDetailPage.dart';
import '../view/sendForInspection/InspectionPage.dart';

mixin JCSRoutes {
  static const String root = '/';
  static const String index = '/index';
  // 计量业务
  static const String scanOnce = '/scanOnce'; //扫一扫
  static const String sendForInspection = '/sendForInspection'; //送检
  static const String receive = '/receive'; //接收
  static const String collect = '/collect'; //领取
  static const String equipdetails = '/equipdetails'; //设备详情


  ///故障报修
  static const String malfunctionReport = '/malfunctionReport'; //故障报修录入
  static const String reportTaskAll = '/reportTaskAll'; //报修清单
  static const String reportTaskWaiting = '/reportTaskWaiting'; //待处理
  static const String reportTaskInitiate = '/reportTaskInitiate'; //我发起
  ///消防维保
  static const String maintenanceTask = '/maintenanceTask'; //维保任务
  static const String maintenanceEquipment = '/maintenanceEquipment'; //维保设施
  static const String maintenanceRecord = '/maintenanceRecord'; //维保记录
  static const String maintenanceCalender = '/maintenanceCalender'; //维保日历
  static const String maintenance = '/maintenance'; //维保详情页
  ///防火监督
  static const String fireproofPlanCheck = '/fireproofPlanCheck'; //计划检查
  ///隐患治理
  static const String hiddenDangerReview = '/hiddenDangerReview'; //隐患复查
  static const String hiddenDangerAudit = '/hiddenDangerAudit'; //隐患审核
  static const String hiddenDangerAuditDetail = '/hiddenDangerAuditDetail'; //隐患审核详情
  static const String hiddenDanger = '/hiddenDanger'; //监督检查隐患
  ///物联监测
  static const String alarmInfo = '/alarmInfo'; // 告警列表
  static const String alarmInfoDetail = '/alarmInfoDetail'; // 告警详情
  static const String iotFacilities = '/iotFacilities'; // 设备设施列表
  static const String iotFacilityDetail = '/iotFacilityDetail'; // 设备设施详情
  static const String monitorEvent = '/monitorEvent'; // 在岗监测列表
  static const String monitorEventDetail = '/monitorEventDetail'; // 在岗监测详情
  static const String monitorVideo = '/monitorVideo'; // 视频监控
  static const String monitorVideoDetail = '/monitorVideoDetail'; // 视频监控查看
  /// 作战指挥
  static const String dispatchMap = '/dispatchMap'; // 作战地图
  static const String foamFluid = '/foamFluid'; // 计算公式 - 泡沫原液量
  static const String verticalTankWater = '/verticalTankWater'; // 计算公式 - 立罐灭火用水量
  static const String hydrocarbonTank = '/hydrocarbonTank'; // 计算公式 - 液化烃球罐用水量
  static const String pipeWater = '/pipeWater'; // 计算公式 - 管网供水能力

  static const String powerDispatching = '/powerDispatching'; // 力量调度
  static const String hazardousChemicals = '/hazardousChemicals'; // 危化品查询
  static const String hazardousChemicalsDetail = '/hazardousChemicalsDetail'; // 危化品查询
  static const String dispatchAlarm = '/dispatchAlarm'; // 当前警情
  static const String dispatchTask = '/dispatchTask'; // 当前任务
  static const String bindingCar = '/bindingCar'; // 车辆绑定
  static const String linkageInformation = '/linkageInformation'; // 联动信息

  ///打卡
  static String sign = '/sign';

  ///离线巡检
  static String offlinePlanPatrol = '/offlinePlanPatrol';
  static String offlineNoPlanPatrol = '/offlineNoPlanPatrol';
  static String offlineMoblePatrol = '/offlineMoblePatrol';
  static String offlinePatrolPoint = '/offlinePatrolPoint';

  ///离线打卡
  static String offlineSign = '/offlineSign';


  ///缺陷治理新
  static String hiddenAdd = '/hiddenAdd';

  ///离线缺陷
  static String hiddenOfflineAdd = '/hiddenOfflineAdd';

  ///待处置任务
  static String myTask = '/myTask';
  static String emergenryLog = '/emergenryLog';

  ///任务执行
  static String pendingTask = '/pendingTask';
  static String taskExecution = '/taskExecution';

  // 日常训练
  static String trainAdd = '/trainAdd';
  static String trainRecord = '/trainRecord';

  static List<GetPage> getPages() {
    return [
      GetPage(name: root, page: () => Login(IotPageConfig.loginInfo)),

      /// 计量业务
      GetPage(name: scanOnce, page: () => const NewQrPage()),
      GetPage(name: sendForInspection, page: () =>  InspectionPage(bizType: 'submission')),
      GetPage(name: receive, page: () => InspectionPage(bizType: 'receive')),
      GetPage(name: collect, page: () => InspectionPage(bizType: 'recaption')),

      ///故障报修
      GetPage(name: malfunctionReport, page: () => const MalfunctionReport()),
      GetPage(name: reportTaskAll, page: () => const ReportTask(0)),
      GetPage(name: reportTaskWaiting, page: () => const ReportTask(1)),
      GetPage(name: reportTaskInitiate, page: () => const ReportTask(3)),

      ///消防维保
      GetPage(name: maintenanceTask, page: () => const Task()),
      GetPage(name: maintenanceEquipment, page: () => const Equipment()),
      GetPage(name: maintenanceRecord, page: () => Record()),
      GetPage(name: maintenanceCalender, page: () => const Calender()),
      GetPage(name: maintenance, page: () => TaskDetail('1','1',false)),

      GetPage(name: alarmInfo, page: () => const AlarmInfo()),
      GetPage(name: alarmInfoDetail, page: () => const AlarmInfoDetail()),
      GetPage(name: iotFacilities, page: () => const IOTFacilities()),
      GetPage(name: iotFacilityDetail, page: () => const FacilityTab()),
      GetPage(name: monitorEvent, page: () => const MonitorEvent()),
      GetPage(name: monitorEventDetail, page: () => const MonitorEventDetail()),
      GetPage(name: monitorVideo, page: () => const MonitorVideoList()),
      GetPage(name: monitorVideoDetail, page: () => const MonitorVideoDetail()),

      ///防火监督
      GetPage(name: fireproofPlanCheck, page: () => const PlanCheck()),

      ///隐患治理
      GetPage(name: hiddenDangerAudit, page: () => const HiddenDangerAudit(1)),
      GetPage(name: hiddenDangerReview, page: () => const HiddenDangerAudit(2)),
      GetPage(name: hiddenDangerAuditDetail, page: () => HiddenDangerAuditDetail(null, 1)),
      GetPage(name: hiddenDanger, page: () => const HiddenDanger()),

      /// 作战指挥
      GetPage(name: dispatchMap, page: () => const DispatchMainMap()),
      GetPage(name: foamFluid, page: () => const FoamFluid()),
      GetPage(name: verticalTankWater, page: () => const VerticalTankWater()),
      GetPage(name: hydrocarbonTank, page: () => const HydrocarbonTank()),
      GetPage(name: pipeWater, page: () => const PipeWater()),
      GetPage(name: powerDispatching, page: () => const PowerDispatching()),
      GetPage(name: hazardousChemicals, page: () => const HazardousChemicals()),
      GetPage(name: hazardousChemicalsDetail, page: () => const HazardousChemicalsDetail()),
      GetPage(name: dispatchAlarm, page: () => const CurrentAlarmList()),
      GetPage(name: dispatchTask, page: () => const CurrentTaskList()),
      GetPage(name: bindingCar, page: () => const BindingCar()),
      GetPage(name: linkageInformation, page: () => const LinkageInformation()),

      ///日常巡检
      GetPage(name: safe_control_routes.Routes.planPatrol, page: () => PlanListScreen()),
      GetPage(name: safe_control_routes.Routes.noPlanPatrol, page: () => const NoPlanInspection()),
      GetPage(name: safe_control_routes.Routes.moblePatrol, page: () => MoveSpotListScreen()),
      GetPage(name: safe_control_routes.Routes.patrolLog, page: () => const RecordListScreen()),
      GetPage(name: safe_control_routes.Routes.patrolPoint, page: () => InspectionSpotScreen()),
      GetPage(name: safe_control_routes.Routes.patrolCalendar, page: () => CalendarMainPage()),
      GetPage(name: safe_control_routes.Routes.patrolLogDetails, page: () => CheckExecListContent(0)),
      GetPage(name: safe_control_routes.Routes.patrolDetails, page: () =>  PlanListContent(0)),


      /// 打卡
      GetPage(name: sign, page: () => Sign()),



      /// 离线
      GetPage(name: offlinePlanPatrol, page: () => OfflinePlanListScreen()),
      GetPage(name: offlineNoPlanPatrol, page: () => OfflineNoPlanInspection()),
      GetPage(name: offlineMoblePatrol, page: () => OfflineMoveSpotListScreen()),
      GetPage(name: offlinePatrolPoint, page: () => OfflineInspectionSpotScreen()),
      GetPage(name: offlineSign, page: () => OfflineSign()),

      ///缺陷治理
      GetPage(name: safe_control_routes.Routes.myReceive, page: () => const HideDangerPage(1)),
      GetPage(name: safe_control_routes.Routes.mySend, page: () => const HideDangerPage(2)),
      GetPage(name: safe_control_routes.Routes.addTask, page: () => const TaskAdditionScreen()),
      GetPage(name: safe_control_routes.Routes.allTask, page: () => const HideDangerPage(0)),

      ///缺陷治理新
      GetPage(name: hiddenAdd, page: () => HiddenDefectFound()),

      ///离线缺陷
      GetPage(name: hiddenOfflineAdd, page: () => HiddenOfflineDefectFound()),

      ///隐患治理
      GetPage(name: safe_control_routes.Routes.waitHandlePage, page: () => PendingHideDanger()),
      GetPage(name: safe_control_routes.Routes.haveHandlePage, page: () => ProcessedHiddenDanger()),
      GetPage(name: safe_control_routes.Routes.latentDangerSavePage, page: () => const HiddenDangerFound()),
      GetPage(name: safe_control_routes.Routes.latentDangerDetailsPage, page: () => PendingHideDanger()),

      ///装备管理
      GetPage(name: equipment_manage_routes.Routes.equipWareHousing, page: () => EquipWareHousing()),
      GetPage(name: equipment_manage_routes.Routes.createScrap, page: () => CreateScrap()),

      ///我的
      GetPage(name: base_routes.Routes.subscribePage, page: () => SubscribePage()),

      ///待处置任务 -应急处置
      GetPage(name: myTask, page: () => MyEmergencyTask()),

      ///应急处置记录
      GetPage(name: emergenryLog, page: () => EmergenryLog()),

      ///任务执行
      // GetPage(name: pendingTask, page: () => const PendingTask()),
      // GetPage(name: taskExecution, page: () => const TaskExecution()),
    ];
  }
}
