import 'package:amos_flutter_ui/dropdown/drapdown_common.dart';
import 'package:amos_flutter_ui/dropdown/dropdown_menu.dart';
import 'package:amos_flutter_ui/dropdown/dropdown_templates.dart';
import 'package:flutter/material.dart';
import 'package:jcs_airport/entity/Page.dart';
import 'package:jcs_airport/view/common/dropdown_hander.dart';
import 'package:jcs_airport/view/common/dropdown_list_menu.dart';
import 'package:jcs_airport/view/common/no_data.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';

///@Description     带有[Dropdown]/[上拉加载]/[下拉刷新]/[无数据提示]的基础页面
///@author          helinlin
///@create          2021-09-01 17:02
abstract class BaseDropdownFilterState<T extends StatefulWidget> extends State<T> {
  //是否显示过滤按钮
  bool hasFilter = true;
  final AmosPage page = AmosPage(current: 0);
  final List<Map<String, Object>> dataList = [];
  final RefreshController refreshController = RefreshController(initialRefresh: false);

  @override
  @mustCallSuper
  void initState() {
    super.initState();
    getData();
  }

  @override
  @mustCallSuper
  void dispose() {
    super.dispose();
    refreshController.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: getAppBar(),
      body: DefaultDropdownMenuController(
        onSelected: onDropdownItemChanged,
        child: Stack(
          children: [
            Padding(
              padding: const EdgeInsets.only(top: 46),
              child: Column(
                children: [
                  dataList.isNotEmpty
                      ? Expanded(
                          child: SmartRefresher(
                          controller: refreshController,
                          enablePullDown: true,
                          enablePullUp: true,
                          header: const WaterDropMaterialHeader(),
                          footer: const ClassicFooter(),
                          onRefresh: onRefresh,
                          onLoading: onLoading,
                          child: ListView.builder(
                            itemCount: dataList.length,
                            shrinkWrap: true,
                            itemBuilder: buildListItem,
                          ),
                        ))
                      : const NoData()
                ],
              ),
            ),
            Row(
              children: [
                Expanded(
                  child: DropdownHeader(
                    fontSize: 13,
                    titles: getDropdownMenuContentEntity()
                        .map((element) =>
                            element.data[element.chooseIndex >= element.data.length ? 0 : element.chooseIndex]['title'])
                        .toList(),
                  ),
                ),
                hasFilter
                    ? Padding(
                        padding: const EdgeInsets.symmetric(horizontal: 8),
                        child: InkWell(
                          child: Row(
                            children: const [
                              Text(
                                '筛选',
                                style: TextStyle(color: Colors.black54),
                              ),
                              Icon(
                                Icons.filter_alt_outlined,
                                size: 14,
                                color: Colors.black54,
                              )
                            ],
                          ),
                          onTap: onFilterTap,
                        ),
                      )
                    : const SizedBox(),
              ],
            ),
            Padding(
              padding: const EdgeInsets.only(top: 46),
              child: DropdownMenu(
                menus: getDropdownMenuContentEntity()
                    .map((element) => DropdownMenuBuilder(
                        builder: (BuildContext context) => DropdownListMenu(
                              selectedIndex: element.chooseIndex,
                              data: element.data,
                              itemBuilder: buildCheckItem,
                            ),
                        height: (element.data.length * 46).toDouble()))
                    .toList(),
              ),
            )
          ],
        ),
      ),
    );
  }

  ///下拉刷新
  @mustCallSuper
  void onRefresh() {
    setState(() {
      dataList.clear();
    });
    page.current = 0;
    getData();
  }

  ///上拉加载
  @mustCallSuper
  void onLoading() {
    page.current += 1;
    getData();
  }

  ///自定义AppBar(需要时重写)
  Widget getAppBar() => AppBar(
        title: Text(pageTitle() ?? ''),
      );

  ///[筛选]菜单被点击(hasFilter为true时重写)
  void onFilterTap() {}

  ///页面标题
  String pageTitle();

  ///构建list项
  Widget buildListItem(BuildContext context, int index);

  ///获取数据
  void getData();

  ///切换dropdown
  void onDropdownItemChanged({int menuIndex, int index, int subIndex, dynamic data});

  ///dropdown内容
  List<DropdownMenuBuilderEntity> getDropdownMenuContentEntity();
}

class DropdownMenuBuilderEntity<T> {
  int chooseIndex;
  List<T> data;

  DropdownMenuBuilderEntity(this.chooseIndex, this.data);
}
