/// 重新设置警情位置
///
///
import 'package:flutter/material.dart';
import 'package:webview_flutter/webview_flutter.dart';
import './../h5_base_map.dart';

/// 点击工具来，重新设置警情位置
class AlarmPositionSet extends StatefulWidget {
  const AlarmPositionSet(
      {Key key, this.callh5, this.h5Url, this.alarmId, this.token})
      : super(key: key);

  final String alarmId;
  final String token;
  final String h5Url;

  /// main map 向 H5 端发送指令
  final Function callh5;

  @override
  _AlarmPositionSetState createState() => _AlarmPositionSetState();
}

class _AlarmPositionSetState extends State<AlarmPositionSet> {
  WebViewController webViewController;

  @override
  Widget build(BuildContext context) {
    return Scaffold(
        appBar: AppBar(
          title: const Text('警情定位'),
          actions: <Widget>[
            IconButton(
              icon: const Icon(
                Icons.save,
                color: Colors.white,
              ),
              onPressed: () {
                /// 通知 h5 端进行警情定位保存
                executeJs('alarmPointSave("goBack")');
              },
            )
          ],
        ),
        body: Stack(
          children: [
            Container(
                child: H5MapBase(
                    h5Url:
                        '${widget.h5Url}?token=${widget.token}&page=alarmPoint&alarmId=${widget.alarmId ?? ''}',
                    onCreated: (wvc) => {webViewController = wvc}))
          ],
        ));
  }

  void executeJs(String method, {dynamic data}) {
    webViewController.evaluateJavascript('$method()');
  }
}
