/// 集结点设定
///
///
import 'package:flutter/material.dart';
import 'package:webview_flutter/webview_flutter.dart';
import './../h5_base_map.dart';

class AssemblyPointSet extends StatefulWidget {
  const AssemblyPointSet(
      {Key key,
      this.assemblyPointId,
      this.h5Url,
      this.alarmId,
      this.callh5,
      this.token})
      : super(key: key);

  /// 集结点Id
  final String assemblyPointId;

  /// 警情ID
  final String alarmId;
  final String token;
  final String h5Url;

  /// main map 向 H5 端发送指令
  final Function callh5;

  @override
  _AssemblyPointSetState createState() => _AssemblyPointSetState();
}

class _AssemblyPointSetState extends State<AssemblyPointSet> {
  WebViewController webViewController;

  @override
  Widget build(BuildContext context) {
    return Scaffold(
        appBar: AppBar(
          title: const Text('集结区设定'),
          actions: <Widget>[
            IconButton(
              icon: const Icon(
                Icons.save,
                color: Colors.white,
              ),
              onPressed: () {
                /// 通知 h5 端进行集结区保存
                executeJs('assemblyPointSave("goBack")');
              },
            )
          ],
        ),
        body: Stack(
          children: [
            Container(
                child: H5MapBase(
                    h5Url:
                        '${widget.h5Url}?token=${widget.token}&page=assemblyPoint&alarmId=${widget.alarmId ?? ''}&assemblyPointId=${widget.assemblyPointId ?? ''}',
                    onCreated: (wvc) => {webViewController = wvc}))
          ],
        ));
  }

  /// 当前 webview 向 h5 执行方法
  void executeJs(String method, {dynamic data}) {
    webViewController.evaluateJavascript('$method()');
  }
}
