import 'package:flutter/material.dart';
import 'package:get/get.dart';
import './power_list.dart';
import './statistics.dart';

/// 力量调度详情
class PowerDispatching extends StatefulWidget {
  const PowerDispatching();

  @override
  State<StatefulWidget> createState() => _PowerDispatchingState();
}

class _PowerDispatchingState extends State<PowerDispatching>
    with SingleTickerProviderStateMixin {
  int tabIndex = 0;
  String alarmId = '';
  TabController _tabController;

  _PowerDispatchingState();

  @override
  void initState() {
    super.initState();
    alarmId = Get.arguments;
    _tabController = TabController(vsync: this, length: 3);
    _tabController.animateTo(tabIndex);
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: const Text('力量调度'),
        bottom: TabBar(
          tabs: const [
            Tab(text: '中队'),
            Tab(text: '车辆'),
            Tab(text: '人员'),
          ],
          controller: _tabController,
        ),
      ),
      body: TabBarView(
        controller: _tabController,
        children: [
          Container(
            decoration: const BoxDecoration(color: Color(0xffefefef)),
            child: Column(children: [
              Statistics(alarmId, 'team'),
              PowerList(alarmId, 'team')
            ]),
          ),
          Container(
            decoration: const BoxDecoration(color: Color(0xffefefef)),
            child: Column(children: [
              Statistics(alarmId, 'car'),
              PowerList(alarmId, 'car')
            ]),
          ),
          Container(
            decoration: const BoxDecoration(color: Color(0xffefefef)),
            child: Column(children: [
              Statistics(alarmId, 'person'),
              PowerList(alarmId, 'person')
            ]),
          ),
        ],
      ),
    );
  }
}
