import 'package:amos_iot_login_tpl/mine/offline/color.dart';
import 'package:flutter/material.dart';
import 'package:shared_preferences/shared_preferences.dart';

import 'back_button.dart';
import 'SearchWidget.dart';

// 选择具体人员

class SelectPersonList extends StatelessWidget {

   List persons;
   String title;
  SelectPersonList(this.persons,this.title);

  @override
  Widget build(BuildContext context) {
    return SelectPersonListContent(persons,title);
  }
}

class SelectPersonListContent extends StatefulWidget {

   List persons;
   String title;
  SelectPersonListContent(this.persons,this.title);

  @override
  _SelectPersonListContentState createState() => _SelectPersonListContentState(persons,title);
}

class _SelectPersonListContentState extends State<SelectPersonListContent> {

   List persons;
   String title;
  _SelectPersonListContentState(this.persons, this.title);

  int _index;
String theme='';


@override
  void initState() {
    // TODO: implement initState
    super.initState();
    initThemeConfig();
  }
  initThemeConfig() async {
    SharedPreferences.getInstance().then((preferences) {
      setState(() {
        this.theme =
            preferences.getString("theme") ?? KColorConstant.DEFAULT_COLOR;
      });
    });
  }
  @override
  Widget build(BuildContext context) {
    return  Scaffold(
        backgroundColor: Color(0xFFefeff4),
        appBar: AppBar(
        title: Text(widget.title,style: TextStyle(color: Colors.black),),
    leading: LeadingButton(
      theme:this.theme
    ),
    centerTitle: true,
          backgroundColor: Colors.white,
    ),
    body:Column(
      children: <Widget>[
        buildSearch(),
        Expanded(
          // padding: EdgeInsets.only(bottom: _index == null? 0: 50.px),
          child: ListView.builder(
              itemCount: persons.length,
              shrinkWrap: true,
              itemBuilder: (ctx,index){

                final item = persons[index];
                String  name = item["name"];
                String fir = name.substring(0,1);
                String  jobTitle = item["jobTitle"] == null ? '' : item["jobTitle"];
                return InkWell(
                  onTap: (){
                    setState(() {
                      _index = index;
                    });
                    confirm(context);
                  },
                  child: Container(
                    alignment: Alignment(-1,0),
                    color: (index != _index? Colors.white : Colors.blue),
                    padding: EdgeInsets.fromLTRB(10.0, 13.0, 24.0, 13.0),
                    // style: Theme.of(context).textTheme.headline2.copyWith(color: index == _index? GetConfig.getColor(theme):Color(0xFF333333),)),
                    child: Container(
                      padding:
                      EdgeInsets.only(left: 0, top: 10, bottom: 10),
                      height: 80,
                      child: Row(
                        mainAxisAlignment: MainAxisAlignment.start,
                        children: <Widget>[
                          Expanded(
                            child: CircleAvatar(
                               //'assets/images/login/username_blue.png',
                              //'assets/images/login/icon_person.svg',
                              //backgroundColor: Colors.grey[100],
                              radius: 30.0,
                                child: Text(fir)
                            ),
                            flex: 0,
                          ),
                          Expanded(
                            child: Container(
                              padding: EdgeInsets.only(
                                  left: 10, top: 10, bottom: 5),
                              width: MediaQuery.of(context).size.width - 50,
                              child: Column(children: <Widget>[
                                Container(
                                  alignment: Alignment(-1,0),
                                  child: Text(
                                      " $name",
                                      textAlign: TextAlign.left,
                                      style: TextStyle(
                                        color: Colors.black,
                                        fontSize: 15,
                                      )
                                  )
                                ),
                                Container(
                                    alignment: Alignment(-1,0),
                                    child: Text(
                                        " $jobTitle",
                                        textAlign: TextAlign.left,
                                        style: TextStyle(
                                          color: Colors.black,
                                          fontSize: 15,
                                        )
                                    )
                                )
                              ]
                              )),
                            // ),
                            flex: 9,
                          ),
                        ],
                      ),
                    ),

                    // ([
                    //
                    // ]),

                        // ,
                        // Text(
                        //   "$title",
                        //   style: Theme.of(context).textTheme.headline2.copyWith(color: index == _index? GetConfig.getColor(theme):Color(0xFF333333),)),
                  ),
                );
               }
              ),
        ),
        // _index == null? Container(): buildBottomButton(context)
      ],
    ));
  }

  // Widget buildBottomButton(context) {
  //   return Align(
  //     alignment: Alignment.bottomCenter,
  //     child: Container(
  //           height: 50.px,
  //           width: double.infinity,
  //           child: RaisedButton(
  //             color: GetConfig.getColor(theme),
  //             child: Text("确定",style: Theme.of(context).textTheme.headline2),
  //             onPressed: () => confirm(context),
  //           ),
  //         ),
  //   );
  // }

  // 确定
  void confirm(BuildContext context) {
     Navigator.of(context).pop(persons[_index]);
  }

  Widget buildSearch() => SearchWidget(
      onEditingComplete: onchange
  );

  void onchange(key) {
    final res = this.widget.persons.where((element) {
        final entry = element["name"];
        return entry.contains(key);
    }).toList();

    setState(() {
      this.persons = res;
    });

  }

}

