import 'dart:convert';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';
import 'package:get/get.dart';
import 'package:jcs_airport/services/api.dart';
import 'package:jcs_airport/routes/routes.dart';
import './pending_task.dart';

import 'form_parser.dart';

///@Description     待办任务
///@author          lixiuming
///@create          2023-11-15 15:34
class TaskExecution extends StatefulWidget {
  final String processInstanceId;
  final String source;
  final String taskLimitTime;

  const TaskExecution( { Key key, this.processInstanceId, this.source, this.taskLimitTime }) : super(key: key);

  static void popUpMsg(String msg, {txtColor, bgColor, gravity, time}) {
    shortMessage(msg,
        gravity: gravity ?? ToastGravity.CENTER,
        toastLength: time,
        textColor: txtColor ?? Colors.white,
        backgroundColor: bgColor ?? Colors.black54);
  }

  @override
  _TaskExecutionState createState() => _TaskExecutionState();
}

class _TaskExecutionState extends State<TaskExecution> {
  // 当前表单ID
  String formId;

  // 页面状态
  bool editable = false;

  // 执行日志
  List<Map> executionLogs = [];

  // 表单组件
  Map<String, List<Widget>> formWidgetMap = {};

  // 表单数据
  Map<String, Map<String, dynamic>> formDataMap = {};

  // 表单校验条件
  Map<String, Map<String, dynamic>> formValidateMap = {};

  // 任务进程弹窗
  bool openTaskProcessesDialog = false;

  // 抽屉控制器
  final AmosDrawerController _drawerController = AmosDrawerController();
  bool _isPanelOpen = false;

  // 流程实例ID
  String processInstanceId = '';

  // 流程实例payload参数
  Map<String, dynamic> processInstancePayload = {};

  // pageFormMetaData
  Map<String, dynamic> pageFormMetaData = {};

  Map<String, dynamic> pageFormSubmitInfo = {};

  int activeLogIndex = 0;

  @override
  void initState() {
    super.initState();
    setup();
  }

  Future<void> setup() async {
    processInstanceId = widget.processInstanceId;
    processInstancePayload['source'] = widget.source;
    processInstancePayload['taskLimitTime'] = widget.taskLimitTime;
    // 获取任务执行日志
    await getTaskFlowLogs(processInstanceId);
  }

  @override
  Widget build(BuildContext context) {
    if (executionLogs.isEmpty) {
      return Scaffold(
        appBar: AppBar(
          title: const Text('任务执行'),
          centerTitle: true,
        ),
        body: Container(),
      );
    }
    return Stack(
      alignment: Alignment.bottomCenter,
      children: [
        Scaffold(
          appBar: AppBar(
            title: const Text('任务执行'),
            centerTitle: true,
          ),
          body: Stack(
            alignment: Alignment.bottomCenter,
            children: [
              SingleChildScrollView(
                  child: Container(
                      color: const Color.fromARGB(255, 245, 245, 245),
                      margin: const EdgeInsets.only(bottom: 100),
                      child: Container(
                        color: Colors.white,
                        margin: const EdgeInsets.only(top: 10.0),
                        padding: const EdgeInsets.only(left: 10.0, right: 10.0),
                        constraints: BoxConstraints(
                          minHeight: MediaQuery.of(context).size.height - 158,
                        ),
                        child: Column(children: <Widget>[
                          Row(
                            children: <Widget>[
                              Expanded(
                                child: Container(
                                  padding:
                                      const EdgeInsets.only(top: 10, bottom: 5),
                                  width: MediaQuery.of(context).size.width - 50,
                                  child: Column(
                                    children: [
                                      Form(
                                        child: Column(
                                            crossAxisAlignment:
                                                CrossAxisAlignment.start,
                                            children:
                                                formWidgetMap[formId] ?? []),
                                      )
                                    ],
                                    // children: <Widget>[],
                                  ),
                                ),
                              ),
                            ],
                          ),
                        ]),
                      ))),
              getExecutionLogsDialog(context, executionLogs),
              editable
                  ? Container(
                      height: 54,
                      width: double.infinity,
                      padding: const EdgeInsets.all(2),
                      child: ElevatedButton(
                        style: ButtonStyle(
                            backgroundColor: MaterialStateProperty.all(
                                const Color.fromRGBO(50, 89, 206, 1))),
                        child: const Text('提交'),
                        onPressed: () {
                          formSubmit(context, formDataMap[formId],
                              formValidateMap[formId]);
                        },
                      ),
                    )
                  : Container(),
            ],
          ),
        ),
        // if (openTaskProcessesDialog)
      ],
    );
  }

  /// 查看执行流程
  Widget getExecutionLogsDialog(context, executionLogs) {
    if (executionLogs.isEmpty) {
      return Container();
    }
    return Material(
        child: Container(
      height: _isPanelOpen
          ? 400
          : editable
              ? 100
              : 50,
      child: AmosDrawer(
        header: Container(
          width: MediaQuery.of(context).size.width,
          child: Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Container(
                padding: const EdgeInsets.only(left: 16),
                child: Row(
                  children: [
                    const Text(
                      '当前',
                      style: TextStyle(
                          fontSize: 14,
                          color: Color.fromRGBO(153, 153, 153, 1)),
                    ),
                    const SizedBox(
                      width: 10,
                    ),
                    Text(executionLogs.first['taskName'],
                        style: const TextStyle(
                            fontSize: 14,
                            color: Color.fromRGBO(51, 51, 51, 1))),
                    const SizedBox(
                      width: 10,
                    ),
                    // const Text('跳转',
                    //     style: TextStyle(
                    //         fontSize: 14,
                    //         color: Color.fromRGBO(24, 144, 255, 1))),
                  ],
                ),
              ),
              Container(
                child: IconButton(
                  padding: const EdgeInsets.all(0),
                  iconSize: 20,
                  color: Colors.blue,
                  icon: _isPanelOpen
                      ? const Icon(Icons.keyboard_arrow_down)
                      : const Icon(Icons.keyboard_arrow_up),
                  onPressed: () {
                    setState(() {
                      if (_isPanelOpen) {
                        setState(() {
                          _isPanelOpen = false;
                        });
                        _drawerController.close();
                      } else {
                        setState(() {
                          _isPanelOpen = true;
                        });
                        _drawerController.open();
                      }
                    });
                  },
                ),
              ),
            ],
          ),
        ),
        maxHeight: 400,
        enabledParallax: true,
        isDraggable: false,
        padding: const EdgeInsets.all(0.0),
        margin: const EdgeInsets.all(0.0),
        direction: SlidingDirection.UP,
        panelSnapping: false,
        controller: _drawerController,
        enabledMask: false,
        hidePanel: false,
        parallaxOffset: 0.8,
        defaultDrawerState: AmosDrawerState.CLOSED,
        showCrossBar: false,
        panelBuilder: (sc) => _panel(sc),
      ),
    ));
  }

  Widget _panel(ScrollController sc) {
    if (executionLogs.isEmpty) {
      return Scaffold(
        appBar: AppBar(
          title: const Text('任务执行'),
          centerTitle: true,
        ),
        body: Container(
          alignment: Alignment.center,
          child: Container(),
        ),
      );
    }
    return MediaQuery.removePadding(
        context: context,
        removeTop: true,
        child: Stack(children: <Widget>[
          Container(
            margin: const EdgeInsets.only(top: 20),
            child: ListView.builder(
                itemCount: executionLogs.length,
                itemBuilder: (BuildContext context, int index) {
                  int idx = executionLogs.length - index - 1;
                  return Container(
                    color: _isPanelOpen &&
                        activeLogIndex == idx
                        ? const Color.fromRGBO(192, 216, 239, 1.0)
                        : Colors.white,
                    child: ListTile(
                      onTap: () {
                        Future.delayed(Duration.zero, () async {
                          MsgBox.showProgressDialog(context,
                              content: '加载中，请稍后...');
                          setState(() {
                            _isPanelOpen = false;
                            switchTaskForm(context, executionLogs[idx]);
                          });
                        }).whenComplete(() => Get.back());
                      },
                      title: Text(
                        (index + 1).toString() +
                            '. ' +
                            '${executionLogs[idx]['taskName'] ?? ''}',
                        style: TextStyle(
                            fontSize: 16,
                            color: executionLogs[idx]['edit']
                                ? const Color.fromRGBO(56, 158, 13, 1)
                                : const Color.fromRGBO(51, 51, 51, 1.0)),
                      ),
                      subtitle: Row(
                        children: [
                          Text(executionLogs[idx]['edit'] ? '' : '执行人：',
                              style: const TextStyle(fontSize: 14)),
                          Text('${executionLogs[idx]['operator'] ?? ''}'),
                        ],
                      ),
                      trailing: Text(
                        '${executionLogs[idx]['operateDate'] ?? ''}',
                        style: const TextStyle(
                            fontSize: 14,
                            color: Color.fromRGBO(153, 153, 153, 1)),
                      ),
                    ),
                  );
                }),
          ),
        ]));
  }

  /// 获取任务执行日志
  Future<void> getTaskFlowLogs(String flowId) async {
    bool closedMask = false;
    await Future.delayed(Duration.zero, () async {
      MsgBox.showProgressDialog(context, content: '加载中，请稍后...');
      var result = await API.getTaskFlowLogs(flowId);
      if (result == null || result['code'] == 500) {
        TaskExecution.popUpMsg('获取任务执行日志失败');
        return;
      }
      List<dynamic> logList = result['flowLogger'] ?? [];
      setState(() {
        executionLogs = [...logList];
      });
      if (logList.isNotEmpty) {
        Map<String, dynamic> editNode = logList.first;
        if (!_hasExecutePermission(logList)) {
          Get.back();
          closedMask = true;
          MsgBox.showMessageAndExitCurrentPage('您没有执行权限！', false, context);
        }
        await switchTaskForm(context, editNode);
        String formKey = editNode['formKey'];
        RegExp reg = RegExp(r'id=(\d+)&');
        formId = reg.firstMatch(formKey)?.group(1);
        pageFormMetaData = {
          'pageId': formId,
          'processInstanceId': processInstanceId,
          // 'taskId': editNode['taskId'],
        };
      }
      if (!closedMask) {
        Get.back();;
      }
    });
  }

  bool _hasExecutePermission(List<dynamic> logList) {
    Map<String, dynamic> editNode = logList.first;
    bool editable = editNode['edit'];
    String operateDate = editNode['operateDate'];
    if (!editable && (operateDate == null || operateDate == '')) {
      return false;
    }
    return true;
  }

  /// 切换任务表单
  Future<void> switchTaskForm(
      BuildContext context, Map<String, dynamic> taskLog) async {
    String taskId = taskLog['taskId'];
    editable = taskLog['edit'];
    String formKey = taskLog['formKey'];
    RegExp reg = RegExp(r'id=(\d+)&');
    formId = reg.firstMatch(formKey)?.group(1);
    // 设置activeLogIndex
    for (int i = 0; i < executionLogs.length; i++) {
      if (executionLogs[i]['taskId'] == taskId) {
        activeLogIndex = i;
        break;
      }
    }
    // 请求表单数据
    if (!editable) {
      Map<String, dynamic> formData = await API.getDynamicFormData(taskId);
      if (formData == null) {
        TaskExecution.popUpMsg('获取表单数据失败');
        return;
      }
      if (formData['type'] == 'raw') {
        formDataMap[formId] = json.decode(formData['value']);
      } else {
        formDataMap[formId] = formData;
      }
    }
    formDataMap[formId] = formDataMap[formId] ?? {};
    formValidateMap[formId] = formValidateMap[formId] ?? {};
    // 请求对应表单结构
    var structure =
        await API.getDynamicFormStructure(int.parse(formId, radix: 10));
    if (structure == null) {
      TaskExecution.popUpMsg('获取表单结构失败');
      return;
    }
    // 解析表单结构并生成表单
    Map<String, dynamic> jsonMap = json.decode(structure['content']);
    List<dynamic> formStructure = jsonMap['children'];
    List<Widget> formWidgets = parseForm(context, formDataMap[formId],
        formStructure, formValidateMap[formId], processInstancePayload, editable);
    setState(() {
      formWidgetMap[formId] = formWidgets;
    });
    // 解析按钮行为
    if (editable) {
      pageFormSubmitInfo = parseBtnAction(jsonMap);
    }
  }

  /// 解析按钮行为
  Map<String, dynamic> parseBtnAction(Map<String, dynamic> jsonMap) {
    if (editable) {
      Map<String, dynamic> formConfig = jsonMap['formConfig'];
      var api = {};
      for (var i = 0; i < formConfig['btns'].length; i++) {
        if (formConfig['btns'][i]['code'] == 'submit') {
          var btn = formConfig['btns'][i];
          for (var j = 0; j < btn['actions'].length; j++) {
            if (btn['actions'][j]['type'] == 'api') {
              api = btn['actions'][j]['api'];
              break;
            }
          }
          break;
        }
      }
      Map<String, dynamic> queryParams = {};
      (api['queryParams'] ?? []).forEach((param) {
        // if (param['value']['type'] == 'field') {
        queryParams[param['name']] = param['value']['value'];
        // }
      });

      return {
        'url': api['apiPath'],
        'httpMethod': api['httpMethod'],
        'bodyType': api['bodyType'],
        'queryParams': queryParams,
      };
    }
    return {};
  }

  /// 表单提交
  Future<void> formSubmit(BuildContext context, Map<String, dynamic> formData,
      Map<String, dynamic> formValidator) async {

    print('===========提交表单开始=================');
    print(formData);
    print('===========提交表单结束=================');

    if (!editable) {
      return;
    }
    // 参数校验
    for (final String key in formValidator.keys) {
      if (formValidator[key]['required']) {
        if (formData[key] == null || formData[key] == '') {
          TaskExecution.popUpMsg(formValidator[key]['message']);
          return;
        }
      }
    }
    // 组装请求
    Map<String, dynamic> params = {...pageFormMetaData};
    // 遍历params, 移除不存在于pageFormSubmitInfo['queryParams']的key
    for (final String key in params.keys) {
      if (!pageFormSubmitInfo['queryParams'].containsKey(key)) {
        params.remove(key);
      }
    }
    // Map<String, dynamic> body = {
    //   'type': pageFormSubmitInfo['bodyType'],
    //   'value': json.encode(formData),
    // };
    String paramsStr = '';
    // 把请求参数遍历params拼接到paramsStr中
    for (final String key in pageFormSubmitInfo['queryParams'].keys) {
      if (params[key] != null) {
        paramsStr += '&' + key + '=' + params[key];
      }
    }
    String url = pageFormSubmitInfo['url'] + '?' + paramsStr.substring(1);
    String method = pageFormSubmitInfo['httpMethod'];

    // 提交表单
    var result = {};

    // Future.delayed(const Duration(seconds: 3), () {
    //   Navigator.pop(context,true);
    // });

    MsgBox.showProgressDialog(context, content: '请稍后...');
    result = await API.submitDynamicFormData(url, method, formData);
    setState(() {
      editable = false;
    });
    TaskExecution.popUpMsg('提交表单成功');
    Future.delayed(const Duration(seconds: 5), () {
      Navigator.pop(context,true);
      Navigator.pop(context,true);
      // Navigator.of(context).pushReplacement(  MaterialPageRoute(builder: (context) => PendingTask(state: 'inProgress')));
    });

    // Future.delayed(const Duration(seconds: 3), () {
    //   Navigator.of(context).pushReplacement(  MaterialPageRoute(builder: (context) => PendingTask(state: 'inProgress')));
    // });


    // Navigator.of(context).pushReplacement(  MaterialPageRoute(builder: (context) => PendingTask(state: 'inProgress')));
    // Future.delayed(Duration.zero, () async {
    //
    //
    //
    //  // Navigator.push(context, MaterialPageRoute(builder: (context) => PendingTask(state: 'inProgress')));
    //   // Future.delayed(const Duration(seconds: 3), () {
    //   //   Navigator.pushReplacementNamed(context, JCSRoutes.pendingTask, arguments: );
    //   // });
    // });

  //  Navigator.of(context).pushReplacement(  MaterialPageRoute(builder: (context) => PendingTask(state: 'inProgress')));

  }
}
