import 'package:flutter/material.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';
import 'package:amos_flutter_utils/amos_flutter_utils.dart';
import 'package:jcs_airport/view/task/utils/widget_behavior.dart';
import 'package:intl/intl.dart';

class DynamicDataTime extends StatefulWidget {
  final Map<String, dynamic> formData;
  final Map<String, dynamic> visualParams;
  final Map<String, dynamic> formValidator;
  final Map<String, dynamic> processInstancePayload;
  final bool editable;

  const DynamicDataTime({
    Key key,
    this.formData,
    this.visualParams,
    this.formValidator,
    this. processInstancePayload,
    this.editable,
  }) : super(key: key);

  @override
  State<StatefulWidget> createState() => _DynamicDataTimeState();
}

class _DynamicDataTimeState extends State<DynamicDataTime> {
  String dateFormat;

  @override
  void initState() {
    super.initState();
    dateFormat = widget.visualParams['format'] ?? 'yyyy-MM-dd';
    dateFormat = dateFormat
        .replaceAll('YYYY', 'yyyy')
        .replaceAll('-DD', '-dd')
        .replaceAll(':MM', ':mm')
        .replaceAll(':SS', ':ss');
  }

  @override
  Widget build(BuildContext context) {

    if (isHidden(widget.visualParams)) {
      String defaultValueType = widget.visualParams['defaultValueType'];
      if (defaultValueType == 'currentDate') {
        setState(() {
          widget.formData[widget.visualParams['fieldKey']] = DateUtils.formatDate(DateTime.now(), format: dateFormat);
        });
      }
      return Container();
    }
    String value = widget.formData[widget.visualParams['fieldKey']];
    if (value == null || value == '') {
      if (widget.visualParams['defaultValueType'] == 'currentDate') {
        setState(() {
          String defaultValue = DateUtils.formatDate(DateTime.now(), format: dateFormat);
          widget.formData[widget.visualParams['fieldKey']] = defaultValue;
        });
      }
      if (widget.visualParams['defaultValueType'] == 'dataLink') {
        Map<String, dynamic> defaultValueDataLink = widget.visualParams['defaultValueDataLink'];
        if (defaultValueDataLink!=null && defaultValueDataLink['source'] == 'urlParams') {
          value =  widget.processInstancePayload[defaultValueDataLink['value']['prop']];
          setState(() {
            widget.formData[widget.visualParams['fieldKey']] =value!=null?  DateUtils.formatDate(DateFormat(dateFormat).parse(value), format: dateFormat) : null;
          });
        }

      }





    }
    return Row(
      children: <Widget>[
        Container(
          height: 95,
          padding: EdgeInsets.only(top: 15.0),
          child: Text(
            widget.visualParams!=null &&   widget.formValidator!=null? (widget.formValidator[widget.visualParams['fieldKey']]!=null ? widget.formValidator[widget.visualParams['fieldKey']]['required'] : false ) ?  '*':'':'',
            textAlign: TextAlign.left,
            //文字放大倍数
            textScaleFactor: 1.0,
            //文本最多显示几行
            maxLines: 1,
            style: TextStyle(color: Colors.red),
          ),
        ),

        Expanded(
          child:     FormItem(
              layout: FormLayout.vertical,
              label: widget.visualParams['label'],
              formfield: !widget.editable || isReadonly(widget.visualParams)
                  ? buildReadonlyWidget()
                  : InputDatePicker(
                  value: widget.formData[widget.visualParams['fieldKey']] != null
                      ? widget.formData[widget.visualParams['fieldKey']]: '',
                  onChange: (val) {
                    setState(() {
                      widget.formData[widget.visualParams['fieldKey']] =
                          DateUtils.formatDate(val, format: dateFormat);
                    });
                  })),
        ),
      ],
    );









  }

  Widget buildReadonlyWidget() {
    var formatter = DateFormat(dateFormat);
    String value = '';
    if (!widget.editable) {
      value = widget.formData[widget.visualParams['fieldKey']] != null
          ? widget.formData[widget.visualParams['fieldKey']] : widget.visualParams['defaultValue'] ?? '';
    } else {
      String defaultValueType = widget.visualParams['defaultValueType'];
      if (defaultValueType == 'currentDate') {
        value = DateUtils.formatDate(DateTime.now(), format: dateFormat);
      }
      if (defaultValueType == 'dataLink') {
        Map<String, dynamic> defaultValueDataLink = widget.visualParams['defaultValueDataLink'];
        if (defaultValueDataLink!=null && defaultValueDataLink['source'] == 'urlParams') {
          value = widget.formData[widget.visualParams['fieldKey']] != null
              ? widget.formData[widget.visualParams['fieldKey']] :  '';
        }

      }

    }

    return TextField(
      style: const TextStyle(fontSize: 14),
      readOnly: true,
      controller: TextEditingController(
          text: value),
      autofocus: false,
      maxLines: 1,
      decoration: const InputDecoration(
        contentPadding: EdgeInsets.symmetric(vertical: 10.0, horizontal: 10),
        border: InputBorder.none,
        filled: true,
        fillColor: Color.fromRGBO(244, 244, 244, 1),
      ),
    );
  }
}
